/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Bfunc;
import com.wapindustrial.calc.CanvasHandler1;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FormulaError;
import com.wapindustrial.calc.FormulaParseException;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.FunctorListN;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.ShortAtom;

public class Reference
extends LispObject {
    static final byte ABS_I1 = 1;
    static final byte ABS_J1 = 2;
    static final byte ABS_I2 = 4;
    static final byte ABS_J2 = 8;
    static final byte BAD_REF = 16;
    final short i1;
    final short j1;
    final short i2;
    final short j2;
    final byte absFlags;

    Reference(int n, int n2, int n3, int n4) {
        this.i1 = (short)n;
        this.j1 = (short)n2;
        this.i2 = (short)n3;
        this.j2 = (short)n4;
        this.absFlags = 0;
    }

    Reference(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
            n5 = (byte)(n5 & 0xFFFFFFFA | n5 & 4 | n5 & 1);
        }
        if (n2 > n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
            n5 = (byte)(n5 & 0xFFFFFFF5 | n5 & 8 | n5 & 2);
        }
        if (n == n3) {
            n5 = (byte)(n5 & 0xFFFFFFFB | (n5 & 1) << 2);
        }
        if (n2 == n4) {
            n5 = (byte)(n5 & 0xFFFFFFF7 | (n5 & 2) << 2);
        }
        this.i1 = (byte)n;
        this.j1 = (byte)n2;
        this.i2 = (byte)n3;
        this.j2 = (byte)n4;
        this.absFlags = (byte)n5;
    }

    public LispObject evaluateSExp() throws EvaluateException {
        if ((this.absFlags & 0x10) != 0) {
            return FormulaError.REF_ERROR;
        }
        return CanvasHandler1.canvasHandler.getCellValue(this.i1, this.j1);
    }

    public FunctorList toList() {
        return new FunctorListN(Bfunc.BFUNC.table[32], new LispObject[]{new ShortAtom(this.i1), new ShortAtom(this.j1), new ShortAtom(this.i2), new ShortAtom(this.j2), new ShortAtom(this.absFlags)});
    }

    public void toFormulaBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(Reference.rangeAddress(this.i1, this.j1, this.i2, this.j2, this.absFlags));
    }

    public int typeNumber() {
        return 2;
    }

    public LispObject cloneReferences() {
        return new Reference(this.i1, this.j1, this.i2, this.j2, this.absFlags);
    }

    public static String columnName(int n) {
        StringBuffer stringBuffer = new StringBuffer(2);
        int n2 = n / 26;
        if (n2 > 0) {
            stringBuffer.append((char)(65 + n2 - 1));
        }
        stringBuffer.append((char)(65 + (n %= 26)));
        return stringBuffer.toString();
    }

    public static String cellAddress(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if ((n3 & 2) != 0) {
            stringBuffer.append('$');
        }
        stringBuffer.append(Reference.columnName(n2));
        if ((n3 & 1) != 0) {
            stringBuffer.append('$');
        }
        stringBuffer.append(String.valueOf(n + 1));
        return stringBuffer.toString();
    }

    public static String rangeAddress(int n, int n2, int n3, int n4, int n5) {
        StringBuffer stringBuffer = new StringBuffer(Reference.cellAddress(n, n2, n5));
        if (n != n3 || n2 != n4) {
            stringBuffer.append(':');
            stringBuffer.append(Reference.cellAddress(n3, n4, n5 >> 2));
        }
        return stringBuffer.toString();
    }

    public static Reference parseAddress(String string) throws FormulaParseException {
        byte[] byArray = string.toUpperCase().getBytes();
        int n = 0;
        try {
            char c;
            int n2 = 0;
            int n3 = -1;
            int n4 = 0;
            if (byArray[0] == 36) {
                n = 1;
                n2 = 2;
            }
            while (!Character.isDigit(c = (char)byArray[n]) && c != '$') {
                if (c < 'A' || c > 'Z') {
                    throw new Exception();
                }
                ++n;
                int n5 = c - 65;
                if ((n3 = n3 != -1 ? (n3 + 1) * 26 + n5 : n5) < 702) continue;
                throw new Exception();
            }
            if (n3 < 0) {
                throw new Exception();
            }
            if (c == '$') {
                ++n;
                n2 = (byte)(n2 | 1);
            }
            while (n < byArray.length && Character.isDigit(c = (char)byArray[n])) {
                n4 *= 10;
                n4 += (short)(c - 48);
                ++n;
            }
            if (--n4 < 0) {
                throw new Exception();
            }
            if (n == byArray.length) {
                return new Reference(n4, n3, n4, n3, n2);
            }
            if (c == ':') {
                if (string.indexOf(58, n + 1) != -1) {
                    throw new Exception();
                }
                Reference reference = Reference.parseAddress(string.substring(n + 1));
                return new Reference(n4, n3, reference.i1, reference.j1, reference.absFlags << 2 | n2);
            }
            if (n != byArray.length) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            LispObject.debug("exception catched:");
            LispObject.debug(exception.getMessage());
        }
        throw new FormulaParseException("illegal cell address [" + string + "]");
    }

    public LispObject shiftReferences(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = false;
        int n5 = this.i1;
        int n6 = this.j1;
        int n7 = this.i2;
        int n8 = this.j2;
        if (n3 < 0) {
            if (n5 >= n && n7 < n - n3) {
                return new Reference(n5, n6, n7, n8, this.absFlags | 0x10);
            }
            bl2 = Reference.intersect(n5, n6, n7, n8, n, n2, (short)(n - n3), n8);
            if (n5 >= n - n3) {
                n5 += n3;
            } else if (n5 > n) {
                n5 = n;
            }
            if (n7 >= n - n3) {
                n7 += n3;
            } else if (n7 > n) {
                n7 = n;
            }
        } else if (n3 > 0) {
            if (n5 >= n) {
                n5 += n3;
            }
            if (n7 >= n) {
                n7 += n3;
            }
            bl2 = Reference.intersect(n5, n6, n7, n8, n, n2, n + n3, n8);
        }
        if (n4 < 0) {
            if (n6 >= n2 && n8 < n2 - n4) {
                return new Reference(n5, n6, n7, n8, this.absFlags | 0x10);
            }
            bl2 = Reference.intersect(n5, n6, n7, n8, n, n2, n7, n2 - n4);
            if (n6 >= n2 - n4) {
                n6 += n4;
            } else if (n6 > n2) {
                n6 = n2;
            }
            if (n8 >= n2 - n4) {
                n8 += n4;
            } else if (n8 > n2) {
                n8 = n2;
            }
        } else if (n4 > 0) {
            if (n6 >= n2) {
                n6 += n4;
            }
            if (n8 >= n2) {
                n8 += n4;
            }
            bl2 = Reference.intersect(n5, n6, n7, n8, n, n2, n7, n2 + n4);
        }
        boolean bl3 = bl = bl2 || n5 != this.i1 || n6 != this.j1 || n7 != this.i2 || n8 != this.j2;
        if (bl) {
            return new Reference(n5, n6, n7, n8, this.absFlags);
        }
        return this;
    }

    public LispObject moveReferences(int n, int n2) {
        boolean bl;
        int n3 = this.i1;
        int n4 = this.j1;
        int n5 = this.i2;
        int n6 = this.j2;
        if ((this.absFlags & 1) == 0) {
            n3 += n;
        }
        if ((this.absFlags & 2) == 0) {
            n4 += n2;
        }
        if ((this.absFlags & 4) == 0) {
            n5 += n;
        }
        if ((this.absFlags & 8) == 0) {
            n6 += n2;
        }
        boolean bl2 = bl = (this.absFlags & 0xF) != 15;
        if (bl) {
            return new Reference(n3, n4, n5, n6, this.absFlags);
        }
        return this;
    }

    public static final boolean intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n > n5 ? n : n5;
        int n10 = n3 < n7 ? n3 : n7;
        int n11 = n2 > n6 ? n2 : n6;
        int n12 = n4 < n8 ? n4 : n8;
        return n9 < n10 && n11 < n12;
    }
}

