/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Bfunc;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.FunctorListN;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LongAtom;
import com.wapindustrial.calc.ShortAtom;
import com.wapindustrial.calc.StringAtomBase;
import java.util.Enumeration;
import java.util.Hashtable;

public class QuotedList
extends LispObject {
    public final LispObject[] value;

    public QuotedList(LispObject[] lispObjectArray) {
        this.value = lispObjectArray;
    }

    public QuotedList(FunctorList functorList, int n, int n2) {
        this(new LispObject[n2 - n]);
        for (int i = n; i < n2; ++i) {
            this.value[i - n] = functorList.getArgumentN(i);
        }
    }

    public QuotedList(FunctorList functorList) {
        this(functorList.toArray());
    }

    public QuotedList(Hashtable hashtable) {
        int n = hashtable.size();
        this.value = new LispObject[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this.value[n2++] = (LispObject)enumeration.nextElement();
        }
    }

    public Hashtable toHashtable() throws EvaluateException {
        Hashtable hashtable = LispObject.createHashtable(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            LispObject lispObject = this.value[i].evaluateSExp();
            hashtable.put(lispObject, lispObject);
        }
        return hashtable;
    }

    public LispObject interpret() throws EvaluateException {
        LispObject lispObject = LispObject.NIL;
        for (int i = 0; i < this.value.length; ++i) {
            lispObject = this.value[i].evaluateSExp();
        }
        return lispObject;
    }

    public void toBuffer(StringBuffer stringBuffer) {
        stringBuffer.append('\'');
        stringBuffer.append('(');
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            this.value[i].toBuffer(stringBuffer);
        }
        stringBuffer.append(')');
    }

    public final short getShort(int n) throws EvaluateException {
        LispObject lispObject = this.value[n].evaluateSExp();
        if (lispObject == LispObject.NIL) {
            return 0;
        }
        return ((ShortAtom)lispObject).value;
    }

    public final long getLong(int n) throws EvaluateException {
        LispObject lispObject = this.value[n].evaluateSExp();
        if (lispObject == LispObject.NIL) {
            return 0L;
        }
        return ((LongAtom)lispObject).value;
    }

    public final int getInt(int n) throws EvaluateException {
        LispObject lispObject = this.value[n].evaluateSExp();
        if (lispObject == LispObject.NIL) {
            return 0;
        }
        return (int)((LongAtom)lispObject).value;
    }

    public final FloatAtom getFloat(int n) throws EvaluateException {
        LispObject lispObject = this.value[n].evaluateSExp();
        if (lispObject == LispObject.NIL) {
            return null;
        }
        return (FloatAtom)lispObject;
    }

    public final String getString(int n) throws EvaluateException {
        LispObject lispObject = this.value[n].evaluateSExp();
        if (lispObject == LispObject.NIL) {
            return null;
        }
        if (lispObject.typeNumber() == 10) {
            return ((StringAtomBase)lispObject).getValue();
        }
        return lispObject.toString();
    }

    public int typeNumber() {
        return 5;
    }

    public QuotedList toQuotedList() {
        return this;
    }

    public FunctorList toList() {
        return new FunctorListN(Bfunc.BFUNC.table[132], this.value);
    }

    public void toFormulaBuffer(StringBuffer stringBuffer) {
        this.toList().toFormulaBuffer(stringBuffer);
    }

    public void toValueBuffer(StringBuffer stringBuffer, int n) {
        this.toFormulaBuffer(stringBuffer);
    }
}

