/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.BooleanAtom;
import com.wapindustrial.calc.DateAtom;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.FormulaError;
import com.wapindustrial.calc.FormulaParseException;
import com.wapindustrial.calc.FunctionModule;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.FunctorList1;
import com.wapindustrial.calc.FunctorList2;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LongAtom;
import com.wapindustrial.calc.ModuleHandler;
import com.wapindustrial.calc.NameObjectBase;
import com.wapindustrial.calc.Reference;
import com.wapindustrial.calc.ShortAtom;
import com.wapindustrial.calc.StringAtom;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import net.jscience.math.MathFP;

public class Operator
extends FunctionModule {
    public static final Operator OPERATOR = new Operator();
    private static final int USED_BITS = 16;
    static final byte[] _namesArray = new byte[]{3, 97, 100, 100, 3, 115, 117, 98, 3, 109, 117, 108, 3, 100, 105, 118, 2, 101, 113, 2, 110, 101, 2, 108, 101, 2, 108, 116, 2, 103, 101, 2, 103, 116, 4, 117, 109, 105, 110, 9, 112, 97, 114, 101, 110, 116, 104, 105, 115, 3, 97, 110, 100, 2, 111, 114};
    public static final int NAME_ADD = 0;
    public static final int NAME_SUB = 4;
    public static final int NAME_MUL = 8;
    public static final int NAME_DIV = 12;
    public static final int NAME_EQ = 16;
    public static final int NAME_NE = 19;
    public static final int NAME_LE = 22;
    public static final int NAME_LT = 25;
    public static final int NAME_GE = 28;
    public static final int NAME_GT = 31;
    public static final int NAME_UMIN = 34;
    public static final int NAME_PARENTHIS = 39;
    public static final int NAME_AND = 49;
    public static final int NAME_OR = 53;
    public static final int INDEX_ADD = 0;
    public static final int INDEX_SUB = 1;
    public static final int INDEX_MUL = 2;
    public static final int INDEX_DIV = 3;
    public static final int INDEX_EQ = 4;
    public static final int INDEX_NE = 5;
    public static final int INDEX_LE = 6;
    public static final int INDEX_LT = 7;
    public static final int INDEX_GE = 8;
    public static final int INDEX_GT = 9;
    public static final int INDEX_UMIN = 10;
    public static final int INDEX_PARENTHIS = 11;
    public static final int INDEX_AND = 12;
    public static final int INDEX_OR = 13;
    private static char[] buf;
    private static int nBuf;
    private static final String MSG_DATE = "bad date format (must be DD/MM/YYYY)";

    private Operator() {
    }

    public void initializeNames() {
        this.namesArray = _namesArray;
        this.namesArrayCount = this.namesArray.length;
        this.table = new FunctionModule.ModuleName[]{new OperatorName("+", 0), new OperatorName("-", 4), new OperatorName("*", 8), new OperatorName("/", 12), new OperatorName("=", 16), new OperatorName("<>", 19), new OperatorName("<=", 22), new OperatorName("<", 25), new OperatorName(">=", 28), new OperatorName(">", 31), new OperatorName("-", 34), new OperatorName("(", 39), (FunctionModule)this.new FunctionModule.ModuleName(49), (FunctionModule)this.new FunctionModule.ModuleName(53)};
        this.namesCount = this.table.length;
    }

    public LispObject evaluate(FunctionModule.ModuleName moduleName, FunctorList functorList) throws EvaluateException {
        int n = functorList.listSize();
        short s = moduleName.offset;
        LispObject lispObject = FormulaError.ERROR;
        block2 : switch (s) {
            case 39: {
                lispObject = functorList.evaluateArg1();
                break;
            }
            case 34: {
                LispObject lispObject2 = functorList.evaluateArg1();
                switch (lispObject2.typeNumber()) {
                    case 7: {
                        lispObject = ShortAtom.createShortAtom(-((ShortAtom)lispObject2).value);
                        break block2;
                    }
                    case 8: {
                        lispObject = new LongAtom(-((LongAtom)lispObject2).value);
                        break block2;
                    }
                    case 9: {
                        lispObject = new FloatAtom(-((FloatAtom)lispObject2).value);
                        break block2;
                    }
                }
                throw new EvaluateException("wrong type for umin", functorList);
            }
            case 49: {
                return BooleanAtom.createBoolean(functorList.getBoolean(1) && functorList.getBoolean(2));
            }
            case 53: {
                return BooleanAtom.createBoolean(functorList.getBoolean(1) || functorList.getBoolean(2));
            }
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: {
                int n2;
                short s2 = 0;
                short s3 = 0;
                long l = 0L;
                long l2 = 0L;
                int n3 = 0;
                long l3 = 0L;
                boolean bl = false;
                LispObject lispObject3 = functorList.evaluateArg1();
                LispObject lispObject4 = functorList.evaluateArg2();
                int n4 = lispObject3.typeNumber();
                if (n4 < 7) {
                    n4 = 7;
                }
                if ((n2 = lispObject4.typeNumber()) < 7) {
                    n2 = 7;
                }
                int n5 = n4 > n2 ? n4 : n2;
                lispObject3 = lispObject3.convertToType(n5);
                lispObject4 = lispObject4.convertToType(n5);
                if (n5 == 7) {
                    s2 = ((ShortAtom)lispObject3).value;
                    s3 = ((ShortAtom)lispObject4).value;
                } else if (n5 == 8) {
                    l = ((LongAtom)lispObject3).value;
                    l2 = ((LongAtom)lispObject4).value;
                } else if (n5 == 9) {
                    l = ((FloatAtom)lispObject3).value;
                    l2 = ((FloatAtom)lispObject4).value;
                }
                switch (s << 16 | n5) {
                    case 7: {
                        n3 = s2 + s3;
                        break;
                    }
                    case 262151: {
                        n3 = s2 - s3;
                        break;
                    }
                    case 524295: {
                        n3 = s2 * s3;
                        break;
                    }
                    case 786439: {
                        try {
                            n3 = s2 / s3;
                            break;
                        }
                        catch (ArithmeticException arithmeticException) {
                            throw new EvaluateException("Divide by zero", functorList);
                        }
                    }
                    case 1441799: {
                        bl = s2 <= s3;
                        break;
                    }
                    case 1638407: {
                        bl = s2 < s3;
                        break;
                    }
                    case 1835015: {
                        bl = s2 >= s3;
                        break;
                    }
                    case 2031623: {
                        bl = s2 > s3;
                        break;
                    }
                    case 0x100007: {
                        bl = s2 == s3;
                        break;
                    }
                    case 1245191: {
                        bl = s2 != s3;
                        break;
                    }
                    case 8: {
                        l3 = l + l2;
                        break;
                    }
                    case 262152: {
                        l3 = l - l2;
                        break;
                    }
                    case 524296: {
                        l3 = l * l2;
                        break;
                    }
                    case 786440: {
                        try {
                            l3 = l / l2;
                            break;
                        }
                        catch (ArithmeticException arithmeticException) {
                            throw new EvaluateException("Divide by zero", functorList);
                        }
                    }
                    case 1441800: {
                        bl = l <= l2;
                        break;
                    }
                    case 1638408: {
                        bl = l < l2;
                        break;
                    }
                    case 1835016: {
                        bl = l >= l2;
                        break;
                    }
                    case 2031624: {
                        bl = l > l2;
                        break;
                    }
                    case 0x100008: {
                        bl = l == l2;
                        break;
                    }
                    case 1245192: {
                        bl = l != l2;
                        break;
                    }
                    case 9: {
                        l3 = l + l2;
                        break;
                    }
                    case 262153: {
                        l3 = l - l2;
                        break;
                    }
                    case 524297: {
                        l3 = MathFP.mul(l, l2);
                        break;
                    }
                    case 786441: {
                        if (l2 == 0L) {
                            throw new EvaluateException("Divide by Zero", functorList);
                        }
                        l3 = MathFP.div(l, l2);
                        break;
                    }
                    case 1441801: {
                        bl = l <= l2;
                        break;
                    }
                    case 0x190009: {
                        bl = l < l2;
                        break;
                    }
                    case 1835017: {
                        bl = l >= l2;
                        break;
                    }
                    case 2031625: {
                        bl = l > l2;
                        break;
                    }
                    case 0x100009: {
                        bl = l == l2;
                        break;
                    }
                    case 1245193: {
                        bl = l != l2;
                        break;
                    }
                    default: {
                        throw new EvaluateException("Unsupported datatypes for operators expression", functorList);
                    }
                }
                if (s == 22 || s == 25 || s == 28 || s == 31) {
                    n5 = 6;
                }
                if (n5 == 6) {
                    lispObject = BooleanAtom.createBoolean(bl);
                    break;
                }
                if (n5 == 7) {
                    lispObject = ShortAtom.createShortAtom(n3);
                    break;
                }
                if (n5 == 8) {
                    lispObject = new LongAtom(l3);
                    break;
                }
                if (n5 != 9) break;
                lispObject = new FloatAtom(l3);
            }
        }
        return lispObject;
    }

    static final FunctorList createOper(NameObjectBase nameObjectBase, LispObject lispObject, LispObject lispObject2) {
        return new FunctorList2(nameObjectBase, lispObject, lispObject2);
    }

    static final FunctorList createOper1(NameObjectBase nameObjectBase, LispObject lispObject) {
        return new FunctorList1(nameObjectBase, lispObject);
    }

    private static final char get1() throws FormulaParseException {
        char c;
        try {
            while ((c = buf[nBuf++]) == ' ' || c == '\t' || c == '\n') {
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new FormulaParseException("Invalid formula, unexpected end of string");
        }
        return c;
    }

    private static final void unget1() {
        --nBuf;
    }

    private static final boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '_';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LispObject parseFormula(String string) throws FormulaParseException {
        LispObject lispObject;
        block8: {
            try {
                int n = string.length();
                buf = new char[n + 1];
                string.getChars(0, n, buf, 0);
                Operator.buf[n] = '\u0000';
                nBuf = 0;
                if (Operator.get1() == '=') {
                    lispObject = this.f_comp();
                    if (Operator.get1() != '\u0000') {
                        throw new FormulaParseException("Bad expression, expected end of string");
                    }
                    break block8;
                }
                Operator.unget1();
                try {
                    lispObject = this.f_const();
                    if (Operator.get1() != '\u0000') {
                        throw new FormulaParseException("Bad expression, expected end of string");
                    }
                }
                catch (FormulaParseException formulaParseException) {
                    lispObject = new StringAtom(string);
                }
            }
            finally {
                buf = null;
            }
        }
        return lispObject;
    }

    private LispObject f_comp() throws FormulaParseException {
        char c;
        LispObject lispObject = this.f_add();
        while ((c = Operator.get1()) == '=' || c == '<' || c == '>' || c == '!') {
            FunctionModule.ModuleName moduleName = this.table[4];
            if (c == '!') {
                if (buf[nBuf++] != '=') {
                    throw new FormulaParseException("Expected '!=' statement");
                }
                moduleName = this.table[5];
            } else if (c != '=') {
                if (buf[nBuf] == '=') {
                    ++nBuf;
                    moduleName = this.table[c == '>' ? 8 : 6];
                } else {
                    moduleName = this.table[c == '>' ? 9 : 7];
                }
            }
            LispObject lispObject2 = this.f_add();
            lispObject = Operator.createOper(moduleName, lispObject, lispObject2);
        }
        Operator.unget1();
        return lispObject;
    }

    private LispObject f_add() throws FormulaParseException {
        char c;
        LispObject lispObject = this.f_mul();
        while ((c = Operator.get1()) == '+' || c == '-') {
            LispObject lispObject2 = this.f_mul();
            lispObject = Operator.createOper(this.table[c == '+' ? 0 : 1], lispObject, lispObject2);
        }
        Operator.unget1();
        return lispObject;
    }

    private LispObject f_mul() throws FormulaParseException {
        char c;
        LispObject lispObject = this.f_uminus();
        while ((c = Operator.get1()) == '*' || c == '/') {
            LispObject lispObject2 = this.f_uminus();
            lispObject = Operator.createOper(this.table[c == '*' ? 2 : 3], lispObject, lispObject2);
        }
        Operator.unget1();
        return lispObject;
    }

    private LispObject f_uminus() throws FormulaParseException {
        if (Operator.get1() == '-') {
            return Operator.createOper1(this.table[10], this.f_brackets());
        }
        Operator.unget1();
        return this.f_brackets();
    }

    private LispObject f_brackets() throws FormulaParseException {
        if (Operator.get1() == '(') {
            LispObject lispObject = this.f_comp();
            if (Operator.get1() != ')') {
                throw new FormulaParseException("missing ')'");
            }
            return Operator.createOper1(this.table[11], lispObject);
        }
        Operator.unget1();
        return this.f_name();
    }

    private LispObject f_const() throws FormulaParseException {
        char c = Operator.get1();
        Operator.unget1();
        if (c == '\'') {
            return Operator.f_const_string1();
        }
        if (c == '-') {
            LispObject lispObject;
            c = Operator.get1();
            LispObject lispObject2 = Operator.f_const_numeric();
            int n = lispObject2.typeNumber();
            if (n == 7) {
                lispObject = (ShortAtom)lispObject2;
                lispObject.value = -lispObject.value;
            }
            if (n == 8) {
                lispObject = (LongAtom)lispObject2;
                ((LongAtom)lispObject).value = -((LongAtom)lispObject).value;
            }
            if (n == 9) {
                lispObject = (FloatAtom)lispObject2;
                ((FloatAtom)lispObject).value = -((FloatAtom)lispObject).value;
            }
            return lispObject2;
        }
        if (Character.isDigit(c)) {
            int n = nBuf;
            while ((c = buf[n++]) != '\u0000') {
                if (c != '/' && c != ':') continue;
                return Operator.f_const_date();
            }
            return Operator.f_const_numeric();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        while (Operator.isLetter(c = buf[nBuf++]) || Character.isDigit(c)) {
            stringBuffer.append(c);
        }
        Operator.unget1();
        String string = stringBuffer.toString();
        if (string.equals("nil")) {
            return LispObject.NIL;
        }
        if (string.compareTo("true") == 0) {
            return BooleanAtom.TRUE;
        }
        if (string.compareTo("false") == 0) {
            return BooleanAtom.FALSE;
        }
        throw new FormulaParseException("Expected a constant");
    }

    private LispObject f_name() throws FormulaParseException {
        char c = Operator.get1();
        if (c == '#') {
            LispObject lispObject = Operator.f_const_date();
            if (Operator.get1() != '#') {
                throw new FormulaParseException("expected trailing '#' in date constant");
            }
            return lispObject;
        }
        Operator.unget1();
        if (c == '\"') {
            return Operator.f_const_string();
        }
        if (Character.isDigit(c)) {
            return Operator.f_const_numeric();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        char c2 = '\u0000';
        while (!(!Operator.isLetter(c = buf[nBuf++]) && !Character.isDigit(c) && c != '-' && c != '$' && c != ':' || c == '-' && Character.isDigit(c2))) {
            stringBuffer.append(c);
            c2 = c;
        }
        Operator.unget1();
        if (stringBuffer.length() <= 0) {
            throw new FormulaParseException("bad formula - expected a constant");
        }
        String string = stringBuffer.toString();
        if (Operator.get1() == '(') {
            Vector<LispObject> vector = new Vector<LispObject>(3);
            c = Operator.get1();
            if (c != ')') {
                Operator.unget1();
            }
            while (c != ')') {
                if (c == '\u0000') {
                    throw new FormulaParseException("Missing ')' in function");
                }
                vector.addElement(this.f_comp());
                c = Operator.get1();
                if (c == 44 || c == 41) continue;
                throw new FormulaParseException("Missing ')' in function");
            }
            int n = vector.size();
            LispObject[] lispObjectArray = new LispObject[n + 1];
            try {
                lispObjectArray[0] = ModuleHandler.MODULEHANDLER.createName(string);
            }
            catch (EvaluateException evaluateException) {
                throw new FormulaParseException(evaluateException.getMessage());
            }
            for (int i = 0; i < n; ++i) {
                lispObjectArray[i + 1] = (LispObject)vector.elementAt(i);
            }
            return LispObject.createFunctorList(lispObjectArray);
        }
        Operator.unget1();
        if (string.equals("nil")) {
            return LispObject.NIL;
        }
        if (string.compareTo("true") == 0) {
            return BooleanAtom.TRUE;
        }
        if (string.compareTo("false") == 0) {
            return BooleanAtom.FALSE;
        }
        NameObjectBase nameObjectBase = ModuleHandler.MODULEHANDLER.findNameInAllModules(string);
        if (nameObjectBase != null) {
            return nameObjectBase;
        }
        return Reference.parseAddress(string);
    }

    private static LispObject f_const_string() throws FormulaParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer(20);
        ++nBuf;
        while ((c = buf[nBuf++]) != '\"') {
            if (c == '\u0000') {
                Operator.unget1();
                break;
            }
            stringBuffer.append(c);
        }
        return new StringAtom(stringBuffer.toString());
    }

    private static LispObject f_const_string1() throws FormulaParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer(20);
        ++nBuf;
        while ((c = buf[nBuf]) != '\u0000') {
            ++nBuf;
            stringBuffer.append(c);
        }
        return new StringAtom(stringBuffer.toString());
    }

    private static LispObject f_const_numeric() throws FormulaParseException {
        char c;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(20);
        while ((c = buf[nBuf++]) >= '0' && c <= '9' || c == '.') {
            if (c == '.') {
                bl = true;
            }
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        try {
            if (c == 'L' || c == 'l') {
                return new LongAtom(Long.parseLong(string));
            }
            Operator.unget1();
            if (!bl) {
                return ShortAtom.createShortAtom(Short.parseShort(string));
            }
            return new FloatAtom(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormulaParseException("Cannot parse numeric constant");
        }
    }

    private static LispObject f_const_date() throws FormulaParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer(20);
        while ((c = buf[nBuf++]) >= '0' && c <= '9' || c == '/' || c == ':' || c == ' ') {
            stringBuffer.append(c);
        }
        Operator.unget1();
        String string = stringBuffer.toString();
        int n = string.indexOf(47);
        int n2 = string.indexOf(47, n + 1);
        int n3 = string.indexOf(32, n2 + 1);
        int n4 = string.indexOf(58, n3 + 1);
        int n5 = string.indexOf(58, n4 + 1);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        Calendar calendar = Calendar.getInstance();
        try {
            if (n > 0 && n2 > 0) {
                n6 = Integer.parseInt(string.substring(0, n));
                n7 = Integer.parseInt(string.substring(n + 1, n2));
                n8 = Integer.parseInt(string.substring(n2 + 1, n3 > 0 ? n3 : string.length()));
                if (n6 < 0 || n6 > 31 || n7 <= 0 || n7 > 12 || n8 < 1970) {
                    throw new FormulaParseException(MSG_DATE);
                }
                calendar.set(5, n6);
                calendar.set(2, n7 - 1);
                calendar.set(1, n8);
            } else {
                calendar.setTime(new Date());
            }
            if (n4 > 0) {
                n9 = Integer.parseInt(string.substring(n3 + 1, n4));
                n10 = Integer.parseInt(string.substring(n4 + 1, n5 > 0 ? n5 : string.length()));
            }
            if (n5 > 0) {
                n11 = Integer.parseInt(string.substring(n5 + 1));
            }
            calendar.set(11, n9);
            calendar.set(12, n10);
            calendar.set(13, n11);
        }
        catch (Exception exception) {
            throw new FormulaParseException(MSG_DATE);
        }
        return new DateAtom((calendar.getTime().getTime() + 500L) / 1000L);
    }

    class OperatorName
    extends FunctionModule.ModuleName {
        String sign;

        OperatorName(String string, int n) {
            super(n);
            this.sign = string;
        }

        public void toFormulaBuffer(StringBuffer stringBuffer, FunctorList functorList) {
            int n = functorList.listSize();
            if (this.offset == 34) {
                stringBuffer.append('-');
            } else if (this.offset == 39) {
                stringBuffer.append('(');
            }
            for (int i = 1; i < n; ++i) {
                if (i != 1) {
                    stringBuffer.append(this.sign);
                }
                functorList.getArgumentN(i).toFormulaBuffer(stringBuffer);
            }
            if (this.offset == 39) {
                stringBuffer.append(')');
            }
        }

        public LispObject getMappedObject() {
            return OPERATOR;
        }
    }
}

