/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FunctionObject;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.LispObject;

public abstract class NameObjectBase
extends LispObject {
    public abstract String getName();

    public abstract LispObject getMappedObject();

    public LispObject setMappedObject(LispObject lispObject) throws EvaluateException {
        throw new EvaluateException("name of this type cannot be set");
    }

    public LispObject evaluate(FunctorList functorList) throws EvaluateException {
        try {
            FunctionObject functionObject = (FunctionObject)this.getMappedObject();
            try {
                return functionObject.evaluate(functorList);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new EvaluateException("Wrong number of arguments", functorList);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EvaluateException("Wrong arguments for a MIDP functions", functorList);
            }
            catch (ClassCastException classCastException) {
                throw new EvaluateException("Type mismatch", functorList);
            }
        }
        catch (ClassCastException classCastException) {
            throw new EvaluateException("Not a functor", functorList);
        }
    }

    public LispObject evaluateSExp() throws EvaluateException {
        try {
            return this.getMappedObject().evaluateSExp();
        }
        catch (NullPointerException nullPointerException) {
            throw new EvaluateException("unmapped name?", this);
        }
    }

    public void toBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public void toFormulaBuffer(StringBuffer stringBuffer, FunctorList functorList) {
        int n = functorList.listSize();
        stringBuffer.append(this.getName());
        stringBuffer.append('(');
        for (int i = 1; i < n; ++i) {
            if (i != 1) {
                stringBuffer.append(',');
            }
            functorList.getArgumentN(i).toFormulaBuffer(stringBuffer);
        }
        stringBuffer.append(')');
    }
}

