/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.QuotedList;
import com.wapindustrial.calc.ScreenLite;
import com.wapindustrial.calc.ShortAtom;
import com.wapindustrial.calc.StringAtom;
import java.util.Vector;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;

class InputForm {
    private static final int PROMPT_TYPE_TEXT = 0;
    private static final int PROMPT_TYPE_INTEGER = 1;
    private static final int PROMPT_TYPE_FLOAT = 2;
    private static final int PROMPT_TYPE_DATE = 3;
    private static final int PROMPT_TYPE_TIME = 4;
    private static final int PROMPT_TYPE_DATETIME = 5;
    private static final int PROMPT_TYPE_LIST = 100;
    final LispObject formtitle;
    final LispObject code;
    FunctorList[] fields;
    LispObject[] values;
    Displayable screen;

    InputForm(LispObject lispObject, LispObject lispObject2) {
        this.formtitle = lispObject;
        this.code = lispObject2;
    }

    private void collectFields(Vector vector, LispObject lispObject) {
        int n = lispObject.typeNumber();
        if (n == 4) {
            FunctorList functorList = (FunctorList)lispObject;
            if (functorList.functor == ScreenLite.SCREENLITE.table[3]) {
                vector.addElement(functorList);
            } else if (functorList.functor != ScreenLite.SCREENLITE.table[10]) {
                int n2 = functorList.listSize();
                for (int i = 1; i < n2; ++i) {
                    this.collectFields(vector, functorList.getArgumentN(i));
                }
            }
            return;
        }
        if (n == 5) {
            QuotedList quotedList = (QuotedList)lispObject;
            for (int i = 0; i < quotedList.value.length; ++i) {
                this.collectFields(vector, quotedList.value[i]);
            }
        }
    }

    LispObject buildCode() throws EvaluateException {
        this.extractFromForm(this.screen);
        return this.buildCode(this.code);
    }

    LispObject buildCode(LispObject lispObject) {
        LispObject lispObject2;
        int n;
        LispObject lispObject3;
        int n2 = lispObject.typeNumber();
        if (n2 == 4) {
            lispObject3 = (FunctorList)lispObject;
            if (((FunctorList)lispObject3).functor == ScreenLite.SCREENLITE.table[3]) {
                for (int i = 0; i < this.fields.length; ++i) {
                    if (lispObject3 != this.fields[i]) continue;
                    return this.values[i];
                }
                throw new IllegalStateException();
            }
            if (((FunctorList)lispObject3).functor != ScreenLite.SCREENLITE.table[10]) {
                n = lispObject3.listSize();
                boolean bl = false;
                LispObject[] lispObjectArray = new LispObject[n];
                lispObjectArray[0] = ((FunctorList)lispObject3).functor;
                for (int i = 1; i < n; ++i) {
                    LispObject lispObject4;
                    lispObject2 = ((FunctorList)lispObject3).getArgumentN(i);
                    lispObjectArray[i] = lispObject4 = this.buildCode(lispObject2);
                    if (lispObject2 == lispObject4) continue;
                    bl = true;
                }
                if (bl) {
                    return LispObject.createFunctorList(lispObjectArray);
                }
            }
        }
        if (n2 == 5) {
            lispObject3 = (QuotedList)lispObject;
            n = 0;
            LispObject[] lispObjectArray = new LispObject[((QuotedList)lispObject3).value.length];
            for (int i = 0; i < ((QuotedList)lispObject3).value.length; ++i) {
                LispObject lispObject5 = ((QuotedList)lispObject3).value[i];
                lispObjectArray[i] = lispObject2 = this.buildCode(lispObject5);
                if (lispObject5 == lispObject2) continue;
                n = 1;
            }
            if (n != 0) {
                return new QuotedList(lispObjectArray);
            }
        }
        return lispObject;
    }

    void initialize() {
        Vector vector = new Vector(10);
        this.collectFields(vector, this.code);
        int n = vector.size();
        this.fields = new FunctorList[n];
        this.values = new LispObject[n];
        for (int i = 0; i < n; ++i) {
            this.fields[i] = (FunctorList)vector.elementAt(i);
        }
    }

    Displayable createForm() throws EvaluateException {
        if (this.fields.length > 1) {
            Form form = new Form(this.formtitle.evaluateSExp().toValueString(0));
            block12: for (int i = 0; i < this.fields.length; ++i) {
                FunctorList functorList = this.fields[i];
                short s = functorList.getShort(1);
                String string = functorList.evaluateArg2().toValueString(0);
                LispObject lispObject = functorList.evaluateArg3();
                switch (s) {
                    case 100: {
                        ChoiceGroup choiceGroup = new ChoiceGroup(string, 1);
                        LispObject[] lispObjectArray = ((QuotedList)lispObject).value;
                        for (int j = 0; j < lispObjectArray.length; ++j) {
                            choiceGroup.append(lispObjectArray[j].toValueString(0), null);
                        }
                        form.append((Item)choiceGroup);
                        continue block12;
                    }
                    case 0: {
                        form.append((Item)new TextField(string, lispObject.toValueString(0), 256, 0));
                        continue block12;
                    }
                    case 1: {
                        form.append((Item)new TextField(string, lispObject.toValueString(0), 256, 2));
                        continue block12;
                    }
                    case 2: {
                        form.append((Item)new TextField(string, lispObject.toValueString(0), 256, 0));
                    }
                }
            }
            this.screen = form;
            return form;
        }
        TextBox textBox = null;
        FunctorList functorList = this.fields[0];
        short s = functorList.getShort(1);
        String string = this.formtitle.evaluateSExp().toValueString(0);
        LispObject lispObject = functorList.evaluateArg3();
        switch (this.fields[0].getShort(1)) {
            case 100: {
                List list = new List(string, 1);
                LispObject[] lispObjectArray = ((QuotedList)lispObject).value;
                for (int i = 0; i < lispObjectArray.length; ++i) {
                    list.append(lispObjectArray[i].toValueString(0), null);
                }
                textBox = list;
                break;
            }
            case 0: {
                textBox = new TextBox(string, lispObject.toValueString(0), 256, 0);
                break;
            }
            case 1: {
                textBox = new TextBox(string, lispObject.toValueString(0), 256, 2);
                break;
            }
            case 2: {
                textBox = new TextBox(string, lispObject.toValueString(0), 256, 0);
            }
        }
        this.screen = textBox;
        return textBox;
    }

    void extractFromForm(Displayable displayable) throws EvaluateException {
        if (this.fields.length > 1) {
            Form form = (Form)displayable;
            for (int i = 0; i < this.fields.length; ++i) {
                short s = this.fields[i].getShort(1);
                LispObject lispObject = LispObject.NIL;
                switch (s) {
                    case 100: {
                        ChoiceGroup choiceGroup = (ChoiceGroup)form.get(i);
                        int n = choiceGroup.getSelectedIndex();
                        if (n == -1) break;
                        lispObject = new StringAtom(choiceGroup.getString(n));
                        break;
                    }
                    case 0: {
                        lispObject = new StringAtom(((TextField)form.get(i)).getString());
                        break;
                    }
                    case 1: {
                        lispObject = ShortAtom.createShortAtom(Short.parseShort(((TextField)form.get(i)).getString()));
                        break;
                    }
                    case 2: {
                        lispObject = new FloatAtom(((TextField)form.get(i)).getString());
                    }
                }
                this.values[i] = lispObject;
            }
            return;
        }
        short s = this.fields[0].getShort(1);
        LispObject lispObject = LispObject.NIL;
        switch (s) {
            case 100: {
                List list = (List)displayable;
                int n = list.getSelectedIndex();
                if (n == -1) break;
                lispObject = new StringAtom(list.getString(n));
                break;
            }
            case 0: {
                lispObject = new StringAtom(((TextBox)displayable).getString());
                break;
            }
            case 1: {
                lispObject = ShortAtom.createShortAtom(Short.parseShort(((TextBox)displayable).getString()));
                break;
            }
            case 2: {
                lispObject = new FloatAtom(((TextBox)displayable).getString());
            }
        }
        this.values[0] = lispObject;
    }
}

