/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Bfunc;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.FunctorList1;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LongAtom;
import java.util.Calendar;
import java.util.Date;
import net.jscience.math.MathFP;

public class DateAtom
extends LispObject {
    public long value;

    public DateAtom() {
    }

    public DateAtom(long l) {
        this.value = l;
    }

    FunctorList toList() {
        return new FunctorList1(Bfunc.BFUNC.table[47], new LongAtom(this.value));
    }

    public void toValueBuffer(StringBuffer stringBuffer, int n) {
        DateAtom.dateToBuffer(stringBuffer, this.value, n);
    }

    public void toFormulaBuffer(StringBuffer stringBuffer) {
        stringBuffer.append('#');
        DateAtom.dateToBuffer(stringBuffer, this.value, 8);
        stringBuffer.append('#');
    }

    public int typeNumber() {
        return 12;
    }

    public LispObject convertToType(int n) throws EvaluateException {
        LispObject lispObject = this;
        switch (n) {
            case 8: {
                lispObject = new LongAtom(this.value);
                break;
            }
            case 9: {
                lispObject = new FloatAtom(MathFP.div(MathFP.toFP(this.value), Bfunc.DAY_BCD_MS_FLOAT));
                break;
            }
            default: {
                return super.convertToType(n);
            }
        }
        return lispObject;
    }

    public static void dateToBuffer(StringBuffer stringBuffer, long l, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l * 1000L));
        int n2 = calendar.get(1);
        int n3 = calendar.get(5);
        int n4 = calendar.get(2) + 1;
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        if ((n &= 0xC) == 0 || n == 8) {
            stringBuffer.append(Integer.toString(n4));
            stringBuffer.append('/');
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n3));
            stringBuffer.append('/');
            stringBuffer.append(Integer.toString(n2));
        }
        if (n == 8) {
            stringBuffer.append(' ');
        }
        if (n == 4 || n == 8) {
            if (n5 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n5));
            stringBuffer.append(':');
            if (n6 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n6));
        }
    }
}

