/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Bfunc;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.FunctorListN;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.Sheet;
import com.wapindustrial.calc.ShortAtom;

public class Cell
extends LispObject {
    short i;
    short j;
    LispObject value;
    LispObject formula;
    static final int FORMAT_SHOWVALUE = 0;
    static final int FORMAT_SHOWLISP = 1;
    static final int FORMAT_SHOWFORMULA = 2;
    static final int MASK_FORMULA = 3;
    static final int FORMAT_SHOWDATE = 0;
    static final int FORMAT_SHOWTIME = 4;
    static final int FORMAT_SHOWDATETIME = 8;
    static final int MASK_DATE = 12;
    short format;

    public Cell(int n, int n2, LispObject lispObject, int n3) {
        this.i = (short)n;
        this.j = (short)n2;
        this.formula = lispObject;
        this.value = LispObject.NIL;
        this.format = (short)n3;
    }

    public String getText() {
        int n = this.format & 3;
        if (n == 1) {
            return this.formula.toString();
        }
        if (n == 2) {
            return this.getFormula();
        }
        return this.value.toValueString(this.format);
    }

    public final boolean isEmpty() {
        return this.value == LispObject.NIL;
    }

    public final boolean isFormula() {
        switch (this.formula.typeNumber()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public String getFormula() {
        StringBuffer stringBuffer = new StringBuffer(40);
        if (this.isFormula()) {
            stringBuffer.append('=');
            this.formula.toFormulaBuffer(stringBuffer);
        } else {
            this.formula.toValueBuffer(stringBuffer, this.format);
        }
        return stringBuffer.toString();
    }

    public int typeNumber() {
        return 14;
    }

    public FunctorList toList() {
        return new FunctorListN(Bfunc.BFUNC.table[31], new LispObject[]{new ShortAtom(this.i), new ShortAtom(this.j), this.formula, new ShortAtom(this.format)});
    }

    public static LispObject fromList(FunctorList functorList) throws EvaluateException {
        int n = functorList.listSize();
        short s = ((ShortAtom)functorList.evaluateArg1()).value;
        short s2 = ((ShortAtom)functorList.evaluateArg2()).value;
        LispObject lispObject = functorList.getArgument3();
        lispObject = Sheet.evaluateRef(lispObject, s, s2);
        short s3 = ((ShortAtom)functorList.evaluateArgN((int)4)).value;
        return new Cell(s, s2, lispObject, s3);
    }

    public int hashCode() {
        return this.i << 16 | this.j;
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }
}

