/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.ShortAtom;
import net.jscience.math.MathFP;

public class BooleanAtom
extends LispObject {
    public boolean value;
    public static final BooleanAtom TRUE = new BooleanAtom(true);
    public static final BooleanAtom FALSE = new BooleanAtom(false);

    public BooleanAtom() {
    }

    private BooleanAtom(boolean bl) {
        this.value = bl;
    }

    public static BooleanAtom createBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public void toBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.value ? "true" : "false");
    }

    public void toJavaBuffer(StringBuffer stringBuffer, int n, FunctorList functorList) {
        this.addIdent(stringBuffer, n);
        stringBuffer.append("BooleanAtom.");
        stringBuffer.append(this.value ? "TRUE" : "FALSE");
        stringBuffer.append(' ');
    }

    public int typeNumber() {
        return 6;
    }

    public LispObject convertToType(int n) throws EvaluateException {
        LispObject lispObject = this;
        switch (n) {
            case 7: {
                lispObject = ShortAtom.createShortAtom(this == TRUE ? 1 : 0);
                break;
            }
            case 9: {
                lispObject = new FloatAtom(this == TRUE ? MathFP.toFP(1L) : 0L);
                break;
            }
            default: {
                return super.convertToType(n);
            }
        }
        return lispObject;
    }
}

