/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.BooleanAtom;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LongAtom;

public class ShortAtom
extends LispObject {
    public static final ShortAtom ZERO = new ShortAtom(0);
    public static final ShortAtom ONE = new ShortAtom(1);
    public static final ShortAtom ONE_MINUS = new ShortAtom(-1);
    public short value;

    public ShortAtom(int n) {
        this.value = (short)n;
    }

    static ShortAtom createShortAtom(int n) {
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return ONE;
        }
        if (n == -1) {
            return ONE_MINUS;
        }
        return new ShortAtom(n);
    }

    public void toBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(Integer.toString(this.value));
    }

    public int typeNumber() {
        return 7;
    }

    public LispObject convertToType(int n) throws EvaluateException {
        LispObject lispObject = this;
        switch (n) {
            case 6: {
                lispObject = this.value == 0 ? BooleanAtom.FALSE : BooleanAtom.TRUE;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                lispObject = new LongAtom(this.value);
                break;
            }
            case 9: {
                lispObject = FloatAtom.convertFromLong(this.value);
                break;
            }
            default: {
                return super.convertToType(n);
            }
        }
        return lispObject;
    }
}

