/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Bfunc;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FunctionModule;
import com.wapindustrial.calc.HelpFunctions;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.NameObjectBase;
import com.wapindustrial.calc.Operator;
import com.wapindustrial.calc.ScreenLite;
import com.wapindustrial.calc.ServerUploader;
import startup.Startup;

public class ModuleHandler
extends FunctionModule {
    public static ModuleHandler MODULEHANDLER = new ModuleHandler();
    private FunctionModule[] modules = new FunctionModule[]{Bfunc.BFUNC, ScreenLite.SCREENLITE, Operator.OPERATOR, HelpFunctions.HELPFUNCTIONS, ServerUploader.SERVERUPLOADER, Startup.STARTUP, this};
    private int modulesCount = this.modules.length;

    public void initializeNames() {
        this.namesArray = new byte[1000];
        this.table = new FunctionModule.ModuleName[20];
        this.namesArrayCount = 0;
        this.namesCount = 0;
        for (int i = 0; i < this.modulesCount - 1; ++i) {
            this.modules[i].initializeNames();
        }
    }

    public NameObjectBase findNameInAllModules(String string) {
        FunctionModule.ModuleName moduleName = null;
        for (int i = 0; i < this.modulesCount && (moduleName = this.modules[i].findName(string)) == null; ++i) {
        }
        return moduleName;
    }

    public NameObjectBase createName(String string) throws EvaluateException {
        NameObjectBase nameObjectBase = this.findNameInAllModules(string);
        if (nameObjectBase == null) {
            FunctionModule functionModule;
            String string2 = ModuleHandler.getClassName(string);
            if (string2 != null && (functionModule = ModuleHandler.getFunctionModule(string2)) != null) {
                LispObject.debug("initializing names for " + string);
                functionModule.initializeNames();
                LispObject.debug("names initialized");
                nameObjectBase = functionModule.findName(string);
            }
            if (nameObjectBase == null) {
                try {
                    nameObjectBase = this.addDataName(string);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    LispObject.debug("tables overflow? namesArrayCount=" + this.namesArrayCount + " namesCount=" + this.namesCount);
                    throw new EvaluateException("name table overflow");
                }
            }
        }
        return nameObjectBase;
    }

    private static final String getClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    static FunctionModule getFunctionModule(String string) throws EvaluateException {
        try {
            LispObject.debug("loading class: " + string);
            Class<?> clazz = Class.forName(string);
            LispObject.debug("loaded");
            return (FunctionModule)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new EvaluateException("Error instantiating class for builtin name: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EvaluateException("Class does not conform FunctionObject interface: " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new EvaluateException("Reference to undefined name: " + string);
        }
    }
}

