/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Bfunc;
import com.wapindustrial.calc.BooleanAtom;
import com.wapindustrial.calc.CanvasHandler1;
import com.wapindustrial.calc.Cell;
import com.wapindustrial.calc.DateAtom;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.FormulaError;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.FunctorList0;
import com.wapindustrial.calc.FunctorList1;
import com.wapindustrial.calc.FunctorList2;
import com.wapindustrial.calc.FunctorList3;
import com.wapindustrial.calc.FunctorListN;
import com.wapindustrial.calc.LongAtom;
import com.wapindustrial.calc.ModuleHandler;
import com.wapindustrial.calc.NameObjectBase;
import com.wapindustrial.calc.ParseException;
import com.wapindustrial.calc.QuotedList;
import com.wapindustrial.calc.Reference;
import com.wapindustrial.calc.RowColumn;
import com.wapindustrial.calc.Sheet;
import com.wapindustrial.calc.ShortAtom;
import com.wapindustrial.calc.StringAtom;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class LispObject {
    private static final int MAX_MC2FILE_SIZE = 15;
    public static final LispObject NIL = new LispObject();
    static final int TYPE_UNKNOWN = 0;
    static final int TYPE_NIL = 1;
    static final int TYPE_REFERENCE = 2;
    static final int TYPE_NAME = 3;
    static final int TYPE_FUNCTORLIST = 4;
    static final int TYPE_QUOTEDLIST = 5;
    static final int TYPE_BOOLEAN = 6;
    static final int TYPE_SHORT = 7;
    static final int TYPE_LONG = 8;
    static final int TYPE_FLOAT = 9;
    static final int TYPE_STRING = 10;
    static final int TYPE_ERROR = 11;
    static final int TYPE_DATE = 12;
    static final int TYPE_ROWCOLUMN = 13;
    static final int TYPE_CELL = 14;
    static final int TYPE_SHEET = 15;
    static final int TYPE_FUNCTION = 16;
    static final int TYPE_PROFILE = 17;
    public static final QuotedList EMPTY_LIST = new QuotedList(new LispObject[0]);
    private static int ncur;
    private static char[] buf;
    static int lineno;
    private static final boolean DEBUG = false;

    public LispObject evaluateSExp() throws EvaluateException {
        return this;
    }

    public LispObject interpret() throws EvaluateException {
        return this.evaluateSExp();
    }

    public LispObject moveReferences(int n, int n2) {
        return this;
    }

    public LispObject shiftReferences(int n, int n2, int n3, int n4) {
        return this;
    }

    public int typeNumber() {
        return 1;
    }

    public static final byte[] getBytesUTF8(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[]{};
        byArray = string.getBytes();
        return byArray;
    }

    public static final String getStringUTF8(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        return new String(byArray, n, n2);
    }

    public static final Hashtable createHashtable(int n) {
        return new Hashtable(n);
    }

    public LispObject convertToType(int n) throws EvaluateException {
        if (this == NIL) {
            LispObject lispObject = this;
            switch (n) {
                case 7: {
                    lispObject = ShortAtom.ZERO;
                    break;
                }
                case 8: {
                    lispObject = new LongAtom();
                    break;
                }
                case 9: {
                    lispObject = new FloatAtom();
                }
            }
            return lispObject;
        }
        if (n == 10) {
            return new StringAtom(this.toString());
        }
        throw new EvaluateException("cannot convert type " + this.typeNumber() + " to " + n, this);
    }

    FunctorList toList() {
        return null;
    }

    public void toBuffer(StringBuffer stringBuffer) {
        FunctorList functorList = this.toList();
        if (functorList != null) {
            functorList.toBuffer(stringBuffer);
            return;
        }
        if (this == NIL) {
            stringBuffer.append("nil");
        } else {
            stringBuffer.append('<');
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append('>');
        }
    }

    public void toFormulaBuffer(StringBuffer stringBuffer) {
        if (this == NIL) {
            return;
        }
        this.toBuffer(stringBuffer);
    }

    public void toValueBuffer(StringBuffer stringBuffer, int n) {
        if (this == NIL) {
            return;
        }
        this.toBuffer(stringBuffer);
    }

    public String toFormulaString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toFormulaBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    public String toValueString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toValueBuffer(stringBuffer, n);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    protected void addIdent(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
    }

    public static FunctorList createFunctorList(LispObject[] lispObjectArray) throws ClassCastException {
        int n = lispObjectArray.length;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        NameObjectBase nameObjectBase = (NameObjectBase)lispObjectArray[0];
        if (n == 1) {
            return new FunctorList0(nameObjectBase);
        }
        if (n == 2) {
            return new FunctorList1(nameObjectBase, lispObjectArray[1]);
        }
        if (n == 3) {
            return new FunctorList2(nameObjectBase, lispObjectArray[1], lispObjectArray[2]);
        }
        if (n == 4) {
            return new FunctorList3(nameObjectBase, lispObjectArray[1], lispObjectArray[2], lispObjectArray[3]);
        }
        LispObject[] lispObjectArray2 = new LispObject[n - 1];
        for (int i = 1; i < n; ++i) {
            lispObjectArray2[i - 1] = lispObjectArray[i];
        }
        return new FunctorListN(nameObjectBase, lispObjectArray2);
    }

    public static LispObject createFunctorOrQuotedList(LispObject[] lispObjectArray) {
        if (lispObjectArray.length == 0) {
            return EMPTY_LIST;
        }
        if (lispObjectArray[0] instanceof NameObjectBase) {
            return LispObject.createFunctorList(lispObjectArray);
        }
        return new QuotedList(lispObjectArray);
    }

    public static LispObject fromList(FunctorList functorList) throws EvaluateException {
        int n = functorList.listSize();
        if (functorList.functor == Bfunc.BFUNC.table[32]) {
            Reference reference = new Reference(((ShortAtom)functorList.evaluateArgN((int)1)).value, ((ShortAtom)functorList.evaluateArgN((int)2)).value, ((ShortAtom)functorList.evaluateArgN((int)3)).value, ((ShortAtom)functorList.evaluateArgN((int)4)).value, ((ShortAtom)functorList.evaluateArgN((int)5)).value);
            return reference;
        }
        if (functorList.functor == Bfunc.BFUNC.table[75]) {
            if (functorList.listSize() > 2) {
                return new FormulaError(functorList.getShort1(), functorList.getString2());
            }
            return new FormulaError(functorList.getShort1());
        }
        if (functorList.functor == Bfunc.BFUNC.table[47]) {
            return new DateAtom(((LongAtom)functorList.evaluateArg1()).value);
        }
        if (functorList.functor == Bfunc.BFUNC.table[30]) {
            return Sheet.sheetFromList(functorList);
        }
        if (functorList.functor == Bfunc.BFUNC.table[48]) {
            return new RowColumn(functorList.getShort(1), functorList.getShort(2));
        }
        if (functorList.functor == Bfunc.BFUNC.table[31]) {
            return Cell.fromList(functorList);
        }
        if (functorList.functor == Bfunc.BFUNC.table[132]) {
            return new QuotedList(functorList, 1, n);
        }
        throw new IllegalArgumentException("Wrong call of toList()");
    }

    public QuotedList toQuotedList() {
        throw new IllegalArgumentException();
    }

    private static char skipBlanks() {
        char c;
        while ((c = buf[ncur]) == '\n' || c == '\r' || c == '\t' || c == ' ') {
            if (c == '\n') {
                ++lineno;
            }
            ++ncur;
        }
        ++ncur;
        return c;
    }

    private static char skipBlanks1() {
        char c;
        while ((c = LispObject.skipBlanks()) == ';') {
            while ((c = buf[ncur]) != '\n' && c != '\r' && c != '\u0000') {
                if (c == '\n') {
                    ++lineno;
                }
                ++ncur;
            }
        }
        return c;
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '_';
    }

    private static void prepareBuf(String string) {
        int n = string.length();
        buf = new char[n + 2];
        string.getChars(0, n, buf, 0);
        LispObject.buf[n] = '\u0000';
        LispObject.buf[n + 1] = '\u0000';
        ncur = 0;
        lineno = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized QuotedList parse(String string) throws ParseException {
        LispObject.prepareBuf(string);
        Vector<LispObject> vector = new Vector<LispObject>();
        try {
            while (LispObject.skipBlanks1() != '\u0000') {
                --ncur;
                vector.addElement(LispObject.parseSExpQ());
            }
            QuotedList quotedList = new QuotedList(LispObject.vectorToArray(vector));
            return quotedList;
        }
        finally {
            buf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized LispObject parseSExp(String string) throws ParseException {
        LispObject.prepareBuf(string);
        try {
            LispObject lispObject = LispObject.parseSExpQ();
            return lispObject;
        }
        finally {
            buf = null;
        }
    }

    public static QuotedList loadFile(String string) throws ParseException {
        InputStream inputStream = NIL.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new ParseException("resource file <" + string + "> not found");
        }
        byte[] byArray = new byte[15360];
        try {
            int n = inputStream.read(byArray);
            String string2 = LispObject.getStringUTF8(byArray, 0, n);
            QuotedList quotedList = LispObject.parse(string2);
            return quotedList;
        }
        catch (IOException iOException) {
            throw new ParseException("i/o error while reading file <" + string + ">");
        }
        finally {
            byArray = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static LispObject[] vectorToArray(Vector vector) {
        int n = vector.size();
        LispObject[] lispObjectArray = new LispObject[n];
        for (int i = 0; i < n; ++i) {
            lispObjectArray[i] = (LispObject)vector.elementAt(i);
        }
        return lispObjectArray;
    }

    private static LispObject parseSExpQ() throws ParseException {
        char c = LispObject.skipBlanks1();
        if (c == '\'') {
            LispObject lispObject = LispObject.parseSExp();
            int n = lispObject.typeNumber();
            if (n == 4) {
                return new QuotedList((FunctorList)lispObject);
            }
            if (n == 5) {
                return lispObject;
            }
            throw new ParseException("quote is supported only for lists");
        }
        --ncur;
        return LispObject.parseSExp();
    }

    private static LispObject parseSExp() throws ParseException {
        char c = LispObject.skipBlanks1();
        if (c == '(') {
            Vector<LispObject> vector = new Vector<LispObject>(4);
            while ((c = LispObject.skipBlanks1()) != ')') {
                if (c == '\u0000') {
                    String string = "missing closing ')'";
                    if (vector.size() > 0) {
                        string = string + " for '" + ((LispObject)vector.elementAt(0)).toString();
                        throw new ParseException(string);
                    }
                }
                --ncur;
                vector.addElement(LispObject.parseSExpQ());
            }
            return LispObject.createFunctorOrQuotedList(LispObject.vectorToArray(vector));
        }
        if (c == '\"') {
            StringBuffer stringBuffer = new StringBuffer(20);
            while ((c = buf[ncur]) != '\"') {
                if (c == '\u0000') {
                    throw new ParseException("missing trailing \" in string constant");
                }
                ++ncur;
                if (c == '\n') {
                    ++lineno;
                }
                if (c == '\\') {
                    c = buf[ncur++];
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case '\"': {
                            c = '\"';
                            break;
                        }
                        default: {
                            stringBuffer.append('\\');
                        }
                    }
                }
                stringBuffer.append(c);
            }
            ++ncur;
            return new StringAtom(stringBuffer.toString());
        }
        if (c == '-' || Character.isDigit(c)) {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append(c);
            boolean bl = false;
            while (Character.isDigit(c = buf[ncur]) || c == '.') {
                if (c == '.') {
                    bl = true;
                }
                stringBuffer.append(c);
                ++ncur;
            }
            String string = stringBuffer.toString();
            if (bl) {
                return new FloatAtom(string);
            }
            if (c == 'L') {
                ++ncur;
                return new LongAtom(Long.parseLong(string));
            }
            return ShortAtom.createShortAtom(Short.parseShort(string));
        }
        if (LispObject.isLetter(c)) {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append(c);
            while (LispObject.isLetter(c = buf[ncur]) || c == '_' || c == '.' || c == '-' || Character.isDigit(c)) {
                stringBuffer.append(c);
                ++ncur;
            }
            String string = stringBuffer.toString();
            if (string.equals("nil")) {
                return NIL;
            }
            if (string.equals("true")) {
                return BooleanAtom.TRUE;
            }
            if (string.equals("false")) {
                return BooleanAtom.FALSE;
            }
            try {
                return ModuleHandler.MODULEHANDLER.createName(string);
            }
            catch (EvaluateException evaluateException) {
                throw new ParseException("Cannot initiate name <" + string + ">: " + evaluateException.getMessage());
            }
        }
        throw new ParseException("Unexpected character <" + c + ">");
    }

    public int listSize() {
        return 0;
    }

    public static final void debug(String string) {
        CanvasHandler1.addToHistory(string);
    }
}

