/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.CanvasHandler1;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FormulaError;
import com.wapindustrial.calc.FunctionModule;
import com.wapindustrial.calc.FunctionObject;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LispTask;
import com.wapindustrial.calc.NameObjectBase;
import com.wapindustrial.calc.QuotedList;
import com.wapindustrial.calc.ShortAtom;
import com.wapindustrial.calc.StringAtom;
import com.wapindustrial.calc.UserFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

public class HelpFunctions
extends FunctionModule
implements CommandListener {
    public static final HelpFunctions HELPFUNCTIONS = new HelpFunctions();
    static final byte[] _namesArray = new byte[]{12, 98, 114, 111, 119, 115, 101, 45, 110, 97, 109, 101, 115, 16, 102, 105, 108, 101, 45, 115, 101, 99, 116, 105, 111, 110, 108, 111, 97, 100, 16, 102, 105, 108, 101, 45, 115, 101, 99, 116, 105, 111, 110, 115, 104, 111, 119};
    public static final int NAME_BROWSE_NAMES = 0;
    public static final int NAME_FILE_SECTIONLOAD = 13;
    public static final int NAME_FILE_SECTIONSHOW = 30;
    public static final int INDEX_BROWSE_NAMES = 0;
    public static final int INDEX_FILE_SECTIONLOAD = 1;
    public static final int INDEX_FILE_SECTIONSHOW = 2;
    private static final Command cmdOK = new Command("Done", 4, 1);
    private static final Command cmdBack = new Command("Back", 2, 2);
    private static String curfile;
    private static Section cursection;
    private static final Section[] history;
    private static int nhist;
    String encoding;
    static int bufcc;
    static int offset;
    static int bufundo;
    static InputStream inputstream;
    static final Hashtable indextables;

    public void initializeNames() {
        this.namesArray = _namesArray;
        this.namesArrayCount = this.namesArray.length;
        this.table = new FunctionModule.ModuleName[]{(FunctionModule)this.new FunctionModule.ModuleName(0), (FunctionModule)this.new FunctionModule.ModuleName(13), (FunctionModule)this.new FunctionModule.ModuleName(30)};
        this.namesCount = this.table.length;
    }

    public LispObject evaluate(FunctionModule.ModuleName moduleName, FunctorList functorList) throws EvaluateException {
        int n = functorList.listSize();
        short s = moduleName.offset;
        FormulaError formulaError = FormulaError.ERROR;
        switch (s) {
            case 0: {
                short s2 = ((ShortAtom)functorList.evaluateArg1()).value;
                int n2 = ((ShortAtom)functorList.evaluateArg2()).value;
                short s3 = ((ShortAtom)functorList.evaluateArg3()).value;
                int n3 = 0;
                int n4 = this.namesCount;
                Vector<FunctionModule.ModuleName> vector = new Vector<FunctionModule.ModuleName>(s3);
                for (int i = 0; i < n4; ++i) {
                    FunctionModule.ModuleName moduleName2 = this.table[i];
                    int n5 = 0;
                    n5 = ((NameObjectBase)moduleName2).getMappedObject() instanceof UserFunction ? 2 : (((NameObjectBase)moduleName2).getMappedObject() instanceof FunctionObject ? 1 : 4);
                    if ((n5 & s2) == 0) continue;
                    if (n3 < n2) {
                        ++n3;
                        continue;
                    }
                    if (n3 >= n2 + s3) break;
                    vector.addElement(moduleName2);
                    ++n3;
                }
                n4 = vector.size();
                LispObject[] lispObjectArray = new LispObject[n4];
                for (int i = 0; i < n4; ++i) {
                    lispObjectArray[i] = new StringAtom(((NameObjectBase)vector.elementAt(i)).getName());
                }
                return new QuotedList(lispObjectArray);
            }
            case 13: {
                String string = functorList.getString(1);
                String string2 = functorList.getString(2);
                String string3 = null;
                if (n == 4) {
                    string3 = functorList.getString(3);
                }
                try {
                    String string4 = HelpFunctions.loadSection(string, string2, string3);
                    if (string4 == null) {
                        string4 = "Section " + string2 + "not found";
                    }
                    return new StringAtom(string4);
                }
                catch (IOException iOException) {
                    throw new EvaluateException(iOException.getMessage(), functorList);
                }
            }
            case 30: {
                String string = functorList.getString(1);
                String string5 = functorList.getString(2);
                this.encoding = null;
                if (n == 4) {
                    this.encoding = functorList.getString(3);
                }
                nhist = 0;
                this.setForm(string, string5);
            }
        }
        return LispObject.NIL;
    }

    private void setForm(String string, String string2) {
        curfile = string;
        Form form = new Form(string2);
        try {
            cursection = HelpFunctions.getSection(string, string2);
            String string3 = "section not found";
            if (cursection != null) {
                string3 = HelpFunctions.loadSection(string, string2, this.encoding);
                if (HelpFunctions.cursection.links != null) {
                    for (int i = 0; i < HelpFunctions.cursection.links.size(); ++i) {
                        Command command = new Command((String)HelpFunctions.cursection.links.elementAt(i), 1, 3 + i);
                        form.addCommand(command);
                    }
                }
            }
            form.append(string3);
            form.addCommand(cmdOK);
            form.addCommand(cmdBack);
            form.setCommandListener((CommandListener)this);
            LispTask.LispMachine.popMessage = form;
            CanvasHandler1.setDisplay((Displayable)form);
        }
        catch (IOException iOException) {
            LispObject.debug("Exception in setForm()");
            LispObject.debug(iOException.getMessage());
            CanvasHandler1.setCanvas();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == cmdOK) {
            nhist = 0;
            CanvasHandler1.setCanvas();
            return;
        }
        if (command == cmdBack) {
            if (nhist == 0) {
                CanvasHandler1.setCanvas();
            } else {
                Section section = history[--nhist];
                this.setForm(curfile, section.name);
            }
            return;
        }
        HelpFunctions.history[HelpFunctions.nhist++] = cursection;
        int n = command.getPriority() - 3;
        this.setForm(curfile, (String)HelpFunctions.cursection.links.elementAt(n));
    }

    static final int readc() {
        ++offset;
        if (bufundo != -1) {
            bufcc = bufundo;
            bufundo = -1;
            return bufcc;
        }
        try {
            bufcc = inputstream.read();
        }
        catch (IOException iOException) {
            return -1;
        }
        return bufcc;
    }

    static final void undo() {
        bufundo = bufcc;
        --offset;
    }

    static final synchronized Hashtable loadIndexes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[40];
        Hashtable<String, Section> hashtable = new Hashtable<String, Section>(10);
        offset = 0;
        bufundo = -1;
        inputstream = inputStream;
        while ((n = HelpFunctions.readc()) != -1) {
            if (n != 91) {
                throw new IOException("wrong help file format");
            }
            int n2 = 0;
            while ((n = HelpFunctions.readc()) != 93) {
                byArray[n2++] = (byte)n;
            }
            String string = new String(byArray, 0, n2);
            if (n2 == 0) {
                throw new IOException("wrong help file format");
            }
            int n3 = offset;
            byte[] byArray2 = new byte[40];
            Vector<String> vector = null;
            int n4 = HelpFunctions.readc();
            int n5 = HelpFunctions.readc();
            while (n4 != 10 || n5 != 91) {
                if (n4 == -1 || n5 == -1) {
                    hashtable.put(string, new Section(string, n3, offset, vector));
                    return hashtable;
                }
                if (n4 == 10 && n5 == 64) {
                    int n6 = 0;
                    while ((n5 = HelpFunctions.readc()) != 10) {
                        byArray2[n6++] = (byte)n5;
                    }
                    if (vector == null) {
                        vector = new Vector<String>(1);
                    }
                    vector.addElement(new String(byArray2, 0, n6).trim());
                }
                n4 = n5;
                n5 = HelpFunctions.readc();
            }
            HelpFunctions.undo();
            hashtable.put(string, new Section(string, n3, offset, vector));
        }
        return hashtable;
    }

    static final Section getSection(String string, String string2) throws IOException {
        Hashtable hashtable = (Hashtable)indextables.get(string);
        if (hashtable == null) {
            InputStream inputStream = HELPFUNCTIONS.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                inputStream.close();
                throw new IOException("Help file doesn't exist");
            }
            hashtable = HelpFunctions.loadIndexes(inputStream);
            inputStream.close();
            indextables.put(string, hashtable);
        }
        return (Section)hashtable.get(string2);
    }

    static final String loadSection(String string, String string2, String string3) throws IOException {
        Section section = HelpFunctions.getSection(string, string2);
        if (section == null) {
            return null;
        }
        InputStream inputStream = HELPFUNCTIONS.getClass().getResourceAsStream(string);
        int n = section.endsec - section.startsec;
        inputStream.skip(section.startsec);
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        inputStream.close();
        if (string3 != null) {
            try {
                return new String(byArray, 0, n, string3).trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LispObject.debug("cannot decode name from UTF-8");
                throw new IOException();
            }
        }
        return new String(byArray, 0, n).trim();
    }

    static {
        cursection = null;
        history = new Section[20];
        nhist = 0;
        indextables = new Hashtable(1);
    }

    static class Section {
        String name;
        short startsec;
        short endsec;
        Vector links;

        Section(String string, int n, int n2, Vector vector) {
            this.name = string;
            this.startsec = (short)n;
            this.endsec = (short)n2;
            this.links = vector;
        }
    }
}

