/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.BooleanAtom;
import com.wapindustrial.calc.Cell;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LongAtom;
import com.wapindustrial.calc.NameObjectBase;
import com.wapindustrial.calc.QuotedList;
import com.wapindustrial.calc.Sheet;
import com.wapindustrial.calc.ShortAtom;
import com.wapindustrial.calc.StringAtomBase;

public abstract class FunctorList
extends LispObject {
    public final NameObjectBase functor;

    public LispObject[] toArray() {
        int n = this.listSize();
        LispObject[] lispObjectArray = new LispObject[n];
        lispObjectArray[0] = this.functor;
        for (int i = 1; i < n; ++i) {
            lispObjectArray[i] = this.getArgumentN(i);
        }
        return lispObjectArray;
    }

    public QuotedList toQuotedList() {
        return new QuotedList(this.toArray());
    }

    FunctorList toList() {
        return this;
    }

    public abstract LispObject getArgumentN(int var1);

    public LispObject getArgument1() {
        return this.getArgumentN(1);
    }

    public LispObject getArgument2() {
        return this.getArgumentN(2);
    }

    public LispObject getArgument3() {
        return this.getArgumentN(3);
    }

    public LispObject evaluateArgN(int n) throws EvaluateException {
        return this.getArgumentN(n).evaluateSExp();
    }

    public LispObject evaluateArg1() throws EvaluateException {
        return this.evaluateArgN(1);
    }

    public LispObject evaluateArg2() throws EvaluateException {
        return this.evaluateArgN(2);
    }

    public LispObject evaluateArg3() throws EvaluateException {
        return this.evaluateArgN(3);
    }

    public LispObject interpretArgN(int n) throws EvaluateException {
        return this.getArgumentN(n).interpret();
    }

    public LispObject interpretArg1() throws EvaluateException {
        return this.interpretArgN(1);
    }

    public LispObject interpretArg2() throws EvaluateException {
        return this.interpretArgN(2);
    }

    public LispObject interpretArg3() throws EvaluateException {
        return this.interpretArgN(3);
    }

    public FunctorList(NameObjectBase nameObjectBase) {
        this.functor = nameObjectBase;
    }

    public void toBuffer(StringBuffer stringBuffer) {
        stringBuffer.append('(');
        stringBuffer.append(this.functor.getName());
        LispObject[] lispObjectArray = this.toArray();
        for (int i = 1; i < lispObjectArray.length; ++i) {
            stringBuffer.append(' ');
            lispObjectArray[i].toBuffer(stringBuffer);
        }
        stringBuffer.append(')');
    }

    public void toFormulaBuffer(StringBuffer stringBuffer) {
        this.functor.toFormulaBuffer(stringBuffer, this);
    }

    public LispObject evaluateSExp() throws EvaluateException {
        return this.functor.evaluate(this);
    }

    public LispObject shiftReferences(int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = this.listSize();
        LispObject[] lispObjectArray = new LispObject[n5];
        lispObjectArray[0] = this.functor;
        for (int i = 1; i < n5; ++i) {
            LispObject lispObject;
            LispObject lispObject2 = this.getArgumentN(i);
            if (lispObject2 == (lispObject = (lispObjectArray[i] = lispObject2.shiftReferences(n, n2, n3, n4)))) continue;
            bl = true;
        }
        if (bl) {
            return LispObject.createFunctorList(lispObjectArray);
        }
        return this;
    }

    public LispObject moveReferences(int n, int n2) {
        boolean bl = false;
        int n3 = this.listSize();
        LispObject[] lispObjectArray = new LispObject[n3];
        lispObjectArray[0] = this.functor;
        for (int i = 1; i < n3; ++i) {
            LispObject lispObject;
            LispObject lispObject2 = this.getArgumentN(i);
            if (lispObject2 == (lispObject = (lispObjectArray[i] = lispObject2.moveReferences(n, n2)))) continue;
            bl = true;
        }
        if (bl) {
            return LispObject.createFunctorList(lispObjectArray);
        }
        return this;
    }

    public final short getShort(int n) throws EvaluateException {
        LispObject lispObject = this.evaluateArgN(n);
        if (lispObject == LispObject.NIL) {
            return 0;
        }
        return ((ShortAtom)lispObject).value;
    }

    public final short getShort1() throws EvaluateException {
        LispObject lispObject = this.evaluateArg1();
        if (lispObject == LispObject.NIL) {
            return 0;
        }
        return ((ShortAtom)lispObject).value;
    }

    public final short getShort2() throws EvaluateException {
        LispObject lispObject = this.evaluateArg2();
        if (lispObject == LispObject.NIL) {
            return 0;
        }
        return ((ShortAtom)lispObject).value;
    }

    public final short getShort3() throws EvaluateException {
        LispObject lispObject = this.evaluateArg3();
        if (lispObject == LispObject.NIL) {
            return 0;
        }
        return ((ShortAtom)lispObject).value;
    }

    public final Cell getCell(int n) throws EvaluateException {
        return (Cell)this.evaluateArgN(n);
    }

    public final Cell getCell1() throws EvaluateException {
        return (Cell)this.evaluateArg1();
    }

    public final Sheet getSheet(int n) throws EvaluateException {
        return (Sheet)this.evaluateArgN(n);
    }

    public final Sheet getSheet1() throws EvaluateException {
        return (Sheet)this.evaluateArg1();
    }

    public final boolean getBoolean(int n) throws EvaluateException {
        LispObject lispObject = this.evaluateArgN(n);
        if (lispObject == LispObject.NIL) {
            return false;
        }
        return ((BooleanAtom)lispObject).value;
    }

    public final int getInt(int n) throws EvaluateException {
        LispObject lispObject = this.evaluateArgN(n);
        if (lispObject == LispObject.NIL) {
            return 0;
        }
        return (int)((LongAtom)lispObject).value;
    }

    public final FloatAtom getFloat(int n) throws EvaluateException {
        LispObject lispObject = this.evaluateArgN(n);
        if (lispObject == LispObject.NIL) {
            return null;
        }
        return (FloatAtom)lispObject;
    }

    public final String getString(int n) throws EvaluateException {
        LispObject lispObject = this.evaluateArgN(n);
        if (lispObject == LispObject.NIL) {
            return null;
        }
        if (lispObject.typeNumber() == 10) {
            return ((StringAtomBase)lispObject).getValue();
        }
        return lispObject.toString();
    }

    public final String getString1() throws EvaluateException {
        return this.getString(1);
    }

    public final String getString2() throws EvaluateException {
        return this.getString(2);
    }

    public final String getString3() throws EvaluateException {
        return this.getString(3);
    }

    public final QuotedList getQuotedList(int n) throws EvaluateException {
        LispObject lispObject = this.evaluateArgN(n);
        if (lispObject == LispObject.NIL) {
            return null;
        }
        return (QuotedList)lispObject;
    }

    public int typeNumber() {
        return 4;
    }
}

