/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FunctionObject;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.NameObjectBase;
import com.wapindustrial.calc.StringAtomBase;

public abstract class FunctionModule
extends FunctionObject {
    public ModuleName[] table;
    protected byte[] namesArray;
    protected int namesArrayCount;
    protected int namesCount;

    public abstract void initializeNames();

    public LispObject evaluate(FunctorList functorList) throws EvaluateException {
        ModuleName moduleName;
        try {
            moduleName = (ModuleName)functorList.functor;
        }
        catch (ClassCastException classCastException) {
            throw new EvaluateException("cannot evaluate - not a functor", functorList);
        }
        try {
            return this.evaluate(moduleName, functorList);
        }
        catch (ClassCastException classCastException) {
            throw new EvaluateException("wrong argument type", functorList);
        }
    }

    public LispObject evaluate(ModuleName moduleName, FunctorList functorList) throws EvaluateException {
        return LispObject.NIL;
    }

    protected int addNameToArray(String string) {
        int n = this.namesArrayCount;
        byte[] byArray = LispObject.getBytesUTF8(string);
        this.namesArray[this.namesArrayCount++] = (byte)byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            this.namesArray[this.namesArrayCount++] = byArray[i];
        }
        return n;
    }

    final ModuleName findName(String string) {
        int n = string.length();
        byte[] byArray = LispObject.getBytesUTF8(string);
        for (int i = 0; i < this.namesCount; ++i) {
            ModuleName moduleName = this.table[i];
            if (moduleName == null || this.namesArray[moduleName.offset] != n) continue;
            for (int j = 0; j < n && this.namesArray[moduleName.offset + j + 1] == byArray[j]; ++j) {
                if (j != n - 1) continue;
                return moduleName;
            }
        }
        return null;
    }

    public int findNameInArray(String string) {
        byte by;
        byte[] byArray = new byte[]{};
        byArray = LispObject.getBytesUTF8(string);
        int n = byArray.length;
        for (int i = 0; i < this.namesArrayCount; i += by + 1) {
            by = this.namesArray[i];
            if (n != by) continue;
            if (by == 0) {
                return i;
            }
            for (int j = 0; j < n && this.namesArray[i + j + 1] == byArray[j]; ++j) {
                if (j != n - 1) continue;
                return i;
            }
        }
        return -1;
    }

    protected ModuleName addDataName(String string) {
        ModuleNameData moduleNameData = new ModuleNameData(this.addNameToArray(string), LispObject.NIL);
        this.table[this.namesCount++] = moduleNameData;
        return moduleNameData;
    }

    protected ModuleName addFunctionName(String string) {
        ModuleName moduleName = new ModuleName(this.addNameToArray(string));
        this.table[this.namesCount++] = moduleName;
        return moduleName;
    }

    protected ModuleStringConstant addStringConstant(String string) {
        int n = this.findNameInArray(string);
        if (n < 0) {
            n = this.addNameToArray(string);
        }
        return new ModuleStringConstant(n);
    }

    protected class ModuleStringConstant
    extends StringAtomBase {
        private short offset;

        public ModuleStringConstant(int n) {
            this.offset = (short)n;
        }

        public String getValue() {
            return LispObject.getStringUTF8(FunctionModule.this.namesArray, this.offset + 1, FunctionModule.this.namesArray[this.offset]);
        }
    }

    protected class ModuleNameData
    extends ModuleName {
        private LispObject mapTo = LispObject.NIL;

        public ModuleNameData(int n, LispObject lispObject) {
            super(n);
            this.mapTo = lispObject;
        }

        public ModuleNameData(int n) {
            super(n);
        }

        public LispObject getMappedObject() {
            return this.mapTo;
        }

        public LispObject setMappedObject(LispObject lispObject) throws EvaluateException {
            LispObject lispObject2 = lispObject;
            this.mapTo = lispObject;
            return lispObject2;
        }
    }

    protected class ModuleName
    extends NameObjectBase {
        public final short offset;

        public ModuleName(int n) {
            this.offset = (short)n;
        }

        private ModuleName(String string) {
            this.offset = (short)FunctionModule.this.namesArrayCount;
            byte[] byArray = LispObject.getBytesUTF8(string);
            FunctionModule.this.namesArray[FunctionModule.this.namesArrayCount++] = (byte)(byArray.length + 1);
            for (int i = 0; i < byArray.length; ++i) {
                FunctionModule.this.namesArray[FunctionModule.this.namesArrayCount++] = byArray[i];
            }
        }

        public String getName() {
            return LispObject.getStringUTF8(FunctionModule.this.namesArray, this.offset + 1, FunctionModule.this.namesArray[this.offset]);
        }

        public LispObject getMappedObject() {
            return FunctionModule.this;
        }

        public LispObject setMappedObject(LispObject lispObject) throws EvaluateException {
            throw new EvaluateException("name of this type cannot be set");
        }
    }
}

