/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LongAtom;
import com.wapindustrial.calc.ShortAtom;
import net.jscience.math.MathFP;

public class FloatAtom
extends LispObject {
    long value;

    public FloatAtom() {
    }

    public FloatAtom(FloatAtom floatAtom) {
        this.value = floatAtom.value;
    }

    public FloatAtom(long l) {
        this.value = l;
    }

    public static FloatAtom convertFromLong(long l) {
        return new FloatAtom(MathFP.toFP(l));
    }

    public FloatAtom(String string) {
        this.value = MathFP.toFP(string);
    }

    public long toLong() {
        return MathFP.toLong(this.value);
    }

    public void toBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(FloatAtom.TrimZeroes(MathFP.toString(this.value, 100)));
    }

    public void toJavaBuffer(StringBuffer stringBuffer, int n, FunctorList functorList) {
        this.addIdent(stringBuffer, n);
        stringBuffer.append("new FloatAtom(\"");
        this.toBuffer(stringBuffer);
        stringBuffer.append("\") ");
    }

    public int typeNumber() {
        return 9;
    }

    public LispObject convertToType(int n) throws EvaluateException {
        LispObject lispObject = this;
        switch (n) {
            case 7: {
                lispObject = new ShortAtom((int)MathFP.toLong(this.value));
                break;
            }
            case 8: {
                lispObject = new LongAtom(MathFP.toLong(this.value));
                break;
            }
            case 9: {
                break;
            }
            default: {
                return super.convertToType(n);
            }
        }
        return lispObject;
    }

    static String TrimZeroes(String string) {
        char c;
        int n = string.length() - 1;
        while ((c = string.charAt(n)) == '0') {
            --n;
        }
        if (c == '.') {
            ++n;
        }
        return string.substring(0, n + 1);
    }

    void add0(FloatAtom floatAtom) {
        this.value += floatAtom.value;
    }

    void sub0(FloatAtom floatAtom) {
        this.value -= floatAtom.value;
    }

    void mul0(FloatAtom floatAtom) {
        this.value = MathFP.mul(this.value, floatAtom.value);
    }

    void div0(FloatAtom floatAtom) {
        this.value = MathFP.div(this.value, floatAtom.value);
    }

    boolean gt(FloatAtom floatAtom) {
        return this.value > floatAtom.value;
    }

    boolean ge(FloatAtom floatAtom) {
        return this.value >= floatAtom.value;
    }

    boolean lt(FloatAtom floatAtom) {
        return this.value < floatAtom.value;
    }

    boolean le(FloatAtom floatAtom) {
        return this.value <= floatAtom.value;
    }

    boolean eq(FloatAtom floatAtom) {
        return this.value == floatAtom.value;
    }

    boolean ne(FloatAtom floatAtom) {
        return this.value != floatAtom.value;
    }
}

