/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Assigment;
import com.wapindustrial.calc.Cell;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LispTask;
import com.wapindustrial.calc.ModuleHandler;
import com.wapindustrial.calc.QuotedList;
import com.wapindustrial.calc.Reference;
import com.wapindustrial.calc.RowColumn;
import com.wapindustrial.calc.ScreenLite;
import com.wapindustrial.calc.Sheet;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class CanvasHandler1
extends LispObject
implements CommandListener {
    public static CanvasHandler1 canvasHandler;
    public MIDlet midlet;
    public Canvas canvas;
    Font font = Font.getDefaultFont();
    public Display display;
    boolean started = false;
    private static final String POUNDS = "#######";
    static final int[] MAX_COLUMNS_ROWS;
    static final int CURSOR_UP_LEFT = -1;
    static final int CURSOR_NONE = 0;
    static final int CURSOR_DOWN_RIGHT = 1;
    int windowx1;
    int windowy1;
    int windowx2;
    int windowy2;
    int cursorx;
    int cursory;
    int selectionx1;
    int selectiony1;
    int selectionx2;
    int selectiony2;
    int fontWidth;
    int fontHeight;
    int[] fontSize = new int[2];
    int canvasWidth;
    int canvasHeight;
    int headerWidth;
    int headerHeight;
    int headerFontColor = 0;
    int headerBackColor = 0xFFFFFF;
    int cellFontColor = 0;
    int cellBackColor = 0xFFFFFF;
    int gridColor = 0;
    int gridSelectedColor = 0xFFFFFF;
    int selectionFontColor = 0xFFFFFF;
    int selectionBackColor = 0;
    public Sheet sheet;
    private static final int MODE_NORMAL = 1;
    private static final int MODE_NUMERIC = 2;
    private static final int MODE_FORMULA = 4;
    int screenmode;
    boolean goldmode;
    int goldkey = 35;
    final short[] goldkeys = new short[10];
    int ngoldkeys;
    String formula;
    static int debugLevel;
    private static final int MAX_HISTORY = 30;
    static final Vector history;
    int clipx;
    int clipy;
    int clipdx;
    int clipdy;

    public static final void addToHistory(String string) {
        if (string == null) {
            string = "<null>";
        }
        if (history.size() >= 30) {
            history.removeElementAt(0);
        }
        history.addElement(string);
    }

    public CanvasHandler1(MIDlet mIDlet, Canvas canvas) {
        this.midlet = mIDlet;
        this.canvas = canvas;
    }

    public void setScreenMode(int n) {
        this.screenmode = n;
        this.formula = "";
    }

    public void startApp() {
        if (!this.started) {
            this.started = true;
            this.fontSize[0] = this.fontWidth = this.font.charWidth('#');
            this.fontSize[1] = this.fontHeight = this.font.getHeight();
            this.canvasWidth = this.canvas.getWidth();
            this.canvasHeight = this.canvas.getHeight();
            this.headerWidth = this.fontWidth * 2;
            this.headerHeight = this.fontHeight;
            this.setScreenMode(1);
            canvasHandler = this;
            ModuleHandler.MODULEHANDLER.initializeNames();
            this.display = Display.getDisplay((MIDlet)this.midlet);
            this.display.setCurrent((Displayable)this.canvas);
            this.sheet = new Sheet();
            this.sheetInitialize();
            String string = this.midlet.getAppProperty("startup");
            QuotedList quotedList = null;
            if (string != null) {
                try {
                    LispObject.debug("evaluating " + string);
                    Runtime.getRuntime().gc();
                    quotedList = LispObject.parse(string);
                }
                catch (Exception exception) {
                    LispObject.debug("exception when processing startapp:");
                    LispObject.debug(exception.getMessage());
                    exception.printStackTrace();
                }
            }
            LispTask.LispMachine = new LispTask();
            LispTask.LispMachine.start();
            if (quotedList != null) {
                LispTask.LispMachine.putCommand(quotedList);
            }
        }
    }

    public void pauseApp() {
    }

    public void destroyApp() {
        LispTask.LispMachine.stop = true;
    }

    public void keyPressed(int n) {
        if (n == this.goldkey) {
            this.goldmode = !this.goldmode;
            this.ngoldkeys = 0;
            this.repaintFormulaBar();
            return;
        }
        if (this.goldmode) {
            this.goldkeys[this.ngoldkeys++] = (short)n;
            Assigment assigment = ScreenLite.findGoldBinding(this.goldkeys, this.ngoldkeys);
            if (assigment != null) {
                this.goldmode = false;
                LispTask.LispMachine.putCommand(assigment.code);
            }
            this.repaintFormulaBar();
            return;
        }
        int n2 = this.canvas.getGameAction(n);
        Assigment assigment = ScreenLite.findKeyBinding(this.screenmode, n2, n);
        if (assigment != null) {
            LispTask.LispMachine.putCommand(assigment.code);
        } else {
            LispObject.debug("unbinded keycode received, action=" + n2 + " key=" + n);
        }
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public void commandAction(Command command, Displayable displayable) {
        Assigment assigment = ScreenLite.findCommandBinding(command);
        if (assigment != null) {
            LispTask.LispMachine.putCommand(assigment.code);
        } else {
            LispObject.debug("unbinded command received");
        }
    }

    private void setWindowX(int n, int n2) {
        int n3 = this.canvasWidth - this.headerWidth;
        this.cursorx = n;
        if (n2 == 1) {
            this.windowx1 = this.getCellCoord(0, n);
            this.windowx2 = this.windowx1 + n3;
        } else if (n2 == -1) {
            this.windowx2 = this.getCellCoord(0, n + 1);
            this.windowx1 = this.windowx2 - n3;
        }
        if (this.windowx1 < 0) {
            this.windowx1 = 0;
            this.windowx2 = n3;
        } else {
            int n4 = this.getCellCoord(0, MAX_COLUMNS_ROWS[0]);
            if (this.windowx2 > n4 && n4 > n3) {
                this.windowx2 = n4;
                this.windowx1 = this.windowx2 - n3;
            }
        }
    }

    private void setWindowY(int n, int n2) {
        int n3 = this.canvasHeight - this.headerHeight;
        this.cursory = n;
        if (n2 == 1) {
            this.windowy1 = this.getCellCoord(1, n);
            this.windowy2 = this.windowy1 + n3;
        } else if (n2 == -1) {
            this.windowy2 = this.getCellCoord(1, n + 1);
            this.windowy1 = this.windowy2 - n3;
        }
        if (this.windowy1 < 0) {
            this.windowy1 = 0;
            this.windowy2 = n3;
        } else {
            int n4 = this.getCellCoord(1, MAX_COLUMNS_ROWS[1]);
            if (this.windowy2 > n4 && n4 > n3) {
                this.windowy2 = n4;
                this.windowy1 = this.windowy2 - n3;
            }
        }
    }

    void repaintCell(int n, int n2) {
        this.canvas.repaint(this.getScreenCellCoordX(n2), this.getScreenCellCoordY(n), this.getRowColumnSize(0, n2), this.getRowColumnSize(1, n));
    }

    void repaint() {
        this.canvas.repaint();
    }

    void repaintFormulaBar() {
        this.canvas.repaint(0, 0, this.canvasWidth, this.headerHeight);
    }

    int setCursorX(int n) {
        if (this.cursorx == n) {
            return 0;
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = MAX_COLUMNS_ROWS[0];
        int n4 = this.getCellCoord(0, n = (n + n3) % n3);
        if (n4 < this.windowx1) {
            bl = true;
            n2 = -1;
        } else {
            int n5 = n4 + this.getRowColumnSize(0, n + 1);
            if (n5 >= this.windowx2) {
                bl = true;
                n2 = 1;
            }
        }
        if (bl) {
            this.setWindowX(n, n2);
            return 2;
        }
        this.cursorx = n;
        return 1;
    }

    int setCursorY(int n) {
        if (this.cursory == n) {
            return 0;
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = MAX_COLUMNS_ROWS[1];
        int n4 = this.getCellCoord(1, n = (n + n3) % n3);
        if (n4 < this.windowy1) {
            bl = true;
            n2 = -1;
        } else {
            int n5 = n4 + this.getRowColumnSize(1, n + 1);
            if (n5 >= this.windowy2) {
                bl = true;
                n2 = 1;
            }
        }
        if (bl) {
            this.setWindowY(n, n2);
            return 2;
        }
        this.cursory = n;
        return 1;
    }

    public void setCursor(int n, int n2) {
        this.setCursorX(n2);
        this.setCursorY(n);
    }

    void paintCell(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = this.getScreenCellCoordX(n2);
        int n4 = this.getScreenCellCoordY(n);
        int n5 = this.getRowColumnSize(0, n2);
        int n6 = this.getRowColumnSize(1, n);
        int n7 = n3 + n5;
        int n8 = n4 + n6;
        boolean bl2 = true;
        graphics.clipRect(n3, n4, n5, n6);
        graphics.setColor(bl ? this.selectionBackColor : this.cellBackColor);
        graphics.fillRect(n3, n4, n5, n6);
        Cell cell = this.getCell(n, n2);
        LispObject lispObject = cell.value;
        if (lispObject != LispObject.NIL || (cell.format & 3) != 0) {
            graphics.setColor(bl ? this.selectionFontColor : this.cellFontColor);
            String string = cell.getText();
            int n9 = this.font.stringWidth(string);
            if (lispObject.typeNumber() == 10) {
                graphics.drawString(string, n3 + 1, n4 + 1, 20);
                bl2 = !this.sheet.isEmpty(n, n2 + 1) || n9 + 3 <= n5;
            } else {
                if (n9 + 3 > n5) {
                    string = POUNDS;
                }
                graphics.drawString(string, n7 - 2, n4 + 1, 24);
            }
        } else {
            int n10 = 0;
            for (int i = n2 - 1; i >= 0; --i) {
                String string;
                int n11;
                n10 += this.getRowColumnSize(0, i);
                cell = this.getCell(n, i);
                lispObject = cell.value;
                if (lispObject == LispObject.NIL) continue;
                if (lispObject.typeNumber() != 10 || (n11 = this.font.stringWidth(string = cell.getText()) + 3) <= n10) break;
                graphics.setColor(bl ? this.selectionFontColor : this.cellFontColor);
                graphics.drawString(string, n3 + 1 - n10, n4 + 1, 20);
                bl2 = !this.sheet.isEmpty(n, n2 + 1) || n11 <= n10 + n5;
                break;
            }
        }
        graphics.setColor(bl ? this.gridSelectedColor : this.gridColor);
        if (bl2) {
            graphics.drawLine(n7 - 1, n4, n7 - 1, n8 - 2);
        }
        if (bl) {
            graphics.drawLine(n3, n8 - 1, n7 - 2, n8 - 1);
        } else {
            graphics.drawLine(n3, n8 - 1, n7 - 1, n8 - 1);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.sheet == null) {
            graphics.drawString("please wait", this.canvasWidth / 2, this.canvasHeight / 2, 65);
            return;
        }
        this.clipx = graphics.getClipX();
        this.clipy = graphics.getClipY();
        this.clipdx = graphics.getClipWidth();
        this.clipdy = graphics.getClipHeight();
        graphics.setColor(this.cellBackColor);
        graphics.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        graphics.setFont(this.font);
        boolean bl = Reference.intersect(this.clipx, this.clipy, this.clipx + this.clipdx, this.clipy + this.clipdy, this.headerWidth, 0, this.canvasWidth - 1, this.headerHeight - 1);
        int n8 = this.windowx1 + (this.clipx - this.headerWidth) - 1;
        int n9 = n8 + this.clipdx;
        if (bl) {
            n8 = this.windowx1;
        }
        int n10 = -1;
        int n11 = MAX_COLUMNS_ROWS[0] - 1;
        int n12 = 0;
        for (n7 = 0; n7 < MAX_COLUMNS_ROWS[0]; ++n7) {
            if (n12 >= n9) {
                n11 = n7 - 1;
                break;
            }
            n6 = this.getRowColumnSize(0, n7);
            if (n10 == -1 && (n12 >= n8 || n12 + n6 > n8)) {
                n10 = n7;
            }
            n12 += n6;
        }
        if (bl) {
            graphics.setColor(this.headerBackColor);
            graphics.fillRect(this.headerWidth, 0, this.canvasWidth - 1, this.headerHeight - 1);
            graphics.setColor(this.gridColor);
            graphics.drawLine(this.headerWidth, this.headerHeight, this.canvasWidth, this.headerHeight);
            graphics.setColor(this.headerFontColor);
            if (this.goldmode) {
                StringBuffer stringBuffer = new StringBuffer("GOLD? ");
                for (n5 = 0; n5 < this.ngoldkeys; ++n5) {
                    if (n5 != 0) {
                        stringBuffer.append('-');
                    }
                    stringBuffer.append(this.canvas.getKeyName((int)this.goldkeys[n5]));
                }
                graphics.drawString(stringBuffer.toString(), 0, 0, 20);
            } else if (this.screenmode == 2) {
                graphics.drawString("NUM: " + this.formula, 0, 0, 20);
            } else if (this.screenmode == 4) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('[');
                stringBuffer.append(Reference.cellAddress(this.cursory, this.cursorx, 0));
                stringBuffer.append("]: ");
                Cell cell = this.getCell(this.cursory, this.cursorx);
                stringBuffer.append(cell.formula.toFormulaString());
                graphics.drawString(stringBuffer.toString(), 0, 0, 20);
            } else {
                graphics.setClip(this.headerWidth, 0, this.canvasWidth - this.headerWidth, this.headerHeight);
                n7 = this.getScreenCellCoordX(n10) - 1;
                graphics.setColor(this.gridColor);
                graphics.drawLine(n7, 0, n7, this.headerHeight);
                for (int i = n10; i <= n11; ++i) {
                    n4 = n7 + this.getRowColumnSize(0, i);
                    graphics.setColor(this.gridColor);
                    graphics.drawLine(n4, 0, n4, this.headerHeight);
                    graphics.setColor(this.headerFontColor);
                    graphics.drawString(this.sheet.getRowColumn(0, i).getName(0), (n7 + n4) / 2, this.headerHeight - 1, 33);
                    n7 = n4;
                }
                graphics.setClip(0, 0, this.canvasWidth, this.canvasHeight);
            }
        }
        n7 = Reference.intersect(this.clipx, this.clipy, this.clipx + this.clipdx, this.clipy + this.clipdy, 0, this.headerHeight, this.headerWidth - 1, this.canvasHeight - 1) ? 1 : 0;
        n5 = this.windowy1 + (this.clipy - this.headerHeight) - 1;
        n4 = n5 + this.clipdy;
        if (n7 != 0) {
            n5 = this.windowy1;
        }
        int n13 = -1;
        int n14 = MAX_COLUMNS_ROWS[1] - 1;
        int n15 = 0;
        for (n3 = 0; n3 < MAX_COLUMNS_ROWS[1]; ++n3) {
            if (n15 >= n4) {
                n14 = n3 - 1;
                break;
            }
            n6 = this.getRowColumnSize(1, n3);
            if (n13 == -1 && (n15 >= n5 || n15 + n6 > n5)) {
                n13 = n3;
            }
            n15 += n6;
        }
        if (n7 != 0) {
            graphics.setColor(this.headerBackColor);
            graphics.fillRect(0, this.headerHeight, this.headerWidth - 1, this.canvasHeight - 1);
            graphics.setColor(this.gridColor);
            graphics.drawLine(this.headerWidth, this.headerHeight, this.headerWidth, this.canvasHeight);
            graphics.setClip(0, this.headerHeight, this.headerWidth, this.canvasHeight - this.headerHeight);
            n3 = this.getScreenCellCoordY(n13) - 1;
            graphics.drawLine(0, n3, this.headerWidth, n3);
            for (n2 = n13; n2 <= n14; ++n2) {
                n = n3 + this.getRowColumnSize(1, n2);
                graphics.setColor(this.gridColor);
                graphics.drawLine(0, n, this.headerWidth, n);
                graphics.setColor(this.headerFontColor);
                graphics.drawString(this.sheet.getRowColumn(1, n2).getName(1), this.headerWidth - 1, n - 1, 40);
                n3 = n;
            }
            graphics.setClip(0, 0, this.canvasWidth, this.canvasHeight);
        }
        if ((n3 = (int)(Reference.intersect(this.clipx, this.clipy, this.clipx + this.clipdx, this.clipy + this.clipdy, this.headerWidth + 1, this.headerHeight + 1, this.canvasWidth, this.canvasHeight) ? 1 : 0)) != 0) {
            graphics.setClip(this.headerWidth + 1, this.headerHeight + 1, this.canvasWidth - this.headerWidth - 1, this.canvasHeight - this.headerHeight - 1);
            for (n2 = n13; n2 <= n14; ++n2) {
                for (n = n11; n >= n10; --n) {
                    boolean bl2 = n2 == this.cursory && n == this.cursorx;
                    boolean bl3 = n >= this.selectionx1 && n <= this.selectionx2 && n2 >= this.selectiony1 && n2 <= this.selectiony2;
                    graphics.setClip(this.headerWidth + 1, this.headerHeight + 1, this.canvasWidth - this.headerWidth, this.canvasHeight - this.headerHeight);
                    this.paintCell(graphics, n2, n, bl2 ^ bl3);
                }
            }
        }
    }

    int getRowColumnSize(int n, int n2) {
        return this.sheet.getRowColumn((int)n, (int)n2).width_height * this.fontSize[n] / 64;
    }

    int getCellCoord(int n, int n2) {
        return this.sheet.coord(n, n2) * this.fontSize[n] / 64;
    }

    int getScreenCellCoordX(int n) {
        return this.getCellCoord(0, n) - this.windowx1 + this.headerWidth + 1;
    }

    int getScreenCellCoordY(int n) {
        return this.getCellCoord(1, n) - this.windowy1 + this.headerHeight + 1;
    }

    Cell getCell(int n, int n2) {
        return this.sheet.getCell(n, n2);
    }

    LispObject getCellValue(int n, int n2) {
        return this.sheet.getCellValue(n, n2);
    }

    public int findCellByCoord(int n, int n2) {
        int n3 = 0;
        n2 += n == 0 ? this.windowx1 - this.headerWidth : this.windowy1 - this.headerHeight;
        n2 = n2 * 64 / this.fontSize[n];
        Hashtable hashtable = this.sheet.rows_columns[n];
        int n4 = this.sheet.defaultWidthHeight[n];
        for (int i = 0; i < MAX_COLUMNS_ROWS[n]; ++i) {
            RowColumn rowColumn = (RowColumn)hashtable.get(new Integer(i));
            n3 = rowColumn != null ? (n3 += rowColumn.width_height) : (n3 += n4);
            if (n2 >= n3) continue;
            return i;
        }
        return MAX_COLUMNS_ROWS[n];
    }

    void sheetInitialize() {
        this.setWindowX(0, 1);
        this.setWindowY(0, 1);
        this.setCursorX(0);
        this.setCursorY(0);
        this.selectiony1 = 1000;
        this.selectionx1 = 1000;
        this.selectiony2 = -1;
        this.selectionx2 = -1;
    }

    static void setDisplay(Displayable displayable) {
        CanvasHandler1.canvasHandler.display.setCurrent(displayable);
    }

    static void setCanvas() {
        CanvasHandler1.canvasHandler.display.setCurrent((Displayable)CanvasHandler1.canvasHandler.canvas);
    }

    String getAppProperty(String string) {
        String string2 = this.midlet.getAppProperty(string);
        return string2;
    }

    static {
        MAX_COLUMNS_ROWS = new int[]{8, 32};
        debugLevel = 1;
        history = new Vector(30);
    }
}

