/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.BooleanAtom;
import com.wapindustrial.calc.CanvasHandler1;
import com.wapindustrial.calc.Cell;
import com.wapindustrial.calc.CircularReferenceException;
import com.wapindustrial.calc.DateAtom;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.FormulaError;
import com.wapindustrial.calc.FormulaParseException;
import com.wapindustrial.calc.FunctionModule;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.FunctorList1;
import com.wapindustrial.calc.FunctorList2;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LispTask;
import com.wapindustrial.calc.LongAtom;
import com.wapindustrial.calc.ModuleHandler;
import com.wapindustrial.calc.NameObjectBase;
import com.wapindustrial.calc.Operator;
import com.wapindustrial.calc.ParseException;
import com.wapindustrial.calc.QuotedList;
import com.wapindustrial.calc.Reference;
import com.wapindustrial.calc.RowColumn;
import com.wapindustrial.calc.Sheet;
import com.wapindustrial.calc.ShortAtom;
import com.wapindustrial.calc.StringAtom;
import com.wapindustrial.calc.StringAtomBase;
import com.wapindustrial.calc.UserFunction;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Font;
import javax.microedition.rms.RecordStoreException;
import net.jscience.math.MathFP;

public class Bfunc
extends FunctionModule {
    public static final Bfunc BFUNC = new Bfunc();
    private static final FloatAtom aPI = new FloatAtom(52707178L);
    private static final FloatAtom aE = new FloatAtom(MathFP.E);
    private static final long DAY_BCD_MS_LONG = 86400L;
    static final long DAY_BCD_MS_FLOAT = MathFP.toFP(86400L);
    static final byte[] _namesArray = new byte[]{2, 105, 102, 5, 119, 104, 105, 108, 101, 4, 115, 101, 116, 113, 5, 100, 101, 102, 117, 110, 4, 115, 97, 100, 100, 4, 115, 115, 117, 98, 4, 115, 109, 117, 108, 4, 115, 100, 105, 118, 3, 115, 103, 116, 3, 115, 103, 101, 3, 115, 108, 116, 3, 115, 108, 101, 3, 115, 101, 113, 3, 115, 110, 101, 4, 108, 111, 97, 100, 11, 109, 111, 100, 117, 108, 101, 45, 108, 111, 97, 100, 5, 105, 115, 110, 105, 108, 4, 84, 69, 88, 84, 5, 83, 72, 79, 82, 84, 11, 98, 105, 110, 100, 45, 116, 111, 45, 107, 101, 121, 15, 98, 105, 110, 100, 45, 116, 111, 45, 99, 111, 109, 109, 97, 110, 100, 12, 98, 105, 110, 100, 45, 116, 111, 45, 109, 101, 110, 117, 6, 112, 114, 111, 109, 112, 116, 15, 112, 114, 111, 109, 112, 116, 45, 112, 114, 101, 115, 101, 114, 118, 101, 8, 97, 112, 112, 45, 101, 120, 105, 116, 9, 97, 112, 112, 45, 100, 101, 98, 117, 103, 10, 109, 101, 110, 117, 45, 115, 116, 97, 114, 116, 12, 98, 105, 110, 100, 45, 116, 111, 45, 103, 111, 108, 100, 4, 98, 105, 110, 100, 11, 36, 105, 110, 112, 117, 116, 45, 102, 111, 114, 109, 12, 115, 104, 101, 101, 116, 45, 99, 114, 101, 97, 116, 101, 11, 99, 101, 108, 108, 45, 99, 114, 101, 97, 116, 101, 3, 114, 101, 102, 10, 99, 117, 114, 115, 111, 114, 45, 115, 101, 116, 11, 99, 117, 114, 115, 111, 114, 45, 109, 111, 118, 101, 10, 99, 117, 114, 115, 111, 114, 45, 103, 101, 116, 13, 115, 104, 101, 101, 116, 45, 97, 100, 100, 99, 101, 108, 108, 15, 99, 101, 108, 108, 45, 103, 101, 116, 102, 111, 114, 109, 117, 108, 97, 15, 99, 101, 108, 108, 45, 115, 101, 116, 102, 111, 114, 109, 117, 108, 97, 17, 99, 101, 108, 108, 45, 103, 101, 116, 119, 115, 102, 111, 114, 109, 117, 108, 97, 17, 99, 101, 108, 108, 45, 115, 101, 116, 119, 115, 102, 111, 114, 109, 117, 108, 97, 13, 115, 104, 101, 101, 116, 45, 103, 101, 116, 99, 101, 108, 108, 10, 115, 101, 120, 112, 45, 112, 97, 114, 115, 101, 11, 99, 101, 108, 108, 45, 97, 99, 116, 105, 118, 101, 17, 115, 104, 101, 101, 116, 45, 114, 101, 99, 97, 108, 99, 117, 108, 97, 116, 101, 13, 115, 101, 120, 112, 45, 101, 118, 97, 108, 117, 97, 116, 101, 12, 99, 101, 108, 108, 45, 114, 101, 112, 97, 105, 110, 116, 4, 100, 97, 116, 101, 9, 114, 111, 119, 99, 111, 108, 117, 109, 110, 14, 115, 104, 101, 101, 116, 45, 97, 99, 116, 105, 118, 97, 116, 101, 12, 115, 104, 101, 101, 116, 45, 97, 99, 116, 105, 118, 101, 10, 115, 104, 101, 101, 116, 45, 115, 97, 118, 101, 10, 115, 104, 101, 101, 116, 45, 108, 111, 97, 100, 13, 115, 104, 101, 101, 116, 45, 103, 101, 116, 110, 97, 109, 101, 13, 115, 104, 101, 101, 116, 45, 115, 101, 116, 110, 97, 109, 101, 10, 115, 104, 101, 101, 116, 45, 108, 105, 115, 116, 14, 99, 101, 108, 108, 45, 115, 101, 116, 102, 111, 114, 109, 97, 116, 14, 99, 101, 108, 108, 45, 103, 101, 116, 102, 111, 114, 109, 97, 116, 12, 115, 104, 101, 101, 116, 45, 100, 101, 108, 101, 116, 101, 7, 109, 101, 115, 115, 97, 103, 101, 20, 115, 104, 101, 101, 116, 45, 103, 101, 116, 119, 105, 100, 116, 104, 104, 101, 105, 103, 104, 116, 20, 115, 104, 101, 101, 116, 45, 115, 101, 116, 119, 105, 100, 116, 104, 104, 101, 105, 103, 104, 116, 13, 115, 104, 101, 101, 116, 45, 114, 101, 112, 97, 105, 110, 116, 13, 115, 101, 108, 101, 99, 116, 105, 111, 110, 45, 103, 101, 116, 13, 115, 101, 108, 101, 99, 116, 105, 111, 110, 45, 115, 101, 116, 8, 103, 111, 108, 100, 45, 107, 101, 121, 10, 99, 101, 108, 108, 45, 99, 108, 101, 97, 114, 17, 114, 101, 102, 101, 114, 101, 110, 99, 101, 45, 112, 114, 111, 99, 101, 115, 115, 9, 115, 101, 108, 101, 99, 116, 105, 111, 110, 12, 115, 101, 116, 115, 104, 101, 101, 116, 115, 105, 122, 101, 12, 115, 104, 101, 101, 116, 45, 105, 110, 115, 101, 114, 116, 15, 99, 101, 108, 108, 45, 103, 101, 116, 119, 115, 118, 97, 108, 117, 101, 12, 115, 116, 114, 45, 103, 101, 116, 119, 105, 100, 116, 104, 9, 99, 101, 108, 108, 45, 99, 111, 112, 121, 12, 99, 101, 108, 108, 45, 103, 101, 116, 116, 121, 112, 101, 5, 101, 114, 114, 111, 114, 11, 115, 121, 115, 116, 101, 109, 45, 105, 110, 102, 111, 9, 100, 101, 98, 117, 103, 45, 115, 101, 116, 14, 115, 99, 114, 101, 101, 110, 45, 115, 101, 116, 109, 111, 100, 101, 20, 115, 99, 114, 101, 101, 110, 45, 115, 101, 116, 102, 111, 114, 109, 117, 108, 97, 98, 97, 114, 18, 102, 111, 114, 109, 117, 108, 97, 98, 97, 114, 45, 114, 101, 112, 97, 105, 110, 116, 14, 115, 99, 114, 101, 101, 110, 45, 103, 101, 116, 109, 111, 100, 101, 20, 115, 99, 114, 101, 101, 110, 45, 103, 101, 116, 102, 111, 114, 109, 117, 108, 97, 98, 97, 114, 8, 112, 97, 114, 115, 101, 45, 119, 115, 14, 99, 101, 108, 108, 45, 99, 114, 101, 97, 116, 101, 45, 119, 115, 14, 115, 99, 114, 101, 101, 110, 45, 115, 101, 116, 102, 111, 110, 116, 20, 115, 104, 101, 101, 116, 45, 115, 101, 116, 100, 101, 102, 97, 117, 108, 116, 115, 105, 122, 101, 11, 104, 105, 115, 116, 111, 114, 121, 45, 103, 101, 116, 3, 97, 100, 100, 3, 115, 117, 98, 3, 109, 117, 108, 3, 100, 105, 118, 2, 101, 113, 2, 110, 101, 2, 108, 101, 2, 108, 116, 2, 103, 101, 2, 103, 116, 4, 117, 109, 105, 110, 9, 112, 97, 114, 101, 110, 116, 104, 105, 115, 2, 80, 73, 1, 69, 4, 102, 97, 100, 100, 4, 102, 115, 117, 98, 4, 102, 109, 117, 108, 4, 102, 100, 105, 118, 5, 97, 116, 97, 110, 50, 3, 112, 111, 119, 4, 97, 99, 111, 115, 4, 97, 115, 105, 110, 4, 97, 116, 97, 110, 3, 99, 111, 115, 3, 115, 105, 110, 3, 99, 111, 116, 3, 101, 120, 112, 3, 108, 111, 103, 4, 115, 113, 114, 116, 3, 116, 97, 110, 6, 115, 116, 114, 45, 101, 113, 7, 115, 116, 114, 45, 108, 101, 110, 8, 100, 97, 116, 101, 45, 97, 100, 100, 8, 100, 97, 116, 101, 45, 115, 117, 98, 5, 114, 111, 117, 110, 100, 6, 116, 111, 116, 121, 112, 101, 7, 115, 116, 114, 45, 99, 97, 116, 7, 115, 116, 114, 45, 115, 117, 98, 8, 115, 116, 114, 45, 102, 105, 110, 100, 3, 115, 117, 109, 12, 99, 101, 108, 108, 45, 97, 100, 100, 114, 101, 115, 115, 15, 115, 104, 101, 101, 116, 45, 105, 115, 99, 104, 97, 110, 103, 101, 100, 16, 115, 104, 101, 101, 116, 45, 115, 101, 116, 99, 104, 97, 110, 103, 101, 100, 10, 99, 111, 108, 111, 114, 115, 45, 115, 101, 116, 5, 113, 108, 105, 115, 116, 9, 99, 111, 108, 111, 114, 45, 114, 103, 98, 15, 97, 112, 112, 45, 103, 101, 116, 112, 114, 111, 112, 101, 114, 116, 121, 14, 113, 108, 105, 115, 116, 45, 116, 111, 45, 115, 104, 101, 101, 116};
    public static final int NAME_IF = 0;
    public static final int NAME_WHILE = 3;
    public static final int NAME_SETQ = 9;
    public static final int NAME_DEFUN = 14;
    public static final int NAME_SADD = 20;
    public static final int NAME_SSUB = 25;
    public static final int NAME_SMUL = 30;
    public static final int NAME_SDIV = 35;
    public static final int NAME_SGT = 40;
    public static final int NAME_SGE = 44;
    public static final int NAME_SLT = 48;
    public static final int NAME_SLE = 52;
    public static final int NAME_SEQ = 56;
    public static final int NAME_SNE = 60;
    public static final int NAME_LOAD = 64;
    public static final int NAME_MODULE_LOAD = 69;
    public static final int NAME_ISNIL = 81;
    public static final int NAME_TEXT = 87;
    public static final int NAME_SHORT = 92;
    public static final int NAME_BIND_TO_KEY = 98;
    public static final int NAME_BIND_TO_COMMAND = 110;
    public static final int NAME_BIND_TO_MENU = 126;
    public static final int NAME_PROMPT = 139;
    public static final int NAME_PROMPT_PRESERVE = 146;
    public static final int NAME_APP_EXIT = 162;
    public static final int NAME_APP_DEBUG = 171;
    public static final int NAME_MENU_START = 181;
    public static final int NAME_BIND_TO_GOLD = 192;
    public static final int NAME_BIND = 205;
    public static final int NAME__INPUT_FORM = 210;
    public static final int NAME_SHEET_CREATE = 222;
    public static final int NAME_CELL_CREATE = 235;
    public static final int NAME_REF = 247;
    public static final int NAME_CURSOR_SET = 251;
    public static final int NAME_CURSOR_MOVE = 262;
    public static final int NAME_CURSOR_GET = 274;
    public static final int NAME_SHEET_ADDCELL = 285;
    public static final int NAME_CELL_GETFORMULA = 299;
    public static final int NAME_CELL_SETFORMULA = 315;
    public static final int NAME_CELL_GETWSFORMULA = 331;
    public static final int NAME_CELL_SETWSFORMULA = 349;
    public static final int NAME_SHEET_GETCELL = 367;
    public static final int NAME_SEXP_PARSE = 381;
    public static final int NAME_CELL_ACTIVE = 392;
    public static final int NAME_SHEET_RECALCULATE = 404;
    public static final int NAME_SEXP_EVALUATE = 422;
    public static final int NAME_CELL_REPAINT = 436;
    public static final int NAME_DATE = 449;
    public static final int NAME_ROWCOLUMN = 454;
    public static final int NAME_SHEET_ACTIVATE = 464;
    public static final int NAME_SHEET_ACTIVE = 479;
    public static final int NAME_SHEET_SAVE = 492;
    public static final int NAME_SHEET_LOAD = 503;
    public static final int NAME_SHEET_GETNAME = 514;
    public static final int NAME_SHEET_SETNAME = 528;
    public static final int NAME_SHEET_LIST = 542;
    public static final int NAME_CELL_SETFORMAT = 553;
    public static final int NAME_CELL_GETFORMAT = 568;
    public static final int NAME_SHEET_DELETE = 583;
    public static final int NAME_MESSAGE = 596;
    public static final int NAME_SHEET_GETWIDTHHEIGHT = 604;
    public static final int NAME_SHEET_SETWIDTHHEIGHT = 625;
    public static final int NAME_SHEET_REPAINT = 646;
    public static final int NAME_SELECTION_GET = 660;
    public static final int NAME_SELECTION_SET = 674;
    public static final int NAME_GOLD_KEY = 688;
    public static final int NAME_CELL_CLEAR = 697;
    public static final int NAME_REFERENCE_PROCESS = 708;
    public static final int NAME_SELECTION = 726;
    public static final int NAME_SETSHEETSIZE = 736;
    public static final int NAME_SHEET_INSERT = 749;
    public static final int NAME_CELL_GETWSVALUE = 762;
    public static final int NAME_STR_GETWIDTH = 778;
    public static final int NAME_CELL_COPY = 791;
    public static final int NAME_CELL_GETTYPE = 801;
    public static final int NAME_ERROR = 814;
    public static final int NAME_SYSTEM_INFO = 820;
    public static final int NAME_DEBUG_SET = 832;
    public static final int NAME_SCREEN_SETMODE = 842;
    public static final int NAME_SCREEN_SETFORMULABAR = 857;
    public static final int NAME_FORMULABAR_REPAINT = 878;
    public static final int NAME_SCREEN_GETMODE = 897;
    public static final int NAME_SCREEN_GETFORMULABAR = 912;
    public static final int NAME_PARSE_WS = 933;
    public static final int NAME_CELL_CREATE_WS = 942;
    public static final int NAME_SCREEN_SETFONT = 957;
    public static final int NAME_SHEET_SETDEFAULTSIZE = 972;
    public static final int NAME_HISTORY_GET = 993;
    public static final int NAME_ADD = 1005;
    public static final int NAME_SUB = 1009;
    public static final int NAME_MUL = 1013;
    public static final int NAME_DIV = 1017;
    public static final int NAME_EQ = 1021;
    public static final int NAME_NE = 1024;
    public static final int NAME_LE = 1027;
    public static final int NAME_LT = 1030;
    public static final int NAME_GE = 1033;
    public static final int NAME_GT = 1036;
    public static final int NAME_UMIN = 1039;
    public static final int NAME_PARENTHIS = 1044;
    public static final int NAME_PI = 1054;
    public static final int NAME_E = 1057;
    public static final int NAME_FADD = 1059;
    public static final int NAME_FSUB = 1064;
    public static final int NAME_FMUL = 1069;
    public static final int NAME_FDIV = 1074;
    public static final int NAME_ATAN2 = 1079;
    public static final int NAME_POW = 1085;
    public static final int NAME_ACOS = 1089;
    public static final int NAME_ASIN = 1094;
    public static final int NAME_ATAN = 1099;
    public static final int NAME_COS = 1104;
    public static final int NAME_SIN = 1108;
    public static final int NAME_COT = 1112;
    public static final int NAME_EXP = 1116;
    public static final int NAME_LOG = 1120;
    public static final int NAME_SQRT = 1124;
    public static final int NAME_TAN = 1129;
    public static final int NAME_STR_EQ = 1133;
    public static final int NAME_STR_LEN = 1140;
    public static final int NAME_DATE_ADD = 1148;
    public static final int NAME_DATE_SUB = 1157;
    public static final int NAME_ROUND = 1166;
    public static final int NAME_TOTYPE = 1172;
    public static final int NAME_STR_CAT = 1179;
    public static final int NAME_STR_SUB = 1187;
    public static final int NAME_STR_FIND = 1195;
    public static final int NAME_SUM = 1204;
    public static final int NAME_CELL_ADDRESS = 1208;
    public static final int NAME_SHEET_ISCHANGED = 1221;
    public static final int NAME_SHEET_SETCHANGED = 1237;
    public static final int NAME_COLORS_SET = 1254;
    public static final int NAME_QLIST = 1265;
    public static final int NAME_COLOR_RGB = 1271;
    public static final int NAME_APP_GETPROPERTY = 1281;
    public static final int NAMESTART_MINIMAL_SET = 1297;
    public static final int NAME_QLIST_TO_SHEET = 1297;
    public static final int NAMESTOP_MINIMAL_SET = 1312;
    public static final int INDEX_IF = 0;
    public static final int INDEX_WHILE = 1;
    public static final int INDEX_SETQ = 2;
    public static final int INDEX_DEFUN = 3;
    public static final int INDEX_SADD = 4;
    public static final int INDEX_SSUB = 5;
    public static final int INDEX_SMUL = 6;
    public static final int INDEX_SDIV = 7;
    public static final int INDEX_SGT = 8;
    public static final int INDEX_SGE = 9;
    public static final int INDEX_SLT = 10;
    public static final int INDEX_SLE = 11;
    public static final int INDEX_SEQ = 12;
    public static final int INDEX_SNE = 13;
    public static final int INDEX_LOAD = 14;
    public static final int INDEX_MODULE_LOAD = 15;
    public static final int INDEX_ISNIL = 16;
    public static final int INDEX_TEXT = 17;
    public static final int INDEX_SHORT = 18;
    public static final int INDEX_BIND_TO_KEY = 19;
    public static final int INDEX_BIND_TO_COMMAND = 20;
    public static final int INDEX_BIND_TO_MENU = 21;
    public static final int INDEX_PROMPT = 22;
    public static final int INDEX_PROMPT_PRESERVE = 23;
    public static final int INDEX_APP_EXIT = 24;
    public static final int INDEX_APP_DEBUG = 25;
    public static final int INDEX_MENU_START = 26;
    public static final int INDEX_BIND_TO_GOLD = 27;
    public static final int INDEX_BIND = 28;
    public static final int INDEX__INPUT_FORM = 29;
    public static final int INDEX_SHEET_CREATE = 30;
    public static final int INDEX_CELL_CREATE = 31;
    public static final int INDEX_REF = 32;
    public static final int INDEX_CURSOR_SET = 33;
    public static final int INDEX_CURSOR_MOVE = 34;
    public static final int INDEX_CURSOR_GET = 35;
    public static final int INDEX_SHEET_ADDCELL = 36;
    public static final int INDEX_CELL_GETFORMULA = 37;
    public static final int INDEX_CELL_SETFORMULA = 38;
    public static final int INDEX_CELL_GETWSFORMULA = 39;
    public static final int INDEX_CELL_SETWSFORMULA = 40;
    public static final int INDEX_SHEET_GETCELL = 41;
    public static final int INDEX_SEXP_PARSE = 42;
    public static final int INDEX_CELL_ACTIVE = 43;
    public static final int INDEX_SHEET_RECALCULATE = 44;
    public static final int INDEX_SEXP_EVALUATE = 45;
    public static final int INDEX_CELL_REPAINT = 46;
    public static final int INDEX_DATE = 47;
    public static final int INDEX_ROWCOLUMN = 48;
    public static final int INDEX_SHEET_ACTIVATE = 49;
    public static final int INDEX_SHEET_ACTIVE = 50;
    public static final int INDEX_SHEET_SAVE = 51;
    public static final int INDEX_SHEET_LOAD = 52;
    public static final int INDEX_SHEET_GETNAME = 53;
    public static final int INDEX_SHEET_SETNAME = 54;
    public static final int INDEX_SHEET_LIST = 55;
    public static final int INDEX_CELL_SETFORMAT = 56;
    public static final int INDEX_CELL_GETFORMAT = 57;
    public static final int INDEX_SHEET_DELETE = 58;
    public static final int INDEX_MESSAGE = 59;
    public static final int INDEX_SHEET_GETWIDTHHEIGHT = 60;
    public static final int INDEX_SHEET_SETWIDTHHEIGHT = 61;
    public static final int INDEX_SHEET_REPAINT = 62;
    public static final int INDEX_SELECTION_GET = 63;
    public static final int INDEX_SELECTION_SET = 64;
    public static final int INDEX_GOLD_KEY = 65;
    public static final int INDEX_CELL_CLEAR = 66;
    public static final int INDEX_REFERENCE_PROCESS = 67;
    public static final int INDEX_SELECTION = 68;
    public static final int INDEX_SETSHEETSIZE = 69;
    public static final int INDEX_SHEET_INSERT = 70;
    public static final int INDEX_CELL_GETWSVALUE = 71;
    public static final int INDEX_STR_GETWIDTH = 72;
    public static final int INDEX_CELL_COPY = 73;
    public static final int INDEX_CELL_GETTYPE = 74;
    public static final int INDEX_ERROR = 75;
    public static final int INDEX_SYSTEM_INFO = 76;
    public static final int INDEX_DEBUG_SET = 77;
    public static final int INDEX_SCREEN_SETMODE = 78;
    public static final int INDEX_SCREEN_SETFORMULABAR = 79;
    public static final int INDEX_FORMULABAR_REPAINT = 80;
    public static final int INDEX_SCREEN_GETMODE = 81;
    public static final int INDEX_SCREEN_GETFORMULABAR = 82;
    public static final int INDEX_PARSE_WS = 83;
    public static final int INDEX_CELL_CREATE_WS = 84;
    public static final int INDEX_SCREEN_SETFONT = 85;
    public static final int INDEX_SHEET_SETDEFAULTSIZE = 86;
    public static final int INDEX_HISTORY_GET = 87;
    public static final int INDEX_ADD = 88;
    public static final int INDEX_SUB = 89;
    public static final int INDEX_MUL = 90;
    public static final int INDEX_DIV = 91;
    public static final int INDEX_EQ = 92;
    public static final int INDEX_NE = 93;
    public static final int INDEX_LE = 94;
    public static final int INDEX_LT = 95;
    public static final int INDEX_GE = 96;
    public static final int INDEX_GT = 97;
    public static final int INDEX_UMIN = 98;
    public static final int INDEX_PARENTHIS = 99;
    public static final int INDEX_PI = 100;
    public static final int INDEX_E = 101;
    public static final int INDEX_FADD = 102;
    public static final int INDEX_FSUB = 103;
    public static final int INDEX_FMUL = 104;
    public static final int INDEX_FDIV = 105;
    public static final int INDEX_ATAN2 = 106;
    public static final int INDEX_POW = 107;
    public static final int INDEX_ACOS = 108;
    public static final int INDEX_ASIN = 109;
    public static final int INDEX_ATAN = 110;
    public static final int INDEX_COS = 111;
    public static final int INDEX_SIN = 112;
    public static final int INDEX_COT = 113;
    public static final int INDEX_EXP = 114;
    public static final int INDEX_LOG = 115;
    public static final int INDEX_SQRT = 116;
    public static final int INDEX_TAN = 117;
    public static final int INDEX_STR_EQ = 118;
    public static final int INDEX_STR_LEN = 119;
    public static final int INDEX_DATE_ADD = 120;
    public static final int INDEX_DATE_SUB = 121;
    public static final int INDEX_ROUND = 122;
    public static final int INDEX_TOTYPE = 123;
    public static final int INDEX_STR_CAT = 124;
    public static final int INDEX_STR_SUB = 125;
    public static final int INDEX_STR_FIND = 126;
    public static final int INDEX_SUM = 127;
    public static final int INDEX_CELL_ADDRESS = 128;
    public static final int INDEX_SHEET_ISCHANGED = 129;
    public static final int INDEX_SHEET_SETCHANGED = 130;
    public static final int INDEX_COLORS_SET = 131;
    public static final int INDEX_QLIST = 132;
    public static final int INDEX_COLOR_RGB = 133;
    public static final int INDEX_APP_GETPROPERTY = 134;
    public static final int INDEXSTART_MINIMAL_SET = 135;
    public static final int INDEX_QLIST_TO_SHEET = 135;
    public static final int INDEXSTOP_MINIMAL_SET = 136;

    public void initializeNames() {
        this.namesArray = _namesArray;
        this.namesArrayCount = this.namesArray.length;
        this.table = new FunctionModule.ModuleName[]{new FunctionModule.ModuleName((FunctionModule)this, 0), new FunctionModule.ModuleName((FunctionModule)this, 3), new FunctionModule.ModuleName((FunctionModule)this, 9), new FunctionModule.ModuleName((FunctionModule)this, 14), new FunctionModule.ModuleName((FunctionModule)this, 20), new FunctionModule.ModuleName((FunctionModule)this, 25), new FunctionModule.ModuleName((FunctionModule)this, 30), new FunctionModule.ModuleName((FunctionModule)this, 35), new FunctionModule.ModuleName((FunctionModule)this, 40), new FunctionModule.ModuleName((FunctionModule)this, 44), new FunctionModule.ModuleName((FunctionModule)this, 48), new FunctionModule.ModuleName((FunctionModule)this, 52), new FunctionModule.ModuleName((FunctionModule)this, 56), new FunctionModule.ModuleName((FunctionModule)this, 60), new FunctionModule.ModuleName((FunctionModule)this, 64), new FunctionModule.ModuleName((FunctionModule)this, 69), new FunctionModule.ModuleName((FunctionModule)this, 81), null, null, null, null, null, null, null, null, null, null, null, null, null, new FunctionModule.ModuleName((FunctionModule)this, 222), new FunctionModule.ModuleName((FunctionModule)this, 235), new FunctionModule.ModuleName((FunctionModule)this, 247), new FunctionModule.ModuleName((FunctionModule)this, 251), new FunctionModule.ModuleName((FunctionModule)this, 262), new FunctionModule.ModuleName((FunctionModule)this, 274), new FunctionModule.ModuleName((FunctionModule)this, 285), new FunctionModule.ModuleName((FunctionModule)this, 299), new FunctionModule.ModuleName((FunctionModule)this, 315), new FunctionModule.ModuleName((FunctionModule)this, 331), new FunctionModule.ModuleName((FunctionModule)this, 349), new FunctionModule.ModuleName((FunctionModule)this, 367), new FunctionModule.ModuleName((FunctionModule)this, 381), new FunctionModule.ModuleName((FunctionModule)this, 392), new FunctionModule.ModuleName((FunctionModule)this, 404), new FunctionModule.ModuleName((FunctionModule)this, 422), new FunctionModule.ModuleName((FunctionModule)this, 436), new FunctionModule.ModuleName((FunctionModule)this, 449), new FunctionModule.ModuleName((FunctionModule)this, 454), new FunctionModule.ModuleName((FunctionModule)this, 464), new FunctionModule.ModuleName((FunctionModule)this, 479), new FunctionModule.ModuleName((FunctionModule)this, 492), new FunctionModule.ModuleName((FunctionModule)this, 503), new FunctionModule.ModuleName((FunctionModule)this, 514), new FunctionModule.ModuleName((FunctionModule)this, 528), new FunctionModule.ModuleName((FunctionModule)this, 542), new FunctionModule.ModuleName((FunctionModule)this, 553), new FunctionModule.ModuleName((FunctionModule)this, 568), new FunctionModule.ModuleName((FunctionModule)this, 583), new FunctionModule.ModuleName((FunctionModule)this, 596), new FunctionModule.ModuleName((FunctionModule)this, 604), new FunctionModule.ModuleName((FunctionModule)this, 625), new FunctionModule.ModuleName((FunctionModule)this, 646), new FunctionModule.ModuleName((FunctionModule)this, 660), new FunctionModule.ModuleName((FunctionModule)this, 674), new FunctionModule.ModuleName((FunctionModule)this, 688), new FunctionModule.ModuleName((FunctionModule)this, 697), new FunctionModule.ModuleName((FunctionModule)this, 708), new FunctionModule.ModuleName((FunctionModule)this, 726), new FunctionModule.ModuleName((FunctionModule)this, 736), new FunctionModule.ModuleName((FunctionModule)this, 749), new FunctionModule.ModuleName((FunctionModule)this, 762), new FunctionModule.ModuleName((FunctionModule)this, 778), new FunctionModule.ModuleName((FunctionModule)this, 791), new FunctionModule.ModuleName((FunctionModule)this, 801), new FunctionModule.ModuleName((FunctionModule)this, 814), new FunctionModule.ModuleName((FunctionModule)this, 820), new FunctionModule.ModuleName((FunctionModule)this, 832), new FunctionModule.ModuleName((FunctionModule)this, 842), new FunctionModule.ModuleName((FunctionModule)this, 857), new FunctionModule.ModuleName((FunctionModule)this, 878), new FunctionModule.ModuleName((FunctionModule)this, 897), new FunctionModule.ModuleName((FunctionModule)this, 912), new FunctionModule.ModuleName((FunctionModule)this, 933), new FunctionModule.ModuleName((FunctionModule)this, 942), new FunctionModule.ModuleName((FunctionModule)this, 957), new FunctionModule.ModuleName((FunctionModule)this, 972), new FunctionModule.ModuleName((FunctionModule)this, 993), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new FunctionModule.ModuleName((FunctionModule)this, 1133), new FunctionModule.ModuleName((FunctionModule)this, 1140), new FunctionModule.ModuleName((FunctionModule)this, 1148), new FunctionModule.ModuleName((FunctionModule)this, 1157), new FunctionModule.ModuleName((FunctionModule)this, 1166), new FunctionModule.ModuleName((FunctionModule)this, 1172), new FunctionModule.ModuleName((FunctionModule)this, 1179), new FunctionModule.ModuleName((FunctionModule)this, 1187), new FunctionModule.ModuleName((FunctionModule)this, 1195), new FunctionModule.ModuleName((FunctionModule)this, 1204), new FunctionModule.ModuleName((FunctionModule)this, 1208), new FunctionModule.ModuleName((FunctionModule)this, 1221), new FunctionModule.ModuleName((FunctionModule)this, 1237), new FunctionModule.ModuleName((FunctionModule)this, 1254), new FunctionModule.ModuleName((FunctionModule)this, 1265), new FunctionModule.ModuleName((FunctionModule)this, 1271), new FunctionModule.ModuleName((FunctionModule)this, 1281), new FunctionModule.ModuleName((FunctionModule)this, 1297)};
        this.namesCount = this.table.length;
    }

    public LispObject evaluate(FunctionModule.ModuleName moduleName, FunctorList functorList) throws EvaluateException {
        int n = functorList.listSize();
        CanvasHandler1 canvasHandler1 = CanvasHandler1.canvasHandler;
        Sheet sheet = canvasHandler1.sheet;
        short s = moduleName.offset;
        switch (s) {
            case 0: {
                if (((BooleanAtom)functorList.evaluateArg1()).value) {
                    return functorList.interpretArg2();
                }
                if (n == 4) {
                    return functorList.interpretArg3();
                }
                return LispObject.NIL;
            }
            case 3: {
                while (((BooleanAtom)functorList.evaluateArg1()).value) {
                    for (int i = 2; i < n; ++i) {
                        functorList.interpretArgN(i);
                    }
                }
                return LispObject.NIL;
            }
            case 9: {
                NameObjectBase nameObjectBase = (NameObjectBase)functorList.getArgument1();
                return nameObjectBase.setMappedObject(functorList.evaluateArg2());
            }
            case 14: {
                NameObjectBase nameObjectBase = (NameObjectBase)functorList.getArgument1();
                QuotedList quotedList = functorList.getArgument2().toQuotedList();
                LispObject lispObject = n == 4 ? functorList.getArgument3() : new QuotedList(functorList, 3, n);
                UserFunction userFunction = new UserFunction(nameObjectBase, quotedList, lispObject);
                return LispObject.NIL;
            }
            case 20: 
            case 25: 
            case 30: 
            case 35: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: {
                short s2 = functorList.getShort1();
                short s3 = functorList.getShort2();
                int n2 = 0;
                boolean bl = false;
                switch (s) {
                    case 20: {
                        n2 = s2 + s3;
                        break;
                    }
                    case 25: {
                        n2 = s2 - s3;
                        break;
                    }
                    case 30: {
                        n2 = s2 * s3;
                        break;
                    }
                    case 35: {
                        n2 = s2 / s3;
                        break;
                    }
                    case 40: {
                        bl = s2 > s3;
                        break;
                    }
                    case 44: {
                        bl = s2 >= s3;
                        break;
                    }
                    case 48: {
                        bl = s2 < s3;
                        break;
                    }
                    case 52: {
                        bl = s2 <= s3;
                        break;
                    }
                    case 56: {
                        bl = s2 == s3;
                        break;
                    }
                    case 60: {
                        bl = s2 != s3;
                    }
                }
                switch (s) {
                    case 20: 
                    case 25: 
                    case 30: 
                    case 35: {
                        return new ShortAtom(n2);
                    }
                    case 40: 
                    case 44: 
                    case 48: 
                    case 52: 
                    case 56: 
                    case 60: {
                        return bl ? BooleanAtom.TRUE : BooleanAtom.FALSE;
                    }
                }
            }
            case 64: {
                try {
                    return LispObject.loadFile(functorList.getString1()).interpret();
                }
                catch (ParseException parseException) {
                    throw new EvaluateException(parseException.getMessage(), functorList);
                }
            }
            case 69: {
                String string = functorList.getString1();
                return ModuleHandler.getFunctionModule(string);
            }
            case 81: {
                return BooleanAtom.createBoolean(functorList.getArgument1() == LispObject.NIL);
            }
            case 222: {
                return LispObject.fromList(functorList);
            }
            case 464: {
                canvasHandler1.sheet = sheet = (Sheet)functorList.evaluateArg1();
                canvasHandler1.sheetInitialize();
                try {
                    sheet.recalculateChangedCells(null);
                }
                catch (CircularReferenceException circularReferenceException) {
                    throw new EvaluateException(circularReferenceException.getMessage(), functorList);
                }
                canvasHandler1.repaint();
                break;
            }
            case 479: {
                return sheet;
            }
            case 235: {
                return Cell.fromList(functorList);
            }
            case 942: {
                Cell cell = (Cell)Cell.fromList(functorList);
                try {
                    cell.formula = Operator.OPERATOR.parseFormula(functorList.getString3());
                }
                catch (FormulaParseException formulaParseException) {
                    // empty catch block
                }
                return cell;
            }
            case 247: {
                return LispObject.fromList(functorList);
            }
            case 251: 
            case 262: {
                int n3;
                int[] nArray = new int[]{canvasHandler1.cursorx, canvasHandler1.cursory};
                short s4 = functorList.getShort1();
                int n4 = functorList.getShort2();
                if (s == 262) {
                    n4 += nArray[s4];
                }
                if ((n3 = s4 == 0 ? canvasHandler1.setCursorX(n4) : canvasHandler1.setCursorY(n4)) == 2) {
                    canvasHandler1.canvas.repaint();
                    break;
                }
                if (n3 != 1) break;
                canvasHandler1.repaintCell(nArray[1], nArray[0]);
                canvasHandler1.repaintCell(canvasHandler1.cursory, canvasHandler1.cursorx);
                break;
            }
            case 274: {
                short s5 = functorList.getShort1();
                return new ShortAtom(s5 == 0 ? canvasHandler1.cursorx : canvasHandler1.cursory);
            }
            case 285: {
                Cell cell = functorList.getCell1();
                sheet.putCell(cell);
                return cell;
            }
            case 299: {
                Cell cell = functorList.getCell1();
                return new StringAtom(cell.formula.toString());
            }
            case 331: {
                Cell cell = functorList.getCell1();
                return new StringAtom(cell.getFormula());
            }
            case 1208: {
                Cell cell = functorList.getCell1();
                return new StringAtom(Reference.cellAddress(cell.i, cell.j, 0));
            }
            case 367: {
                short s6 = functorList.getShort1();
                short s7 = functorList.getShort2();
                return canvasHandler1.getCell(s6, s7);
            }
            case 381: {
                try {
                    return LispObject.parseSExp(functorList.getString1());
                }
                catch (ParseException parseException) {
                    throw new EvaluateException(parseException.getMessage(), functorList);
                }
            }
            case 392: {
                return canvasHandler1.getCell(canvasHandler1.cursory, canvasHandler1.cursorx);
            }
            case 315: {
                Cell cell = functorList.getCell1();
                try {
                    sheet.setFormula(cell.i, cell.j, functorList.getString2());
                    break;
                }
                catch (ParseException parseException) {
                    throw new EvaluateException(parseException.getMessage(), functorList);
                }
            }
            case 349: {
                Cell cell = functorList.getCell1();
                String string = functorList.getString2();
                try {
                    sheet.setWSFormula(cell.i, cell.j, string);
                    break;
                }
                catch (FormulaParseException formulaParseException) {
                    throw new EvaluateException(formulaParseException.getMessage());
                }
            }
            case 404: {
                short s8 = 0;
                if (n > 1) {
                    s8 = functorList.getShort1();
                }
                try {
                    sheet.recalculateChangedCells(s8 == 1 ? canvasHandler1 : null);
                }
                catch (CircularReferenceException circularReferenceException) {
                    throw new EvaluateException(circularReferenceException.getMessage(), functorList);
                }
                if (s8 != 2) break;
                canvasHandler1.repaint();
                break;
            }
            case 422: {
                return functorList.evaluateArg1().interpret();
            }
            case 1297: {
                QuotedList quotedList = functorList.getQuotedList(1);
                Sheet sheet2 = functorList.getSheet(2);
                int n5 = functorList.getShort3();
                int n6 = functorList.getShort(4);
                short s9 = functorList.getShort(5);
                for (int i = 0; i < quotedList.value.length; ++i) {
                    int n7 = n5;
                    int n8 = n6;
                    if (s9 == 0) {
                        n7 += i;
                    } else {
                        n8 += i;
                    }
                    LispObject.debug("iii=" + n7 + " jjj=" + n8 + " val=" + quotedList.value[i]);
                    Cell cell = new Cell(n7, n8, quotedList.value[i], 0);
                    sheet2.putCell(cell);
                }
                break;
            }
            case 436: {
                if (n == 2) {
                    Cell cell = functorList.getCell1();
                    canvasHandler1.repaintCell(cell.i, cell.j);
                    break;
                }
                canvasHandler1.repaintCell(functorList.getShort1(), functorList.getShort2());
                break;
            }
            case 449: {
                return LispObject.fromList(functorList);
            }
            case 454: {
                return LispObject.fromList(functorList);
            }
            case 492: {
                try {
                    Sheet sheet3 = functorList.getSheet1();
                    sheet3.saveToRecordStore(functorList.getString2());
                    break;
                }
                catch (RecordStoreException recordStoreException) {
                    throw new EvaluateException("Error saving sheet: " + recordStoreException.getMessage(), functorList);
                }
            }
            case 503: {
                try {
                    Sheet sheet4 = Sheet.readFromRecordStore(functorList.getString1());
                    canvasHandler1.sheetInitialize();
                    return sheet4;
                }
                catch (RecordStoreException recordStoreException) {
                    throw new EvaluateException("Error loading sheet: " + recordStoreException.getMessage(), functorList);
                }
                catch (ParseException parseException) {
                    throw new EvaluateException("Error parsing sheet: " + parseException.getMessage(), functorList);
                }
            }
            case 514: {
                return new StringAtom(functorList.getSheet1().name);
            }
            case 528: {
                functorList.getSheet1().name = functorList.getString2();
                break;
            }
            case 1221: {
                Sheet sheet5 = functorList.getSheet1();
                return sheet5.isChanged ? BooleanAtom.TRUE : BooleanAtom.FALSE;
            }
            case 1237: {
                functorList.getSheet1().isChanged = functorList.getBoolean(2);
                break;
            }
            case 542: {
                return Sheet.listSheets();
            }
            case 553: {
                short s10;
                Cell cell = functorList.getCell1();
                cell.format = s10 = functorList.getShort2();
                break;
            }
            case 568: {
                Cell cell = functorList.getCell1();
                return new ShortAtom(cell.format);
            }
            case 583: {
                String string = functorList.getString1();
                try {
                    Sheet.deleteFromRecordStore(string);
                    break;
                }
                catch (RecordStoreException recordStoreException) {
                    throw new EvaluateException("cannot delete sheet", functorList);
                }
            }
            case 596: {
                Alert alert = new Alert(functorList.getString1(), functorList.getString2(), null, AlertType.INFO);
                alert.setTimeout(-2);
                LispTask.LispMachine.popMessage = alert;
                break;
            }
            case 604: {
                Sheet sheet6 = functorList.getSheet1();
                return new ShortAtom(sheet6.getRowColumn((int)functorList.getShort2(), (int)functorList.getShort3()).width_height);
            }
            case 625: {
                Sheet sheet7 = functorList.getSheet1();
                short s11 = functorList.getShort2();
                RowColumn rowColumn = new RowColumn(functorList.getShort3(), functorList.getShort(4));
                sheet7.rows_columns[s11].put(rowColumn, rowColumn);
                break;
            }
            case 646: {
                canvasHandler1.repaint();
                break;
            }
            case 660: {
                short s12 = functorList.getShort1();
                short s13 = functorList.getShort2();
                return new ShortAtom(s12 == 0 ? (s13 == 0 ? canvasHandler1.selectionx1 : canvasHandler1.selectiony1) : (s13 == 0 ? canvasHandler1.selectionx2 : canvasHandler1.selectiony2));
            }
            case 674: {
                short s14 = functorList.getShort1();
                short s15 = functorList.getShort2();
                short s16 = functorList.getShort3();
                if (s14 == 0) {
                    if (s15 == 0) {
                        canvasHandler1.selectionx1 = s16;
                        break;
                    }
                    canvasHandler1.selectiony1 = s16;
                    break;
                }
                if (s15 == 0) {
                    canvasHandler1.selectionx2 = s16;
                    break;
                }
                canvasHandler1.selectiony2 = s16;
                break;
            }
            case 688: {
                canvasHandler1.goldkey = functorList.getShort1();
                break;
            }
            case 697: {
                Sheet sheet8 = sheet;
                int n9 = 1;
                if (n >= 3) {
                    sheet8 = (Sheet)functorList.evaluateArgN(n9++);
                }
                Cell cell = (Cell)functorList.evaluateArgN(n9);
                sheet8.clearCell(cell.i, cell.j);
                break;
            }
            case 708: {
                int n10 = 1;
                Sheet sheet9 = sheet;
                if (n >= 4) {
                    sheet9 = (Sheet)functorList.evaluateArgN(n10++);
                }
                Reference reference = (Reference)functorList.evaluateArgN(n10++);
                NameObjectBase nameObjectBase = (NameObjectBase)functorList.getArgumentN(n10++);
                LispObject lispObject = LispObject.NIL;
                for (int i = reference.i1; i <= reference.i2; ++i) {
                    for (int j = reference.j1; j <= reference.j2; ++j) {
                        lispObject = new FunctorList1(nameObjectBase, sheet9.getCell(i, j)).evaluateSExp();
                    }
                }
                return lispObject;
            }
            case 726: {
                return new Reference(canvasHandler1.selectiony1, canvasHandler1.selectionx1, canvasHandler1.selectiony2, canvasHandler1.selectionx2);
            }
            case 736: {
                CanvasHandler1.MAX_COLUMNS_ROWS[functorList.getShort1()] = functorList.getShort2();
                break;
            }
            case 749: {
                int n11 = 1;
                Sheet sheet10 = sheet;
                if (n > 4) {
                    sheet10 = (Sheet)functorList.evaluateArgN(n11++);
                }
                short s17 = functorList.getShort(n11++);
                short s18 = functorList.getShort(n11++);
                short s19 = functorList.getShort(n11++);
                if (s17 == 1) {
                    sheet.insertCells(s18, 0, s19, 0);
                    break;
                }
                sheet.insertCells(0, s18, 0, s19);
                break;
            }
            case 762: {
                Cell cell = functorList.getCell1();
                return new StringAtom(cell.getText());
            }
            case 778: {
                String string = ((StringAtomBase)functorList.evaluateArg1()).getValue();
                int n12 = canvasHandler1.font.stringWidth(string);
                return new ShortAtom((n12 * 64 + canvasHandler1.fontWidth - 1) / canvasHandler1.fontWidth);
            }
            case 791: {
                Cell cell = functorList.getCell1();
                short s20 = functorList.getShort2();
                short s21 = functorList.getShort3();
                sheet.copyCell1(cell.i, cell.j, s20, s21);
                break;
            }
            case 801: {
                Cell cell = functorList.getCell1();
                return new ShortAtom(cell.value.typeNumber());
            }
            case 814: {
                return LispObject.fromList(functorList);
            }
            case 820: {
                Runtime runtime = Runtime.getRuntime();
                runtime.gc();
                String string = System.getProperty("microedition.platform");
                if (string == null) {
                    string = "null";
                }
                return new QuotedList(new LispObject[]{new LongAtom(runtime.freeMemory()), new LongAtom(runtime.totalMemory()), new StringAtom(string), new ShortAtom(this.namesCount)});
            }
            case 832: {
                CanvasHandler1.debugLevel = functorList.getShort1();
                break;
            }
            case 842: {
                canvasHandler1.setScreenMode(functorList.getShort1());
                break;
            }
            case 857: {
                canvasHandler1.formula = functorList.getString1();
            }
            case 878: {
                canvasHandler1.repaintFormulaBar();
                break;
            }
            case 912: {
                return new StringAtom(canvasHandler1.formula);
            }
            case 897: {
                return new ShortAtom(canvasHandler1.screenmode);
            }
            case 933: {
                try {
                    return Operator.OPERATOR.parseFormula(functorList.getString1());
                }
                catch (FormulaParseException formulaParseException) {
                    throw new EvaluateException(formulaParseException.getMessage(), functorList);
                }
            }
            case 957: {
                canvasHandler1.font = Font.getFont((int)functorList.getShort1(), (int)functorList.getShort2(), (int)functorList.getShort3());
                canvasHandler1.fontSize[0] = canvasHandler1.fontWidth = canvasHandler1.font.charWidth('#');
                canvasHandler1.fontSize[1] = canvasHandler1.fontHeight = canvasHandler1.font.getHeight();
                canvasHandler1.headerWidth = canvasHandler1.fontWidth * 2;
                canvasHandler1.headerHeight = canvasHandler1.fontHeight;
                break;
            }
            case 972: {
                Sheet sheet11 = (Sheet)functorList.evaluateArg1();
                sheet11.defaultWidthHeight[functorList.getShort2()] = functorList.getShort3();
                break;
            }
            case 1271: {
                return new LongAtom(functorList.getShort1() * 256 * 256 + functorList.getShort2() * 256 + functorList.getShort3());
            }
            case 1254: {
                QuotedList quotedList = functorList.getQuotedList(1);
                canvasHandler1.headerFontColor = quotedList.getInt(0);
                canvasHandler1.headerBackColor = quotedList.getInt(1);
                canvasHandler1.cellFontColor = quotedList.getInt(2);
                canvasHandler1.cellBackColor = quotedList.getInt(3);
                canvasHandler1.gridColor = quotedList.getInt(4);
                canvasHandler1.gridSelectedColor = quotedList.getInt(5);
                canvasHandler1.selectionFontColor = quotedList.getInt(6);
                canvasHandler1.selectionBackColor = quotedList.getInt(7);
                break;
            }
            case 1265: {
                return new QuotedList(functorList, 1, n);
            }
            case 1281: {
                return new StringAtom(canvasHandler1.getAppProperty(functorList.getString1()));
            }
            case 993: {
                if (n == 1) {
                    int n13 = CanvasHandler1.history.size();
                    LispObject[] lispObjectArray = new LispObject[n13];
                    for (int i = 0; i < n13; ++i) {
                        lispObjectArray[i] = new StringAtom((String)CanvasHandler1.history.elementAt(i));
                    }
                    return new QuotedList(lispObjectArray);
                }
                Sheet sheet12 = new Sheet();
                int n14 = CanvasHandler1.history.size();
                if (n14 > CanvasHandler1.MAX_COLUMNS_ROWS[1]) {
                    n14 = CanvasHandler1.MAX_COLUMNS_ROWS[1];
                }
                sheet12.name = "log history";
                for (int i = 0; i < n14; ++i) {
                    Cell cell = new Cell(i, 0, new StringAtom((String)CanvasHandler1.history.elementAt(CanvasHandler1.history.size() - i - 1)), 0);
                    sheet12.putCell(cell);
                }
                return sheet12;
            }
            case 1059: 
            case 1064: 
            case 1069: 
            case 1074: 
            case 1079: 
            case 1085: 
            case 1089: 
            case 1094: 
            case 1099: 
            case 1104: 
            case 1108: 
            case 1112: 
            case 1116: 
            case 1120: 
            case 1124: 
            case 1129: 
            case 1133: 
            case 1140: 
            case 1148: 
            case 1157: 
            case 1166: 
            case 1172: 
            case 1179: 
            case 1187: 
            case 1195: 
            case 1204: {
                return this.evaluate1(moduleName, functorList);
            }
        }
        return LispObject.NIL;
    }

    public LispObject evaluate1(FunctionModule.ModuleName moduleName, FunctorList functorList) throws EvaluateException {
        int n = functorList.listSize();
        short s = moduleName.offset;
        switch (s) {
            case 1089: 
            case 1094: 
            case 1099: 
            case 1104: 
            case 1108: 
            case 1112: 
            case 1116: 
            case 1120: 
            case 1124: 
            case 1129: {
                long l = ((FloatAtom)functorList.evaluateArg1()).value;
                long l2 = 0L;
                switch (s) {
                    case 1089: {
                        l2 = MathFP.acos(l);
                        break;
                    }
                    case 1094: {
                        l2 = MathFP.asin(l);
                        break;
                    }
                    case 1099: {
                        l2 = MathFP.atan(l);
                        break;
                    }
                    case 1104: {
                        l2 = MathFP.cos(l);
                        break;
                    }
                    case 1108: {
                        l2 = MathFP.sin(l);
                        break;
                    }
                    case 1112: {
                        l2 = MathFP.cot(l);
                        break;
                    }
                    case 1116: {
                        l2 = MathFP.exp(l);
                        break;
                    }
                    case 1120: {
                        l2 = MathFP.log(l);
                        break;
                    }
                    case 1124: {
                        l2 = MathFP.sqrt(l);
                        break;
                    }
                    case 1129: {
                        l2 = MathFP.tan(l);
                    }
                }
                return new FloatAtom(l2);
            }
            case 1059: 
            case 1064: 
            case 1069: 
            case 1074: 
            case 1079: 
            case 1085: {
                long l = ((FloatAtom)functorList.evaluateArg1()).value;
                long l3 = ((FloatAtom)functorList.evaluateArg2()).value;
                long l4 = 0L;
                switch (s) {
                    case 1059: {
                        l4 = l + l3;
                        break;
                    }
                    case 1064: {
                        l4 = l - l3;
                        break;
                    }
                    case 1069: {
                        l4 = MathFP.mul(l, l3);
                        break;
                    }
                    case 1074: {
                        l4 = MathFP.div(l, l3);
                        break;
                    }
                    case 1079: {
                        l4 = MathFP.atan2(l, l3);
                        break;
                    }
                    case 1085: {
                        l4 = MathFP.pow(l, l3);
                    }
                }
                return new FloatAtom(l4);
            }
            case 1133: {
                String string = functorList.getString1();
                String string2 = functorList.getString2();
                return BooleanAtom.createBoolean(string.compareTo(string2) == 0);
            }
            case 1140: {
                return new ShortAtom(functorList.getString1().length());
            }
            case 1179: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(functorList.getString(i));
                }
                return new StringAtom(stringBuffer.toString());
            }
            case 1187: {
                String string = functorList.getString1();
                short s2 = functorList.getShort2();
                short s3 = functorList.getShort3();
                return new StringAtom(string.substring(s2, s3));
            }
            case 1195: {
                String string = functorList.getString1();
                String string3 = functorList.getString2();
                return new ShortAtom(string.indexOf(string3));
            }
            case 1148: {
                DateAtom dateAtom = (DateAtom)functorList.evaluateArg1();
                FloatAtom floatAtom = functorList.getFloat(2);
                return new DateAtom(MathFP.toLong(MathFP.mul(floatAtom.value, DAY_BCD_MS_FLOAT)) + dateAtom.value);
            }
            case 1157: {
                DateAtom dateAtom = (DateAtom)functorList.evaluateArg1();
                DateAtom dateAtom2 = (DateAtom)functorList.evaluateArg2();
                return new FloatAtom(MathFP.div(MathFP.toFP(dateAtom.value - dateAtom2.value), DAY_BCD_MS_FLOAT));
            }
            case 1166: {
                FloatAtom floatAtom = functorList.getFloat(1);
                short s4 = functorList.getShort2();
                long l = MathFP.round(floatAtom.value, s4);
                String string = MathFP.toString(l);
                int n2 = string.indexOf(46);
                if (n2 >= 0) {
                    string = string.substring(0, n2 + s4 + 1);
                }
                return new FloatAtom(string);
            }
            case 1172: {
                LispObject lispObject = functorList.evaluateArg1();
                short s5 = functorList.getShort2();
                return lispObject.convertToType(s5);
            }
            case 1204: {
                LispObject lispObject = LispObject.NIL;
                for (int i = 1; i < n; ++i) {
                    LispObject lispObject2 = functorList.getArgumentN(i);
                    if (lispObject2.typeNumber() == 2) {
                        Reference reference = (Reference)lispObject2;
                        if ((reference.absFlags & 0x10) != 0) {
                            return FormulaError.REF_ERROR;
                        }
                        for (int j = reference.i1; j <= reference.i2; ++j) {
                            for (int k = reference.j1; k <= reference.j2; ++k) {
                                LispObject lispObject3 = CanvasHandler1.canvasHandler.getCellValue(j, k);
                                int n3 = lispObject3.typeNumber();
                                if (n3 != 7 && n3 != 8 && n3 != 9) continue;
                                lispObject = new FunctorList2(Operator.OPERATOR.table[0], lispObject, lispObject3).evaluateSExp();
                            }
                        }
                        continue;
                    }
                    int n4 = (lispObject2 = lispObject2.evaluateSExp()).typeNumber();
                    if (n4 != 7 && n4 != 8 && n4 != 9) continue;
                    lispObject = new FunctorList2(Operator.OPERATOR.table[0], lispObject, lispObject2).evaluateSExp();
                }
                return lispObject;
            }
        }
        return LispObject.NIL;
    }
}

