/*
 * Decompiled with CFR 0.152.
 */
package phoneman;

import com.telecom.IniFile;
import com.telecom.MessageBox;
import com.telecom.MessageBoxCallback;
import com.telecom.Splash;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.midlet.MIDlet;
import phoneman.Constants;
import phoneman.Favorites;
import phoneman.FileSystemAccessor;
import phoneman.Help;
import phoneman.Node;
import phoneman.PlayerCtrl;
import phoneman.ResProp;

public class PhoneMan
extends MIDlet
implements CommandListener,
MessageBoxCallback {
    private Display display;
    private List form;
    private Displayable saveDisplayable = null;
    private Command commandExit = new Command("\u0412\u044b\u0445\u043e\u0434", 3, 1);
    private Command commandOpen = new Command("\u041e\u0442\u043a\u0440\u044b\u0442\u044c", 4, 1);
    private Command commandProp = new Command("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", 8, 2);
    private Command commandMP3Player = new Command("MP3 Player", 8, 2);
    private Command commandSetPath = new Command("\u0417\u0430\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443", 8, 2);
    private Command commandFavorites = new Command("\u0418\u0437\u0431\u0440\u0430\u043d\u043d\u043e\u0435", 8, 2);
    private Command commandAutoPreview = new Command("\u041f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440", 8, 2);
    private Command commandContent = new Command("File/Content-type", 8, 2);
    private Command commandInfo = new Command("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", 8, 2);
    private Command commandHelp = new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 8, 2);
    private Command commandAbout = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 8, 2);
    private String[] listRoot = null;
    private static PhoneMan pm = null;
    private Vector v = new Vector();
    public static boolean useFileProtocol = false;
    private String info;

    public PhoneMan() {
        pm = this;
        this.display = Display.getDisplay((MIDlet)this);
        this.form = new List("Phone manager", 3);
        this.form.addCommand(this.commandExit);
        this.form.addCommand(this.commandOpen);
        this.form.addCommand(this.commandProp);
        this.form.addCommand(this.commandMP3Player);
        this.form.addCommand(this.commandFavorites);
        this.form.addCommand(this.commandSetPath);
        this.form.addCommand(this.commandInfo);
        this.form.addCommand(this.commandAutoPreview);
        this.form.addCommand(this.commandContent);
        this.form.addCommand(this.commandHelp);
        this.form.addCommand(this.commandAbout);
        this.form.addCommand(this.commandExit);
        this.form.setSelectCommand(this.commandOpen);
        this.form.setCommandListener((CommandListener)this);
        new Constants();
        this.createRootList();
        String[] stringArray = Manager.getSupportedContentTypes((String)"file");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toUpperCase().indexOf("WAV") > 0 | stringArray[n].toUpperCase().indexOf("MP3") > 0) {
                useFileProtocol = true;
                break;
            }
            ++n;
        }
    }

    public void startApp() {
        if (this.saveDisplayable == null) {
            Splash.showSplash(this.display, (Displayable)this.form);
            this.loadSetting();
        } else {
            this.display.setCurrent(this.saveDisplayable);
        }
    }

    public void pauseApp() {
        this.saveDisplayable = this.display.getCurrent();
    }

    public void destroyApp(boolean bl) {
        this.saveSetting();
        this.display.setCurrent((Displayable)null);
    }

    public void createRootList() {
        this.listRoot = null;
        this.listRoot = FileSystemAccessor.listRoots();
        int n = 0;
        while (n < this.listRoot.length) {
            this.form.append(this.listRoot[n], Constants.iconDisk);
            ++n;
        }
    }

    public static void quit() {
        if (pm != null) {
            pm.destroyApp(false);
            pm.notifyDestroyed();
        }
    }

    private void addProtocol2Info(String string) {
        this.info = this.info + "\nSupported protocols for content-type \"" + string + "\":\n";
        String[] stringArray = Manager.getSupportedProtocols((String)string);
        int n = 0;
        while (n < stringArray.length) {
            this.info = this.info + "" + stringArray[n] + "\n";
            ++n;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.commandInfo) {
            System.gc();
            String string = "";
            string = useFileProtocol ? "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \"file\"" : "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \"content-type\"";
            this.info = "";
            this.info = this.info + "\u041f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 ";
            this.info = Node.autoPreview ? this.info + "\u0432\u043a\u043b\u044e\u0447\u0435\u043d" : this.info + "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d";
            this.info = this.info + "\n\n" + string + "\n\n";
            String[] stringArray = null;
            this.info = this.info + "\u041f\u0430\u043c\u044f\u0442\u044c:\n";
            this.info = this.info + "\u0412\u0441\u0435\u0433\u043e: " + Runtime.getRuntime().totalMemory() + " \u0431\u0430\u0439\u0442\n";
            this.info = this.info + "\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u043e: " + Runtime.getRuntime().freeMemory() + " \u0431\u0430\u0439\u0442\n";
            this.info = this.info + "\nSupported content-types for protocol \"file\":\n";
            stringArray = Manager.getSupportedContentTypes((String)"file");
            int n = 0;
            while (n < stringArray.length) {
                this.info = this.info + "" + stringArray[n] + "\n";
                ++n;
            }
            this.info = this.info + "\nSupported content-types for protocol \"http\":\n";
            stringArray = Manager.getSupportedContentTypes((String)"http");
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.info = this.info + "" + stringArray[n2] + "\n";
                ++n2;
            }
            this.info = this.info + "\nSupported content-types for protocol \"capture\":\n";
            stringArray = Manager.getSupportedContentTypes((String)"capture");
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.info = this.info + "" + stringArray[n3] + "\n";
                ++n3;
            }
            this.addProtocol2Info("audio/wav");
            this.addProtocol2Info("audio/x-wav");
            this.addProtocol2Info("audio/mp3");
            this.addProtocol2Info("audio/x-mp3");
            this.addProtocol2Info("audio/amr");
            this.addProtocol2Info("audio/x-amr");
            new MessageBox(1, this.display, this, "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", this.info, 0, false);
        } else if (command == this.commandExit) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.commandHelp) {
            new Help(this.display, (Displayable)this.form);
        } else if (command == this.commandOpen) {
            int n = this.form.getSelectedIndex();
            if (n != -1) {
                Node node = new Node(this.display, (Displayable)this.form, this.listRoot[n]);
            }
        } else if (command == this.commandProp) {
            int n = this.form.getSelectedIndex();
            if (n != -1) {
                new ResProp(this.display, (Displayable)this.form, this.listRoot[n]);
            }
        } else if (command == this.commandMP3Player) {
            this.createMP3Player();
        } else if (command == this.commandSetPath) {
            new MessageBox(0, this.display, this, "\u041d\u043e\u0432\u043e\u0435 \u0438\u043c\u044f:", "", 1, true);
        } else if (command == this.commandAutoPreview) {
            Node.changePreview(this.display, (Displayable)this.form);
        } else if (command == this.commandContent) {
            Node.changeContent(this.display, (Displayable)this.form);
        } else if (command == this.commandFavorites) {
            new Favorites(this.display, (Displayable)this.form);
        } else if (command == this.commandAbout) {
            PhoneMan.showAbout(this.display, (Displayable)this.form);
        }
    }

    public void MessageBoxCallbackProc(int n, int n2, String string) {
        this.display.setCurrent((Displayable)this.form);
        if (n2 == 1 && n == 0) {
            String string2 = string.trim();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            Node node = new Node(this.display, (Displayable)this.form, string2);
            Node.listBookmark.addElement(node);
            Node.numBookmark = Node.listBookmark.size() - 1;
        }
    }

    public static void showAbout(Display display, Displayable displayable) {
        Splash splash = new Splash(display, displayable);
        splash.canCancel = false;
        splash.splashTime = -1;
        splash.imageName = "/res/logo.png";
        splash.textColor = 255;
        splash.textHeader = new String[]{"Phone Manager", "\u0412\u0435\u0440\u0441\u0438\u044f \u043e\u0442 11/04/2005"};
        splash.textFooter = new String[]{"\u041c\u0435\u0434\u0432\u0435\u0434\u0435\u0432 \u041e. \u0412.", "\"\u041e\u0410\u041e \u0410\u0440\u0442\u0435\u043b\u0435\u043a\u043e\u043c\"", "\u0421\u0435\u0432\u0435\u0440\u043e\u0434\u0432\u0438\u043d\u0441\u043a, 2005"};
        splash.show();
    }

    private void nodeList(String string) {
        FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(string);
        String[] stringArray = fileSystemAccessor.list();
        fileSystemAccessor = null;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                FileSystemAccessor fileSystemAccessor2 = new FileSystemAccessor(stringArray[n]);
                if (fileSystemAccessor2.isDirectory()) {
                    this.nodeList(stringArray[n]);
                } else if (stringArray[n].toUpperCase().endsWith(".MP3")) {
                    this.v.addElement(stringArray[n]);
                }
                fileSystemAccessor2 = null;
                ++n;
            }
        }
    }

    private void createMP3Player() {
        String[] stringArray = FileSystemAccessor.listRoots();
        int n = 0;
        while (n < stringArray.length) {
            this.nodeList(stringArray[n]);
            ++n;
        }
        PlayerCtrl playerCtrl = PlayerCtrl.createPlayer(this.display, (Displayable)this.form, "" + this.v.elementAt(0));
        playerCtrl.audioList = this.v;
        playerCtrl.indexList = 0;
    }

    private void saveSetting() {
        try {
            IniFile iniFile = new IniFile("FAVORITES");
            String[] stringArray = new String[Favorites.vFavorites.size()];
            int n = 0;
            while (n < Favorites.vFavorites.size()) {
                stringArray[n] = "" + Favorites.vFavorites.elementAt(n);
                ++n;
            }
            iniFile.writeStrings(stringArray);
            iniFile = null;
            iniFile = new IniFile("SETTINGS");
            String string = Node.autoPreview ? "true" : "false";
            String string2 = useFileProtocol ? "true" : "false";
            iniFile.writeStrings(new String[]{string, string2});
        }
        catch (Exception exception) {}
    }

    private void loadSetting() {
        block4: {
            try {
                IniFile iniFile = new IniFile("FAVORITES");
                String[] stringArray = iniFile.readStrings();
                int n = 0;
                while (n < stringArray.length) {
                    Favorites.vFavorites.addElement(stringArray[n]);
                    ++n;
                }
                iniFile = null;
                iniFile = new IniFile("SETTINGS");
                stringArray = iniFile.readStrings();
                if (stringArray == null || stringArray.length == 0) break block4;
                Node.autoPreview = stringArray[0].equals("true");
                if (stringArray[1].equals("true")) {
                    useFileProtocol = true;
                    break block4;
                }
                useFileProtocol = false;
            }
            catch (Exception exception) {}
        }
    }
}

