/*
 * Decompiled with CFR 0.152.
 */
package phoneman;

import com.motorola.extensions.ScalableJPGImage;
import com.telecom.MessageBox;
import com.telecom.MessageBoxCallback;
import com.telecom.Splash;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import phoneman.Constants;
import phoneman.Favorites;
import phoneman.FileSystemAccessor;
import phoneman.Help;
import phoneman.ImageCtrl;
import phoneman.MemoCtrl;
import phoneman.PhoneMan;
import phoneman.PlayerCtrl;
import phoneman.ResProp;
import phoneman.SubMenu;

public class Node
implements CommandListener,
MessageBoxCallback,
Runnable {
    private Display display;
    private Displayable parent;
    public String path = "";
    private List node;
    private Command commandBack = new Command("\u041d\u0430\u0437\u0430\u0434", 3, 1);
    private Command commandBackFromText = new Command("\u041d\u0430\u0437\u0430\u0434", 3, 1);
    private Command commandOpen = new Command("\u041e\u0442\u043a\u0440\u044b\u0442\u044c", 4, 1);
    private Command commandProp = new Command("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", 8, 2);
    private Command commandCopy = new Command("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 8, 2);
    private Command commandPaste = new Command("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", 8, 2);
    private Command commandCut = new Command("\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", 8, 2);
    private Command commandRename = new Command("\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c", 8, 2);
    private Command commandDelete = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 8, 2);
    private Command commandAbout = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 8, 2);
    private Command commandQuit = new Command("\u0412\u044b\u0445\u043e\u0434", 8, 2);
    private Command commandHelp = new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 8, 2);
    private Command commandFavorites = new Command("\u0418\u0437\u0431\u0440\u0430\u043d\u043d\u043e\u0435", 8, 2);
    private Command commandAddFavorites = new Command("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u0438\u0437\u0431\u0440\u0430\u043d\u043d\u043e\u0435", 8, 2);
    private Command commandSetBookmark = new Command("\u0417\u0430\u043a\u043b\u0430\u0434\u043a\u0430", 8, 2);
    private Command commandNextBookmark = new Command("\u041f\u0435\u0440\u0435\u0439\u0442\u0438", 8, 2);
    private Command commandSetPath = new Command("\u0417\u0430\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443", 8, 2);
    private Command commandAutoPreview = new Command("\u041f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440", 8, 2);
    private Command commandContent = new Command("File/Content-type", 8, 2);
    private Command commandToUp = new Command("\u041d\u0430\u0432\u0435\u0440\u0445", 8, 2);
    private Command commandCreateText = new Command("UTF Notepad", 8, 2);
    private Command commandToBegin = new Command("\u0412 \u043d\u0430\u0447\u0430\u043b\u043e", 8, 2);
    private Command commandToEnd = new Command("\u0412 \u043a\u043e\u043d\u0435\u0446", 8, 2);
    private Command commandSubMenuFile = new Command("\u0424\u0430\u0439\u043b", 8, 2);
    private Command commandSubMenuMove = new Command("\u041f\u0435\u0440\u0435\u0445\u043e\u0434", 8, 2);
    private Command commandSubMenuNav = new Command("\u041d\u0430\u0432\u0438\u0433\u0430\u0446\u0438\u044f", 8, 2);
    public String[] fileList = null;
    private Vector imageList = new Vector();
    private Vector audioList = new Vector();
    private static int fileOp = 0;
    private static String clipboard = "";
    public static Vector listBookmark = new Vector();
    public static int numBookmark = -1;
    private Thread thread = null;
    private boolean canRun = true;
    public static boolean autoPreview = true;

    Node(Display display, Displayable displayable, String string) {
        this.display = display;
        this.parent = displayable;
        this.path = string;
        this.node = new List(string, 3);
        this.node.addCommand(this.commandBack);
        this.node.addCommand(this.commandOpen);
        this.node.addCommand(this.commandProp);
        this.node.addCommand(this.commandSubMenuFile);
        this.node.addCommand(this.commandSubMenuMove);
        this.node.addCommand(this.commandSubMenuNav);
        this.node.addCommand(this.commandCreateText);
        this.node.addCommand(this.commandAutoPreview);
        this.node.addCommand(this.commandContent);
        this.node.addCommand(this.commandHelp);
        this.node.addCommand(this.commandAbout);
        this.node.addCommand(this.commandQuit);
        this.node.setSelectCommand(this.commandOpen);
        this.node.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.node);
        this.createList();
    }

    public void commandActionCallback(Command command, Displayable displayable) {
        this.display.setCurrent((Displayable)this.node);
        if (command != null) {
            this.commandAction(command, displayable);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        int n = this.node.getSelectedIndex();
        if (command == this.commandSubMenuNav) {
            String[] stringArray = new String[]{"\u0418\u0437\u0431\u0440\u0430\u043d\u043d\u043e\u0435", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u0438\u0437\u0431\u0440\u0430\u043d\u043d\u043e\u0435", "\u0417\u0430\u043a\u043b\u0430\u0434\u043a\u0430", "\u041f\u0435\u0440\u0435\u0439\u0442\u0438", "\u0417\u0430\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443"};
            Vector<Command> vector = new Vector<Command>();
            vector.addElement(this.commandFavorites);
            vector.addElement(this.commandAddFavorites);
            vector.addElement(this.commandSetBookmark);
            vector.addElement(this.commandNextBookmark);
            vector.addElement(this.commandSetPath);
            SubMenu subMenu = new SubMenu(this.display, this, "\u041d\u0430\u0432\u0438\u0433\u0430\u0446\u0438\u044f", stringArray, vector);
        } else if (command == this.commandSubMenuMove) {
            String[] stringArray = new String[]{"\u041d\u0430\u0432\u0435\u0440\u0445", "\u0412 \u043d\u0430\u0447\u0430\u043b\u043e", "\u0412 \u043a\u043e\u043d\u0435\u0446"};
            Vector<Command> vector = new Vector<Command>();
            vector.addElement(this.commandToUp);
            vector.addElement(this.commandToBegin);
            vector.addElement(this.commandToEnd);
            SubMenu subMenu = new SubMenu(this.display, this, "\u041f\u0435\u0440\u0435\u0445\u043e\u0434", stringArray, vector);
        } else if (command == this.commandSubMenuFile) {
            String[] stringArray = new String[]{"\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", "\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"};
            Vector<Command> vector = new Vector<Command>();
            vector.addElement(this.commandCopy);
            vector.addElement(this.commandPaste);
            vector.addElement(this.commandCut);
            vector.addElement(this.commandRename);
            vector.addElement(this.commandDelete);
            SubMenu subMenu = new SubMenu(this.display, this, "\u0424\u0430\u0439\u043b", stringArray, vector);
        } else if (command == this.commandToBegin) {
            this.node.setSelectedIndex(0, true);
        } else if (command == this.commandToEnd) {
            this.node.setSelectedIndex(this.node.size() - 1, true);
        } else if (command == this.commandCreateText) {
            if (n != -1 && this.fileList[n].toUpperCase().endsWith(".UTF")) {
                try {
                    FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(this.fileList[n]);
                    byte[] byArray = fileSystemAccessor.read();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    String string = dataInputStream.readUTF();
                    dataInputStream = null;
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                    new MemoCtrl(this.display, this, Constants.getResourceName(this.fileList[n]), string);
                }
                catch (Exception exception) {}
            } else {
                new MemoCtrl(this.display, this, "myutf.utf", "<empty>");
            }
        } else if (command == this.commandToUp) {
            String string = this.path.substring(0, this.path.length() - 1);
            int n2 = string.lastIndexOf(47);
            if ((string = string.substring(0, n2 + 1)).length() >= 3) {
                Node node = new Node(this.display, (Displayable)this.node, string);
            }
        } else if (command == this.commandAddFavorites) {
            Favorites.vFavorites.addElement("" + this.path);
        } else if (command == this.commandFavorites) {
            new Favorites(this.display, (Displayable)this.node);
        } else if (command == this.commandAutoPreview) {
            Node.changePreview(this.display, (Displayable)this.node);
        } else if (command == this.commandContent) {
            Node.changeContent(this.display, (Displayable)this.node);
        } else if (command == this.commandQuit) {
            PhoneMan.quit();
        } else if (command == this.commandSetBookmark) {
            listBookmark.addElement(this);
            numBookmark = listBookmark.size() - 1;
        } else if (command == this.commandNextBookmark) {
            if (++numBookmark >= listBookmark.size()) {
                numBookmark = 0;
            }
            Node node = (Node)listBookmark.elementAt(numBookmark);
            node.display.setCurrent((Displayable)node.node);
        } else if (command == this.commandHelp) {
            new Help(this.display, (Displayable)this.node);
        } else if (command == this.commandBack) {
            this.canRun = false;
            while (this.thread != null) {
            }
            this.display.setCurrent(this.parent);
        } else if (command == this.commandBackFromText) {
            this.display.setCurrent((Displayable)this.node);
        } else if (command == this.commandProp) {
            if (n != -1) {
                new ResProp(this.display, (Displayable)this.node, this.fileList[n]);
            }
        } else if (command == this.commandDelete) {
            if (n != -1) {
                fileOp = 5;
                new MessageBox(0, this.display, this, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c?\n", Constants.getResourceName(this.fileList[n]), 1, false);
            }
        } else if (command == this.commandRename) {
            if (n != -1) {
                fileOp = 4;
                new MessageBox(0, this.display, this, "\u041d\u043e\u0432\u043e\u0435 \u0438\u043c\u044f:", Constants.getResourceName(this.fileList[n]), 1, true);
            }
        } else if (command == this.commandSetPath) {
            fileOp = 6;
            new MessageBox(0, this.display, this, "\u041f\u0430\u043f\u043a\u0430:", this.path, 1, true);
        } else if (command == this.commandCopy) {
            if (n != -1) {
                clipboard = this.fileList[n];
                fileOp = 1;
            }
        } else if (command == this.commandCut) {
            if (n != -1) {
                clipboard = this.fileList[n];
                fileOp = 2;
                this.node.set(n, this.node.getString(n), Constants.iconDelFile);
            }
        } else if (command == this.commandPaste) {
            if (clipboard != "" && fileOp == 1 | fileOp == 2) {
                FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(clipboard);
                byte[] byArray = fileSystemAccessor.read();
                fileSystemAccessor = null;
                if (byArray != null) {
                    String string = Constants.getResourceName(clipboard);
                    FileSystemAccessor fileSystemAccessor2 = new FileSystemAccessor(this.path + string);
                    fileSystemAccessor2.rewrite(byArray);
                    fileSystemAccessor2 = null;
                    if (fileOp == 2) {
                        FileSystemAccessor fileSystemAccessor3 = new FileSystemAccessor(clipboard);
                        fileSystemAccessor3.delete();
                        fileSystemAccessor3 = null;
                    }
                    this.createList();
                }
                clipboard = "";
                fileOp = 0;
            }
        } else if (command == this.commandAbout) {
            PhoneMan.showAbout(this.display, (Displayable)this.node);
        } else if (command == this.commandOpen && n != -1) {
            String string = this.fileList[n];
            String string2 = Constants.getResourceName(string);
            if (Constants.getResourceGroupIndex(string) == 3) {
                PlayerCtrl playerCtrl = PlayerCtrl.createPlayer(this.display, (Displayable)this.node, string);
                playerCtrl.audioList = this.audioList;
                int n3 = 0;
                while (n3 < this.audioList.size()) {
                    String string3 = "" + this.audioList.elementAt(n3);
                    if (string3.equals(string)) {
                        playerCtrl.indexList = n3;
                        break;
                    }
                    ++n3;
                }
            } else if (Constants.getResourceGroupIndex(string) == 2) {
                ImageCtrl imageCtrl = new ImageCtrl(this.display, (Displayable)this.node, string);
                imageCtrl.imageList = this.imageList;
                int n4 = 0;
                while (n4 < this.imageList.size()) {
                    String string4 = "" + this.imageList.elementAt(n4);
                    if (string4.equals(string)) {
                        imageCtrl.indexList = n4;
                        break;
                    }
                    ++n4;
                }
                imageCtrl.show();
            } else if (string.toUpperCase().endsWith("UTF")) {
                this.commandAction(this.commandCreateText, displayable);
            } else if (Constants.getResourceGroupIndex(string) == 5) {
                Form form = new Form(string2);
                form.setCommandListener((CommandListener)this);
                form.addCommand(this.commandBackFromText);
                FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(string);
                byte[] byArray = fileSystemAccessor.read();
                fileSystemAccessor = null;
                String string5 = "";
                int n5 = 0;
                while (n5 < byArray.length) {
                    byte by = byArray[n5];
                    if (by != 10) {
                        string5 = string5 + String.valueOf(Constants.byte2char(by));
                    }
                    ++n5;
                }
                form.append(string5);
                string5 = null;
                this.display.setCurrent((Displayable)form);
            } else if (string.toUpperCase().endsWith("/")) {
                Node node = new Node(this.display, (Displayable)this.node, string);
            }
        }
    }

    private void sortList() {
        if (this.fileList != null) {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            int n = 0;
            while (n < this.fileList.length) {
                if (this.fileList[n].toUpperCase().endsWith("/")) {
                    vector.addElement(this.fileList[n]);
                } else {
                    vector2.addElement(this.fileList[n]);
                }
                ++n;
            }
            vector = Node.sortList(vector);
            vector2 = Node.sortList(vector2);
            int n2 = 0;
            while (n2 < vector.size()) {
                this.fileList[n2] = "" + vector.elementAt(n2);
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector2.size()) {
                this.fileList[vector.size() + n3] = "" + vector2.elementAt(n3);
                ++n3;
            }
            vector = null;
            vector2 = null;
        }
    }

    public static Vector sortList(Vector vector) {
        if (vector.size() > 1 && vector != null) {
            boolean bl;
            do {
                bl = false;
                int n = 0;
                while (n < vector.size() - 1) {
                    String string;
                    String string2 = "" + vector.elementAt(n);
                    if (string2.compareTo(string = "" + vector.elementAt(n + 1)) > 0) {
                        vector.setElementAt(string, n);
                        vector.setElementAt(string2, n + 1);
                        bl = true;
                    }
                    ++n;
                }
            } while (bl);
        }
        return vector;
    }

    public void createList() {
        this.imageList.setSize(0);
        this.audioList.setSize(0);
        this.fileList = null;
        this.node.deleteAll();
        FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(this.path);
        this.fileList = fileSystemAccessor.list();
        fileSystemAccessor = null;
        this.sortList();
        if (this.fileList != null) {
            int n = 0;
            while (n < this.fileList.length) {
                String string = this.fileList[n];
                int n2 = Constants.getResourceGroupIndex(string);
                if (n2 == 3) {
                    this.audioList.addElement(string);
                } else if (n2 == 2) {
                    this.imageList.addElement(string);
                }
                if (n2 != 0) {
                    this.node.append(Constants.getResourceName(string), Constants.getResourceImage(string));
                } else {
                    string = string.substring(0, string.length() - 1);
                    string = string.substring(string.lastIndexOf(47) + 1);
                    Image image = Constants.iconFolder;
                    String string2 = string.toUpperCase();
                    if (string2.equals("AUDIO")) {
                        image = Constants.iconFolderAudio;
                    } else if (string2.equals("PICTURE")) {
                        image = Constants.iconFolderPicture;
                    } else if (string2.equals("VIDEO")) {
                        image = Constants.iconFolderVideo;
                    }
                    this.node.append(Constants.getResourcePath(string), image);
                }
                ++n;
            }
        }
        if (autoPreview) {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    public void MessageBoxCallbackProc(int n, int n2, String string) {
        this.display.setCurrent((Displayable)this.node);
        if (n2 == 1) {
            switch (fileOp) {
                case 5: {
                    FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(this.fileList[this.node.getSelectedIndex()]);
                    fileSystemAccessor.delete();
                    fileSystemAccessor = null;
                    break;
                }
                case 4: {
                    String string2 = string.trim();
                    if (string2 == "") break;
                    FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(this.fileList[this.node.getSelectedIndex()]);
                    String string3 = string.trim();
                    fileSystemAccessor.rename(this.path + string3);
                    fileSystemAccessor = null;
                    this.fileList[this.node.getSelectedIndex()] = this.path + string3;
                    this.node.set(this.node.getSelectedIndex(), string3, Constants.getResourceImage(string3));
                    break;
                }
                case 6: {
                    listBookmark.addElement(this);
                    numBookmark = listBookmark.size() - 1;
                    String string4 = string.trim();
                    if (!string4.endsWith("/")) {
                        string4 = string4 + "/";
                    }
                    Node node = new Node(this.display, (Displayable)this.node, string4);
                }
            }
            this.createList();
        }
    }

    public void run() {
        if (this.fileList != null) {
            int n = 0;
            while (n < this.fileList.length) {
                while (this.display.getCurrent() != this.node && this.canRun) {
                }
                if (!this.canRun) break;
                if (Constants.getResourceGroupIndex(this.fileList[n]) == 2 && this.node.getImage(n) != null) {
                    FileSystemAccessor fileSystemAccessor;
                    try {
                        fileSystemAccessor = new FileSystemAccessor(this.fileList[n]);
                    }
                    catch (Exception exception) {
                        fileSystemAccessor = null;
                    }
                    if (fileSystemAccessor != null) {
                        byte[] byArray = fileSystemAccessor.read();
                        if (byArray != null) {
                            String string = this.node.getString(n);
                            String string2 = this.fileList[n].toUpperCase();
                            if (string2.endsWith(".JPG") | string2.endsWith(".GIF")) {
                                ScalableJPGImage scalableJPGImage = ScalableJPGImage.createImage((byte[])byArray, (int)0, (int)byArray.length, (int)32, (int)32);
                                try {
                                    this.node.set(n, string, scalableJPGImage.getImage());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                scalableJPGImage = null;
                            } else if (string2.endsWith(".PNG")) {
                                try {
                                    this.node.set(n, string, Image.createImage((byte[])byArray, (int)0, (int)byArray.length));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        byArray = null;
                    }
                    System.gc();
                }
                ++n;
            }
        }
        this.thread = null;
    }

    public static void changeContent(Display display, Displayable displayable) {
        PhoneMan.useFileProtocol = !PhoneMan.useFileProtocol;
        String string = "";
        String string2 = "";
        if (PhoneMan.useFileProtocol) {
            string = "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f";
            string2 = "\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \"file\"";
        } else {
            string = "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f";
            string2 = "\"content-type\"";
        }
        Splash splash = new Splash(display, displayable);
        splash.imageName = "<empty>";
        splash.canCancel = true;
        splash.splashTime = 2500;
        splash.textColor = 255;
        splash.textHeader = new String[]{" ", "Player", " ", string, string2};
        splash.show();
    }

    public static void changePreview(Display display, Displayable displayable) {
        autoPreview = !autoPreview;
        String string = "";
        string = autoPreview ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d" : "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d";
        Splash splash = new Splash(display, displayable);
        splash.imageName = "<empty>";
        splash.canCancel = true;
        splash.splashTime = 2500;
        splash.textColor = 255;
        splash.textHeader = new String[]{" ", " ", "\u041f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440", string};
        splash.show();
    }

    public void memoCancel() {
        this.display.setCurrent((Displayable)this.node);
    }

    public void memoSave(MemoCtrl memoCtrl) {
        try {
            String string = ((TextField)memoCtrl.get(1)).getString();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            FileSystemAccessor fileSystemAccessor = new FileSystemAccessor(this.path + ((TextField)memoCtrl.get(0)).getString());
            fileSystemAccessor.rewrite(byArray);
            byArray = null;
            dataOutputStream = null;
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        memoCtrl = null;
        this.display.setCurrent((Displayable)this.node);
        this.createList();
    }
}

