/*
 * Decompiled with CFR 0.152.
 */
package phoneman;

import com.motorola.io.FileConnection;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import phoneman.Constants;
import phoneman.PhoneMan;
import phoneman.PlayerTimerTask;

public class PlayerCtrl
extends Canvas
implements PlayerListener {
    private Display display;
    private Displayable parent;
    private Player player = null;
    private Timer timer;
    private String event;
    private Object eventData;
    private String fileName;
    private VolumeControl volcontrol;
    public Vector audioList = null;
    public int indexList = -1;
    private static int curVol = -1;
    public static boolean autoReplay = true;
    private boolean flashed = true;

    PlayerCtrl() {
        this.setFullScreenMode(true);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new PlayerTimerTask(this), 1000L, 1000L);
    }

    public void playerUpdate(Player player, String string, Object object) {
        this.event = string;
        this.eventData = object;
        this.repaint();
        if (string == "endOfMedia" && autoReplay) {
            this.keyReleased(-5);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(192, 192, 192);
        graphics.fillRect(0, 44, this.getWidth(), this.getHeight());
        graphics.drawImage(Constants.iconMedia, 8, 8, 0);
        graphics.drawImage(Constants.iconMediaCtrl, this.getWidth() - Constants.iconMediaCtrl.getWidth() - 8, 8, 0);
        graphics.setColor(0, 0, 255);
        String string = this.fileName;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        graphics.drawString(string, 8, 48, 0);
        String string2 = "\u0417\u0430\u043a\u0440\u044b\u0442";
        if (this.player != null) {
            int n2 = this.player.getState();
            switch (n2) {
                case 100: {
                    string2 = "\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435";
                    break;
                }
                case 200: {
                    string2 = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430";
                    break;
                }
                case 300: {
                    string2 = "\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
                    break;
                }
                case 400: {
                    string2 = "\u0412\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u0435";
                }
            }
            graphics.drawString(string2, 8, graphics.getFont().getHeight() + 48, 0);
            long l = 0L;
            if (string.toUpperCase().endsWith(".MP3") && this.player.getState() == 400) {
                long l2 = this.player.getDuration() / 1000000L;
                long l3 = this.player.getMediaTime() / 1000000L;
                l = l3 * 100L / l2;
                if (l3 == -1L) {
                    string2 = "TIME_UNKNOWN";
                }
                long l4 = l2 / 60L;
                long l5 = l2 - l4 * 60L;
                long l6 = l3 / 60L;
                long l7 = l3 - l6 * 60L;
                graphics.drawString("" + (l6 < 10L ? "0" + l6 : "" + l6) + ":" + (l7 < 10L ? "0" + l7 : "" + l7) + " / " + (l4 < 10L ? "0" + l4 : "" + l4) + ":" + (l5 < 10L ? "0" + l5 : "" + l5), 8, graphics.getFont().getHeight() * 2 + 48, 0);
            } else if (this.player.getState() == 400) {
                l = this.player.getMediaTime() / 1000000L;
                if (l > 100L) {
                    l = 100L;
                }
                graphics.drawString("" + l + "%", 8, graphics.getFont().getHeight() * 2 + 48, 0);
            }
            int n3 = this.volcontrol.getLevel();
            graphics.setColor(0, 0, 255);
            graphics.drawString("\u0413\u0440\u043e\u043c\u043a\u043e\u0441\u0442\u044c: " + n3 + "%", 8, graphics.getFont().getHeight() * 3 + 48, 0);
        }
    }

    protected void keyReleased(int n) {
        if (n == 48) {
            this.destroyPlayer();
        } else if (n == -21) {
            this.destroyPlayer();
        } else if (n == -22) {
            this.stopPlayer();
            this.startPlayer();
        } else if (this.player.getState() == 400 && n == 42) {
            this.volcontrol.setLevel(this.volcontrol.getLevel() - 10);
        } else if (this.player.getState() == 400 && n == 35) {
            this.volcontrol.setLevel(this.volcontrol.getLevel() + 10);
        } else if (n == -1) {
            if (this.player.getState() == 300) {
                try {
                    this.player.start();
                }
                catch (MediaException mediaException) {}
            }
        } else if (n == -6) {
            if (this.player.getState() == 400) {
                try {
                    this.player.stop();
                }
                catch (MediaException mediaException) {}
            }
        } else if (n == -5) {
            if (this.audioList.size() != 0) {
                ++this.indexList;
                if (this.indexList > this.audioList.size() - 1) {
                    this.indexList = 0;
                }
                this.stopPlayer();
                this.fileName = "" + this.audioList.elementAt(this.indexList);
                this.startPlayer();
            }
        } else if (n == -2) {
            if (this.audioList.size() != 0) {
                --this.indexList;
                if (this.indexList < 0) {
                    this.indexList = this.audioList.size() - 1;
                }
                this.stopPlayer();
                this.fileName = "" + this.audioList.elementAt(this.indexList);
                this.startPlayer();
            }
        } else if (n == 54 && this.player.getState() == 400) {
            long l;
            long l2 = this.player.getMediaTime();
            long l3 = l2 + (l = this.player.getDuration() - 1L) / 20L;
            if (l3 > l) {
                l3 = l;
            }
            try {
                this.player.setMediaTime(l3);
            }
            catch (MediaException mediaException) {}
        } else if (n == 52 && this.player.getState() == 400) {
            long l;
            long l4 = this.player.getMediaTime();
            long l5 = l4 - (l = this.player.getDuration()) / 20L;
            if (l5 < 0L) {
                l5 = 0L;
            }
            try {
                this.player.setMediaTime(l5);
            }
            catch (MediaException mediaException) {}
        } else if (n == 53) {
            boolean bl = this.flashed = !this.flashed;
            if (this.flashed) {
                this.display.flashBacklight(3000000);
            } else {
                this.display.flashBacklight(1000);
            }
        }
    }

    public static PlayerCtrl createPlayer(Display display, Displayable displayable, String string) {
        PlayerCtrl playerCtrl = new PlayerCtrl();
        playerCtrl.display = display;
        playerCtrl.parent = displayable;
        playerCtrl.fileName = string;
        display.setCurrent((Displayable)playerCtrl);
        playerCtrl.startPlayer();
        playerCtrl.indexList = 0;
        return playerCtrl;
    }

    private void destroyPlayer() {
        this.stopPlayer();
        this.timer.cancel();
        this.timer = null;
        List list = (List)this.parent;
        String string = Constants.getResourceName(this.fileName);
        int n = 0;
        while (n < list.size()) {
            if (list.getString(n).equals(string)) {
                list.setSelectedIndex(n, true);
                break;
            }
            ++n;
        }
        this.flashed = true;
        this.display.flashBacklight(3000000);
        this.display.setCurrent(this.parent);
    }

    private void startPlayer() {
        this.player = null;
        this.volcontrol = null;
        System.gc();
        if (PhoneMan.useFileProtocol) {
            try {
                this.player = Manager.createPlayer((String)("file:/" + this.fileName));
                this.player.addPlayerListener((PlayerListener)this);
                this.player.realize();
                this.player.prefetch();
                this.volcontrol = (VolumeControl)this.player.getControl("VolumeControl");
                if (curVol != -1) {
                    this.volcontrol.setLevel(curVol);
                }
                this.player.start();
            }
            catch (Exception exception) {
                this.startPlayerFileConnection();
            }
        } else {
            this.startPlayerFileConnection();
        }
    }

    private void startPlayerFileConnection() {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file://" + this.fileName));
            DataInputStream dataInputStream = fileConnection.openDataInputStream();
            this.player = Manager.createPlayer((InputStream)dataInputStream, (String)this.getContentType(this.fileName));
            this.player.addPlayerListener((PlayerListener)this);
            this.player.realize();
            this.player.prefetch();
            this.volcontrol = (VolumeControl)this.player.getControl("VolumeControl");
            if (curVol != -1) {
                this.volcontrol.setLevel(curVol);
            }
            this.player.start();
            ((InputStream)dataInputStream).close();
            fileConnection.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private void stopPlayer() {
        block4: {
            if (this.player == null) break block4;
            try {
                try {
                    curVol = this.volcontrol.getLevel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.volcontrol = null;
                this.player.stop();
                this.player.close();
                this.player = null;
            }
            catch (MediaException mediaException) {}
        }
    }

    private String getContentType(String string) {
        String string2 = "";
        if ((string = string.trim().toUpperCase()).endsWith(".WAV")) {
            string2 = "audio/x-wav";
        } else if (string.endsWith(".MP3")) {
            string2 = "audio/x-mp3";
        } else if (string.endsWith(".MID")) {
            string2 = "audio/x-midi";
        } else if (string.endsWith(".MIDI")) {
            string2 = "audio/x-midi";
        } else if (string.endsWith(".AMR")) {
            string2 = "audio/x-amr";
        } else if (string.endsWith(".IMY")) {
            string2 = "audio/x-imy";
        }
        return string2;
    }
}

