/*
 * Decompiled with CFR 0.152.
 */
package phoneman;

import com.motorola.extensions.ScalableJPGImage;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.game.Sprite;
import phoneman.Constants;
import phoneman.FileSystemAccessor;
import phoneman.ImageProp;

public class ImageCtrl
extends Canvas {
    private Display display;
    private Displayable parent;
    private String fileName = "";
    private Image image = null;
    private static final int[] imageWidths = new int[]{160, 176, 272, 320};
    private static final int[] imageHeights = new int[]{120, 235, 204, 240};
    private static final int imageSize0 = 2;
    private int imageSize = 2;
    private int offsetX = 0;
    private int offsetY = 0;
    private final int offsetStep;
    private boolean canMove = true;
    public Vector imageList = null;
    public int indexList = -1;
    private static int[] transformArr = new int[]{0, 5, 3, 6, 2, 7, 1, 4};
    private static int transform = 0;
    private Command commandBackFromText = new Command("Ok", 4, 1);
    private int originalWidth;
    private int originalHeight;

    ImageCtrl(Display display, Displayable displayable, String string) {
        this.offsetStep = 20;
        this.display = display;
        this.parent = displayable;
        this.fileName = string;
        this.setFullScreenMode(true);
    }

    public void show() {
        this.createImage();
        this.display.setCurrent((Displayable)this);
    }

    private void createImage() {
        block12: {
            try {
                FileSystemAccessor fileSystemAccessor;
                this.image = null;
                try {
                    fileSystemAccessor = new FileSystemAccessor(this.fileName);
                }
                catch (Exception exception) {
                    fileSystemAccessor = null;
                }
                if (fileSystemAccessor == null) break block12;
                byte[] byArray = fileSystemAccessor.read();
                if (byArray != null) {
                    String string = this.fileName.toUpperCase();
                    if (string.endsWith(".JPG") | string.endsWith(".GIF")) {
                        ScalableJPGImage scalableJPGImage = ScalableJPGImage.createImage((byte[])byArray, (int)0, (int)byArray.length, (int)imageWidths[this.imageSize], (int)imageHeights[this.imageSize]);
                        try {
                            this.image = scalableJPGImage.getImage();
                            this.originalWidth = scalableJPGImage.getOrigWidth();
                            this.originalHeight = scalableJPGImage.getOrigHeight();
                        }
                        catch (Exception exception) {
                            this.image = null;
                        }
                        scalableJPGImage = null;
                    } else if (string.endsWith(".PNG")) {
                        try {
                            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                            this.originalWidth = this.image.getWidth();
                            this.originalHeight = this.image.getHeight();
                        }
                        catch (Exception exception) {
                            this.image = null;
                        }
                    }
                    byArray = null;
                    System.gc();
                    this.canMove = true;
                    break block12;
                }
                this.createErrImage();
            }
            catch (Exception exception) {
                System.out.println("createImage error: " + exception.getMessage());
                this.createErrImage();
            }
        }
        this.repaint();
    }

    private void createErrImage() {
        this.image = null;
        this.image = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.originalWidth = this.image.getWidth();
        this.originalHeight = this.image.getHeight();
        int n = this.getWidth() - 48;
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        try {
            graphics.drawImage(Constants.iconStop, 24, this.image.getHeight() / 2, 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.setColor(0, 0, 255);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        this.fileName = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
        graphics.drawString(this.fileName, (this.image.getWidth() - graphics.getFont().stringWidth(this.fileName)) / 2, 4, 0);
        String string = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438";
        graphics.drawString(string, 48 + (n - graphics.getFont().stringWidth(string)) / 2, (this.image.getHeight() - graphics.getFont().getHeight() * 2) / 2, 0);
        string = "\u0447\u0442\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430";
        graphics.drawString(string, 48 + (n - graphics.getFont().stringWidth(string)) / 2, this.image.getHeight() / 2, 0);
        this.canMove = false;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        try {
            Sprite sprite = new Sprite(this.image);
            sprite.setTransform(transformArr[transform]);
            int n = sprite.getWidth();
            int n2 = sprite.getHeight();
            switch (transformArr[transform]) {
                case 0: {
                    n = sprite.getWidth();
                    n2 = sprite.getHeight();
                    break;
                }
                case 5: {
                    n = sprite.getHeight();
                    n2 = sprite.getWidth();
                    break;
                }
                case 3: {
                    n = sprite.getWidth();
                    n2 = sprite.getHeight();
                    break;
                }
                case 6: {
                    n = sprite.getHeight();
                    n2 = sprite.getWidth();
                    break;
                }
                case 2: {
                    n = sprite.getWidth();
                    n2 = sprite.getHeight();
                    break;
                }
                case 7: {
                    n = sprite.getHeight();
                    n2 = sprite.getWidth();
                    break;
                }
                case 1: {
                    n = sprite.getWidth();
                    n2 = sprite.getHeight();
                    break;
                }
                case 4: {
                    n = sprite.getHeight();
                    n2 = sprite.getWidth();
                }
            }
            sprite.defineReferencePixel(n / 2, n2 / 2);
            sprite.setRefPixelPosition(this.getWidth() / 2 - this.offsetX, this.getHeight() / 2 - this.offsetY);
            sprite.paint(graphics);
            sprite = null;
        }
        catch (Exception exception) {
            System.out.println("paint error: " + exception.getMessage());
        }
    }

    private void quitViewer() {
        List list = (List)this.parent;
        String string = Constants.getResourceName(this.fileName);
        int n = 0;
        while (n < list.size()) {
            if (list.getString(n).equals(string)) {
                list.setSelectedIndex(n, true);
                break;
            }
            ++n;
        }
        this.display.setCurrent(this.parent);
    }

    public void keyReleased(int n) {
        if (n == -23) {
            new ImageProp(this.display, this, this.fileName, this.image, this.originalWidth, this.originalHeight);
        } else if (n == -21) {
            this.quitViewer();
        } else if (n == 48) {
            this.quitViewer();
        } else if (n == 35) {
            if (++transform >= transformArr.length) {
                transform = 0;
            }
            this.repaint();
        } else if (n == 42) {
            if (--transform < 0) {
                transform = transformArr.length - 1;
            }
            this.repaint();
        } else if (n == -5) {
            if (this.imageList.size() != 0) {
                ++this.indexList;
                if (this.indexList > this.imageList.size() - 1) {
                    this.indexList = 0;
                }
                this.fileName = "" + this.imageList.elementAt(this.indexList);
                this.offsetX = 0;
                this.offsetY = 0;
                this.createImage();
            }
        } else if (n == -2) {
            if (this.imageList.size() != 0) {
                --this.indexList;
                if (this.indexList < 0) {
                    this.indexList = this.imageList.size() - 1;
                }
                this.fileName = "" + this.imageList.elementAt(this.indexList);
                this.offsetX = 0;
                this.offsetY = 0;
                this.createImage();
            }
        } else if (n == 53) {
            this.imageSize = 2;
            this.offsetX = 0;
            this.offsetY = 0;
            transform = 0;
            this.createImage();
        } else if (n == 52) {
            if (this.canMove) {
                this.offsetX -= 20;
                if (this.offsetX < -Math.abs(this.image.getWidth() - this.getWidth() + 1) / 2) {
                    this.offsetX = -Math.abs(this.image.getWidth() - this.getWidth() + 1) / 2;
                }
                this.repaint();
            }
        } else if (n == 54) {
            if (this.canMove) {
                this.offsetX += 20;
                if (this.offsetX > Math.abs(this.image.getWidth() - this.getWidth() + 1) / 2) {
                    this.offsetX = Math.abs(this.image.getWidth() - this.getWidth() + 1) / 2;
                }
                this.repaint();
            }
        } else if (n == 50) {
            if (this.canMove) {
                this.offsetY -= 20;
                if (this.offsetY < -Math.abs(this.image.getHeight() - this.getHeight() + 1) / 2) {
                    this.offsetY = -Math.abs(this.image.getHeight() - this.getHeight() + 1) / 2;
                }
                this.repaint();
            }
        } else if (n == 56) {
            if (this.canMove) {
                this.offsetY += 20;
                if (this.offsetY > Math.abs(this.image.getHeight() - this.getHeight() + 1) / 2) {
                    this.offsetY = Math.abs(this.image.getHeight() - this.getHeight() + 1) / 2;
                }
                this.repaint();
            }
        } else if (n == -1) {
            if (this.canMove && this.imageSize < imageWidths.length - 1) {
                this.offsetX = 0;
                this.offsetY = 0;
                ++this.imageSize;
                this.createImage();
            }
        } else if (n == -6 && this.canMove && this.imageSize != 0) {
            this.offsetX = 0;
            this.offsetY = 0;
            --this.imageSize;
            this.createImage();
        }
    }
}

