/*
 * Decompiled with CFR 0.152.
 */
package phoneman;

import com.motorola.io.FileConnection;
import com.motorola.io.FileSystemRegistry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;

public class FileSystemAccessor {
    private FileConnection connection;
    private String location;
    public static final int DIR_INFO = 0;
    public static final int RD_INFO = 1;
    public static final int NRD_INFO = 2;

    public FileSystemAccessor(String string) {
        this.location = string;
    }

    public long availableSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.availableSize();
            this.close();
        }
        return l;
    }

    public boolean canRead() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.canRead();
            this.close();
        }
        return bl;
    }

    public boolean canWrite() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.canWrite();
            this.close();
        }
        return bl;
    }

    private void close() {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (Exception exception) {
            System.out.println("Close connection failed: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public boolean create() {
        boolean bl = false;
        this.open(2);
        if (this.connection.exists()) {
            bl = true;
            System.out.println("file " + this.location + " already exists.");
        } else if (this.connection.create()) {
            System.out.println("file " + this.location + " is created.");
            bl = true;
        } else {
            System.out.println("Could not create the file");
        }
        this.close();
        return bl;
    }

    public boolean delete() {
        boolean bl = false;
        this.open(2);
        if (this.connection.exists()) {
            if (this.connection.delete()) {
                System.out.println("file " + this.location + " is deleted!");
                bl = true;
            } else {
                System.out.println("Could not delete file " + this.location);
            }
        } else {
            System.out.println("file does not exist anyway.");
            bl = true;
        }
        this.close();
        return bl;
    }

    public long directorySize(boolean bl) {
        long l = 0L;
        this.open();
        if (this.connection != null) {
            try {
                l = this.connection.directorySize(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
        }
        return l;
    }

    public boolean exists() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.exists();
            this.close();
        }
        return bl;
    }

    public long fileSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.fileSize();
            this.close();
        }
        return l;
    }

    public boolean isDirectory() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.isDirectory();
            this.close();
        }
        return bl;
    }

    public boolean isHidden() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.isHidden();
            this.close();
        }
        return bl;
    }

    public long lastModified() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.lastModified();
            this.close();
        }
        return l;
    }

    public String[] list() {
        String[] stringArray = new String[]{};
        this.open();
        if (this.connection != null) {
            stringArray = this.connection.list();
            this.close();
        }
        return stringArray;
    }

    public static String[] listRoots() {
        return FileSystemRegistry.listRoots();
    }

    private void open(int n) {
        try {
            String string = "file://" + this.location;
            this.connection = (FileConnection)Connector.open((String)string, (int)n);
        }
        catch (Exception exception) {
            System.out.println("Open connection  to '" + this.location + "' failed: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void open() {
        this.open(1);
    }

    public byte[] read() {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                this.open(1);
                long l = this.connection.fileSize();
                byArray = new byte[(int)l];
                DataInputStream dataInputStream = this.connection.openDataInputStream();
                if (dataInputStream != null) {
                    if (l != (long)dataInputStream.read(byArray)) {
                        byArray = null;
                    }
                    dataInputStream.close();
                    dataInputStream = null;
                    break block4;
                }
                byArray = null;
            }
            catch (Exception exception) {
                System.out.println("Could not read: " + exception.toString());
                byArray = null;
            }
        }
        return byArray;
    }

    public boolean rename(String string) {
        boolean bl = false;
        this.open(2);
        if (this.connection.rename("file://" + string)) {
            System.out.println("file is renamed to " + string);
            bl = true;
        } else {
            System.out.println("Could not rename file!");
        }
        this.close();
        return bl;
    }

    public boolean rewrite(byte[] byArray) {
        boolean bl = false;
        this.open(2);
        if (this.connection.exists()) {
            if (this.connection.delete()) {
                System.out.println("file is deleted successfully!");
            } else {
                System.out.println("file is NOT deleted!");
            }
        }
        System.out.print("creating file " + this.location + "... ");
        if (this.connection.create()) {
            System.out.println("created!");
        } else {
            System.out.println("could not create!");
        }
        if (this.connection.exists()) {
            System.out.println("saving data");
            try {
                DataOutputStream dataOutputStream = this.connection.openDataOutputStream();
                dataOutputStream.write(byArray, 0, byArray.length);
                dataOutputStream.flush();
                dataOutputStream.close();
                bl = true;
            }
            catch (Exception exception) {
                System.out.println("dos.write: " + exception.toString());
            }
        } else {
            System.out.println("file again does not exists, skip saving data.");
        }
        this.close();
        return bl;
    }

    public void setHidden(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setHidden(bl);
            this.close();
        }
    }

    public void setReadable(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setReadable(bl);
            this.close();
        }
    }

    public void setWriteable(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setWriteable(bl);
            this.close();
        }
    }

    public long totalSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.totalSize();
            this.close();
        }
        return l;
    }

    public long usedSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.usedSize();
            this.close();
        }
        return l;
    }
}

