/*
 * Decompiled with CFR 0.152.
 */
package fm;

import com.jenfa.AsciiTextFile;
import com.motorola.io.FileConnection;
import fm.Localization;
import fm.callback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class TreeUI
extends Canvas
implements CommandListener {
    char[] ascii = new char[]{' ', ' ', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0401', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0451', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f'};
    Image font;
    Image fold_sm;
    Localization lang = Localization.getInstance();
    boolean updated;
    static int SYMBOL_WIDTH = 6;
    static int SYMBOL_HEIGHT = 10;
    int s_line = 0;
    int line_y = 0;
    int p_line = 0;
    int im_y = 0;
    static int SKIP_LEN = 10;
    int line = 0;
    Image tree = null;
    int width = 0;
    int height = 0;
    boolean exiting = false;
    int i = 0;
    String root = "";
    String[] dirs_list = null;
    int[] dirs_skip = null;
    String[] dirs_tmp = null;
    int[] skip_tmp = null;
    int g_point = 0;
    Command exit = new Command(this.lang.getString("exit"), 8, 3);
    Command update = new Command(this.lang.getString("update"), 8, 2);
    FileConnection fc = null;
    Display disp;
    callback Callback = null;

    public TreeUI(Display d, callback c, String cur_root) {
        try {
            this.font = Image.createImage((String)"/graphics/font.png");
            this.fold_sm = Image.createImage((String)"/graphics/folder_sm.png");
        }
        catch (Exception e) {
            this.HandleError(e, "TreeUI Constructor");
        }
        this.setFullScreenMode(true);
        this.disp = d;
        this.Callback = c;
        this.root = cur_root;
        this.addCommand(this.exit);
        this.addCommand(this.update);
        this.setCommandListener(this);
        this.ReadTreeFromRMS();
        this.enterMainLoop();
    }

    void UpdateTree() {
        this.initVariables();
        this.updated = true;
        this.dirs_tmp[0] = String.valueOf(String.valueOf(new StringBuffer("/").append(this.lang.getString("change_drive")).append("/")));
        this.skip_tmp[0] = 0;
        this.dirs_tmp[1] = String.valueOf(String.valueOf(new StringBuffer("/").append(this.lang.getString("favourites")).append("/")));
        this.skip_tmp[1] = 0;
        this.g_point = 2;
        this.RenderTree(this.root, 0, true);
    }

    void initVariables() {
        this.tree = null;
        this.dirs_skip = null;
        this.dirs_tmp = null;
        this.skip_tmp = null;
        this.updated = false;
        this.dirs_list = new String[0];
        this.dirs_skip = new int[0];
        this.dirs_tmp = new String[1000];
        this.skip_tmp = new int[1000];
        this.s_line = 0;
        this.line_y = 0;
        this.p_line = 0;
        this.im_y = 0;
        this.line = 0;
        this.g_point = 0;
    }

    void ReadTreeFromRMS() {
        boolean read = true;
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)"tree".concat(String.valueOf(String.valueOf(this.root))), (boolean)false);
        }
        catch (Exception e) {
            if (e instanceof RecordStoreNotFoundException) {
                read = false;
                this.UpdateTree();
            }
            this.HandleError(e, "ReadTreeFromRMS");
        }
        if (read) {
            this.initVariables();
            try {
                ByteArrayInputStream bis = null;
                DataInputStream dis = null;
                RecordEnumeration re = rs.enumerateRecords(null, null, true);
                while (re.hasNextElement()) {
                    bis = new ByteArrayInputStream(re.nextRecord());
                    dis = new DataInputStream(bis);
                    this.dirs_tmp[this.g_point] = dis.readUTF();
                    this.skip_tmp[this.g_point] = dis.readInt();
                    ++this.g_point;
                    bis.close();
                    bis = null;
                    dis = null;
                }
            }
            catch (Exception e) {
                this.HandleError(e, "ReadTreeFromRMS");
            }
        }
    }

    void reverseDirsArrays() {
        String rs = null;
        int is = 0;
        this.i = 0;
        while (this.i < this.dirs_list.length / 2) {
            rs = this.dirs_list[this.i];
            is = this.dirs_skip[this.i];
            this.dirs_skip[this.i] = this.dirs_skip[this.dirs_list.length - 1 - this.i];
            this.dirs_skip[this.dirs_list.length - 1 - this.i] = is;
            this.dirs_list[this.i] = this.dirs_list[this.dirs_list.length - 1 - this.i];
            this.dirs_list[this.dirs_list.length - 1 - this.i] = rs;
            ++this.i;
        }
    }

    void WriteTreeToRMS() {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)"tree".concat(String.valueOf(String.valueOf(this.root))), (boolean)true);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                rs.deleteRecord(re.nextRecordId());
            }
            rs.closeRecordStore();
            rs = RecordStore.openRecordStore((String)"tree".concat(String.valueOf(String.valueOf(this.root))), (boolean)true);
            ByteArrayOutputStream bos = null;
            DataOutputStream dos = null;
            this.i = 0;
            while (this.i < this.dirs_list.length) {
                bos = new ByteArrayOutputStream();
                dos = new DataOutputStream(bos);
                dos.writeUTF(this.dirs_list[this.i]);
                dos.writeInt(this.dirs_skip[this.i]);
                byte[] a = bos.toByteArray();
                rs.addRecord(a, 0, a.length);
                ++this.i;
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            this.HandleError(e, "WriteTreeToRMS");
        }
    }

    void DrawTree() {
        this.tree = Image.createImage((int)256, (int)(this.dirs_list.length * SYMBOL_HEIGHT + this.dirs_list.length * 2));
        Graphics g = this.tree.getGraphics();
        this.i = 0;
        while (this.i < this.dirs_list.length) {
            g.drawImage(this.fold_sm, 0 + this.dirs_skip[this.i] * SKIP_LEN, this.i * SYMBOL_HEIGHT + this.i * 2, 0);
            g.drawImage(this.string2Image(this.getLastURLPart(this.dirs_list[this.i], true)), 10 + SKIP_LEN * this.dirs_skip[this.i], this.i * SYMBOL_HEIGHT + this.i * 2, 0);
            ++this.i;
        }
    }

    void RenderTree(String dir, int skip, boolean adddirasroot) {
        if (adddirasroot) {
            ++skip;
            this.dirs_tmp[this.g_point] = dir;
            this.skip_tmp[this.g_point] = 0;
            ++this.g_point;
        }
        String[] dirs = this.ListFolders(dir);
        for (int i = 1; i < dirs.length; ++i) {
            this.dirs_tmp[this.g_point] = dirs[i];
            this.skip_tmp[this.g_point] = skip;
            ++this.g_point;
            this.RenderTree(dirs[i], skip + 1, false);
        }
        dirs = null;
    }

    void enterMainLoop() {
        this.exiting = false;
        this.dirs_list = new String[this.g_point];
        this.dirs_skip = new int[this.g_point];
        System.arraycopy(this.skip_tmp, 0, this.dirs_skip, 0, this.g_point);
        System.arraycopy(this.dirs_tmp, 0, this.dirs_list, 0, this.g_point);
        this.skip_tmp = null;
        this.dirs_tmp = null;
        if (this.updated) {
            this.WriteTreeToRMS();
        }
        if (!this.updated) {
            this.reverseDirsArrays();
        }
        this.DrawTree();
        this.DrawSelectionLines(0, 0, this.tree.getGraphics());
        this.disp.setCurrent((Displayable)this);
        this.MainLoop();
    }

    void MainLoop() {
        this.repaint();
    }

    public void HandleError(Exception what, String where) {
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        ErrorOut.addCommand(this.exit);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void HandleError2(Error what, String where) {
        Alert ErrorOut = new Alert("Error occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        ErrorOut.addCommand(this.exit);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER ERROR]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public String getFirstURLPart(String URL2) {
        int idx = 0;
        idx = URL2.indexOf("/");
        if (idx != -1) {
            URL2 = URL2.substring(0, idx);
        }
        return URL2;
    }

    public String getLastURLPart(String URL2, boolean hasFinalSlash) {
        boolean idx1 = false;
        int idxf = -1;
        int pidxf = -1;
        idxf = URL2.lastIndexOf(47);
        if (hasFinalSlash) {
            if (idxf != -1) {
                pidxf = URL2.lastIndexOf(47, idxf - 1);
            }
            URL2 = URL2.substring(pidxf + 1, idxf);
        } else {
            URL2 = URL2.substring(idxf + 1);
        }
        return URL2;
    }

    String[] ListFolders(String dir) {
        int point = 0;
        String[] res = new String[1000];
        res[0] = "";
        try {
            this.fc = null;
            this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(dir))));
            String[] files = this.fc.list();
            this.fc.close();
            this.i = 0;
            while (this.i < files.length) {
                this.fc = null;
                this.fc = (FileConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("file://").append(this.root).append(files[this.i]))));
                if (this.fc.isDirectory()) {
                    res[++point] = files[this.i];
                }
                this.fc.close();
                ++this.i;
            }
            files = null;
            String curfn = "";
            boolean addtolist = false;
            AsciiTextFile atf = new AsciiTextFile();
            atf.openFile("/hiddendirs.lst");
            while (!atf.eof()) {
                curfn = atf.readLine();
                if (!curfn.startsWith(dir)) continue;
                curfn = curfn.substring(dir.length());
                curfn = this.getFirstURLPart(curfn);
                curfn = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(dir))).append(curfn).append("/")));
                addtolist = this.isExists(curfn, true);
                if (dir == curfn) {
                    addtolist = false;
                }
                this.i = 1;
                while (this.i <= point && addtolist) {
                    if (curfn.compareTo(res[this.i]) == 0) {
                        addtolist = false;
                        break;
                    }
                    ++this.i;
                }
                if (!addtolist) continue;
                res[++point] = curfn;
            }
            atf.close();
            atf = null;
        }
        catch (Exception e) {
            this.HandleError(e, "ListFolders");
        }
        String[] res2 = new String[point + 1];
        System.arraycopy(res, 0, res2, 0, point + 1);
        res = null;
        return res2;
    }

    boolean isExists(String fname, boolean isDir) {
        boolean a = false;
        try {
            this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(fname))));
            a = this.fc.exists();
            this.fc.close();
        }
        catch (Exception e) {
            this.HandleError(e, "isExists");
        }
        return a;
    }

    Image string2Image(String s) {
        int width = s.length() * SYMBOL_WIDTH;
        int height = SYMBOL_HEIGHT;
        Image res = Image.createImage((int)width, (int)height);
        Image tmp = Image.createImage((int)SYMBOL_WIDTH, (int)SYMBOL_HEIGHT);
        Graphics g = res.getGraphics();
        Graphics g2 = tmp.getGraphics();
        for (int i = 0; i < s.length(); ++i) {
            int code = this.ascii_ord(s.charAt(i));
            int xpos = code - 1;
            xpos = SYMBOL_WIDTH * xpos;
            xpos = -1 * xpos;
            g2.setColor(255, 255, 255);
            g2.fillRect(0, 0, tmp.getWidth(), tmp.getHeight());
            g2.drawImage(this.font, xpos, 0, 0);
            xpos = i * SYMBOL_WIDTH;
            g.drawImage(tmp, xpos, 0, 0);
        }
        return res;
    }

    int ascii_ord(char ch) {
        for (int i = 1; i < this.ascii.length; ++i) {
            if (ch != this.ascii[i]) continue;
            return i;
        }
        return 1;
    }

    public void paint(Graphics g) {
        g.drawImage(this.tree, 0, -1 * this.im_y, 0);
    }

    public void DrawSelectionLines(int s_line, int p_line, Graphics g) {
        g.setColor(255, 255, 255);
        int p_line_y1 = p_line * SYMBOL_HEIGHT + 2 * p_line - 1;
        if (p_line_y1 < 0) {
            p_line_y1 = 0;
        }
        g.drawLine(0, p_line_y1, this.getWidth(), p_line_y1);
        g.drawLine(0, (p_line + 1) * SYMBOL_HEIGHT + 2 * (p_line + 1) - 2, this.getWidth(), (p_line + 1) * SYMBOL_HEIGHT + 2 * (p_line + 1) - 2);
        g.setColor(0, 0, 255);
        g.drawLine(0, this.line_y, this.getWidth(), this.line_y);
        g.drawLine(0, (s_line + 1) * SYMBOL_HEIGHT + 2 * (s_line + 1) - 2, this.getWidth(), (s_line + 1) * SYMBOL_HEIGHT + 2 * (s_line + 1) - 2);
    }

    public void freeMem() {
        this.ascii = null;
        this.font = null;
        this.fold_sm = null;
        this.tree = null;
        this.dirs_skip = null;
        this.dirs_tmp = null;
        this.skip_tmp = null;
        this.fc = null;
        this.disp = null;
        System.gc();
    }

    public void keyPressed(int keycode) {
        if (1 == this.getGameAction(keycode)) {
            this.p_line = this.s_line--;
            if (this.s_line < 0) {
                this.s_line = 0;
            }
            this.line_y = this.s_line * SYMBOL_HEIGHT + 2 * this.s_line - 1;
            if (this.line_y < 0) {
                this.line_y = 0;
            }
            if (this.im_y > this.line_y) {
                this.im_y = this.line_y;
            }
            this.DrawSelectionLines(this.s_line, this.p_line, this.tree.getGraphics());
            this.repaint();
        }
        if (6 == this.getGameAction(keycode)) {
            this.p_line = this.s_line++;
            if (this.s_line > this.dirs_list.length - 1) {
                this.s_line = this.dirs_list.length - 1;
            }
            this.line_y = this.s_line * SYMBOL_HEIGHT + 2 * this.s_line - 1;
            if (this.line_y < 0) {
                this.line_y = 0;
            }
            if (this.im_y + this.getHeight() < (this.s_line + 1) * SYMBOL_HEIGHT + 2 * (this.s_line + 1)) {
                this.im_y = (this.s_line + 1) * SYMBOL_HEIGHT + 2 * (this.s_line + 1) - this.getHeight();
            }
            this.DrawSelectionLines(this.s_line, this.p_line, this.tree.getGraphics());
            this.repaint();
        }
        if (keycode == 51) {
            this.p_line = this.s_line;
            this.s_line = 0;
            this.line_y = 0;
            if (this.im_y > this.line_y) {
                this.im_y = this.line_y;
            }
            this.DrawSelectionLines(this.s_line, this.p_line, this.tree.getGraphics());
            this.repaint();
        }
        if (this.getGameAction(keycode) == 8 && keycode != 53) {
            this.freeMem();
            if (this.s_line != 0 && this.s_line != 1) {
                this.Callback.tree_ui_callback(this.dirs_list[this.s_line], (Object)this, false, false);
            }
            if (this.s_line == 0) {
                this.Callback.tree_ui_callback("", (Object)this, true, false);
            }
            if (this.s_line == 1) {
                this.Callback.tree_ui_callback("", (Object)this, false, true);
            }
        }
        if (keycode == 57) {
            this.p_line = this.s_line;
            this.s_line = this.dirs_list.length - 1;
            this.line_y = this.s_line * SYMBOL_HEIGHT + 2 * this.s_line - 1;
            if (this.line_y < 0) {
                this.line_y = 0;
            }
            if (this.im_y + this.getHeight() < (this.s_line + 1) * SYMBOL_HEIGHT + 2 * (this.s_line + 1)) {
                this.im_y = (this.s_line + 1) * SYMBOL_HEIGHT + 2 * (this.s_line + 1) - this.getHeight();
            }
            this.DrawSelectionLines(this.s_line, this.p_line, this.tree.getGraphics());
            this.repaint();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.update) {
            this.UpdateTree();
            this.enterMainLoop();
        }
        if (c == this.exit) {
            this.Callback.tree_ui_callback("", (Object)this, false, false);
        }
    }
}

