/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.DimensionsCollector;
import fm.Localization;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class SettingsHandler
implements CommandListener {
    Displayable cb = null;
    ChoiceGroup cg;
    ChoiceGroup resolution;
    ChoiceGroup rot;
    ChoiceGroup sort;
    ChoiceGroup lng;
    TextField s_dir;
    TextField tf_seek_step;
    TextField tf_volume_step;
    boolean showtree = false;
    boolean useInputStreamInAudio = false;
    boolean scrollImages = true;
    boolean scrollAudio = true;
    boolean show_hidden_files = true;
    boolean show_hidden_dirs = true;
    boolean ap_shuffle = false;
    boolean ap_auto_next = false;
    boolean jpg_preview = false;
    boolean icons = true;
    boolean show_drive_dialog = true;
    byte im_rotate = 0;
    byte im_width = 0;
    byte im_height = 0;
    byte volume = (byte)50;
    byte sort_files = 0;
    byte seek_step = (byte)5;
    byte volume_step = (byte)4;
    byte lang_id = 0;
    Localization lang = Localization.getInstance();
    String start_dir = "mobile/";
    Command exit = new Command(this.lang.getString("exit"), 8, 3);
    Command ok = new Command(this.lang.getString("ok"), 4, 1);
    Command cancel = new Command(this.lang.getString("cancel"), 3, 1);
    Display disp;

    public SettingsHandler(Display d) {
        this.disp = d;
    }

    public void LoadSettings() {
        block3: {
            this.showtree = false;
            this.useInputStreamInAudio = false;
            try {
                RecordStore rs = RecordStore.openRecordStore((String)"fm_settings", (boolean)true);
                RecordEnumeration re = rs.enumerateRecords(null, null, false);
                if (re.hasNextElement()) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(re.nextRecord());
                    DataInputStream dis = new DataInputStream(bis);
                    this.showtree = dis.readBoolean();
                    this.useInputStreamInAudio = dis.readBoolean();
                    this.scrollImages = dis.readBoolean();
                    this.scrollAudio = dis.readBoolean();
                    this.jpg_preview = dis.readBoolean();
                    this.im_width = dis.readByte();
                    this.im_height = dis.readByte();
                    this.volume = dis.readByte();
                    this.im_rotate = dis.readByte();
                    this.show_hidden_dirs = dis.readBoolean();
                    this.sort_files = dis.readByte();
                    this.start_dir = dis.readUTF();
                    this.seek_step = dis.readByte();
                    this.volume_step = dis.readByte();
                    this.icons = dis.readBoolean();
                    this.show_hidden_files = dis.readBoolean();
                    this.ap_shuffle = dis.readBoolean();
                    this.ap_auto_next = dis.readBoolean();
                    this.show_drive_dialog = dis.readBoolean();
                    this.lang_id = dis.readByte();
                }
                rs.closeRecordStore();
            }
            catch (Exception e) {
                if (e instanceof EOFException) break block3;
                this.HandleError(e, "LoadSettings");
            }
        }
    }

    public void SaveSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"fm_settings", (boolean)true);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                rs.deleteRecord(re.nextRecordId());
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeBoolean(this.showtree);
            dos.writeBoolean(this.useInputStreamInAudio);
            dos.writeBoolean(this.scrollImages);
            dos.writeBoolean(this.scrollAudio);
            dos.writeBoolean(this.jpg_preview);
            dos.writeByte(this.im_width);
            dos.writeByte(this.im_height);
            dos.writeByte(this.volume);
            dos.writeByte(this.im_rotate);
            dos.writeBoolean(this.show_hidden_dirs);
            dos.writeByte(this.sort_files);
            dos.writeUTF(this.start_dir);
            dos.writeByte(this.seek_step);
            dos.writeByte(this.volume_step);
            dos.writeBoolean(this.icons);
            dos.writeBoolean(this.show_hidden_files);
            dos.writeBoolean(this.ap_shuffle);
            dos.writeBoolean(this.ap_auto_next);
            dos.writeBoolean(this.show_drive_dialog);
            dos.writeByte(this.lang_id);
            byte[] a = bos.toByteArray();
            rs.addRecord(a, 0, a.length);
            a = null;
            bos.close();
            dos = null;
            bos = null;
            rs.closeRecordStore();
            rs = null;
        }
        catch (Exception e) {
            this.HandleError(e, "SaveSettings");
        }
    }

    void HandleError(Exception what, String where) {
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        ErrorOut.addCommand(this.exit);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void ChangeSettings(Displayable callback2) {
        this.cb = callback2;
        Form form = new Form(this.lang.getString("settings"));
        this.cg = new ChoiceGroup("", 2);
        this.cg.append(this.lang.getString("setting_show_tree_start"), null);
        this.cg.append(this.lang.getString("setting_use_inputstream_in_player"), null);
        this.cg.append(this.lang.getString("setting_scroll_images_in_viewer"), null);
        this.cg.append(this.lang.getString("setting_scroll_audio_in_player"), null);
        this.cg.append(this.lang.getString("setting_jpg_preview"), null);
        this.cg.append(this.lang.getString("setting_show_hidden_dirs"), null);
        this.cg.append(this.lang.getString("setting_filelist_icons"), null);
        this.cg.append(this.lang.getString("setting_show_hidden_files"), null);
        this.cg.append(this.lang.getString("setting_show_drive_select_start"), null);
        this.cg.setSelectedIndex(0, this.showtree);
        this.cg.setSelectedIndex(1, this.useInputStreamInAudio);
        this.cg.setSelectedIndex(2, this.scrollImages);
        this.cg.setSelectedIndex(3, this.scrollAudio);
        this.cg.setSelectedIndex(4, this.jpg_preview);
        this.cg.setSelectedIndex(5, this.show_hidden_dirs);
        this.cg.setSelectedIndex(6, this.icons);
        this.cg.setSelectedIndex(7, this.show_hidden_files);
        this.cg.setSelectedIndex(8, this.show_drive_dialog);
        this.sort = new ChoiceGroup(this.lang.getString("setting_sort_type"), 1);
        this.sort.append(this.lang.getString("setting_sort_no"), null);
        this.sort.append(this.lang.getString("setting_sort_name_up"), null);
        this.sort.append(this.lang.getString("setting_sort_name_down"), null);
        this.sort.append(this.lang.getString("setting_sort_date_up"), null);
        this.sort.append(this.lang.getString("setting_sort_date_down"), null);
        this.sort.append(this.lang.getString("setting_sort_name_2chars_up"), null);
        this.sort.append(this.lang.getString("setting_sort_name_2chars_down"), null);
        this.sort.setSelectedIndex((int)this.sort_files, true);
        this.resolution = new ChoiceGroup(this.lang.getString("setting_starting_res_in_viewer"), 1);
        DimensionsCollector dc = new DimensionsCollector();
        if (dc.getWidth() != 128) {
            this.resolution.append("176x235 (235x176)", null);
            this.resolution.append("272x204 (204x272)", null);
            this.resolution.append("320x240 (240x320)", null);
        } else {
            this.resolution.append("128x96 (96x128)", null);
            this.resolution.append("160x120 (120x160)", null);
            this.resolution.append("320x240 (240x320)", null);
        }
        this.resolution.setSelectedIndex((int)this.im_width, true);
        this.rot = new ChoiceGroup(this.lang.getString("setting_starting_rotate_in_viewer"), 1);
        this.rot.append("0 ".concat(String.valueOf(String.valueOf(this.lang.getString("degrees")))), null);
        this.rot.append("90 ".concat(String.valueOf(String.valueOf(this.lang.getString("degrees")))), null);
        this.rot.append("270 ".concat(String.valueOf(String.valueOf(this.lang.getString("degrees")))), null);
        this.rot.setSelectedIndex((int)this.im_rotate, true);
        this.s_dir = new TextField(this.lang.getString("setting_start_folder"), this.start_dir, 255, 0);
        this.tf_seek_step = new TextField(this.lang.getString("setting_seek_step"), String.valueOf(this.seek_step), 255, 2);
        this.tf_volume_step = new TextField(this.lang.getString("setting_volume_step"), String.valueOf(this.volume_step), 255, 2);
        this.lng = new ChoiceGroup(this.lang.getString("setting_language"), 1);
        this.lng.append(this.lang.getString("setting_lang_eng"), null);
        this.lng.append(this.lang.getString("setting_lang_rus"), null);
        this.lng.setSelectedIndex((int)this.lang_id, true);
        form.append((Item)this.cg);
        form.append((Item)this.sort);
        form.append((Item)this.resolution);
        form.append((Item)this.rot);
        form.append((Item)this.s_dir);
        form.append((Item)this.tf_seek_step);
        form.append((Item)this.tf_volume_step);
        form.append((Item)this.lng);
        form.addCommand(this.ok);
        form.addCommand(this.cancel);
        form.setCommandListener((CommandListener)this);
        this.disp.setCurrent((Displayable)form);
    }

    public void Callback() {
        this.cg = null;
        this.disp.setCurrent(this.cb);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.ok) {
            this.showtree = this.cg.isSelected(0);
            this.useInputStreamInAudio = this.cg.isSelected(1);
            this.scrollImages = this.cg.isSelected(2);
            this.scrollAudio = this.cg.isSelected(3);
            this.jpg_preview = this.cg.isSelected(4);
            this.show_hidden_dirs = this.cg.isSelected(5);
            this.icons = this.cg.isSelected(6);
            this.show_hidden_files = this.cg.isSelected(7);
            this.show_drive_dialog = this.cg.isSelected(8);
            this.sort_files = (byte)this.sort.getSelectedIndex();
            this.im_width = (byte)this.resolution.getSelectedIndex();
            this.im_height = (byte)this.resolution.getSelectedIndex();
            this.im_rotate = (byte)this.rot.getSelectedIndex();
            this.start_dir = this.s_dir.getString();
            this.seek_step = Byte.parseByte(this.tf_seek_step.getString());
            this.volume_step = Byte.parseByte(this.tf_volume_step.getString());
            this.lang_id = (byte)this.lng.getSelectedIndex();
            this.SaveSettings();
            this.Callback();
        }
        if (c == this.cancel) {
            this.Callback();
        }
    }
}

