/*
 * Decompiled with CFR 0.152.
 */
package fm;

import com.motorola.extensions.ScalableJPGImage;
import com.motorola.io.FileConnection;
import fm.SettingsHandler;
import fm.callback;
import fm.exec;
import java.io.DataInputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class ImageViewerUI
extends Canvas {
    int[] p_width = new int[3];
    int[] p_height = new int[3];
    int[] widths_176204 = new int[]{176, 235, 320};
    int[] heights_176204 = new int[]{220, 176, 240};
    int[] widths_128128 = new int[]{128, 160, 320};
    int[] heights_128128 = new int[]{96, 120, 240};
    int cur_w = 0;
    int cur_h = 0;
    int curposx = 0;
    int curposy = 0;
    byte rotate = 0;
    int width = 0;
    int height = 0;
    Sprite rotator = null;
    ScalableJPGImage sjpgimage = null;
    byte[] img_store;
    boolean image_loaded = false;
    Display disp;
    String[] piclist;
    int[] real_idxs;
    callback Callback;
    int index;

    public ImageViewerUI(Display d, exec prev, String[] filelist, int[] ridxs, int idx) {
        this.disp = d;
        this.Callback = prev;
        this.piclist = filelist;
        this.setFullScreenMode(true);
        this.index = idx;
        SettingsHandler sh = new SettingsHandler(this.disp);
        sh.LoadSettings();
        this.cur_w = sh.im_width;
        this.cur_h = sh.im_height;
        this.rotate = sh.im_rotate;
        sh = null;
        this.real_idxs = ridxs;
    }

    protected void paint(Graphics g) {
        try {
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.image_loaded) {
                this.rotator.setPosition(this.curposx, this.curposy);
                this.rotator.paint(g);
            }
        }
        catch (Exception e) {
            this.HandleError(e, "ImageViewerUI.paint");
        }
    }

    void placeImageToCenter() {
        this.curposx = -1 * this.width / 2;
        this.curposx += this.getWidth() / 2;
        this.curposy = -1 * this.height / 2;
        this.curposy += this.getHeight() / 2;
    }

    public void setImage(byte[] data) {
        try {
            try {
                this.curposx = 0;
                this.curposy = 0;
                this.width = 0;
                this.height = 0;
                if (this.getWidth() == 128) {
                    System.arraycopy(this.widths_128128, 0, this.p_width, 0, 3);
                    System.arraycopy(this.heights_128128, 0, this.p_height, 0, 3);
                } else {
                    System.arraycopy(this.widths_176204, 0, this.p_width, 0, 3);
                    System.arraycopy(this.heights_176204, 0, this.p_height, 0, 3);
                }
                this.sjpgimage = ScalableJPGImage.createImage((byte[])data, (int)0, (int)data.length, (int)this.p_width[this.cur_w], (int)this.p_height[this.cur_h]);
                this.width = this.sjpgimage.getImage().getWidth();
                this.height = this.sjpgimage.getImage().getHeight();
                this.rotator = new Sprite(this.sjpgimage.getImage());
                this.placeImageToCenter();
                this.sjpgimage = null;
                this.image_loaded = true;
                this.img_store = data;
                data = new byte[]{};
                if (this.rotate == 0) {
                    this.execRotate(false);
                } else {
                    this.execRotate(true);
                }
                System.gc();
            }
            catch (Error e) {
                this.HandleError2(e, "ImageViewerUI.setImage");
            }
        }
        catch (Exception e) {
            this.HandleError(e, "ImageViewerUI.setImage");
        }
    }

    void resampleImage() {
        try {
            this.curposx = 0;
            this.curposy = 0;
            this.sjpgimage = ScalableJPGImage.createImage((byte[])this.img_store, (int)0, (int)this.img_store.length, (int)this.p_width[this.cur_w], (int)this.p_height[this.cur_h]);
            this.width = this.sjpgimage.getImage().getWidth();
            this.height = this.sjpgimage.getImage().getHeight();
            this.rotator = new Sprite(this.sjpgimage.getImage());
            this.sjpgimage = null;
            if (this.rotate == 0) {
                this.execRotate(false);
            } else {
                this.execRotate(true);
            }
            this.placeImageToCenter();
            this.repaint();
            System.gc();
        }
        catch (Error e) {
            this.HandleError2(e, String.valueOf(String.valueOf(new StringBuffer("ImageViewerUI.resampleImage : desired dimensions: ").append(String.valueOf(this.p_width[this.cur_w])).append("x").append(String.valueOf(this.p_height[this.cur_h])))));
        }
    }

    public void HandleError(Exception what, String where) {
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void HandleError2(Error what, String where) {
        Alert ErrorOut = new Alert("Error occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER ERROR]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    protected void freeMem() {
        this.p_width = null;
        this.p_height = null;
        this.sjpgimage = null;
        this.img_store = null;
        this.disp = null;
        System.gc();
    }

    public byte[] readFileFully(String filename) {
        byte[] a = new byte[]{};
        try {
            FileConnection fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(filename))));
            int size = (int)fc.fileSize();
            a = new byte[size];
            DataInputStream dis = fc.openDataInputStream();
            dis.readFully(a, 0, size);
            dis.close();
            fc.close();
        }
        catch (Exception e) {
            this.HandleError(e, "ImageViewerUI.readFileFully");
        }
        return a;
    }

    public void execRotate(boolean toggleDimensions) {
        try {
            try {
                if (this.rotate == 2) {
                    this.rotator.setTransform(6);
                }
                if (this.rotate == 1) {
                    this.rotator.setTransform(5);
                }
                if (this.rotate == 0) {
                    this.rotator.setTransform(0);
                }
                if (toggleDimensions) {
                    int r = this.height;
                    this.height = this.width;
                    this.width = r;
                }
            }
            catch (Error e) {
                this.HandleError2(e, "ImageViewerUI.execRotate");
            }
        }
        catch (Exception e) {
            this.HandleError(e, "ImageViewerUI.execRotate");
        }
        this.placeImageToCenter();
    }

    void unload() {
        this.freeMem();
    }

    protected void keyPressed(int keycode) {
        if (keycode == 42) {
            if (this.rotate == 2) {
                this.rotate = 1;
                this.execRotate(false);
            } else {
                this.rotate = (byte)(this.rotate - 1);
                if (this.rotate < 0) {
                    this.rotate = (byte)2;
                }
                this.execRotate(true);
            }
            this.repaint();
        }
        if (keycode == 35) {
            if (this.rotate == 1) {
                this.rotate = (byte)2;
                this.execRotate(false);
            } else {
                this.rotate = (byte)(this.rotate + 1);
                if (this.rotate > 2) {
                    this.rotate = 0;
                }
                this.execRotate(true);
            }
            this.repaint();
        }
        if (keycode == 51) {
            ++this.cur_w;
            ++this.cur_h;
            if (this.cur_w > 2) {
                this.cur_w = 2;
            }
            if (this.cur_h > 2) {
                this.cur_h = 2;
            }
            this.resampleImage();
        }
        if (keycode == 57) {
            --this.cur_w;
            --this.cur_h;
            if (this.cur_w < 0) {
                this.cur_w = 0;
            }
            if (this.cur_h < 0) {
                this.cur_h = 0;
            }
            this.resampleImage();
        }
        if (keycode == 52) {
            this.curposx += 30;
            if (this.curposx >= 0) {
                this.curposx = 0;
            }
            this.repaint();
        }
        if (keycode == 54) {
            this.curposx -= 30;
            if (this.curposx < -1 * (this.width - this.getWidth())) {
                this.curposx = -1 * (this.width - this.getWidth());
                if (this.curposx > 0) {
                    this.curposx = 0;
                }
            }
            this.repaint();
        }
        if (keycode == 50) {
            this.curposy += 30;
            if (this.curposy >= 0) {
                this.curposy = 0;
            }
            this.repaint();
        }
        if (keycode == 56) {
            this.curposy -= 30;
            if (this.curposy < -1 * (this.height - this.getHeight())) {
                this.curposy = -1 * (this.height - this.getHeight());
                if (this.curposy > 0) {
                    this.curposy = 0;
                }
            }
            this.repaint();
        }
        if (this.getGameAction(keycode) == 1 && keycode != 50) {
            --this.index;
            if (this.index < 0) {
                this.index = this.piclist.length - 1;
            }
            this.setImage(this.readFileFully(this.piclist[this.index]));
            this.repaint();
        }
        if (this.getGameAction(keycode) == 6 && keycode != 56) {
            ++this.index;
            if (this.index > this.piclist.length - 1) {
                this.index = 0;
            }
            this.setImage(this.readFileFully(this.piclist[this.index]));
            this.repaint();
        }
        if (keycode == -21 || keycode == 21) {
            this.unload();
            this.Callback.viewer_callback(true, this.real_idxs[this.index], (Object)this);
        }
    }

    protected void keyRepeated(int keycode) {
        if (keycode == 52) {
            this.curposx += 30;
            this.repaint();
        }
        if (keycode == 54) {
            this.curposx -= 30;
            this.repaint();
        }
        if (keycode == 50) {
            this.curposy += 30;
            this.repaint();
        }
        if (keycode == 56) {
            this.curposy -= 30;
            this.repaint();
        }
    }
}

