/*
 * Decompiled with CFR 0.152.
 */
package fm;

import com.jenfa.AsciiTextFile;
import com.jenfa.UTFTextFile;
import fm.Localization;
import fm.callback;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

public class FileViewerUI
implements CommandListener {
    callback Callback;
    Display disp;
    String filename = null;
    Localization lang = Localization.getInstance();
    int viewType = 0;
    public static int VIEW_ASCII = 1;
    public static int VIEW_HEX = 2;
    public static int VIEW_UTF = 3;
    Command close = new Command(this.lang.getString("close"), 7, 1);
    Command empty = new Command("", 8, 1);
    Command show_as_ascii = new Command(this.lang.getString("as_ascii"), 8, 1);
    Command show_as_hex = new Command(this.lang.getString("as_hex"), 8, 1);
    Command show_as_utf = new Command(this.lang.getString("as_utf"), 8, 1);

    public FileViewerUI(Display d, callback prev) {
        this.disp = d;
        this.Callback = prev;
    }

    public void setFile(String fname, int initialViewType) {
        if (initialViewType == VIEW_ASCII) {
            this.filename = fname;
            this.setViewType(VIEW_ASCII);
        }
    }

    public void setViewType(int to) {
        this.viewType = to;
    }

    public void HandleError(Exception what, String where) {
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void HandleError2(Error what, String where) {
        Alert ErrorOut = new Alert("Error occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER ERROR]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void viewFile() throws Exception {
        Form out = new Form(this.filename.substring(7));
        try {
            if (this.viewType == VIEW_ASCII) {
                String ll = "";
                AsciiTextFile atf = new AsciiTextFile();
                atf.openFile(this.filename);
                while (!atf.eof()) {
                    ll = String.valueOf(String.valueOf(ll)).concat(String.valueOf(String.valueOf(atf.readLine())));
                    ll = String.valueOf(String.valueOf(ll)).concat("\n");
                }
                out.append(ll);
                atf.close();
                atf = null;
            }
            if (this.viewType == VIEW_UTF) {
                UTFTextFile utf = new UTFTextFile();
                utf.openFile(this.filename);
                while (!utf.eof()) {
                    out.append(String.valueOf(String.valueOf(utf.readLine())).concat("\n"));
                }
                utf.close();
                utf = null;
            }
        }
        catch (Exception e) {
            Exception e2 = new Exception(String.valueOf(String.valueOf(e.toString())).concat(" at FileViewerUI.viewFile"));
            throw e2;
        }
        out.addCommand(this.empty);
        out.addCommand(this.close);
        out.addCommand(this.show_as_ascii);
        out.addCommand(this.show_as_hex);
        out.addCommand(this.show_as_utf);
        out.setCommandListener((CommandListener)this);
        this.disp.setCurrent((Displayable)out);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.close) {
            System.gc();
            this.Callback.callback(false, this);
        }
        if (c == this.show_as_ascii) {
            this.setViewType(VIEW_ASCII);
            try {
                this.viewFile();
            }
            catch (Exception e) {
                this.HandleError(e, "");
            }
        }
        if (c == this.show_as_utf) {
            this.setViewType(VIEW_UTF);
            try {
                this.viewFile();
            }
            catch (Exception e) {
                this.HandleError(e, "");
            }
        }
    }
}

