/*
 * Decompiled with CFR 0.152.
 */
package fm;

import com.motorola.io.FileConnection;
import fm.AudioPlayerRepaintControl;
import fm.Localization;
import fm.SettingsHandler;
import fm.callback;
import fm.exec;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.PitchControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.VolumeControl;

public class AudioPlayerUI
extends Canvas
implements PlayerListener,
CommandListener,
Runnable {
    Display disp;
    callback Callback;
    Player pl = null;
    boolean loaded = false;
    VolumeControl vc = null;
    PitchControl pc = null;
    RateControl rc = null;
    byte seek_step = 0;
    byte volume_step = 0;
    Random rnd;
    int volume = 0;
    Localization lang = Localization.getInstance();
    Command exit2 = new Command(this.lang.getString("exit"), 8, 3);
    int timeout = 0;
    boolean show_info = true;
    boolean s_override_info = false;
    String info = "";
    String override_info = "";
    String filename;
    String filepath;
    boolean auto_scroll = false;
    boolean backlight = true;
    boolean random_scroll = false;
    boolean keyboard_locked = false;
    String total;
    String played;
    String[] audlist;
    int[] real_idxs;
    int index;
    SettingsHandler Sh;
    AudioPlayerRepaintControl aprc = new AudioPlayerRepaintControl(this);
    Command exit = new Command(this.lang.getString("close"), 7, 1);
    Font song_title = Font.getFont((int)0, (int)0, (int)8);

    public AudioPlayerUI(Display d, exec prev, String[] filelist, int[] ridxs, int idx, SettingsHandler sh) {
        this.disp = d;
        this.Sh = sh;
        this.disp.flashBacklight(Integer.MAX_VALUE);
        this.Callback = prev;
        this.audlist = filelist;
        this.real_idxs = ridxs;
        this.index = idx;
        this.addCommand(this.exit);
        this.setCommandListener(this);
        this.volume = sh.volume;
        this.seek_step = sh.seek_step;
        this.volume_step = sh.volume_step;
        this.auto_scroll = sh.ap_auto_next;
        this.random_scroll = sh.ap_shuffle;
        this.rnd = new Random(System.currentTimeMillis());
    }

    public void run() {
        if (this.s_override_info) {
            ++this.timeout;
            if (this.timeout == 3) {
                this.s_override_info = false;
                this.timeout = 0;
            }
        }
        this.repaint();
    }

    public void HandleError(Exception what, String where) {
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        ErrorOut.addCommand(this.exit2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void freeMem() {
        this.pl = null;
        this.song_title = null;
        this.vc = null;
        this.disp = null;
        System.gc();
    }

    protected void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(255, 255, 255);
        g.setFont(this.song_title);
        g.drawString(this.filename, 1, 1, 0);
        if (this.pl.getState() == 200) {
            g.drawString("00:00/".concat(String.valueOf(String.valueOf(this.millisecs2time(this.pl.getDuration())))), 1, this.song_title.getHeight() + 2, 0);
        }
        if (this.pl.getState() == 300) {
            g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.millisecs2time(this.pl.getMediaTime())))).append("/").append(this.millisecs2time(this.pl.getDuration())))), 1, this.song_title.getHeight() + 2, 0);
        }
        if (this.pl.getState() == 400) {
            g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.millisecs2time(this.pl.getMediaTime())))).append("/").append(this.millisecs2time(this.pl.getDuration())))), 1, this.song_title.getHeight() + 2, 0);
        }
        if (this.show_info && !this.s_override_info) {
            g.drawString(this.info, 1, this.song_title.getHeight() * 2 + 4, 0);
        }
        if (this.s_override_info) {
            g.drawString(this.override_info, 1, this.song_title.getHeight() * 2 + 4, 0);
        }
    }

    protected void keyPressed(int keycode) {
        try {
            if (!this.keyboard_locked) {
                long newt;
                long dur;
                if (this.getGameAction(keycode) == 1 && keycode != 50) {
                    boolean handled = false;
                    if (this.pl.getState() == 300) {
                        this.pl.start();
                        handled = true;
                    }
                    if (this.pl.getState() == 400 && !handled) {
                        this.pl.stop();
                        handled = true;
                    }
                    if (this.pl.getState() == 200 && !handled) {
                        this.pl.prefetch();
                        this.pl.start();
                        handled = true;
                    }
                }
                if (this.getGameAction(keycode) == 6 && keycode != 56) {
                    if (this.pl.getState() == 300) {
                        this.pl.setMediaTime(0L);
                    }
                    if (this.pl.getState() == 400) {
                        this.pl.stop();
                        this.pl.setMediaTime(0L);
                    }
                }
                if (keycode == 52) {
                    long cur = this.pl.getMediaTime();
                    newt = cur - (dur = this.pl.getDuration()) / (long)(100 / this.seek_step);
                    if (newt < (long)0) {
                        newt = 0L;
                    }
                    this.pl.setMediaTime(newt);
                    this.overrideInfo("\u041f\u0435\u0440\u0435\u043c\u043e\u0442\u043a\u0430");
                }
                if (keycode == 54) {
                    long cur = this.pl.getMediaTime();
                    newt = cur + (dur = this.pl.getDuration()) / (long)(100 / this.seek_step);
                    if (newt >= dur) {
                        newt = 0L;
                    }
                    this.pl.setMediaTime(newt);
                    this.overrideInfo(this.lang.getString("seeking"));
                }
                if (this.getGameAction(keycode) == 2 && keycode != 52) {
                    if (!this.random_scroll) {
                        --this.index;
                    } else {
                        int rnd_znac = this.rnd.nextInt();
                        if (rnd_znac < 0) {
                            rnd_znac = -1 * rnd_znac;
                        }
                        this.index = rnd_znac % this.audlist.length;
                    }
                    if (this.index < 0) {
                        this.index = this.audlist.length - 1;
                    }
                    this.pl.deallocate();
                    try {
                        this.openFile(this.audlist[this.index]);
                        this.prepareFile();
                        this.launchPlayer();
                    }
                    catch (Exception e) {
                        this.HandleError(e, "keyPressed1");
                    }
                }
                if (this.getGameAction(keycode) == 5 && keycode != 54) {
                    if (!this.random_scroll) {
                        ++this.index;
                    } else {
                        int rnd_znac = this.rnd.nextInt();
                        if (rnd_znac < 0) {
                            rnd_znac = -1 * rnd_znac;
                        }
                        this.index = rnd_znac % this.audlist.length;
                    }
                    if (this.index > this.audlist.length - 1) {
                        this.index = 0;
                    }
                    this.pl.deallocate();
                    try {
                        this.openFile(this.audlist[this.index]);
                        this.prepareFile();
                        this.launchPlayer();
                    }
                    catch (Exception e) {
                        this.HandleError(e, "keyPressed2");
                    }
                }
                if (keycode == 42) {
                    if (this.vc != null) {
                        this.volume -= this.volume_step;
                        this.vc.setLevel(this.volume);
                        this.volume = this.vc.getLevel();
                        this.overrideInfo(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.lang.getString("volume")))).append(": ").append(String.valueOf(this.volume)).append("%"))));
                    } else {
                        this.overrideInfo(this.lang.getString("error"));
                    }
                }
                if (keycode == 35) {
                    if (this.vc != null) {
                        this.volume += this.volume_step;
                        this.vc.setLevel(this.volume);
                        this.volume = this.vc.getLevel();
                        this.overrideInfo(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.lang.getString("volume")))).append(": ").append(String.valueOf(this.volume)).append("%"))));
                    } else {
                        this.overrideInfo(this.lang.getString("error"));
                    }
                }
                if (keycode == 50) {
                    if (this.vc != null) {
                        boolean muted = this.vc.isMuted();
                        if (muted) {
                            this.vc.setMute(false);
                            this.overrideInfo(this.lang.getString("unmuted"));
                        } else {
                            this.vc.setMute(true);
                            this.overrideInfo(this.lang.getString("muted"));
                        }
                    } else {
                        this.overrideInfo(this.lang.getString("error"));
                    }
                }
                if (keycode == 55) {
                    boolean bl = this.auto_scroll = !this.auto_scroll;
                    if (this.auto_scroll) {
                        this.overrideInfo(this.lang.getString("scroll_auto"));
                    }
                    if (!this.auto_scroll) {
                        this.overrideInfo(this.lang.getString("scroll_manual"));
                    }
                }
                if (keycode == 57) {
                    boolean bl = this.random_scroll = !this.random_scroll;
                    if (this.random_scroll) {
                        this.overrideInfo(this.lang.getString("shuffle_on"));
                    }
                    if (!this.random_scroll) {
                        this.overrideInfo(this.lang.getString("shuffle_off"));
                    }
                }
                if (keycode == 56) {
                    boolean bl = this.backlight = !this.backlight;
                    if (this.backlight) {
                        this.overrideInfo(this.lang.getString("backlight_on"));
                        this.disp.flashBacklight(Integer.MAX_VALUE);
                    }
                    if (!this.backlight) {
                        this.overrideInfo(this.lang.getString("backlight_off"));
                        this.disp.flashBacklight(0);
                    }
                }
            }
            if (keycode == 48) {
                boolean bl = this.keyboard_locked = !this.keyboard_locked;
                if (this.keyboard_locked) {
                    this.overrideInfo(this.lang.getString("keyb_locked"));
                }
                if (!this.keyboard_locked) {
                    this.overrideInfo(this.lang.getString("keyb_unlocked"));
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(String.valueOf(e.toString())).concat(" at AudioPlayerUI.keyPressed"));
        }
    }

    void showInfo(String what) {
        this.info = what;
        this.show_info = true;
        this.timeout = 0;
    }

    void overrideInfo(String what) {
        this.override_info = what;
        this.s_override_info = true;
        this.timeout = 0;
    }

    public String millisecs2time(long millisecs) {
        long ts = millisecs / (long)100000;
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.formatNumber(ts / 600L, 2, true)))).append(":").append(this.formatNumber(ts % (long)600 / (long)10, 2, true))));
    }

    private String formatNumber(long num, int len, boolean leadingZeros) {
        StringBuffer ret = new StringBuffer(String.valueOf(num));
        if (leadingZeros) {
            while (ret.length() < len) {
                ret.insert(0, '0');
            }
        } else {
            while (ret.length() < len) {
                ret.append('0');
            }
        }
        return ret.toString();
    }

    public void openFile(String fname) {
        this.filepath = fname;
        this.filename = fname.substring(fname.lastIndexOf(47) + 1);
        this.info = this.lang.getString("preparing");
    }

    public void prepareFile() throws Exception {
        try {
            SettingsHandler sh = new SettingsHandler(this.disp);
            sh.LoadSettings();
            this.pl = null;
            if (sh.useInputStreamInAudio) {
                FileConnection fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(this.filepath))));
                InputStream is = fc.openInputStream();
                this.pl = Manager.createPlayer((InputStream)is, (String)AudioPlayerUI.guessContentType("file://".concat(String.valueOf(String.valueOf(this.filepath)))));
            } else {
                this.pl = Manager.createPlayer((String)"file:/".concat(String.valueOf(String.valueOf(this.filepath))));
            }
            this.pl.addPlayerListener((PlayerListener)this);
            this.pl.realize();
            this.info = "Realized";
            this.repaint();
            this.pl.prefetch();
            this.vc = (VolumeControl)this.pl.getControl("VolumeControl");
            this.vc.setLevel(this.volume);
            this.pc = (PitchControl)this.pl.getControl("PitchControl");
            this.rc = (RateControl)this.pl.getControl("RateControl");
            this.info = "Prefetched";
            this.repaint();
        }
        catch (Exception e) {
            Exception e2 = new Exception(String.valueOf(String.valueOf(e.toString())).concat(" at AudioPlayerUI.prepareFile"));
            throw e2;
        }
        this.aprc = null;
        this.aprc = new AudioPlayerRepaintControl(this);
        this.aprc.StartProgramFlow(1L, 1000L);
    }

    public void launchPlayer() throws Exception {
        this.repaint();
        try {
            this.pl.start();
            this.info = this.lang.getString("playing");
        }
        catch (Exception e) {
            Exception e2 = new Exception(String.valueOf(String.valueOf(e.toString())).concat(" at AudioPlayerUI.prepareFile"));
            throw e2;
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (!this.keyboard_locked && c == this.exit) {
            this.disp.flashBacklight(Integer.MAX_VALUE);
            try {
                if (this.pl.getState() == 400) {
                    this.pl.stop();
                }
                if (this.pl.getState() == 300) {
                    this.pl.deallocate();
                }
                this.pl.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.Sh.volume = (byte)this.volume;
            this.Sh.ap_auto_next = this.auto_scroll;
            this.Sh.ap_shuffle = this.random_scroll;
            this.Sh.SaveSettings();
            this.Sh = null;
            this.freeMem();
            this.Callback.viewer_callback(false, this.real_idxs[this.index], this);
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event == "endOfMedia") {
            if (!this.auto_scroll) {
                this.showInfo(this.lang.getString("stopped"));
                this.repaint();
            } else {
                this.keyPressed(this.getKeyCode(2));
            }
        }
        if (event == "error") {
            this.showInfo(this.lang.getString("error"));
            this.repaint();
        }
        if (event == "closed") {
            this.showInfo(this.lang.getString("closed"));
            this.repaint();
        }
        if (event == "started") {
            this.showInfo(this.lang.getString("playing"));
            this.repaint();
        }
        if (event == "stopped") {
            this.showInfo(this.lang.getString("stopped"));
            this.repaint();
        }
    }

    public static String[] splitURL(String url) throws Exception {
        int slash;
        StringBuffer u = new StringBuffer(url);
        String[] result = new String[6];
        for (int i = 0; i <= 5; ++i) {
            result[i] = "";
        }
        boolean protFound = false;
        int index = url.indexOf(":");
        if (index > 0) {
            result[0] = url.substring(0, index);
            u.delete(0, index + 1);
            protFound = true;
        } else if (index == 0) {
            throw new Exception("url format error - protocol");
        }
        if (u.length() > 2 && u.charAt(0) == '/' && u.charAt(1) == '/') {
            u.delete(0, 2);
            slash = u.toString().indexOf(47);
            if (slash < 0) {
                slash = u.length();
            }
            int colon = u.toString().indexOf(58);
            int endIndex = slash;
            if (colon >= 0) {
                if (colon > slash) {
                    throw new Exception("url format error - port");
                }
                endIndex = colon;
                result[2] = u.toString().substring(colon + 1, slash);
            }
            result[1] = u.toString().substring(0, endIndex);
            u.delete(0, slash);
        }
        if (u.length() > 0) {
            url = u.toString();
            slash = url.lastIndexOf(47);
            if (slash > 0) {
                result[3] = url.substring(0, slash);
            }
            if (slash < url.length() - 1) {
                String fn = url.substring(slash + 1, url.length());
                int anchorIndex = fn.indexOf("#");
                if (anchorIndex >= 0) {
                    result[4] = fn.substring(0, anchorIndex);
                    result[5] = fn.substring(anchorIndex + 1);
                } else {
                    result[4] = fn;
                }
            }
        }
        return result;
    }

    public static String guessContentType(String url) throws Exception {
        String[] sURL = AudioPlayerUI.splitURL(url);
        String ext = "";
        String ct = "";
        int lastDot = sURL[4].lastIndexOf(46);
        if (lastDot >= 0) {
            ext = sURL[4].substring(lastDot + 1).toLowerCase();
        }
        if (ext.equals("mid") || ext.equals("kar") || ext.equals("midi") || ext.equals("bas")) {
            ct = "audio/midi";
        } else if (ext.equals("wav")) {
            ct = "audio/x-wav";
        } else if (ext.equals("jts")) {
            ct = "audio/x-tone-seq";
        } else if (ext.equals("txt")) {
            ct = "audio/x-txt";
        } else if (ext.equals("amr")) {
            ct = "audio/amr";
        } else if (ext.equals("awb")) {
            ct = "audio/amr-wb";
        } else if (ext.equals("gif")) {
            ct = "image/gif";
        } else if (ext.equals("mp3")) {
            ct = "audio/mpeg";
        }
        return ct;
    }
}

