/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.UUID;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class SPPServer
extends Thread {
    private StreamConnectionNotifier service = null;
    private StreamConnection con = null;
    private CarAPI carAPI;
    private CarConnection carConnection;
    private BluetoothCar bluetoothCar;
    private InputStream is;
    private OutputStream os;

    public SPPServer(CarAPI carAPI, BluetoothCar bluetoothCar) {
        this.carAPI = carAPI;
        this.bluetoothCar = bluetoothCar;
        this.carConnection = new CarConnection(carAPI);
        this.defineService();
        this.start();
    }

    public void run() {
        while (true) {
            this.waitForClientConnection();
            if (this.con != null) {
                if (!this.carAPI.isAppActive()) {
                    this.bluetoothCar.resumeRequest();
                    this.carAPI.startDisconnectTimer();
                }
                try {
                    this.is = this.con.openInputStream();
                    this.os = this.con.openOutputStream();
                }
                catch (IOException iOException) {
                    System.out.println("IOException: " + iOException.getMessage());
                    this.closeConnection();
                }
                this.carConnection.resetCarData();
                this.carAPI.timeToCloseConnection = false;
                while (this.carConnection.processEvents(this.is, this.os)) {
                    try {
                        SPPServer.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.closeConnection();
        }
    }

    private void closeConnection() {
        try {
            this.carConnection.quitCarLink(this.os);
            this.con.close();
            this.con = null;
            this.is.close();
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean connectionOpen() {
        return this.con != null;
    }

    public void closeAll() {
        this.closeConnection();
        try {
            this.service.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void defineService() {
        String string = " ";
        try {
            UUID uUID = new UUID("1101", true);
            string = "btspp://localhost:" + uUID.toString() + ";name=xSPPServer";
            System.out.println(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("NumberFormatException: " + numberFormatException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NullPointerException: " + nullPointerException.getMessage());
        }
        try {
            this.service = (StreamConnectionNotifier)Connector.open((String)string);
            System.out.println("Connector.open(serviceURL): OK!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("IllegalArgumentException: " + illegalArgumentException.getMessage());
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            System.out.println("ConnectionNotFoundException: " + connectionNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    private void waitForClientConnection() {
        try {
            System.out.println("Waits for client to connect!");
            System.out.flush();
            this.con = this.service.acceptAndOpen();
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
            this.closeConnection();
        }
    }
}

