/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class GUI
extends Canvas
implements Runnable,
CommandListener {
    private static final int P900_OK = 63562;
    private static final int P900_RET = 63557;
    private static final int P900_C = 63564;
    private static final int P900_MENU = 63563;
    private static final int DISPLAY_IDLE = -2;
    private static final int DISPLAY_REC = -3;
    private static final int DISPLAY_PLAY = -4;
    private Command aboutCommand;
    private Command rotateScrCommand;
    private Command exitCommand;
    private Command soundOnCommand;
    private Command soundOffCommand;
    private Command recordCommand;
    private Command stopRecordCommand;
    private Command replayCommand;
    private Command stopReplayCommand;
    private Image aboutImage;
    private Sprite spDisplayIdle;
    private Sprite spDisplayRec;
    private Sprite spDisplayPlay;
    private Sprite[] sprites;
    private Image pictSpeedR;
    private Image pictSpeedN;
    private Image pictSpeed1;
    private Image pictSpeed2;
    private Image pictSpeed3;
    private Image pictDisplayIdle;
    private Image pictDisplayRec;
    private Image pictDisplayPlay;
    private Image pictPanelNC;
    private Image pictPanelCh;
    private Image pictPanelOk;
    private Image pictWheelLeft2;
    private Image pictWheelLeft1;
    private Image pictWheelStraight;
    private Image pictWheelRight1;
    private Image pictWheelRight2;
    private int lastKnownWidth;
    private int lastKnownHeight;
    private boolean blackScreen;
    private String blackScreenText;
    private CarAPI carAPI;
    private Thread myThread;
    private boolean landscapeMode;
    private boolean wheelSoundAvailable;
    private boolean engineSoundAvailable;
    private boolean gearSoundAvailable;
    private boolean statusSoundAvailable;
    private boolean enableWheelSound;
    private boolean enableEngineSound;
    private boolean enableGearSound;
    private boolean enableStatusSound;
    private boolean wantToPlayGearUp;
    private boolean wantToPlayGearDown;
    private boolean wantToPlayWheel;
    private boolean wantToPlayReady;
    private boolean wantToPlayCharging;
    private boolean wantToPlayNoLink;
    private boolean enableTouchWheel;
    private int lastKnownDirection;
    private int lastKnownSpeed;
    private int lastKnownStatus;
    private int lastKnownMode;
    private long startedWheelSoundTime;
    private Player soundGearUp;
    private Player soundGearDown;
    private Player soundGearUpWheel;
    private Player soundGearDownWheel;
    private Player soundWheel;
    private Player soundSpeedR;
    private Player soundSpeedN;
    private Player soundSpeed1;
    private Player soundSpeed2;
    private Player soundSpeed3;
    private Player soundReady;
    private Player soundCharging;
    private Player soundNoLink;
    private Player currentlyPlayingSound;
    private boolean started;
    private long eventStartTime;
    private boolean recording = false;
    private boolean replaying = false;
    private Enumeration events;
    private Vector drivePath = new Vector();
    private Timer playbackTimer;
    private TimerTask playbackTimerTask = new TimerTask(){

        /*
         * Unable to fully structure code
         */
        public void run() {
            block7: {
                block5: {
                    block6: {
                        if (!GUI.access$000(GUI.this) || !GUI.access$100(GUI.this).isAppActive() || !GUI.access$200(GUI.this).hasMoreElements()) break block5;
                        var1_1 = (driveEventClass)GUI.access$200(GUI.this).nextElement();
                        if (var1_1.eventDuration < 0L) break block6;
                        v0 = var1_1.event;
                        GUI.access$100(GUI.this);
                        if (v0 < 7) ** GOTO lbl-1000
                        v1 = var1_1.event;
                        GUI.access$100(GUI.this);
                        if (v1 <= 11) {
                            GUI.access$100(GUI.this).setDirection(var1_1.event);
                            GUI.access$300(GUI.this);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = var1_1.event;
                            GUI.access$100(GUI.this);
                            if (v2 >= -1) {
                                v3 = var1_1.event;
                                GUI.access$100(GUI.this);
                                if (v3 <= 3) {
                                    GUI.access$100(GUI.this).setSpeed(var1_1.event);
                                    GUI.access$300(GUI.this);
                                }
                            }
                        }
                        if (GUI.access$400(GUI.this) != null) {
                            GUI.access$400(GUI.this).schedule(GUI.access$500(GUI.this), var1_1.eventDuration);
                        }
                        break block7;
                    }
                    GUI.this.stopReplaying();
                    break block7;
                }
                GUI.this.stopReplaying();
            }
        }
    };
    private BluetoothCar bluetoothCar;

    public GUI(CarAPI carAPI, BluetoothCar bluetoothCar) {
        this.carAPI = carAPI;
        try {
            this.aboutImage = Image.createImage((String)"/About.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.started = false;
        this.blackScreen = false;
        this.blackScreenText = "Loading...";
        this.lastKnownWidth = 0;
        this.lastKnownHeight = 0;
        this.landscapeMode = this.getHeight() > this.getWidth();
        this.sprites = new Sprite[13];
        this.aboutCommand = new Command("About", 1, 1);
        this.addCommand(this.aboutCommand);
        this.recordCommand = new Command("Record", "Record Path", 1, 1);
        this.stopRecordCommand = new Command("Stop Recording", "Stop Recording Path", 6, 1);
        this.replayCommand = new Command("Replay", "Replay Path", 1, 1);
        this.stopReplayCommand = new Command("Stop Replaying", "Stop Replaying Path", 6, 1);
        this.addCommand(this.recordCommand);
        this.rotateScrCommand = new Command("Rotate", "Rotate Screen", 1, 1);
        this.addCommand(this.rotateScrCommand);
        this.exitCommand = new Command("Exit", 7, 1);
        this.addCommand(this.exitCommand);
        this.soundOffCommand = new Command("Sound Off", "Sound FX Off", 1, 1);
        this.soundOnCommand = new Command("Sound On", "Sound FX On", 1, 1);
        this.setCommandListener(this);
        this.enableTouchWheel = false;
        this.lastKnownDirection = 9;
        this.lastKnownSpeed = 0;
        this.lastKnownStatus = 6;
        this.lastKnownMode = this.getMode();
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void run() {
        if (!this.started) {
            this.started = true;
            this.blackScreen = true;
            this.blackScreenText = "Loading graphics...";
            this.repaint();
            this.serviceRepaints();
            this.loadImages();
            this.blackScreen = true;
            this.blackScreenText = "Loading Sound FX...";
            this.repaint();
            this.serviceRepaints();
            this.loadSounds();
            this.addCommands();
            this.repaint();
        }
        while (true) {
            if (!this.allUpdated()) {
                this.processCarEvents();
            }
            this.playSounds();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("InterruptedException: " + interruptedException.getMessage());
            }
            long l = System.currentTimeMillis();
            this.carAPI.waitUntilActive();
        }
    }

    public boolean allUpdated() {
        return this.carAPI.getStatus() == this.lastKnownStatus && this.carAPI.getDirection() == this.lastKnownDirection && this.carAPI.getSpeed() == this.lastKnownSpeed && this.getMode() == this.lastKnownMode;
    }

    private Player getSoundFX(String string, boolean bl) {
        boolean bl2 = true;
        Player player = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            player = Manager.createPlayer((InputStream)inputStream, (String)"audio/X-wav");
            player.prefetch();
            if (bl) {
                player.setLoopCount(-1);
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2) {
            return player;
        }
        return null;
    }

    private void loadImages() {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        int n5;
        if (!this.started) {
            return;
        }
        try {
            if (this.pictSpeedR == null) {
                this.pictSpeedR = Image.createImage((String)"/SpeedR.png");
            }
            if (this.pictSpeedN == null) {
                this.pictSpeedN = Image.createImage((String)"/SpeedN.png");
            }
            if (this.pictSpeed1 == null) {
                this.pictSpeed1 = Image.createImage((String)"/Speed1.png");
            }
            if (this.pictSpeed2 == null) {
                this.pictSpeed2 = Image.createImage((String)"/Speed2.png");
            }
            if (this.pictSpeed3 == null) {
                this.pictSpeed3 = Image.createImage((String)"/Speed3.png");
            }
            if (this.pictDisplayIdle == null) {
                this.pictDisplayIdle = Image.createImage((String)"/DisplayIdle.png");
            }
            if (this.pictDisplayRec == null) {
                this.pictDisplayRec = Image.createImage((String)"/DisplayRec.png");
            }
            if (this.pictDisplayPlay == null) {
                this.pictDisplayPlay = Image.createImage((String)"/DisplayPlay.png");
            }
            if (this.pictPanelNC == null) {
                this.pictPanelNC = Image.createImage((String)"/NoLink.png");
            }
            if (this.pictPanelCh == null) {
                this.pictPanelCh = Image.createImage((String)"/Charging.png");
            }
            if (this.pictPanelOk == null) {
                this.pictPanelOk = Image.createImage((String)"/Ready.png");
            }
            if (this.pictWheelLeft2 == null) {
                this.pictWheelLeft2 = Image.createImage((String)"/WheelL2.png");
            }
            if (this.pictWheelLeft1 == null) {
                this.pictWheelLeft1 = Image.createImage((String)"/WheelL1.png");
            }
            if (this.pictWheelStraight == null) {
                this.pictWheelStraight = Image.createImage((String)"/Wheel0.png");
            }
            if (this.pictWheelRight1 == null) {
                this.pictWheelRight1 = Image.createImage((String)"/WheelR1.png");
            }
            if (this.pictWheelRight2 == null) {
                this.pictWheelRight2 = Image.createImage((String)"/WheelR2.png");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n6 = this.pictDisplayIdle.getWidth();
        int n7 = this.pictDisplayIdle.getHeight();
        int n8 = this.pictPanelOk.getHeight();
        int n9 = this.pictWheelStraight.getHeight();
        int n10 = this.pictSpeedN.getWidth();
        int n11 = this.pictSpeedN.getHeight();
        if (this.landscapeMode) {
            n5 = this.getHeight();
            n4 = this.getWidth();
        } else {
            n5 = this.getWidth();
            n4 = this.getHeight();
        }
        boolean bl2 = bl = n11 * ((n4 - n7) * 100) / n10 / 100 <= n5 - n6;
        if (bl) {
            n3 = n11;
            int n12 = (n5 - n6) * 100 / n3;
            int n13 = n10;
            int n14 = n4 * 100 / n13;
            n2 = n12 < n14 ? n12 : n14;
            n12 = (n5 - n11 * n2 / 100) * 100 / (n3 = n6);
            n = n12 < (n14 = (n4 - n7) * 100 / (n13 = n8 + n9)) ? n12 : n14;
        } else {
            n3 = n10;
            int n15 = (n4 - n7) * 100 / n3;
            n2 = n15;
            int n16 = n6;
            int n17 = (n5 - n11 * n2 / 100) * 100 / n16;
            n15 = (n4 - n7) * 100 / (n3 = n9 + n8);
            n = n17 < n15 ? n17 : n15;
        }
        try {
            this.spDisplayIdle = new Sprite(this.pictDisplayIdle);
            this.spDisplayRec = new Sprite(this.pictDisplayRec);
            this.spDisplayPlay = new Sprite(this.pictDisplayPlay);
            this.insertSprite(6, new Sprite(this.downscaleImage(n, this.pictPanelNC)));
            this.insertSprite(5, new Sprite(this.downscaleImage(n, this.pictPanelCh)));
            this.insertSprite(4, new Sprite(this.downscaleImage(n, this.pictPanelOk)));
            this.insertSprite(-1, new Sprite(this.downscaleImage(n2, this.pictSpeedR)));
            this.insertSprite(0, new Sprite(this.downscaleImage(n2, this.pictSpeedN)));
            this.insertSprite(1, new Sprite(this.downscaleImage(n2, this.pictSpeed1)));
            this.insertSprite(2, new Sprite(this.downscaleImage(n2, this.pictSpeed2)));
            this.insertSprite(3, new Sprite(this.downscaleImage(n2, this.pictSpeed3)));
            this.insertSprite(7, new Sprite(this.downscaleImage(n, this.pictWheelLeft2)));
            this.insertSprite(8, new Sprite(this.downscaleImage(n, this.pictWheelLeft1)));
            this.insertSprite(9, new Sprite(this.downscaleImage(n, this.pictWheelStraight)));
            this.insertSprite(10, new Sprite(this.downscaleImage(n, this.pictWheelRight1)));
            this.insertSprite(11, new Sprite(this.downscaleImage(n, this.pictWheelRight2)));
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NullPointerException: Load sprites: " + nullPointerException.getMessage());
        }
        this.setSpritePos(bl);
        this.lastKnownWidth = this.getWidth();
        this.lastKnownHeight = this.getHeight();
        this.repaint();
    }

    private void loadSounds() {
        if (!this.started) {
            return;
        }
        this.gearSoundAvailable = true;
        this.wheelSoundAvailable = true;
        this.engineSoundAvailable = true;
        this.statusSoundAvailable = true;
        this.currentlyPlayingSound = null;
        this.startedWheelSoundTime = System.currentTimeMillis();
        this.soundReady = this.getSoundFX("Ready.wav", false);
        this.statusSoundAvailable = this.soundReady != null && (this.soundCharging = this.getSoundFX("Charging.wav", false)) != null && (this.soundNoLink = this.getSoundFX("NoLink.wav", false)) != null;
        this.soundWheel = this.getSoundFX("Wheel.wav", false);
        this.wheelSoundAvailable = this.soundWheel != null;
        this.soundGearUp = this.getSoundFX("GearUp.wav", false);
        boolean bl = this.gearSoundAvailable = this.soundGearUp != null && (this.soundGearDown = this.getSoundFX("GearDown.wav", false)) != null;
        if (this.gearSoundAvailable && this.wheelSoundAvailable) {
            this.soundGearUpWheel = this.getSoundFX("GearUpWheel.wav", false);
            this.soundGearDownWheel = this.getSoundFX("GearDownWheel.wav", false);
            if (this.soundGearUpWheel == null || this.soundGearDownWheel == null) {
                this.gearSoundAvailable = false;
                this.wheelSoundAvailable = false;
            }
        }
        this.engineSoundAvailable = (this.soundSpeedR = this.getSoundFX("SpeedR.wav", true)) != null && (this.soundSpeedN = this.getSoundFX("SpeedN.wav", true)) != null && (this.soundSpeed1 = this.getSoundFX("Speed1.wav", true)) != null && (this.soundSpeed2 = this.getSoundFX("Speed2.wav", true)) != null && (this.soundSpeed3 = this.getSoundFX("Speed3.wav", true)) != null;
        this.enableGearSound = this.gearSoundAvailable;
        this.enableWheelSound = this.wheelSoundAvailable;
        this.enableEngineSound = this.engineSoundAvailable;
        this.enableStatusSound = this.statusSoundAvailable;
    }

    private void addCommands() {
        if (this.enableWheelSound || this.enableGearSound || this.enableEngineSound || this.enableStatusSound) {
            this.addCommand(this.soundOffCommand);
        }
        this.setCommandListener(this);
    }

    private void setSpritePos(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        if (this.landscapeMode) {
            n18 = this.getSprite(-2).getWidth();
            n17 = this.getSprite(-2).getHeight();
            n16 = this.getSprite(4).getWidth();
            n15 = this.getSprite(4).getHeight();
            n14 = this.getSprite(7).getWidth();
            n13 = this.getSprite(7).getHeight();
            n12 = this.getSprite(-1).getWidth();
            n11 = this.getSprite(-1).getHeight();
            n10 = this.getHeight();
            n9 = this.getWidth();
        } else {
            n17 = this.getSprite(-2).getWidth();
            n18 = this.getSprite(-2).getHeight();
            n15 = this.getSprite(4).getWidth();
            n16 = this.getSprite(4).getHeight();
            n13 = this.getSprite(7).getWidth();
            n14 = this.getSprite(7).getHeight();
            n11 = this.getSprite(-1).getWidth();
            n12 = this.getSprite(-1).getHeight();
            n10 = this.getWidth();
            n9 = this.getHeight();
        }
        if (bl) {
            n8 = n10 - n17;
            n7 = 0;
        } else {
            n8 = (n10 - n17) / 2;
            n7 = 0;
        }
        if (bl) {
            n6 = n10 - n17 + (n17 - n15) / 2;
            n5 = n18;
        } else {
            n6 = n10 - n15;
            n5 = n18;
        }
        if (bl) {
            n4 = (n10 - n17 - n11) / 2;
            n3 = n9 - n12;
        } else {
            n4 = (n10 - n15 - n11) / 2;
            n3 = n9 - n12;
        }
        if (bl) {
            n2 = n10 - n17 + (n17 - n13) / 2;
            n = n9 - n14;
        } else {
            n2 = n10 - n13;
            n = n9 - n14;
        }
        try {
            Sprite sprite;
            int n19;
            for (n19 = -4; n19 <= -2; ++n19) {
                sprite = this.getSprite(n19);
                if (this.landscapeMode) {
                    sprite.setPosition(n7, n10 - n8 - n17);
                    continue;
                }
                sprite.setPosition(n8, n7);
            }
            n19 = 4;
            while (true) {
                if (n19 > 6) break;
                sprite = this.getSprite(n19);
                if (this.landscapeMode) {
                    sprite.setPosition(n5, n10 - n6 - n15);
                } else {
                    sprite.setPosition(n6, n5);
                }
                ++n19;
            }
            n19 = -1;
            while (true) {
                if (n19 > 3) break;
                sprite = this.getSprite(n19);
                if (this.landscapeMode) {
                    sprite.setPosition(n3, n10 - n4 - n11);
                } else {
                    sprite.setPosition(n4, n3);
                }
                ++n19;
            }
            n19 = 7;
            while (true) {
                if (n19 <= 11) {
                    sprite = this.getSprite(n19);
                    if (this.landscapeMode) {
                        sprite.setPosition(n, n10 - n2 - n13);
                    } else {
                        sprite.setPosition(n2, n);
                    }
                    ++n19;
                    continue;
                }
                break;
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NullPointerException: Set sprites position: " + nullPointerException.getMessage());
        }
    }

    private void insertSprite(int n, Sprite sprite) {
        this.sprites[++n] = sprite;
    }

    private int rgbToInt(int n, int n2, int n3) {
        return n << 16 | n2 << 8 | n3;
    }

    private Image downscaleImage(int n, Image image) {
        if (n >= 100) {
            return Image.createImage((Image)image);
        }
        if (n <= 0) {
            return null;
        }
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        int[] nArray = new int[n2 * n3];
        int n4 = n2 * n / 100;
        int n5 = n3 * n / 100;
        int[] nArray2 = new int[n4 * n5];
        image.getRGB(nArray, 0, n2, 0, 0, n2, n3);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (int k = 100 * i / n; k < 100 * (i + 1) / n; ++k) {
                    for (int i2 = 100 * j / n; i2 < 100 * (j + 1) / n; ++i2) {
                        if (i2 < n2) {
                            int n10 = nArray[k * n2 + i2];
                            n6 += n10 >>> 16 & 0xFF;
                            n7 += n10 >>> 8 & 0xFF;
                            n8 += n10 & 0xFF;
                        }
                        ++n9;
                    }
                }
                nArray2[i * n4 + j] = this.rgbToInt(n6 /= n9, n7 /= n9, n8 /= n9);
            }
        }
        return Image.createRGBImage((int[])nArray2, (int)n4, (int)n5, (boolean)false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Sprite getSprite(int n) {
        Sprite sprite;
        if (n >= -1) {
            if (n <= 3) {
                sprite = this.sprites[n + 1];
                sprite.defineReferencePixel(sprite.getWidth() / 2, sprite.getWidth() / 2);
                if (this.landscapeMode) return sprite;
                sprite.setTransform(5);
                return sprite;
            }
        }
        sprite = n >= -4 && n <= -2 ? (n == -2 ? this.spDisplayIdle : (n == -3 ? this.spDisplayRec : this.spDisplayPlay)) : this.sprites[n + 1];
        sprite.defineReferencePixel(sprite.getWidth() / 2, sprite.getWidth() / 2);
        if (this.landscapeMode) {
            sprite.setTransform(6);
            return sprite;
        }
        sprite.setTransform(0);
        return sprite;
    }

    private void playSounds() {
        if (!(this.wantToPlayWheel || this.wantToPlayGearUp || this.wantToPlayGearDown || this.wantToPlayReady || this.wantToPlayCharging || this.wantToPlayNoLink)) {
            boolean bl = false;
            try {
                if (this.currentlyPlayingSound == null) {
                    bl = true;
                } else if (this.currentlyPlayingSound.getState() != 400) {
                    bl = true;
                }
                if (bl) {
                    switch (this.carAPI.getSpeed()) {
                        case -1: {
                            this.currentlyPlayingSound = this.soundSpeedR;
                            break;
                        }
                        case 0: {
                            this.currentlyPlayingSound = this.soundSpeedN;
                            break;
                        }
                        case 1: {
                            this.currentlyPlayingSound = this.soundSpeed1;
                            break;
                        }
                        case 2: {
                            this.currentlyPlayingSound = this.soundSpeed2;
                            break;
                        }
                        case 3: {
                            this.currentlyPlayingSound = this.soundSpeed3;
                        }
                    }
                    this.currentlyPlayingSound.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        Player player = null;
        if (this.wantToPlayWheel) {
            this.startedWheelSoundTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.startedWheelSoundTime < this.soundWheel.getDuration() / 1000L) {
            this.wantToPlayWheel = true;
        }
        if (this.wantToPlayReady) {
            if (this.enableStatusSound) {
                player = this.soundReady;
            }
            this.wantToPlayReady = false;
        } else if (this.wantToPlayCharging) {
            if (this.enableStatusSound) {
                player = this.soundCharging;
            }
            this.wantToPlayCharging = false;
        } else if (this.wantToPlayNoLink) {
            if (this.enableStatusSound) {
                player = this.soundNoLink;
            }
            this.wantToPlayNoLink = false;
        } else {
            if (this.wantToPlayGearUp && this.wantToPlayWheel && this.enableWheelSound && this.enableGearSound) {
                player = this.soundGearUpWheel;
            } else if (this.wantToPlayGearDown && this.wantToPlayWheel && this.enableWheelSound && this.enableGearSound) {
                player = this.soundGearDownWheel;
            } else if (this.wantToPlayGearUp && this.enableGearSound) {
                player = this.soundGearUp;
            } else if (this.wantToPlayGearDown && this.enableGearSound) {
                player = this.soundGearDown;
            } else if (this.wantToPlayWheel && this.enableWheelSound) {
                player = this.soundWheel;
            }
            this.wantToPlayWheel = false;
            this.wantToPlayGearUp = false;
            this.wantToPlayGearDown = false;
        }
        if (player == null) {
            return;
        }
        try {
            if (this.currentlyPlayingSound != null) {
                this.currentlyPlayingSound.stop();
            }
            this.currentlyPlayingSound = player;
            this.currentlyPlayingSound.setMediaTime(0L);
            this.currentlyPlayingSound.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getMode() {
        if (this.recording) {
            return -3;
        }
        if (this.replaying) {
            return -4;
        }
        return -2;
    }

    private void processCarEvents() {
        block15: {
            block17: {
                block16: {
                    if (this.lastKnownMode != this.getMode()) {
                        this.repaint(this.getSprite(-2).getX(), this.getSprite(-2).getY(), this.getSprite(-2).getWidth(), this.getSprite(-2).getHeight());
                    }
                    if (this.carAPI.getDirection() == this.lastKnownDirection) break block15;
                    if (this.carAPI.getDirection() == 7) break block16;
                    if (this.carAPI.getDirection() != 11) break block17;
                }
                this.wantToPlayWheel = true;
            }
            if (this.recording) {
                this.recordEvent(this.carAPI.getDirection());
            }
            this.repaint(this.getSprite(7).getX(), this.getSprite(7).getY(), this.getSprite(7).getWidth(), this.getSprite(7).getHeight());
        }
        if (this.carAPI.getSpeed() != this.lastKnownSpeed) {
            if (this.carAPI.getSpeed() < this.lastKnownSpeed) {
                this.wantToPlayGearDown = true;
            } else {
                this.wantToPlayGearUp = true;
            }
            if (this.recording) {
                this.recordEvent(this.carAPI.getSpeed());
            }
            this.repaint(this.getSprite(0).getX(), this.getSprite(0).getY(), this.getSprite(0).getWidth(), this.getSprite(0).getHeight());
        }
        if (this.carAPI.getStatus() != this.lastKnownStatus) {
            if (this.carAPI.getStatus() == 4) {
                this.wantToPlayReady = true;
                this.carAPI.setSpeed(0);
                this.carAPI.setDirection(9);
                this.repaint();
            } else if (this.carAPI.getStatus() == 5) {
                this.wantToPlayCharging = true;
            } else if (this.carAPI.getStatus() == 6) {
                this.wantToPlayNoLink = true;
            }
            this.repaint(this.getSprite(4).getX(), this.getSprite(4).getY(), this.getSprite(4).getWidth(), this.getSprite(4).getHeight());
        }
        this.lastKnownSpeed = this.carAPI.getSpeed();
        this.lastKnownDirection = this.carAPI.getDirection();
        this.lastKnownStatus = this.carAPI.getStatus();
        this.lastKnownMode = this.getMode();
    }

    private boolean intersects(Sprite sprite, int n, int n2, int n3, int n4) {
        if (sprite.getX() + sprite.getWidth() < n) {
            return false;
        }
        if (sprite.getX() > n + n3) {
            return false;
        }
        if (sprite.getY() + sprite.getHeight() < n2) {
            return false;
        }
        return sprite.getY() <= n2 + n4;
    }

    private boolean withinSprite(Sprite sprite, int n, int n2) {
        return sprite.getX() <= n && n <= sprite.getX() + sprite.getWidth() && sprite.getY() <= n2 && n2 <= sprite.getY() + sprite.getHeight();
    }

    private int getGear(int n, int n2) {
        int n3;
        if (this.landscapeMode) {
            n3 = this.getSprite(0).getWidth();
            n2 = n - this.getSprite(0).getX();
        } else {
            n3 = this.getSprite(0).getHeight();
            n2 -= this.getSprite(0).getY();
        }
        if (n2 < 32 * n3 / 208) {
            return 3;
        }
        if (n2 < 67 * n3 / 208) {
            return 2;
        }
        if (n2 < 100 * n3 / 208) {
            return 1;
        }
        if (n2 < 153 * n3 / 208) {
            return 0;
        }
        return -1;
    }

    private int getDirection(int n, int n2) {
        int n3;
        if (this.landscapeMode) {
            n3 = this.getSprite(7).getHeight();
            n = n3 - (n2 - this.getSprite(7).getY());
        } else {
            n3 = this.getSprite(7).getWidth();
            n -= this.getSprite(7).getX();
        }
        if (n < 17 * n3 / 100) {
            return 7;
        }
        if (n < 33 * n3 / 100) {
            return 8;
        }
        if (n < 67 * n3 / 100) {
            return 9;
        }
        if (n < 83 * n3 / 100) {
            return 10;
        }
        return 11;
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setColor(130, 158, 160);
        graphics.fillRect(n, n2, n3, n4);
        if (this.blackScreen) {
            this.blackScreen = false;
            graphics.setColor(0, 0, 0);
            graphics.drawString(this.blackScreenText, this.getWidth() / 2, this.getHeight() / 2, 33);
            return;
        }
        if (this.intersects(this.getSprite(-2), n, n2, n3, n4)) {
            this.getSprite(this.getMode()).paint(graphics);
        }
        if (this.intersects(this.getSprite(7), n, n2, n3, n4)) {
            switch (this.carAPI.getDirection()) {
                case 7: {
                    this.getSprite(7).paint(graphics);
                    break;
                }
                case 8: {
                    this.getSprite(8).paint(graphics);
                    break;
                }
                case 9: {
                    this.getSprite(9).paint(graphics);
                    break;
                }
                case 10: {
                    this.getSprite(10).paint(graphics);
                    break;
                }
                case 11: {
                    this.getSprite(11).paint(graphics);
                }
            }
        }
        if (this.intersects(this.getSprite(4), n, n2, n3, n4)) {
            switch (this.carAPI.getStatus()) {
                case 4: {
                    this.getSprite(4).paint(graphics);
                    break;
                }
                case 5: {
                    this.getSprite(5).paint(graphics);
                    break;
                }
                case 6: {
                    this.getSprite(6).paint(graphics);
                }
            }
        }
        if (this.intersects(this.getSprite(-1), n, n2, n3, n4)) {
            switch (this.carAPI.getSpeed()) {
                case -1: {
                    this.getSprite(-1).paint(graphics);
                    break;
                }
                case 0: {
                    this.getSprite(0).paint(graphics);
                    break;
                }
                case 1: {
                    this.getSprite(1).paint(graphics);
                    break;
                }
                case 2: {
                    this.getSprite(2).paint(graphics);
                    break;
                }
                case 3: {
                    this.getSprite(3).paint(graphics);
                }
            }
        }
    }

    protected void sizeChanged(int n, int n2) {
        this.landscapeMode = n2 > n;
        if (!this.started) {
            return;
        }
        if (n != this.lastKnownWidth || n2 != this.lastKnownHeight) {
            this.blackScreen = true;
            this.blackScreenText = "Adjusting graphics...";
            this.repaint();
            this.serviceRepaints();
            this.loadImages();
        }
    }

    private int getLandscapeGameAction(int n) {
        switch (n) {
            case 5: {
                return 6;
            }
            case 2: {
                return 1;
            }
            case 1: {
                return 5;
            }
            case 6: {
                return 2;
            }
        }
        return n;
    }

    protected void keyPressed(int n) {
        if (this.replaying) {
            this.stopReplaying();
        }
        int n2 = n == 63562 ? 2 : (n == 63563 ? 5 : this.getGameAction(n));
        if (this.landscapeMode) {
            n2 = this.getLandscapeGameAction(n2);
        }
        switch (n2) {
            case 6: {
                if (this.carAPI.getSpeed() > 0) {
                    this.carAPI.setSpeed(0);
                } else {
                    this.carAPI.setSpeed(-1);
                }
                this.processCarEvents();
                break;
            }
            case 1: {
                this.carAPI.incSpeed();
                this.processCarEvents();
                break;
            }
            case 5: {
                this.carAPI.turnRight();
                this.processCarEvents();
                break;
            }
            case 2: {
                this.carAPI.turnLeft();
                this.processCarEvents();
                break;
            }
        }
    }

    protected void keyRepeated(int n) {
        if (this.replaying) {
            this.stopReplaying();
        }
        int n2 = n == 63562 ? 2 : (n == 63563 ? 5 : this.getGameAction(n));
        if (this.landscapeMode) {
            n2 = this.getLandscapeGameAction(n2);
        }
        switch (n2) {
            case 6: {
                this.carAPI.decSpeed();
                this.processCarEvents();
                break;
            }
            case 1: {
                this.carAPI.incSpeed();
                this.processCarEvents();
                break;
            }
            case 5: {
                this.carAPI.turnRight();
                this.processCarEvents();
                break;
            }
            case 2: {
                this.carAPI.turnLeft();
                this.processCarEvents();
            }
        }
    }

    protected void keyReleased(int n) {
        if (this.replaying) {
            this.stopReplaying();
        }
        int n2 = n == 63562 ? 2 : (n == 63563 ? 5 : this.getGameAction(n));
        switch (n2) {
            case 5: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                this.carAPI.setDirection(9);
                this.processCarEvents();
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (this.replaying) {
            this.stopReplaying();
        }
        int n3 = this.getGear(n, n2);
        this.carAPI.setSpeed(n3);
        this.processCarEvents();
        this.enableTouchWheel = this.withinSprite(this.getSprite(9), n, n2);
        if (this.enableTouchWheel) {
            int n4 = this.getDirection(n, n2);
            this.carAPI.setDirection(n4);
            this.processCarEvents();
        }
    }

    protected void pointerDragged(int n, int n2) {
        if (this.replaying) {
            this.stopReplaying();
        }
        int n3 = this.getGear(n, n2);
        this.carAPI.setSpeed(n3);
        this.processCarEvents();
        if (this.enableTouchWheel) {
            int n4 = this.getDirection(n, n2);
            this.carAPI.setDirection(n4);
            this.processCarEvents();
        }
    }

    protected void pointerReleased(int n, int n2) {
        if (this.replaying) {
            this.stopReplaying();
        }
        this.carAPI.setSpeed(0);
        this.processCarEvents();
        if (this.enableTouchWheel) {
            this.carAPI.setDirection(9);
            this.processCarEvents();
        }
    }

    protected void hideNotify() {
        if (this.started) {
            this.carAPI.setAppActive(false);
        }
        if (this.recording) {
            this.stopRecording();
        }
        if (this.replaying) {
            this.stopReplaying();
        }
    }

    protected void showNotify() {
        if (this.started) {
            this.carAPI.setAppActive(true);
        }
    }

    private void startRecording() {
        if (this.replaying) {
            this.stopReplaying();
        }
        this.drivePath.removeAllElements();
        this.eventStartTime = 0L;
        this.recording = true;
        this.removeCommand(this.recordCommand);
        this.removeCommand(this.replayCommand);
        this.removeCommand(this.stopReplayCommand);
        this.addCommand(this.recordCommand);
        this.addCommand(this.stopRecordCommand);
    }

    public void stopRecording() {
        this.recording = false;
        if (this.eventStartTime > 0L) {
            try {
                driveEventClass driveEventClass2 = (driveEventClass)this.drivePath.lastElement();
                driveEventClass2.eventDuration = System.currentTimeMillis() - this.eventStartTime;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.eventStartTime = 0L;
        this.removeCommand(this.stopRecordCommand);
        this.removeCommand(this.stopReplayCommand);
        this.addCommand(this.recordCommand);
        if (!this.drivePath.isEmpty()) {
            this.addCommand(this.replayCommand);
        }
    }

    private void startReplaying() {
        this.recording = false;
        if (this.replaying) {
            this.stopReplaying();
        }
        this.replaying = true;
        this.events = this.drivePath.elements();
        this.playbackTimer = new Timer();
        this.playbackTimer.schedule(this.playbackTimerTask, 1L);
        this.removeCommand(this.recordCommand);
        this.removeCommand(this.stopRecordCommand);
        this.addCommand(this.stopReplayCommand);
    }

    public void stopReplaying() {
        this.removeCommand(this.stopRecordCommand);
        this.removeCommand(this.stopReplayCommand);
        this.addCommand(this.recordCommand);
        this.replaying = false;
        if (this.playbackTimer != null) {
            this.playbackTimer.cancel();
            this.playbackTimer = null;
        }
    }

    private void recordEvent(int n) {
        driveEventClass driveEventClass2;
        if (this.eventStartTime > 0L) {
            try {
                driveEventClass2 = (driveEventClass)this.drivePath.lastElement();
                driveEventClass2.eventDuration = System.currentTimeMillis() - this.eventStartTime;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        driveEventClass2 = new driveEventClass();
        driveEventClass2.event = n;
        driveEventClass2.eventDuration = -1L;
        this.drivePath.addElement(driveEventClass2);
        this.eventStartTime = System.currentTimeMillis();
    }

    public void commandAction(Command command, Displayable displayable) {
        System.out.println("Command: " + command.getLabel());
        if (command == this.exitCommand) {
            BluetoothCar.getInstance().destroyApp(false);
        } else if (command == this.soundOffCommand) {
            this.removeCommand(this.soundOffCommand);
            this.addCommand(this.soundOnCommand);
            this.enableWheelSound = false;
            this.enableGearSound = false;
            this.enableEngineSound = false;
            this.enableStatusSound = false;
        } else if (command == this.soundOnCommand) {
            this.removeCommand(this.soundOnCommand);
            this.addCommand(this.soundOffCommand);
            this.enableWheelSound = this.wheelSoundAvailable;
            this.enableGearSound = this.gearSoundAvailable;
            this.enableEngineSound = this.engineSoundAvailable;
            this.enableStatusSound = this.statusSoundAvailable;
        } else if (command == this.aboutCommand) {
            this.showAbout();
        } else if (command == this.recordCommand) {
            this.startRecording();
        } else if (command == this.stopRecordCommand) {
            this.stopRecording();
        } else if (command == this.replayCommand) {
            this.startReplaying();
        } else if (command == this.stopReplayCommand) {
            this.stopReplaying();
        } else if (command == this.rotateScrCommand) {
            this.landscapeMode = !this.landscapeMode;
            this.blackScreen = true;
            this.blackScreenText = "Adjusting graphics...";
            this.repaint();
            this.serviceRepaints();
            this.loadImages();
        }
    }

    private void showAbout() {
        Alert alert = new Alert("Bluetooth Car ver. " + "1.14", "Copyright (c) 2003\nSony Ericsson Mobile Communications AB\nAll Rights Reserved.\n\nThis application is free of charge and provided as is, without any kind of warranties.\n\nThe purpose of this application is to demonstrate the possibilities with Java MIDP 2.0 and the Sony Ericsson Bluetooth car, CAR-100.\n\nWritten in 2003 by Christopher Wong and \u00c5ke Rydgren", this.aboutImage, AlertType.INFO);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)BluetoothCar.getInstance()).setCurrent((Displayable)alert);
    }

    private void showMessage(String string) {
        Alert alert = new Alert("Message:", string, null, AlertType.INFO);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)BluetoothCar.getInstance()).setCurrent((Displayable)alert);
    }

    static /* synthetic */ boolean access$000(GUI gUI) {
        return gUI.replaying;
    }

    static /* synthetic */ CarAPI access$100(GUI gUI) {
        return gUI.carAPI;
    }

    static /* synthetic */ Enumeration access$200(GUI gUI) {
        return gUI.events;
    }

    static /* synthetic */ void access$300(GUI gUI) {
        gUI.processCarEvents();
    }

    static /* synthetic */ Timer access$400(GUI gUI) {
        return gUI.playbackTimer;
    }

    static /* synthetic */ TimerTask access$500(GUI gUI) {
        return gUI.playbackTimerTask;
    }

    class driveEventClass {
        public int event;
        public long eventDuration;

        driveEventClass() {
        }
    }
}

