/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CarConnection {
    private final String CAR_CHARGING;
    private final String CAR_SPEED;
    private final String CAR_READY;
    private final String FORWARD_PRESSED;
    private final String BACK_PRESSED;
    private final String SPEED3_PRESSED;
    private final String SPEED2_PRESSED;
    private final String SPEED1_PRESSED;
    private final String STOP_PRESSED;
    private final String LEFT_PRESSED;
    private final String LEFT_RELEASED;
    private final String RIGHT_PRESSED;
    private final String RIGHT_RELEASED;
    private final String NO_PRESSED;
    private final String NO_RELEASED;
    private final String OK;
    private final byte[] CRLF = new byte[]{13, 10};
    private final int GEAR_3;
    private final int GEAR_2;
    private final int GEAR_1;
    private int currGear;
    private final int ACC_ON;
    private final int ACC_OFF;
    private final int ACC_BACK;
    private int currAcceleration;
    private int currDirection;
    private CarAPI carAPI;
    private final long SEND_DELAY;
    private long lastSendTime;

    public CarConnection(CarAPI carAPI) {
        this.CAR_CHARGING = "Charging";
        this.CAR_SPEED = "Speed=2";
        this.CAR_READY = "Ready";
        this.FORWARD_PRESSED = "+CKEV: u,1";
        this.BACK_PRESSED = "+CKEV: d,1";
        this.SPEED3_PRESSED = "+CKEV: #,1";
        this.SPEED2_PRESSED = "+CKEV: 0,1";
        this.SPEED1_PRESSED = "+CKEV: *,1";
        this.STOP_PRESSED = "+CKEV: :J,1";
        this.LEFT_PRESSED = "+CKEV: 2,1";
        this.LEFT_RELEASED = "+CKEV: 2,0";
        this.RIGHT_PRESSED = "+CKEV: 3,1";
        this.RIGHT_RELEASED = "+CKEV: 3,0";
        this.NO_PRESSED = "+CKEV: e,1";
        this.NO_RELEASED = "+CKEV: e,0";
        this.OK = "OK";
        this.GEAR_3 = 3;
        this.GEAR_2 = 2;
        this.GEAR_1 = 1;
        this.ACC_ON = 4;
        this.ACC_OFF = 5;
        this.ACC_BACK = 6;
        this.SEND_DELAY = 100L;
        this.carAPI = carAPI;
        this.lastSendTime = System.currentTimeMillis();
        this.resetCarData();
    }

    public void resetCarData() {
        this.currGear = 2;
        this.currAcceleration = 5;
        this.currDirection = 9;
    }

    public void quitCarLink(OutputStream outputStream) {
        try {
            this.send(outputStream, "+CKEV: e,1");
            this.send(outputStream, "+CKEV: e,0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.carAPI.setStatus(6);
    }

    /*
     * Unable to fully structure code
     */
    public boolean processEvents(InputStream var1_1, OutputStream var2_2) {
        try {
            block32: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block31: {
                                                var3_3 = var1_1.available();
                                                if (var3_3 <= 0) break block31;
                                                var4_6 = new byte[var3_3];
                                                var5_8 = var1_1.read(var4_6);
                                                var6_9 = new String(var4_6);
                                                System.out.println("RX: " + var6_9);
                                                if (var6_9.indexOf("Ready") != -1 || var6_9.indexOf("Speed=2") != -1) {
                                                    this.carAPI.setStatus(4);
                                                } else if (var6_9.indexOf("Charging") != -1) {
                                                    this.carAPI.setStatus(5);
                                                }
                                                this.sendOK(var2_2);
                                                break block32;
                                            }
                                            if (System.currentTimeMillis() - this.lastSendTime <= 100L) break block32;
                                            if (this.carAPI.getStatus() != 4) break block32;
                                            if (!this.carAPI.isSpeedChanged()) break block33;
                                            var4_7 = this.carAPI.getAndClearSpeed();
                                            if (var4_7 == 3) ** GOTO lbl30
                                            if (var4_7 == 2) ** GOTO lbl30
                                            if (var4_7 == 1) {
lbl30:
                                                // 3 sources

                                                if (var4_7 == 3 && this.currGear != 3) {
                                                    this.send(var2_2, "+CKEV: #,1");
                                                    this.currGear = 3;
                                                } else if (var4_7 == 2 && this.currGear != 2) {
                                                    this.send(var2_2, "+CKEV: 0,1");
                                                    this.currGear = 2;
                                                } else if (var4_7 == 1 && this.currGear != 1) {
                                                    this.send(var2_2, "+CKEV: *,1");
                                                    this.currGear = 1;
                                                }
                                                if (this.currAcceleration != 4) {
                                                    this.send(var2_2, "+CKEV: u,1");
                                                    this.currAcceleration = 4;
                                                }
                                            } else if (var4_7 == 0) {
                                                if (this.currAcceleration != 5) {
                                                    this.send(var2_2, "+CKEV: :J,1");
                                                    this.currAcceleration = 5;
                                                }
                                            } else if (var4_7 == -1 && this.currAcceleration != 6) {
                                                this.send(var2_2, "+CKEV: d,1");
                                                this.currAcceleration = 6;
                                            }
                                        }
                                        var4_7 = this.carAPI.getAndClearDirection();
                                        if (this.currAcceleration != 5) break block34;
                                        if (this.currDirection == 7) {
                                            this.send(var2_2, "+CKEV: 2,0");
                                        } else if (this.currDirection == 11) {
                                            this.send(var2_2, "+CKEV: 3,0");
                                        }
                                        break block32;
                                    }
                                    if (var4_7 == 7) break block35;
                                    if (var4_7 != 8) break block36;
                                    if (this.currDirection == 7) break block36;
                                }
                                this.send(var2_2, "+CKEV: 2,1");
                                if (this.currDirection == 11) {
                                    this.send(var2_2, "+CKEV: 3,0");
                                }
                                this.currDirection = 7;
                                break block32;
                            }
                            if (var4_7 == 11) break block37;
                            if (var4_7 != 10) break block38;
                            if (this.currDirection == 11) break block38;
                        }
                        this.send(var2_2, "+CKEV: 3,1");
                        if (this.currDirection == 7) {
                            this.send(var2_2, "+CKEV: 2,0");
                        }
                        this.currDirection = 11;
                        break block32;
                    }
                    if (var4_7 == 9) break block39;
                    if (this.currDirection == 9) break block32;
                    if (var4_7 == 8) break block39;
                    if (var4_7 != 10) break block32;
                }
                if (this.currDirection == 11) {
                    this.send(var2_2, "+CKEV: 3,0");
                } else if (this.currDirection == 7) {
                    this.send(var2_2, "+CKEV: 2,0");
                }
                this.currDirection = 9;
            }
            if (this.carAPI.timeToCloseConnection) {
                this.quitCarLink(var2_2);
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException var3_4) {
            System.out.println("IllegalArgumentException: " + var3_4.getMessage());
            this.carAPI.setStatus(6);
            return false;
        }
        catch (IOException var3_5) {
            System.out.println("IOException: " + var3_5.getMessage());
            this.carAPI.setStatus(6);
            return false;
        }
    }

    private void send(OutputStream outputStream, String string) throws IOException {
        if (string != null) {
            outputStream.write(this.CRLF);
            outputStream.write(string.getBytes());
            outputStream.write(this.CRLF);
            outputStream.flush();
            this.lastSendTime = System.currentTimeMillis();
        }
    }

    private void sendOK(OutputStream outputStream) throws IOException {
        outputStream.write(this.CRLF);
        outputStream.write("OK".getBytes());
        outputStream.write(this.CRLF);
        outputStream.flush();
        this.lastSendTime = System.currentTimeMillis();
    }
}

