/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;

public class CarAPI {
    public static final int CAR_READY = 4;
    public static final int CAR_CHARGING = 5;
    public static final int CAR_NO_LINK = 6;
    private int status = 6;
    public static final int CAR_SPEED_3 = 3;
    public static final int CAR_SPEED_2 = 2;
    public static final int CAR_SPEED_1 = 1;
    public static final int CAR_SPEED_N = 0;
    public static final int CAR_SPEED_R = -1;
    private int speed = 0;
    private boolean speedChanged;
    public static final int CAR_DIRECTION_LEFT = 7;
    public static final int CAR_DIRECTION_LIGHT_LEFT = 8;
    public static final int CAR_DIRECTION_STRAIGHT = 9;
    public static final int CAR_DIRECTION_LIGHT_RIGHT = 10;
    public static final int CAR_DIRECTION_RIGHT = 11;
    private int direction = 9;
    private boolean directionChanged;
    private boolean appActive = false;
    private BluetoothCar bluetoothCar;
    public boolean timeToCloseConnection = false;
    private final long TIMER_DELAY;
    private TimerTask disconnectTimerTask;
    private Timer disconnectTimer;

    public CarAPI(BluetoothCar bluetoothCar) {
        this.TIMER_DELAY = 10000L;
        this.bluetoothCar = bluetoothCar;
        this.disconnectTimerTask = new TimerTask(){

            public void run() {
                if (!CarAPI.this.isAppActive()) {
                    CarAPI.this.timeToCloseConnection = true;
                }
            }
        };
    }

    public boolean isAppActive() {
        return this.appActive;
    }

    public void setAppActive(boolean bl) {
        this.appActive = bl;
        if (bl) {
            this.stopTimer();
            this.stopWaiting();
        } else {
            this.setSpeed(0);
            this.setDirection(9);
            this.startDisconnectTimer();
        }
    }

    public void startDisconnectTimer() {
        this.stopTimer();
        this.disconnectTimer = new Timer();
        this.disconnectTimer.schedule(this.disconnectTimerTask, 10000L);
    }

    public void stopTimer() {
        if (this.disconnectTimer != null) {
            this.disconnectTimer.cancel();
        }
    }

    public synchronized void waitUntilActive() {
        if (!this.appActive && this.status == 6 && this.bluetoothCar.guiUpdated()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void stopWaiting() {
        this.notifyAll();
    }

    public void setStatus(int n) {
        if (n == this.status) {
            return;
        }
        if (n >= 4 && n <= 6) {
            this.status = n;
            this.stopWaiting();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isSpeedChanged() {
        return this.speedChanged;
    }

    public void setSpeed(int n) {
        if (n == this.speed) {
            return;
        }
        if (n >= -1 && n <= 3) {
            this.speed = n;
            this.speedChanged = true;
        }
    }

    public void incSpeed() {
        if (this.speed == 3) {
            return;
        }
        ++this.speed;
        this.speedChanged = true;
    }

    public void decSpeed() {
        if (this.speed == -1) {
            return;
        }
        --this.speed;
        this.speedChanged = true;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getAndClearSpeed() {
        this.speedChanged = false;
        return this.speed;
    }

    public boolean isDirectionChanged() {
        return this.directionChanged;
    }

    public void setDirection(int n) {
        if (n == this.direction) {
            return;
        }
        if (n >= 7 && n <= 11) {
            this.direction = n;
            this.directionChanged = true;
        }
    }

    public void turnLeft() {
        if (this.direction == 7) {
            return;
        }
        --this.direction;
        this.directionChanged = true;
    }

    public void turnRight() {
        if (this.direction == 11) {
            return;
        }
        ++this.direction;
        this.directionChanged = true;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getAndClearDirection() {
        this.directionChanged = false;
        return this.direction;
    }

    public void stop() {
        if (this.speed == 0) {
            return;
        }
        this.speed = 0;
        this.speedChanged = true;
    }
}

