/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.DateId;
import JabpLite.JabpLite;
import JabpLite.Split;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class FindView
extends Canvas
implements CommandListener {
    Transaction t;
    Transaction t1;
    Transaction oldT;
    Transaction previousT;
    TransactionStore ts;
    Alert alert;
    Calendar calendar;
    Display display;
    Font font;
    JabpLite parent;
    String oldName = "";
    String categoryString;
    int width;
    int height;
    int actionKey;
    int upKey;
    int downKey;
    int leftKey;
    int rightKey;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int oldId;
    int startPos;
    int totalFound;
    int dateWidth;
    int numberWidth;
    int reconciledWidth;
    int descriptionWidth;
    int descriptionPosition;
    int amountPosition;
    int currencyRate;
    boolean fromCategoryView;

    public FindView(JabpLite jabpLite, Display display, String string, boolean bl) {
        this.parent = jabpLite;
        this.display = display;
        this.categoryString = string;
        this.fromCategoryView = bl;
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.okCommand);
        this.setCommandListener(this);
        this.calendar = Calendar.getInstance();
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.dateWidth = this.font.stringWidth("99/99");
        this.numberWidth = this.font.stringWidth("999999.99");
        this.reconciledWidth = this.font.stringWidth(" r");
        this.setPositions();
        this.numItemsPage = this.height / this.fontHeight - 2;
        this.actionKey = this.getKeyCode(8);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.ts = new TransactionStore(this.parent, new Account());
        this.numItems = this.parent.findHt.size();
        this.currentX = 0;
        this.currentY = this.fontHeight;
        this.currentPos = 0;
        this.startPos = 0;
    }

    public void paint(Graphics graphics) {
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.numItemsPage = this.height / this.fontHeight - 2;
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.fontHeight * i + this.fontHeight, this.width, this.fontHeight);
                graphics.setColor(0);
            }
            this.t = this.getTransactionFromIndex(i + this.startPos);
            this.buildLine(graphics, this.t, this.fontHeight * i + this.fontHeight);
        }
        this.t = this.getTransactionFromIndex(this.startPos + this.currentPos);
    }

    Transaction getTransactionFromIndex(int n) {
        short s = (short)n;
        int n2 = ((DateId)this.parent.findHt.get((Object)new Short((short)s))).id;
        return this.ts.getTransaction(n2);
    }

    void showHeader(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString(this.numItems + " \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f\u043c", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString("\u0418\u0442\u043e\u0433\u043e", this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        String string = Utilities.numberToString(this.parent.totalFound, false);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.fontHeight;
            --this.currentPos;
            this.previousT = new Transaction();
            this.previousT.clone(this.t);
            this.t = this.getTransactionFromIndex(this.startPos + this.currentPos);
            if (this.currentY < this.fontHeight) {
                this.currentY = this.fontHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            }
            this.repaint();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.fontHeight;
            ++this.currentPos;
            this.previousT = new Transaction();
            this.previousT.clone(this.t);
            this.t = this.getTransactionFromIndex(this.startPos + this.currentPos);
            if (this.currentY + this.fontHeight * 2 > this.height) {
                this.currentY -= this.fontHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
    }

    String setPageDate(Date date) {
        this.calendar.setTime(date);
        String string = "" + this.calendar.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.calendar.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (this.parent.dateFormat == 1) {
            return string2 + "/" + string;
        }
        return string + "/" + string2;
    }

    String setReconciled(boolean bl) {
        if (bl) {
            return " r";
        }
        return "";
    }

    void buildLine(Graphics graphics, Transaction transaction, int n) {
        int n2;
        graphics.drawString(this.setPageDate(transaction.date), this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
        int n3 = transaction.description.length();
        for (int i = 0; i < n3; ++i) {
            n2 = n3 - i;
            if (this.font.stringWidth(transaction.description.substring(0, n2)) > this.descriptionWidth) continue;
            graphics.drawString(transaction.description.substring(0, n2), this.descriptionPosition, n + this.parent.fontAdjustment, 20);
            break;
        }
        String string = Utilities.numberToString(transaction.amount, false);
        if (!this.categoryString.equals("") && transaction.splitFlag) {
            for (n2 = 0; n2 < this.t.ss.size(); ++n2) {
                Split split = this.t.ss.getSplit(n2);
                if (this.fromCategoryView) {
                    if (!split.category.equals(this.categoryString)) continue;
                    string = Utilities.numberToString(split.amount, false);
                    continue;
                }
                if (split.category.toLowerCase().indexOf(this.categoryString) < 0) continue;
                string = Utilities.numberToString(split.amount, false);
            }
        }
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
        graphics.drawString(this.setReconciled(transaction.reconciled), this.width - this.reconciledWidth - this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
    }

    void setPositions() {
        this.descriptionWidth = this.width - this.numberWidth - this.dateWidth - this.reconciledWidth - this.parent.widthAdjustment * 2 - 30;
        this.descriptionPosition = this.dateWidth + this.parent.widthAdjustment + 10;
        this.amountPosition = this.descriptionPosition + this.descriptionWidth + 10;
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void keyPressed(int n) {
        if (n == this.leftKey || n == -3) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.fontHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (n == this.rightKey || n == -4) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.fontHeight + this.fontHeight;
            }
            this.repaint();
            return;
        }
        if (n == this.actionKey || n == -5) {
            return;
        }
        if (n == this.upKey) {
            this.drawUp();
            return;
        }
        if (n == this.downKey) {
            this.drawDown();
            return;
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 < this.fontHeight) {
            this.keyPressed(this.leftKey);
            return;
        }
        if (n2 > this.height - this.fontHeight) {
            this.keyPressed(this.rightKey);
            return;
        }
        int n3 = (n2 - this.fontHeight) / this.fontHeight;
        while (n3 > this.currentPos) {
            this.drawDown();
        }
        while (n3 < this.currentPos) {
            this.drawUp();
        }
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        this.parent.findHt = null;
        this.ts.closeTransactionStore();
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this && command == this.parent.okCommand) {
            if (this.fromCategoryView) {
                this.display.setCurrent((Displayable)this.parent.cv);
            } else {
                this.display.setCurrent((Displayable)this.parent.av);
            }
        }
    }
}

