/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.Category;
import JabpLite.CategoryForm;
import JabpLite.CategoryStore;
import JabpLite.CurrencyView;
import JabpLite.FindForm;
import JabpLite.FindView;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.PreferenceForm;
import JabpLite.Split;
import JabpLite.StandingOrder;
import JabpLite.StandingOrderStore;
import JabpLite.StandingOrderView;
import JabpLite.TopExpenses;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;

public class CategoryView
extends Canvas
implements CommandListener,
Runnable {
    Category c;
    Category c1;
    Category oldC;
    Category previousC;
    CategoryForm cf;
    Form debug;
    CategoryStore cs;
    Alert alert;
    Display display;
    Font font;
    PreferenceForm pf;
    FindForm ff;
    ViewForm vl;
    JabpLite parent;
    String msg = "";
    Command topExpensesCommand = new Command("\u041e\u0441\u043d.\u0420\u0430\u0441\u0445\u043e\u0434\u044b", 1, 5);
    int width;
    int height;
    int actionKey;
    int upKey;
    int downKey;
    int leftKey;
    int rightKey;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int oldPos;
    int oldId;
    int startPos;
    int numberWidth;
    int categoryWidth;
    int currentPosition;
    int totalCurrent;
    int runMode;

    public CategoryView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.findCommand);
        this.addCommand(this.topExpensesCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.numberWidth = this.font.stringWidth("999999.99");
        this.setPositions();
        this.numItemsPage = this.height / this.fontHeight - 2;
        this.actionKey = this.getKeyCode(8);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.cs = new CategoryStore(this.parent);
        this.numItems = this.cs.getNumCategories();
        this.setTotals();
        this.currentX = 0;
        this.currentY = this.fontHeight;
        this.currentPos = 0;
        this.startPos = 0;
    }

    public void paint(Graphics graphics) {
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.numItemsPage = this.height / this.fontHeight - 2;
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.fontHeight * i + this.fontHeight, this.width, this.fontHeight);
                graphics.setColor(0);
            }
            this.c = this.cs.getCategoryFromIndex(i + this.startPos);
            this.buildLine(graphics, this.c, this.fontHeight * i + this.fontHeight);
        }
        this.c = this.cs.getCategoryFromIndex(this.startPos + this.currentPos);
    }

    void showHeader(Graphics graphics) {
        if (this.msg.equals("")) {
            graphics.setColor(this.parent.colorHeading);
            graphics.fillRect(0, 0, this.width, this.fontHeight);
            graphics.setColor(0);
            graphics.drawString("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
            graphics.drawString("\u0412\u0430\u043b\u044e\u0442\u0430", this.currentPosition + this.numberWidth - this.font.stringWidth("\u0412\u0430\u043b\u044e\u0442\u0430"), this.parent.fontAdjustment, 20);
        } else {
            graphics.setColor(this.parent.colorRed);
            graphics.fillRect(0, 0, this.width, this.fontHeight);
            graphics.setColor(0);
            graphics.drawString(this.msg, this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        }
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString("\u0418\u0442\u043e\u0433\u043e", this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        String string = Utilities.numberToString(this.totalCurrent, false);
        graphics.drawString(string, this.currentPosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.fontHeight;
            --this.currentPos;
            this.previousC = new Category();
            this.previousC.clone(this.c);
            this.c = this.cs.getCategoryFromIndex(this.startPos + this.currentPos);
            if (this.currentY < this.fontHeight) {
                this.currentY = this.fontHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            }
            this.repaint();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.fontHeight;
            ++this.currentPos;
            this.previousC = new Category();
            this.previousC.clone(this.c);
            this.c = this.cs.getCategoryFromIndex(this.startPos + this.currentPos);
            if (this.currentY + this.fontHeight * 2 > this.height) {
                this.currentY -= this.fontHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
    }

    void buildLine(Graphics graphics, Category category, int n) {
        int n2 = category.name.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = n2 - i;
            if (this.font.stringWidth(category.name.substring(0, n3)) > this.categoryWidth) continue;
            graphics.drawString(category.name.substring(0, n3), this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
            break;
        }
        String string = Utilities.numberToString(category.current, false);
        graphics.drawString(string, this.currentPosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
    }

    void setPositions() {
        this.categoryWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.currentPosition = this.categoryWidth + this.parent.widthAdjustment + 10;
    }

    Category showCategory() {
        this.oldC = new Category();
        this.oldC.clone(this.c);
        return this.c;
    }

    void newCategory(Category category) {
        this.c1 = category;
        this.c1.id = this.cs.saveNewCategory(this.c1);
        if (this.c == null) {
            this.c = this.c1;
        }
        ++this.numItems;
        this.totalCurrent += this.c1.current;
        this.repaint();
    }

    void editCategory(Category category) {
        this.c1 = category;
        this.cs.saveExistingCategory(this.c1);
        this.totalCurrent += this.c1.current - this.oldC.current;
        if (!this.c1.name.equals(this.oldC.name)) {
            this.runMode = 1;
            this.display.callSerially((Runnable)this);
        } else {
            this.msg = "";
        }
        this.repaint();
    }

    void deleteCategory(Category category) {
        this.c1 = category;
        this.cs.deleteCategory(this.c1);
        this.cs.deleteIndex(this.startPos + this.currentPos);
        this.totalCurrent -= this.c1.current;
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.fontHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void setTotals() {
        this.totalCurrent = 0;
        for (int i = 0; i < this.numItems; ++i) {
            this.c = this.cs.getCategoryFromIndex(i);
            this.totalCurrent += this.c.current;
        }
        this.c = this.cs.getCategoryFromIndex(0);
    }

    void updateCategoryName() {
        this.cs.deleteIndex(this.startPos + this.currentPos);
        this.cs.addIndex(this.c1);
        TransactionStore transactionStore = new TransactionStore(this.parent, new Account());
        RecordEnumeration recordEnumeration = transactionStore.getTransactions();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Transaction transaction = transactionStore.getTransaction(n);
                if (transaction.splitFlag) {
                    boolean bl = false;
                    for (int i = 0; i < transaction.ss.size(); ++i) {
                        Split split = transaction.ss.getSplit(i);
                        if (!split.category.equals(this.oldC.name)) continue;
                        split.category = this.c1.name;
                        transaction.ss.setSplit(split, i);
                        bl = true;
                    }
                    if (!bl) continue;
                    transactionStore.saveExistingTransaction(transaction);
                    continue;
                }
                if (!transaction.category.equals(this.oldC.name)) continue;
                transaction.category = this.c1.name;
                transactionStore.saveExistingTransaction(transaction);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cv5");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        transactionStore.closeTransactionStore();
        transactionStore = null;
        StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
        recordEnumeration = standingOrderStore.getStandingOrders();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                StandingOrder standingOrder = standingOrderStore.getStandingOrder(n);
                if (!standingOrder.category.equals(this.oldC.name)) continue;
                standingOrder.category = this.c1.name;
                standingOrderStore.saveExistingStandingOrder(standingOrder);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cv5a");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        standingOrderStore.closeStandingOrderStore();
        standingOrderStore = null;
        if (this.parent.tv != null) {
            this.parent.tv.runThread();
        }
        if (this.parent.sov != null) {
            this.parent.sov.runThread();
        }
        this.msg = "";
        this.repaint();
    }

    protected void showNotify() {
        this.repaint();
    }

    void processFind() {
        this.ff.execute2(this.c.name);
        this.ff = null;
        this.msg = "";
        FindView findView = new FindView(this.parent, this.display, this.c.name, true);
        this.display.setCurrent((Displayable)findView);
    }

    public void run() {
        if (this.runMode == 1) {
            this.updateCategoryName();
        }
        if (this.runMode == 2) {
            this.processFind();
        }
    }

    protected void keyPressed(int n) {
        if (n == this.leftKey || n == -3) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.fontHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (n == this.rightKey || n == -4) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.fontHeight + this.fontHeight;
            }
            this.repaint();
            return;
        }
        if (n == this.actionKey) {
            // empty if block
        }
        if (n == this.upKey) {
            this.drawUp();
            return;
        }
        if (n == this.downKey) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("\u0417\u0430\u043f\u0438\u0441\u044c \u0421\u0432\u043e\u0439\u0441\u0442\u0432");
            this.debug.append("\u041f\u043e\u0437\u0438\u0446\u0438\u044f" + n2 + "\u0438\u0437" + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((NameId)this.cs.ht.get((Object)new Short((short)s))).id;
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c ID " + n3 + "\n");
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c \u0414\u043b\u0438\u043d\u044b" + this.cs.getRecordSize(n3) + "\n");
            this.debug.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0417\u0430\u043f\u0438\u0441\u0438 \u0418\u0441\u0442\u043e\u0440\u0438\u0438 " + this.cs.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 < this.fontHeight) {
            this.keyPressed(this.leftKey);
            return;
        }
        if (n2 > this.height - this.fontHeight) {
            this.keyPressed(this.rightKey);
            return;
        }
        int n3 = (n2 - this.fontHeight) / this.fontHeight;
        while (n3 > this.currentPos) {
            this.drawDown();
        }
        while (n3 < this.currentPos) {
            this.drawUp();
        }
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        Object object;
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                this.cf = new CategoryForm(this.parent, new Category(), "\u041d\u043e\u0432\u044b\u0439 ");
                this.cf.addCommand(this.parent.createCommand);
                this.cf.addCommand(this.parent.cancelCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.msg = "\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438, \u0436\u0434\u0438\u0442\u0435...";
                this.repaint();
                this.cf = new CategoryForm(this.parent, this.showCategory(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                this.cf.addCommand(this.parent.updateCommand);
                this.cf.addCommand(this.parent.cancelCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.cf = new CategoryForm(this.parent, this.showCategory(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
                this.cf.addCommand(this.parent.deleteCommand);
                this.cf.addCommand(this.parent.cancelCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.mainCommand) {
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
            if (command == this.parent.findCommand) {
                this.msg = "\u0414\u0443\u043c\u0430\u044e, \u0436\u0434\u0438\u0442\u0435...";
                this.repaint();
                this.ff = new FindForm(this.parent, false);
                this.runMode = 2;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
            if (command == this.topExpensesCommand) {
                object = new TopExpenses(this.parent, this.display);
                this.display.setCurrent((Displayable)object);
            }
        }
        if (displayable == this.cf) {
            if (command == this.parent.deleteCommand) {
                this.cf = null;
                if (this.c.current != 0 || this.c.open != 0) {
                    this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0441\u0442\u044c \u0411\u0430\u043b\u0430\u043d\u0441\u044b");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                object = new StandingOrderStore(this.parent);
                RecordEnumeration recordEnumeration = ((StandingOrderStore)object).getStandingOrders();
                try {
                    while (recordEnumeration.hasNextElement()) {
                        int n = recordEnumeration.nextRecordId();
                        StandingOrder standingOrder = ((StandingOrderStore)object).getStandingOrder(n);
                        if (!standingOrder.category.equals(this.c.name)) continue;
                        this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0441\u0442\u044c \u041f\u043e\u0441\u0442. \u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u044f");
                        this.display.setCurrent(this.alert, (Displayable)this);
                        recordEnumeration.destroy();
                        recordEnumeration = null;
                        ((StandingOrderStore)object).closeStandingOrderStore();
                        object = null;
                        return;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " cv5a");
                }
                recordEnumeration.destroy();
                recordEnumeration = null;
                ((StandingOrderStore)object).closeStandingOrderStore();
                object = null;
                this.display.setCurrent((Displayable)this);
                this.deleteCategory(this.c);
            }
            if (command == this.parent.createCommand) {
                this.c1 = this.cf.update();
                if (this.c1.name.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                if (this.cs.lookUpId(this.c1) != 0) {
                    this.alert.setString(this.c1.name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                this.display.setCurrent((Displayable)this);
                this.newCategory(this.c1);
                this.cf = null;
            }
            if (command == this.parent.updateCommand) {
                this.c1 = this.cf.update();
                if (this.c1.name.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                int n = this.c1.id;
                if (!this.c1.name.equals(this.oldC.name) && this.cs.lookUpId(this.c1) != 0) {
                    this.alert.setString(this.c1.name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                this.c1.id = n;
                this.display.setCurrent((Displayable)this);
                this.editCategory(this.c1);
                this.cf = null;
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.cf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.vl = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv == null) {
                        this.alert.setString("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u044c");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    } else {
                        this.display.setCurrent((Displayable)this.parent.tv);
                    }
                }
                if (this.vl.update() == 2) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
    }
}

