/*
 * Decompiled with CFR 0.152.
 */
package trezor;

import javax.microedition.rms.RecordStore;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class PasswordMgr {
    byte[] digest;
    private static final String STORE = "trezor.digest";

    public PasswordMgr() {
        this.loadDigest();
    }

    public boolean match(String string) {
        if (this.digest == null) {
            return false;
        }
        byte[] byArray = this.createDigest(string);
        if (this.digest.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (this.digest[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void initialize(String string) {
        if (string == null) {
            try {
                RecordStore.deleteRecordStore((String)STORE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.digest = null;
        } else {
            this.digest = this.createDigest(string);
            this.saveDigest();
        }
    }

    public boolean isInitialized() {
        return this.digest != null;
    }

    private byte[] createDigest(String string) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = string.getBytes();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDigest() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)STORE, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                return;
            }
            this.digest = recordStore.getRecord(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDigest() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)STORE, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(this.digest, 0, this.digest.length);
            } else {
                recordStore.setRecord(1, this.digest, 0, this.digest.length);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

