/*
 * Decompiled with CFR 0.152.
 */
package trezor;

import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import trezor.CryptMgr;
import trezor.Entry;

public class EntryMgr {
    private static final String STORE = "trezor.data";
    private static byte[] EMTY_DATA = new byte[0];
    private CryptMgr cryptMgr;
    private Vector entries = new Vector();

    public EntryMgr(CryptMgr cryptMgr) {
        this.cryptMgr = cryptMgr;
    }

    public void deleteAll() {
        try {
            RecordStore.deleteRecordStore((String)STORE);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.entries.removeAllElements();
    }

    public Entry createEntry(String string, String string2) {
        Entry entry = new Entry(string, string2);
        this.entries.addElement(entry);
        this.saveEntry(entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntry(Entry entry) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)STORE, (boolean)true);
            recordStore.deleteRecord(entry.getId());
            this.entries.removeElement(entry);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    public void changeEntry(Entry entry) {
        this.saveEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEntry(Entry entry) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)STORE, (boolean)true);
            byte[] byArray = entry.getBytes();
            byArray = this.cryptMgr.encrypt(byArray);
            int n = entry.getId();
            if (n == 0) {
                n = recordStore.addRecord(byArray, 0, byArray.length);
                entry.setId(n);
            } else {
                recordStore.setRecord(n, byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        this.entries.removeAllElements();
        try {
            recordStore = RecordStore.openRecordStore((String)STORE, (boolean)true);
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                byte[] byArray = recordStore.getRecord(n);
                byArray = this.cryptMgr.decrypt(byArray);
                Entry entry = new Entry(n, byArray);
                this.entries.addElement(entry);
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        finally {
            if (recordEnumeration != null) {
                recordEnumeration.destroy();
            }
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    public Vector getEntries() {
        return this.entries;
    }
}

