/*
 * Decompiled with CFR 0.152.
 */
package p;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import p.RGBColor;

public class Instrument {
    public static final int TOOL_CIRCLE = 3;
    public static final int TOOL_END = 5;
    public static final int TOOL_FILL = 1;
    public static final int TOOL_LINE = 2;
    public static final int TOOL_PENCIL = 0;
    public static final int TOOL_RECT = 4;
    RGBColor[] color;
    private Image imTool;
    private String[] namesTools = new String[5];
    private int[] toolParam;
    private int toolType;
    private boolean toolUsed;

    public Instrument() {
        this.namesTools[0] = "pencil";
        this.namesTools[1] = "fill";
        this.namesTools[2] = "line";
        this.namesTools[3] = "circle";
        this.namesTools[4] = "rect";
        this.toolType = 0;
        this.toolParam = new int[5];
        this.color = new RGBColor[2];
        this.toolParam[0] = 1;
        this.color[0] = new RGBColor(0, 0, 0);
        this.color[1] = new RGBColor(255, 255, 255);
        try {
            this.imTool = Image.createImage((String)("/p/" + this.namesTools[this.toolType] + ".png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawColors(Graphics g, int x, int y) {
        g.setColor(this.color[0].GetInt());
        g.fillRect(x, y, 4, 8);
        g.setColor(this.color[1].GetInt());
        g.fillRect(x + 5, y, 4, 8);
    }

    public void drawIcon(Graphics g, int x, int y) {
        g.drawImage(this.imTool, x, y, 20);
    }

    public void drawParamIcon(Graphics g, int x, int y) {
        switch (this.toolType) {
            case 0: {
                this.color[0].invert();
                g.setColor(this.color[0].GetInt());
                g.fillRect(x, y, this.toolParam[0] + 2, this.toolParam[0] + 2);
                this.color[0].invert();
                g.setColor(this.color[0].GetInt());
                g.fillRect(x + 1, y + 1, this.toolParam[0], this.toolParam[0]);
                break;
            }
            case 4: {
                if (this.toolParam[0] == 1) {
                    g.setColor(255, 0, 0);
                    g.drawLine(x, y, x + 7, y + 7);
                    g.drawLine(x + 7, y, x, y + 7);
                    g.drawRect(x, y, 7, 7);
                    break;
                }
                this.color[0].invert();
                g.setColor(this.color[0].GetInt());
                g.fillRect(x, y, this.toolParam[0] + 2, this.toolParam[0] + 2);
                this.color[0].invert();
                g.setColor(this.color[0].GetInt());
                g.fillRect(x + 1, y + 1, this.toolParam[0], this.toolParam[0]);
                break;
            }
            default: {
                g.setColor(255, 0, 0);
                g.drawLine(x, y, x + 7, y + 7);
                g.drawLine(x + 7, y, x, y + 7);
                g.drawRect(x, y, 7, 7);
            }
        }
    }

    public RGBColor getColor() {
        return this.color[0];
    }

    public int getParam(int idx) {
        return this.toolParam[idx];
    }

    public int getToolType() {
        return this.toolType;
    }

    public boolean isUsed() {
        return this.toolUsed;
    }

    public void setColor(int r, int g, int b) {
        this.color[0] = new RGBColor(r, g, b);
    }

    public void setParam(int idx, int param) {
        this.toolParam[idx] = param;
    }

    public void setToolType(int type) {
        this.toolType = type;
        try {
            this.imTool = Image.createImage((String)("/p/" + this.namesTools[this.toolType] + ".png"));
            this.toolUsed = false;
            this.toolParam[0] = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void swapColors() {
        RGBColor tmp = new RGBColor(this.color[0].r, this.color[0].g, this.color[0].b);
        this.color[0] = new RGBColor(this.color[1].r, this.color[1].g, this.color[1].b);
        this.color[1] = new RGBColor(tmp.r, tmp.g, tmp.b);
    }

    public void switchMode() {
        if (this.toolUsed) {
            this.unUse();
        } else {
            this.use();
        }
    }

    private void unUse() {
        try {
            this.imTool = Image.createImage((String)("/p/" + this.namesTools[this.toolType] + ".png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.toolUsed = false;
    }

    private void use() {
        try {
            this.imTool = Image.createImage((String)("/p/" + this.namesTools[this.toolType] + "_use.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.toolUsed = true;
    }
}

