/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.Regular;
import JabpLite.Split;
import JabpLite.SplitStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RegularStore {
    RecordStore rs;
    JabpLite parent;
    Hashtable ht;

    public RegularStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        this.ht = this.parent.regularHt;
        this.openRegularStore();
    }

    void openRegularStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)"\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u044b\u0435", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs1");
        }
    }

    void closeRegularStore() {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs2");
        }
    }

    int getNumRegulars() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs3");
            return 0;
        }
    }

    RecordEnumeration getRegulars() {
        if (this.rs == null) {
            return null;
        }
        try {
            return this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs6");
            return null;
        }
    }

    byte[] toByteArray(Regular regular) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(regular.description);
            dataOutputStream.writeInt(regular.amount);
            dataOutputStream.writeUTF(regular.reference);
            dataOutputStream.writeUTF(regular.category);
            dataOutputStream.writeBoolean(regular.transferFlag);
            if (regular.transferFlag) {
                dataOutputStream.writeUTF(regular.transferAccount);
            }
            dataOutputStream.writeBoolean(regular.splitFlag);
            if (regular.splitFlag) {
                dataOutputStream.writeInt(regular.ss.size());
                for (int i = 0; i < regular.ss.size(); ++i) {
                    Split split = regular.ss.getSplit(i);
                    dataOutputStream.writeInt(split.amount);
                    dataOutputStream.writeUTF(split.category);
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    Regular fromByteArray(byte[] byArray) {
        Regular regular = new Regular();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            regular.description = dataInputStream.readUTF();
            regular.amount = dataInputStream.readInt();
            regular.reference = dataInputStream.readUTF();
            regular.category = dataInputStream.readUTF();
            regular.transferFlag = dataInputStream.readBoolean();
            if (regular.transferFlag) {
                regular.transferAccount = dataInputStream.readUTF();
            }
            regular.splitFlag = dataInputStream.readBoolean();
            if (regular.splitFlag) {
                regular.ss = new SplitStore();
                int n = dataInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    Split split = new Split();
                    split.amount = dataInputStream.readInt();
                    split.category = dataInputStream.readUTF();
                    regular.ss.addSplit(split);
                }
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " rs4a");
        }
        return regular;
    }

    Regular getRegular(int n) {
        Regular regular = new Regular();
        try {
            byte[] byArray = this.rs.getRecord(n);
            regular = this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs4 record " + n);
        }
        regular.id = n;
        return regular;
    }

    Regular getRegularFromIndex(int n) {
        short s = (short)n;
        int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
        return this.getRegular(n2);
    }

    Regular getRegularFromName(String string) {
        int n = this.getNumRegulars();
        for (int i = 0; i < n; ++i) {
            short s = (short)i;
            String string2 = ((NameId)this.ht.get((Object)new Short((short)s))).name;
            if (!string2.equals(string)) continue;
            int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
            return this.getRegular(n2);
        }
        Regular regular = new Regular();
        regular.description = string;
        regular.id = this.saveNewRegular(regular);
        return regular;
    }

    void deleteRegular(Regular regular) {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.deleteRecord(regular.id);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs5");
        }
    }

    int saveNewRegular(Regular regular) {
        if (this.rs == null) {
            return 0;
        }
        try {
            regular.id = this.rs.getNextRecordID();
            byte[] byArray = this.toByteArray(regular);
            this.rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs7");
        }
        this.addIndex(regular);
        return regular.id;
    }

    void saveExistingRegular(Regular regular) {
        if (this.rs == null) {
            return;
        }
        if (regular.id == 0) {
            System.out.println("Id error in saveExistingRegular()");
            return;
        }
        try {
            byte[] byArray = this.toByteArray(regular);
            this.rs.setRecord(regular.id, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs7a");
        }
    }

    int lookUpId(Regular regular) {
        regular.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(regular.description)) continue;
            regular.id = ((NameId)this.ht.get((Object)s)).id;
            break;
        }
        return regular.id;
    }

    int lookUpIndex(Regular regular) {
        int n = this.ht.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(regular.description)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    void deleteIndex(int n) {
        int n2 = this.ht.size();
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i + 1;
            NameId nameId = (NameId)this.ht.get(new Short((short)n3));
            this.ht.put(new Short((short)i), nameId);
        }
        this.ht.remove(new Short((short)(n2 - 1)));
    }

    void addIndex(Regular regular) {
        int n;
        int n2;
        int n3 = n2 = this.ht.size();
        for (n = 0; n < n2; ++n) {
            NameId nameId = (NameId)this.ht.get(new Short((short)n));
            if (regular.description.compareTo(nameId.name) >= 0) continue;
            n3 = n;
            break;
        }
        if (n3 < n2) {
            for (n = n2 - 1; n >= n3; --n) {
                int n4 = n + 1;
                NameId nameId = (NameId)this.ht.get(new Short((short)n));
                this.ht.put(new Short((short)n4), nameId);
            }
        }
        NameId nameId = new NameId(regular.description, regular.id);
        this.ht.put(new Short((short)n3), nameId);
    }

    void compressRegulars() {
        try {
            byte[] byArray;
            this.parent.regularHt = new Hashtable();
            this.ht = this.parent.regularHt;
            RecordStore recordStore = RecordStore.openRecordStore((String)"Temp", (boolean)true);
            RecordEnumeration recordEnumeration = this.getRegulars();
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            this.closeRegularStore();
            RecordStore.deleteRecordStore((String)"\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u044b\u0435");
            this.openRegularStore();
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                Regular regular = this.fromByteArray(byArray);
                regular.id = this.rs.addRecord(byArray, 0, byArray.length);
                this.addIndex(regular);
            }
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"Temp");
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs8");
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " rs9");
            return 0;
        }
    }
}

