/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Investment;
import JabpLite.JabpLite;
import JabpLite.NameId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class InvestmentStore {
    RecordStore rs;
    JabpLite parent;
    Hashtable ht;

    public InvestmentStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        this.ht = this.parent.investmentHt;
        this.openInvestmentStore();
    }

    void openInvestmentStore() {
        try {
            this.rs = RecordStore.openRecordStore((String)"\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is1");
        }
    }

    void closeInvestmentStore() {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is2");
        }
    }

    int getNumInvestments() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is3");
            return 0;
        }
    }

    RecordEnumeration getInvestments() {
        if (this.rs == null) {
            return null;
        }
        try {
            return this.rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is6");
            return null;
        }
    }

    byte[] toByteArray(Investment investment) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(investment.name);
            dataOutputStream.writeUTF(investment.description);
            dataOutputStream.writeUTF(investment.currency);
            dataOutputStream.writeInt(investment.holding);
            dataOutputStream.writeInt(investment.price);
            dataOutputStream.writeLong(investment.priceDate.getTime());
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    Investment fromByteArray(byte[] byArray) {
        Investment investment = new Investment(this.parent);
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            investment.name = dataInputStream.readUTF();
            investment.description = dataInputStream.readUTF();
            investment.currency = dataInputStream.readUTF();
            investment.holding = dataInputStream.readInt();
            investment.price = dataInputStream.readInt();
            investment.priceDate = new Date(dataInputStream.readLong());
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " is4a");
        }
        return investment;
    }

    Investment getInvestment(int n) {
        Investment investment = new Investment(this.parent);
        try {
            byte[] byArray = this.rs.getRecord(n);
            investment = this.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is4 record " + n);
        }
        investment.id = n;
        return investment;
    }

    Investment getInvestmentFromIndex(int n) {
        short s = (short)n;
        int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
        return this.getInvestment(n2);
    }

    Investment getInvestmentFromName(String string) {
        int n = this.getNumInvestments();
        for (int i = 0; i < n; ++i) {
            short s = (short)i;
            String string2 = ((NameId)this.ht.get((Object)new Short((short)s))).name;
            if (!string2.equals(string)) continue;
            int n2 = ((NameId)this.ht.get((Object)new Short((short)s))).id;
            return this.getInvestment(n2);
        }
        Investment investment = new Investment(this.parent);
        investment.name = string;
        investment.id = this.saveNewInvestment(investment);
        if (this.parent.iv != null) {
            ++this.parent.iv.numItems;
        }
        return investment;
    }

    void deleteInvestment(Investment investment) {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.deleteRecord(investment.id);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is5");
        }
    }

    int saveNewInvestment(Investment investment) {
        if (this.rs == null) {
            return 0;
        }
        try {
            investment.id = this.rs.getNextRecordID();
            byte[] byArray = this.toByteArray(investment);
            this.rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is7");
        }
        this.addIndex(investment);
        return investment.id;
    }

    void saveExistingInvestment(Investment investment) {
        if (this.rs == null) {
            return;
        }
        if (investment.id == 0) {
            System.out.println("Id error in saveExistingInvestment()");
            return;
        }
        try {
            byte[] byArray = this.toByteArray(investment);
            this.rs.setRecord(investment.id, byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is7a");
        }
    }

    int lookUpId(Investment investment) {
        investment.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(investment.name)) continue;
            investment.id = ((NameId)this.ht.get((Object)s)).id;
            break;
        }
        return investment.id;
    }

    int lookUpIndex(Investment investment) {
        int n = this.ht.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Short s = new Short((short)i);
            String string = ((NameId)this.ht.get((Object)s)).name;
            if (!string.equals(investment.name)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    void deleteIndex(int n) {
        int n2 = this.ht.size();
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i + 1;
            NameId nameId = (NameId)this.ht.get(new Short((short)n3));
            this.ht.put(new Short((short)i), nameId);
        }
        this.ht.remove(new Short((short)(n2 - 1)));
    }

    void addIndex(Investment investment) {
        int n;
        int n2;
        int n3 = n2 = this.ht.size();
        for (n = 0; n < n2; ++n) {
            NameId nameId = (NameId)this.ht.get(new Short((short)n));
            if (investment.name.compareTo(nameId.name) >= 0) continue;
            n3 = n;
            break;
        }
        if (n3 < n2) {
            for (n = n2 - 1; n >= n3; --n) {
                int n4 = n + 1;
                NameId nameId = (NameId)this.ht.get(new Short((short)n));
                this.ht.put(new Short((short)n4), nameId);
            }
        }
        NameId nameId = new NameId(investment.name, investment.id);
        this.ht.put(new Short((short)n3), nameId);
    }

    void compressInvestments() {
        try {
            byte[] byArray;
            this.parent.investmentHt = new Hashtable();
            this.ht = this.parent.investmentHt;
            RecordStore recordStore = RecordStore.openRecordStore((String)"Temp", (boolean)true);
            RecordEnumeration recordEnumeration = this.getInvestments();
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            this.closeInvestmentStore();
            RecordStore.deleteRecordStore((String)"\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438");
            this.openInvestmentStore();
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                Investment investment = this.fromByteArray(byArray);
                investment.id = this.rs.addRecord(byArray, 0, byArray.length);
                this.addIndex(investment);
            }
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"Temp");
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is8");
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is9");
            return 0;
        }
    }

    int getRecordSize(int n) {
        try {
            return this.rs.getRecordSize(n);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " is10");
            return 0;
        }
    }
}

