/*
 * Decompiled with CFR 0.152.
 */
package map.visual;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import map.storage.MapStorager;
import map.visual.LabelLayout;
import map.visual.PolyLine;
import map.visual.SpatialEntity;
import map.visual.ViewPort;

public class MapVisualizer {
    private ViewPort a = null;
    private MapStorager b = null;
    public float viewRate = 1.0f;
    private static Font c = null;

    public MapVisualizer(MapStorager mapStorager, ViewPort viewPort) {
        this(mapStorager, viewPort, 0.0f, 0.0f);
    }

    public MapVisualizer(MapStorager mapStorager, ViewPort viewPort, float f, float f2) {
        this.b = mapStorager;
        this.a = viewPort;
        this.a.setLocation(f, f2);
        c = Font.getFont((int)32, (int)0, (int)8);
    }

    public void drawMap(Graphics graphics, PolyLine polyLine) {
        int n;
        float f;
        float f2 = this.a.getHorizontalSize() * this.viewRate;
        float f3 = this.a.getVertical() * this.viewRate;
        this.a.a = f = this.a.getHorizontalSize() / f2;
        Vector vector = this.b.regionQuery(this.a.getLocationX(), this.a.getLocationY(), this.a.getLocationX() + f2, this.a.getLocationY() + f3);
        int n2 = 0;
        LabelLayout labelLayout = new LabelLayout(5, c);
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                SpatialEntity spatialEntity = (SpatialEntity)vector.elementAt(n);
                if (spatialEntity == null) continue;
                switch (spatialEntity.getType()) {
                    case 16: {
                        n2 = 10930928;
                        break;
                    }
                    case 17: {
                        n2 = 39168;
                        break;
                    }
                    case 18: {
                        n2 = 52224;
                        break;
                    }
                    case 19: {
                        n2 = 0xCCCCCC;
                        break;
                    }
                    case 20: {
                        n2 = 0xFFCC00;
                        break;
                    }
                    case 5: {
                        n2 = 11473939;
                        break;
                    }
                    case 3: {
                        n2 = 9211248;
                        break;
                    }
                    case 8: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = 9211248;
                    }
                }
                spatialEntity.draw(graphics, this.a, n2);
                if (spatialEntity.d == null || SpatialEntity.e[0] == Integer.MAX_VALUE) continue;
                if (spatialEntity.a == 5) {
                    labelLayout.add(SpatialEntity.e, spatialEntity.d);
                    continue;
                }
                if (spatialEntity.a == 4 && this.viewRate <= 0.7f) {
                    labelLayout.add(SpatialEntity.e, spatialEntity.d);
                    continue;
                }
                if (spatialEntity.a != 3 || !(this.viewRate <= 0.3f)) continue;
                labelLayout.add(SpatialEntity.e, spatialEntity.d);
            }
        }
        if (polyLine != null) {
            polyLine.draw(graphics, this.a, 255);
            graphics.setColor(0xFF0000);
            graphics.fillArc((int)((polyLine.getPointX(0) - this.a.getLocationX()) * this.a.a) - 3, (int)((polyLine.getPointY(0) - this.a.getLocationY()) * this.a.a) - 3, 7, 7, 0, 360);
            graphics.fillArc((int)((polyLine.getPointX(polyLine.getPointsSize() - 1) - this.a.getLocationX()) * this.a.a) - 3, (int)((polyLine.getPointY(polyLine.getPointsSize() - 1) - this.a.getLocationY()) * this.a.a) - 3, 7, 7, 0, 360);
        }
        graphics.setFont(c);
        for (n = 0; n < labelLayout.size(); ++n) {
            labelLayout.drawLabel(n, graphics);
        }
    }

    public void setViewRate(float f) {
        this.viewRate = f;
    }

    public float getViewRate() {
        return this.viewRate;
    }

    public void setLocation(float f, float f2) {
        this.a.setLocation(f, f2);
    }

    public float getLocationX() {
        return this.a.getLocationX();
    }

    public float getLocationY() {
        return this.a.getLocationY();
    }

    public void translation(float f, float f2) {
        this.a.locationMove(f, f2);
    }
}

