/*
 * Decompiled with CFR 0.152.
 */
package compass;

import compass.EarthHeading;
import henson.midp.Float;

public class EarthPosition {
    private Float b;
    private Float a;

    public EarthPosition(int n, int n2) {
        this.b = new Float(n).Div(60L);
        this.a = new Float(n2).Div(60L);
    }

    public EarthPosition(int n, int n2, int n3, int n4) {
        this.b = new Float(n).Add(new Float(n2).Div(n < 0 ? -60L : 60L));
        this.a = new Float(n3).Add(new Float(n4).Div(n3 < 0 ? -60L : 60L));
    }

    public int latTotalMinutes() {
        return (int)Float.Int(this.b.Mul(60L)).toLong();
    }

    public int longTotalMinutes() {
        return (int)Float.Int(this.a.Mul(60L)).toLong();
    }

    public Float getLatitude() {
        return this.b;
    }

    public Float getLongitude() {
        return this.a;
    }

    public String latString() {
        return Math.abs(this.latTotalMinutes() / 60) + "\u00b0 " + Math.abs(this.latTotalMinutes()) % 60 + "' " + (this.latTotalMinutes() < 0 ? "\u042e.\u0428." : "\u0421.\u0428.");
    }

    public String longString() {
        return Math.abs(this.longTotalMinutes() / 60) + "\u00b0 " + Math.abs(this.longTotalMinutes()) % 60 + "' " + (this.longTotalMinutes() < 0 ? "\u0417.\u0414." : "\u0412.\u0414.");
    }

    public String toString() {
        return this.latString() + "\n" + this.longString();
    }

    public EarthHeading toEarthHeading(EarthPosition earthPosition) {
        Float float_ = Float.PI.Div(180L);
        Float float_2 = Float.toRadians(this.b);
        Float float_3 = new Float(earthPosition.latTotalMinutes()).Div(60L).Mul(float_);
        Float float_4 = Float.toRadians(this.a.Neg());
        Float float_5 = new Float(earthPosition.longTotalMinutes()).Div(60L).Mul(float_).Neg();
        Float float_6 = Float.sin(float_2.Sub(float_3).Div(2L));
        Float float_7 = Float.sin(float_4.Sub(float_5).Div(2L));
        Float float_8 = Float.asin(Float.sqrt(float_6.Mul(float_6).Add(Float.cos(float_2).Mul(Float.cos(float_3)).Mul(float_7.Mul(float_7))))).Mul(2L);
        Float float_9 = Float.sin(float_5.Sub(float_4)).Less(0L) ? Float.acos(Float.sin(float_3).Sub(Float.sin(float_2).Mul(Float.cos(float_8))).Div(Float.sin(float_8).Mul(Float.cos(float_2)))) : Float.PImul2.Sub(Float.acos(Float.sin(float_3).Sub(Float.sin(float_2).Mul(Float.cos(float_8))).Div(Float.sin(float_8).Mul(Float.cos(float_2)))));
        return new EarthHeading((int)float_9.Div(float_).toLong(), (int)float_8.Mul(6371L).toLong());
    }
}

