/*
 * Decompiled with CFR 0.152.
 */
package net.landspurg.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.landspurg.map.MapCanvas;
import net.landspurg.map.OneLoc;
import net.landspurg.map.OneLocSquare;
import net.landspurg.map.TrackListener;
import net.landspurg.map.TrackNotifier;
import net.landspurg.map.oneGPSPos;
import net.landspurg.util.NotifyLoadURL;
import net.landspurg.util.URLFetcher;
import net.landspurg.util.UtilMidp;
import org.kxml2.io.KXmlParser;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Track
implements NotifyLoadURL {
    public Display a;
    public Alert a;
    public String a;
    public boolean isInit = false;
    public int a;
    public int[] coordSeg;
    public long[] times = null;
    public float[] alts = null;
    public float[] courses = null;
    public float[] speeds = null;
    public static OneLoc m_defaultLocType = new OneLoc(0.0f, 0.0f);
    public OneLoc m_locType = m_defaultLocType;
    public String m_name = "Noname";
    public Vector listPlaces = new Vector();
    public byte[] savedTrack = null;
    public static TrackNotifier a = null;
    public TrackNotifier b;
    public int b = 0;
    public int c = 0;
    public boolean a;
    public int d = 0;
    public long a;
    public boolean m_autoDisplay = false;
    public static final int sizeElem = 28;
    public static final int sizeHeader = 88;
    public static ByteArrayOutputStream a = null;
    public static DataOutputStream a = null;
    public static int currRecord = 0;
    public static int e = 1000;
    public static int m_curRate = 5;
    public static long b = -1L;
    public static Vector tracks = new Vector();
    public static final int TYPE_EXPORT_KML = 0;
    public static final int TYPE_EXPORT_GPX = 1;
    public static final int REFRESH_MODE_NONE = 0;
    public static final int REFRESH_MODE_ON_CHANGE = 1;
    public static final int REFRESH_MODE_ON_INTERVAL = 2;
    public int m_refreshType = 0;
    private TrackListener a = false;

    public Track(Display display, String string, String string2, MapCanvas mapCanvas) {
        int n;
        this.a = display;
        this.a = string;
        if (display != null) {
            this.a = new Alert("Loading", string2, null, AlertType.INFO);
            display.setCurrent((Displayable)this.a);
            this.a.setTimeout(-2);
        }
        String string3 = string;
        if (mapCanvas != null) {
            string3 = mapCanvas.locateURL(this.a);
        }
        if (UtilMidp.DEBUG) {
            System.out.println("url:" + string3);
        }
        if ((n = string3.lastIndexOf(47)) == -1) {
            n = 0;
        }
        n = n == string3.length() - 1 ? 0 : ++n;
        this.m_name = string3.substring(n);
        System.out.println("Will fetch:" + string3);
        URLFetcher uRLFetcher = new URLFetcher(string3);
        uRLFetcher.setListener(this);
        uRLFetcher.fetch();
        this.isInit = true;
    }

    public Track(Display display, String string) {
        this.a = display;
        this.m_name = string;
    }

    public Track(Display display, int n) {
        this.a = display;
        this.a = n;
        this.a();
    }

    public Track(Display display, Displayable displayable, InputStream inputStream, String string) {
        this.a = display;
        this.a = "none";
        this.a = new Alert("Loading", string, null, AlertType.INFO);
        display.setCurrent((Displayable)this.a);
        this.a.setTimeout(-2);
        this.inputStream(inputStream);
        this.isInit = true;
    }

    public static Track getTrack(Display display, String string) {
        Track track = new Track(display, string);
        Track.addTrack(track);
        return track;
    }

    public static Track getTrack(Display display, String string, String string2, MapCanvas mapCanvas) {
        Track track = new Track(display, string, string2, mapCanvas);
        Track.addTrack(track);
        return track;
    }

    public static Track getTrack(Display display, Displayable displayable, InputStream inputStream, String string) {
        Track track = new Track(display, displayable, inputStream, string);
        Track.addTrack(track);
        return track;
    }

    public static void addTrack(Track track) {
        System.out.println("Add track:" + track.m_name + " " + a);
        tracks.addElement(track);
        if (a != null) {
            a.onTrackCreated(track);
        }
    }

    public long a(byte[] byArray, int n, int n2) {
        long l = 0L;
        while (n2-- > 0) {
            int n3;
            if ((n3 = byArray[n++]) < 0) {
                n3 = 256 + n3;
            }
            l = (l << 8) + (long)n3;
        }
        return l;
    }

    public static void a(byte[] byArray, int n, int n2, long l) {
        while (n2-- > 0) {
            byArray[n + n2] = (byte)(l % 255L);
            l >>= 8;
        }
    }

    public void setUrl(String string, MapCanvas mapCanvas) {
        this.clear();
        this.a = string;
        if (mapCanvas != null) {
            string = mapCanvas.locateURL(string);
        }
        System.out.println("Will fetch:" + string);
        URLFetcher uRLFetcher = new URLFetcher(string);
        uRLFetcher.setListener(this);
        uRLFetcher.fetch();
    }

    public void export(OutputStream outputStream, int n) {
        switch (n) {
            case 1: {
                this.b(outputStream);
                break;
            }
            default: {
                this.a(outputStream);
            }
        }
    }

    public static void initTracks() {
        int n = 0;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"GPSTrack", (boolean)true);
            System.out.println("RECORD STORE OPEN size:" + recordStore.getSize());
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n2 = recordEnumeration.nextRecordId();
                int n3 = recordStore.getRecordSize(n2);
                System.out.println("Record " + n + " Size:" + n3 + " rd:" + n2);
                String string = "Record " + n++ + " Size:" + n3 + " rd:" + n2;
                try {
                    Track track = new Track(null, n2);
                    Track.addTrack(track);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void a() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"GPSTrack", (boolean)true);
            byte[] byArray = recordStore.getRecord(this.a);
            int n = 63;
            while (byArray[n] == 0) {
                --n;
            }
            try {
                this.m_name = new String(byArray, 0, n, "UTF-8");
            }
            catch (Exception exception) {
                this.m_name = new String(byArray, 0, n);
            }
            this.m_name = this.m_name.trim();
            this.d = (int)this.a(byArray, 64, 1);
            this.c = (int)this.a(byArray, 65, 3);
            this.b = (int)this.a(byArray, 68, 4);
            this.a = this.a(byArray, 72, 8);
            System.out.println("Header:" + this.c + " waypoints:" + this.b + " time:" + this.a);
            if (UtilMidp.DEBUG) {
                System.out.println("Trying to read:" + this.a + " size:" + recordStore.getRecordSize(this.a));
            }
            recordStore.closeRecordStore();
            byArray = null;
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void clear() {
        this.b = 0;
        this.listPlaces = new Vector();
        this.c = 0;
    }

    public float parseFloat(String string) {
        return Float.parseFloat(string);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean inputStream(InputStream var1_1) {
        var2_2 = 0;
        try {
            var3_3 = new KXmlParser();
            var3_3.setInput(var1_1, "UTF-8");
            var4_5 = false;
            var5_7 = true;
            var6_8 = false;
            var7_9 = false;
            var8_10 = false;
            var9_11 = false;
            var10_12 = -1;
            var11_13 = -1;
            var12_14 = "";
            var13_15 = "";
            var14_16 = "";
            var15_17 = "";
            var16_18 = null;
            var17_19 = null;
            var18_20 = null;
            var19_21 = null;
            var20_22 = null;
            var21_23 /* !! */  = null;
            var22_24 = 0;
            var23_25 = false;
            var24_26 = false;
            var25_27 = new Hashtable<String, String>();
            block18: while (var5_7) {
                var26_28 = var3_3.next();
                var27_29 = "";
                switch (var26_28) {
                    case 2: {
                        var27_29 = var3_3.getName().toLowerCase();
                        System.out.println("Starttag:" + var27_29);
                        if (var23_25) {
                            if (!var27_29.equals("b")) break;
                            var28_30 = new OneLocSquare(this.parseFloat(var3_3.getAttributeValue(null, "x1")), this.parseFloat(var3_3.getAttributeValue(null, "y1")), this.parseFloat(var3_3.getAttributeValue(null, "x2")), this.parseFloat(var3_3.getAttributeValue(null, "y2")));
                            var28_30.description = var3_3.getAttributeValue(null, "t");
                            this.listPlaces.addElement(var28_30);
                            break;
                        }
                        if (var27_29.equals("link") || var27_29.equals("networklink")) {
                            var9_11 = true;
                            break;
                        }
                        if (var27_29.equals("blocks")) {
                            var23_25 = true;
                            break;
                        }
                        if (var27_29.equals("href") && var9_11) {
                            var3_3.next();
                            this.a = "http://127.0.0.1/j2memap/mob/kmlProxy.php?url=" + UtilMidp.urlEncode(var3_3.getText());
                            System.out.println("URL:" + this.a);
                            var24_26 = true;
                            var3_3.next();
                            break;
                        }
                        if (var27_29.equals("viewformat")) {
                            var28_31 = this.a(var3_3);
                            this.a = this.a + '?' + var28_31;
                            break;
                        }
                        if (var27_29.equals("viewrefreshtime")) {
                            var3_3.next();
                            var28_32 = var3_3.getText();
                            System.out.println("Refresh time:" + var28_32);
                            var3_3.next();
                            break;
                        }
                        if (var27_29.equals("viewrefreshmode")) {
                            var3_3.next();
                            var28_33 = var3_3.getText();
                            System.out.println("Refresh mode:" + var28_33);
                            var3_3.next();
                            if (!var28_33.equals("onStop")) continue block18;
                            this.m_refreshType = 1;
                            break;
                        }
                        if (var27_29.equals("item") || var27_29.equals("waypoint") || var27_29.equals("placemark") || var27_29.equals("poi") || var27_29.equals("flag")) {
                            var4_5 = true;
                            break;
                        }
                        if (var27_29.equals("name")) {
                            var3_3.next();
                            var14_16 = var3_3.getText();
                            var3_3.next();
                            if (!var4_5) {
                                this.m_name = var14_16;
                            }
                            if (!var7_9) break;
                            var20_22.name = var14_16;
                            break;
                        }
                        if (var27_29.equals("street") || var27_29.equals("address")) {
                            var3_3.next();
                            var19_21 = var3_3.getText();
                            var3_3.next();
                            if (var4_5) break;
                            this.m_name = var14_16;
                            break;
                        }
                        if (var27_29.equals("iconstyle")) {
                            var8_10 = true;
                            break;
                        }
                        if (var27_29.equals("values")) {
                            if (var25_27 == null) {
                                var25_27 = new Hashtable<K, V>();
                            }
                            for (var28_34 = 0; var28_34 < var3_3.getAttributeCount(); ++var28_34) {
                                var29_44 = var3_3.getAttributeName(var28_34);
                                var30_52 = var3_3.getAttributeValue(var28_34);
                                System.out.println("name:" + var29_44 + " " + var30_52);
                                var25_27.put(var29_44, var30_52);
                            }
                            if (var20_22 == null) break;
                            var20_22.a = var25_27;
                            var25_27 = null;
                            break;
                        }
                        if (var27_29.equals("linestring")) {
                            var4_5 = false;
                            var6_8 = true;
                            break;
                        }
                        if (var27_29.equals("position")) {
                            var12_14 = var3_3.getAttributeValue(null, "x");
                            var13_15 = var3_3.getAttributeValue(null, "y");
                            break;
                        }
                        if (var27_29.equals("coordinates")) {
                            var3_3.next();
                            var28_35 = var3_3.getText().trim();
                            System.out.println("Coord:" + var28_35);
                            var29_45 = 0;
                            var30_53 = 0;
                            while (var29_45 != -1) {
                                var29_45 = var28_35.indexOf(10, var29_45 + 1);
                                ++var30_53;
                            }
                            System.out.println("Count:" + var30_53);
                            var31_58 = new int[var30_53 * 2];
                            var30_53 = 0;
                            var29_45 = 0;
                            while ((var32_59 = var28_35.indexOf(44, var29_45)) != -1) {
                                var33_62 = var28_35.substring(var29_45, var32_59);
                                var29_45 = var28_35.indexOf(44, var32_59 + 1);
                                if (var29_45 == -1) {
                                    var29_45 = var28_35.length();
                                }
                                var34_63 = var28_35.substring(var32_59 + 1, var29_45);
                                if (var4_5) {
                                    var12_14 = var33_62;
                                    var13_15 = var34_63;
                                } else {
                                    var31_58[var30_53++] = MapCanvas.yFromLat(Float.parseFloat((String)var34_63));
                                    var31_58[var30_53++] = MapCanvas.xFromLon(Float.parseFloat((String)var33_62));
                                    System.out.println((int)var31_58[var30_53 - 2] + " " + (int)var31_58[var30_53 - 1]);
                                }
                                if (var32_59 + 1 < var28_35.length() && (var29_45 = var28_35.indexOf(10, var32_59 + 1)) != -1) continue;
                                break;
                            }
                            if (var6_8) {
                                var21_23 /* !! */  = (int[])var31_58;
                                var22_24 = var30_53;
                            }
                            var3_3.next();
                            break;
                        }
                        if (var27_29.equals("coord")) {
                            var4_5 = true;
                            var12_14 = var3_3.getAttributeValue(null, "lon");
                            var13_15 = var3_3.getAttributeValue(null, "lat");
                            break;
                        }
                        if (var27_29.equals("trkseg") || var27_29.equals("rteseg")) {
                            var21_23 /* !! */  = null;
                            var22_24 = 0;
                            break;
                        }
                        if (var27_29.equals("result")) {
                            var4_5 = true;
                            break;
                        }
                        if (var27_29.equals("trkpt") || var27_29.equals("rtept")) {
                            var28_36 = 0.0f;
                            var29_46 = 0.0f;
                            for (var30_54 = 0; var30_54 < var3_3.getAttributeCount(); ++var30_54) {
                                var31_58 = var3_3.getAttributeName(var30_54);
                                var32_60 = var3_3.getAttributeValue(var30_54);
                                if (var31_58.equals("lat")) {
                                    var28_36 = this.parseFloat(var32_60);
                                }
                                if (!var31_58.equals("lon")) continue;
                                var29_46 = this.parseFloat(var32_60);
                            }
                            if (var21_23 /* !! */  == null) {
                                var21_23 /* !! */  = new int[256];
                            }
                            if (var22_24 >= var21_23 /* !! */ .length) {
                                var30_55 = new int[var21_23 /* !! */ .length + 256];
                                System.arraycopy(var21_23 /* !! */ , 0, var30_55, 0, var21_23 /* !! */ .length);
                                var21_23 /* !! */  = var30_55;
                            }
                            var21_23 /* !! */ [var22_24++] = MapCanvas.yFromLat(var28_36);
                            var21_23 /* !! */ [var22_24++] = MapCanvas.xFromLon(var29_46);
                            break;
                        }
                        if (var27_29.equals("wpt") || var27_29.equals("place") || var27_29.equals("blip") || var27_29.equals("marker")) {
                            var7_9 = true;
                            var28_37 = 0.0f;
                            var29_47 = 0.0f;
                            var14_16 = null;
                            var29_47 = this.parseFloat(var3_3.getAttributeValue(null, "lon"));
                            var28_37 = this.parseFloat(var3_3.getAttributeValue(null, "lat"));
                            var20_22 = this.m_locType.clone(var29_47, var28_37);
                            for (var30_56 = 0; var30_56 < var3_3.getAttributeCount(); ++var30_56) {
                                var31_58 = var3_3.getAttributeName(var30_56);
                                var32_61 = var3_3.getAttributeValue(var30_56);
                                if (var31_58.equals("name") || var31_58.equals("title")) {
                                    var20_22.name = var32_61;
                                }
                                if (var31_58.equals("desc")) {
                                    var20_22.description = var32_61;
                                }
                                if (var31_58.equals("tel") && !var32_61.equals("")) {
                                    var20_22.phoneNum = var32_61;
                                }
                                if (var31_58.equals("addr") && !var32_61.equals("")) {
                                    var20_22.address = var32_61;
                                }
                                if (var31_58.equals("category")) {
                                    var20_22.m_category = Integer.parseInt(var32_61);
                                }
                                if (var31_58.equals("photo") && !var32_61.equals("")) {
                                    var20_22.imageName = var32_61;
                                }
                                if (var31_58.equals("ais")) {
                                    var33_62 = UtilMidp.explode(var32_61);
                                    var34_63 = new StringBuffer();
                                    for (var35_64 = 0; var35_64 < var33_62.length; ++var35_64) {
                                        var34_63.append(var33_62[var35_64] + "\n");
                                    }
                                    var15_17 = var34_63.toString();
                                }
                                if (this.a == null) continue;
                                this.a.setString("Read " + var15_17 + "(" + this.listPlaces.size() + ")");
                            }
                            if (UtilMidp.DEBUG) {
                                System.out.println("New waypoint..." + var20_22.saveToString());
                            }
                            this.listPlaces.addElement(var20_22);
                            break;
                        }
                        if (var7_9) {
                            var28_38 = var27_29;
                            var3_3.next();
                            var29_48 = var3_3.getText();
                            var3_3.next();
                            if (var28_38.equals("name")) {
                                var20_22.name = var29_48;
                                break;
                            }
                            if (var28_38.equals("cmt")) {
                                var20_22.description = var29_48;
                                break;
                            }
                            if (var28_38.equals("desc")) {
                                var20_22.description = var29_48;
                                break;
                            }
                            if (!var28_38.equals("sym")) continue block18;
                        }
                        if (var27_29.equals("photo")) {
                            var17_19 = "http://static.flickr.com/" + var3_3.getAttributeValue(null, "server") + "/" + var3_3.getAttributeValue(null, "id") + "_" + var3_3.getAttributeValue(null, "secret") + "_s.jpg";
                            System.out.println("PhotoURL:" + var17_19);
                            var28_39 = new OneLoc(this.parseFloat(var3_3.getAttributeValue(null, "longitude")), this.parseFloat(var3_3.getAttributeValue(null, "latitude")));
                            var28_39.iconName = var17_19;
                            var28_39.imageName = "http://static.flickr.com/" + var3_3.getAttributeValue(null, "server") + "/" + var3_3.getAttributeValue(null, "id") + "_" + var3_3.getAttributeValue(null, "secret") + "_m.jpg";
                            this.listPlaces.addElement(var28_39);
                            break;
                        }
                        if (!var4_5) break;
                        if (!var27_29.equals("geo:lat") && !var27_29.equals("lat") && !var27_29.equals("latitude")) ** GOTO lbl264
                        var3_3.next();
                        var13_15 = var3_3.getText();
                        var3_3.next();
                        ** GOTO lbl350
lbl264:
                        // 1 sources

                        if (!var27_29.equals("geo:long") && !var27_29.equals("lng") && !var27_29.equals("longitude")) ** GOTO lbl271
                        var3_3.next();
                        var12_14 = var3_3.getText();
                        var3_3.next();
                        ** GOTO lbl350
lbl271:
                        // 1 sources

                        if (!var27_29.equals("name") && !var27_29.equals("title")) ** GOTO lbl279
                        var3_3.next();
                        var14_16 = var3_3.getText();
                        var3_3.next();
                        System.out.println("Read: name:" + var14_16);
                        ** GOTO lbl350
lbl279:
                        // 1 sources

                        if (var27_29.equals("link")) ** GOTO lbl350
                        if (!var27_29.equals("type")) ** GOTO lbl293
                        var3_3.next();
                        var28_40 = var3_3.getText();
                        try {
                            var11_13 = Integer.parseInt(var28_40);
                        }
                        catch (Exception var29_49) {
                            if (var15_17 != "") ** GOTO lbl290
                            var15_17 = var28_40;
                        }
lbl290:
                        // 3 sources

                        var3_3.next();
                        ** GOTO lbl350
lbl293:
                        // 1 sources

                        if (var27_29.equals("severity")) {
                            var3_3.next();
                            var28_41 = Integer.parseInt(var3_3.getText());
                            switch (var28_41) {
                                case 5: {
                                    var10_12 = 0xFF0000;
                                    break;
                                }
                                case 4: {
                                    var10_12 = 0xFF2000;
                                    break;
                                }
                                case 3: {
                                    var10_12 = 0xFF4000;
                                    break;
                                }
                                case 2: {
                                    var10_12 = 0xFF6000;
                                    break;
                                }
                                default: {
                                    var10_12 = 0xFF8080;
                                }
                            }
                            var3_3.next();
                        } else if (var27_29.equals("color")) {
                            var3_3.next();
                            var28_42 = var3_3.getText();
                            if (var8_10) {
                                var29_50 = var28_42.indexOf(120);
                                if (var29_50 != -1) {
                                    var28_42 = var28_42.substring(var29_50);
                                }
                                var10_12 = (int)Long.parseLong(var28_42, 16);
                            }
                            var3_3.next();
                        } else if (var27_29.equals("icon")) {
                            var3_3.next();
                            var16_18 = var3_3.getText();
                            if (var16_18 != null) {
                                var16_18.trim();
                            }
                            var3_3.next();
                        } else if (var27_29.equals("tel")) {
                            var3_3.next();
                            var18_20 = var3_3.getText().trim();
                            var3_3.next();
                        } else if (var27_29.equals("photoURL")) {
                            var3_3.next();
                            var17_19 = var3_3.getText();
                            var3_3.next();
                        }
lbl350:
                        // 12 sources

                        if (!var27_29.equals("description") && !var27_29.equals("desc")) break;
                        var3_3.next();
                        var15_17 = var3_3.getText();
                        var3_3.next();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 3: {
                        var27_29 = var3_3.getName().toLowerCase();
                        System.out.println("end tag:" + var27_29);
                        if (var27_29.equals("item") || var27_29.equals("flag") || var27_29.equals("poi") || var27_29.equals("waypoint") || var27_29.equals("result") || var27_29.equals("placemark") && var12_14 != null) {
                            var4_5 = false;
                            System.out.println("Location: " + var12_14 + " lat:" + var13_15 + " name:" + var14_16);
                            var28_43 = this.m_locType.clone(this.parseFloat(var12_14), this.parseFloat(var13_15));
                            if (var14_16 != null) {
                                var28_43.name = var14_16;
                            }
                            if (var18_20 != null) {
                                var28_43.phoneNum = var18_20;
                            }
                            if (var16_18 != null) {
                                var28_43.iconName = var16_18;
                            }
                            if (var15_17 != null) {
                                var28_43.description = var15_17;
                            }
                            if (var17_19 != null) {
                                var28_43.imageName = var17_19;
                            }
                            if (var19_21 != null) {
                                var28_43.address = var19_21;
                            }
                            var19_21 = null;
                            if (var10_12 != -1) {
                                var28_43.m_col = var10_12;
                            }
                            var10_12 = -1;
                            if (var11_13 != -1) {
                                var28_43.m_type = var11_13;
                            }
                            var11_13 = -1;
                            var29_51 = var25_27.keys();
                            while (var29_51.hasMoreElements()) {
                                var30_57 = (String)var29_51.nextElement();
                                var28_43.setValue(var30_57, var25_27.get(var30_57));
                            }
                            var25_27.clear();
                            this.listPlaces.addElement(var28_43);
                            if (this.a != null) {
                                this.a.setString("Read " + var15_17 + "(" + this.listPlaces.size() + ")");
                            }
                            var16_18 = null;
                            var18_20 = null;
                            var17_19 = null;
                            var15_17 = null;
                            var14_16 = null;
                            ++var2_2;
                            break;
                        }
                        if (var27_29.equals("link") || var27_29.equals("networklink")) {
                            var9_11 = false;
                            break;
                        }
                        if (var27_29.equals("blocks")) {
                            var23_25 = false;
                            break;
                        }
                        if (var27_29.equals("wpt")) {
                            var7_9 = false;
                            break;
                        }
                        if (var27_29.equals("trkseg")) break;
                        if (var27_29.equals("linestring")) {
                            var6_8 = false;
                            var12_14 = null;
                            break;
                        }
                        if (!var27_29.equals("iconstyle")) break;
                        var8_10 = false;
                        break;
                    }
                    case 1: {
                        System.out.println("end doc...");
                        if (this.listPlaces != null) {
                            this.b = this.listPlaces.size();
                        }
                        if (var21_23 /* !! */  != null) {
                            this.coordSeg = new int[var22_24];
                            this.c = var22_24 / 2;
                            System.arraycopy(var21_23 /* !! */ , 0, this.coordSeg, 0, var22_24);
                        }
                        if (Track.a != null) {
                            Track.a.onTrackLoaded(this);
                        }
                        if (this.b != null) {
                            this.b.onTrackLoaded(this);
                        }
                        return false;
                    }
                }
            }
        }
        catch (Exception var3_4) {
            var3_4.printStackTrace();
            UtilMidp.MsgBox("Importing", var3_4.toString(), AlertType.ERROR, -2);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException var4_6) {
                var4_6.printStackTrace();
            }
        }
        if (var2_2 == 0) {
            // empty if block
        }
        if (Track.a != null) {
            Track.a.onTrackLoaded(this);
        }
        if (this.b != null) {
            this.b.onTrackLoaded(this);
        }
        this.a = true;
        return false;
    }

    public String a(KXmlParser kXmlParser) {
        String string = "";
        try {
            kXmlParser.next();
            string = kXmlParser.getText();
            kXmlParser.next();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public void error(int n) {
        String string = "Error " + n + " while accessing the URL " + this.a + "\n check the URL..";
        System.out.println(string);
        UtilMidp.MsgBox("Error", string, AlertType.ERROR, -2);
        this.a = true;
        if (a != null) {
            a.onTrackLoaded(this);
        }
        if (this.b != null) {
            this.b.onTrackLoaded(this);
        }
    }

    public void loaded(URLFetcher uRLFetcher) {
        this.a = true;
    }

    public boolean lineRead(URLFetcher uRLFetcher, String string) {
        return false;
    }

    public static void setGlobalNotifier(TrackNotifier trackNotifier) {
        a = trackNotifier;
    }

    public void setNotifier(TrackNotifier trackNotifier) {
        this.b = trackNotifier;
        if (this.a && this.b != null) {
            this.b.onTrackLoaded(this);
        }
    }

    public String sendTrack(String string) {
        String string2 = "Sending ok";
        try {
            if (this.a != -1) {
                this.loadTrack();
            } else {
                this.saveTrack();
            }
            System.out.println("the url:" + string);
            HttpConnection httpConnection = null;
            int n = -1;
            httpConnection = (HttpConnection)Connector.open((String)string, (int)3);
            httpConnection.setRequestMethod("POST");
            DataOutputStream dataOutputStream = httpConnection.openDataOutputStream();
            System.out.println("open input stream...");
            System.out.println("writing ");
            for (int i = 0; i < this.savedTrack.length; ++i) {
                dataOutputStream.writeByte(this.savedTrack[i]);
            }
            System.out.println("flush");
            dataOutputStream.flush();
            dataOutputStream.close();
            System.out.println(httpConnection.getResponseMessage());
            n = httpConnection.getResponseCode();
            if (n == 200) {
                InputStream inputStream = httpConnection.openInputStream();
                System.out.println("Loaded..");
            } else {
                System.out.println("error.." + n);
                string2 = "error..." + n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = exception.toString();
        }
        return string2;
    }

    public void loadTrack() {
        if (!this.isInit && this.a != -1) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"GPSTrack", (boolean)true);
                this.savedTrack = recordStore.getRecord(this.a);
                this.isInit = true;
                if (UtilMidp.DEBUG) {
                    System.out.println("Trying to read:" + this.a + " size:" + recordStore.getRecordSize(this.a));
                }
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getTrack() {
        int[] nArray = null;
        if (this.coordSeg != null) return this.coordSeg;
        if (this.a == -1) return this.coordSeg;
        this.loadTrack();
        try {
            int n;
            if (this.savedTrack == null) return nArray;
            byte[] byArray = this.savedTrack;
            int n2 = this.c;
            this.coordSeg = new int[n2 * 2];
            this.times = new long[n2];
            this.alts = new float[n2];
            this.speeds = new float[n2];
            this.courses = new float[n2];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[64];
            dataInputStream.read(byArray2);
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readLong();
            dataInputStream.readLong();
            for (n = 0; n < n2; ++n) {
                float f = dataInputStream.readFloat();
                float f2 = dataInputStream.readFloat();
                float f3 = dataInputStream.readFloat();
                float f4 = dataInputStream.readFloat();
                float f5 = dataInputStream.readFloat();
                long l = dataInputStream.readLong();
                System.out.println("[" + n + "]" + f + " " + f2 + " alt:" + f3 + " dir:" + f4 + " sp:" + f5 + " " + l);
                this.coordSeg[2 * n + 1] = MapCanvas.xFromLon(f);
                this.coordSeg[2 * n] = MapCanvas.yFromLat(f2);
                this.times[n] = l;
                this.alts[n] = f3;
                this.courses[n] = f4;
                this.speeds[n] = f5;
            }
            nArray = this.coordSeg;
            n = 0;
            while (n < this.b) {
                int n3 = dataInputStream.read();
                byte[] byArray3 = new byte[n3];
                dataInputStream.read(byArray3);
                String string = new String(byArray3);
                System.out.println(string);
                OneLoc oneLoc = OneLoc.createFromString(string);
                this.listPlaces.addElement(oneLoc);
                ++n;
            }
            return nArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return nArray;
        }
    }

    public Vector getWaypoints() {
        this.loadTrack();
        return this.listPlaces;
    }

    public void a(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        printStream.print("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
        printStream.print("<Folder>\n");
        if (this.getWaypoints() != null) {
            Enumeration enumeration = this.getWaypoints().elements();
            while (enumeration.hasMoreElements()) {
                OneLoc oneLoc = (OneLoc)enumeration.nextElement();
                printStream.print(" <Placemark>\n");
                if (oneLoc.name != null) {
                    printStream.print("  <name>" + oneLoc.name + "</name>\n");
                }
                if (oneLoc.description != null) {
                    printStream.print("  <description>" + oneLoc.description + "</description>\n");
                }
                printStream.print("  <Style>\n");
                printStream.print("   <IconStyle><color>ff" + Integer.toHexString(oneLoc.m_col) + "</color></IconStyle>\n");
                printStream.print("  </Style>\n");
                printStream.print("  <Point>\n");
                printStream.print("   <coordinates>" + oneLoc.m_lon + "," + oneLoc.m_lat + "," + "0.0" + "</coordinates>\n");
                printStream.print("  </Point>\n");
                printStream.print(" </Placemark>\n");
            }
        }
        if (this.getTrack() != null) {
            printStream.print(" <Placemark>\n");
            printStream.print("<styleUrl>root://styles#default+icon=0x307</styleUrl>");
            printStream.print("  <LineString>\n");
            printStream.print("   <coordinates>\n    ");
            for (int i = 0; i < this.coordSeg.length; i += 2) {
                float f = MapCanvas.convLat(this.coordSeg[i]);
                float f2 = MapCanvas.convLon(this.coordSeg[i + 1]);
                float f3 = 0.0f;
                if (this.alts != null) {
                    f3 = this.alts[i / 2];
                }
                printStream.print(f2 + "," + f + "," + f3 + " ");
            }
            printStream.print("\n   </coordinates>\n");
            printStream.print("  </LineString>\n");
            printStream.print(" </Placemark>\n");
        }
        printStream.print("</Folder>\n");
        printStream.print("</kml>");
        printStream.print("");
    }

    public void b(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        printStream.print("<gpx version=\"1.0\" creator=\"J2MEMAP http://j2memap.landspurg.net\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    \t\txmlns=\"http://www.topografix.com/GPX/1/0\"\n    \t\txsi:schemaLocation=\"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd\">\n");
        if (this.getWaypoints() != null) {
            Enumeration enumeration = this.getWaypoints().elements();
            while (enumeration.hasMoreElements()) {
                OneLoc oneLoc = (OneLoc)enumeration.nextElement();
                printStream.print(" <wpt lat=\"" + oneLoc.m_lat + "\" lon=\"" + oneLoc.m_lon + "\">\n");
                if (oneLoc.name != null) {
                    printStream.print("  <name>" + oneLoc.name + "</name>\n");
                }
                if (oneLoc.description != null) {
                    printStream.print("  <desc>" + oneLoc.description + "</desc>\n");
                }
                printStream.print("  </wpt>\n");
            }
        }
        if (this.getTrack() != null) {
            printStream.print(" <trk>\n  <trkseg>\n");
            for (int i = 0; i < this.coordSeg.length; i += 2) {
                float f = MapCanvas.convLat(this.coordSeg[i]);
                float f2 = MapCanvas.convLon(this.coordSeg[i + 1]);
                printStream.print("   <trkpt lat=\"" + f + "\" lon=\"" + f2 + "\">\n");
                if (this.alts != null) {
                    printStream.print("    <ele>" + this.alts[i / 2] + "</ele>\n");
                }
                if (this.speeds != null) {
                    printStream.print("    <speed>" + this.speeds[i / 2] + "</speed>\n");
                }
                if (this.courses != null) {
                    printStream.print("    <course>" + this.courses[i / 2] + "</course>\n");
                }
                if (this.times != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new Date(this.times[i / 2]));
                    String string = calendar.get(1) + "-" + this.a(calendar.get(2) + 1, 2) + "-" + this.a(calendar.get(5), 2) + "T" + this.a(calendar.get(11), 2) + ":" + this.a(calendar.get(12), 2) + ":" + this.a(calendar.get(13), 2) + "Z";
                    printStream.print("    <time>" + string + "</time>\n");
                }
                printStream.print("   </trkpt>\n");
            }
            printStream.print(" </trkseg>\n  </trk>\n");
        }
        printStream.print("</gpx>\n");
        printStream.print("");
    }

    private String a(int n, int n2) {
        String string = n + "";
        while (string.length() < n2) {
            string = "0" + string;
        }
        if (string.length() > n2) {
            string = string.substring(string.length() - n2);
        }
        return string;
    }

    public void saveTrack() {
        try {
            if (this.savedTrack == null) {
                this.savedTrack = a.toByteArray();
                a.reset();
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"GPSTrack", (boolean)true);
            byte[] byArray = this.m_name.getBytes();
            if (byArray.length != 0) {
                System.arraycopy(byArray, 0, this.savedTrack, 0, byArray.length);
            }
            this.savedTrack[byArray.length] = 0;
            this.savedTrack[byArray.length + 1] = 0;
            this.c = (this.savedTrack.length - 88) / 28;
            this.b = 0;
            Track.a(this.savedTrack, 64, 4, this.c);
            Track.a(this.savedTrack, 68, 4, this.b);
            if (this.a == -1) {
                this.a = recordStore.addRecord(this.savedTrack, 0, this.savedTrack.length);
            } else {
                recordStore.setRecord(this.a, this.savedTrack, 0, this.savedTrack.length);
            }
            recordStore.closeRecordStore();
            this.a();
            if (a != null) {
                a.onTrackSaved(this);
            }
        }
        catch (Exception exception) {
            UtilMidp.showException(exception);
        }
    }

    public void addLoc(OneLoc oneLoc) {
        this.listPlaces.addElement(oneLoc);
    }

    public void b() {
        try {
            if (a == null) {
                a = new ByteArrayOutputStream();
                a = new DataOutputStream(a);
            }
            if (a.size() == 0) {
                byte[] byArray = new String("newTrack").getBytes();
                byte[] byArray2 = new byte[64 - byArray.length];
                ((OutputStream)a).write(byArray);
                ((OutputStream)a).write(byArray2);
                a.writeInt(0);
                a.writeInt(0);
                long l = System.currentTimeMillis();
                System.out.println("TimeStamp:" + l + " " + new Date(l).toString());
                a.writeLong(l);
                a.writeLong(0L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addRecord(oneGPSPos oneGPSPos2) {
        try {
            if (oneGPSPos2.stamp - b > (long)(m_curRate * 1000)) {
                this.b();
                a.writeFloat((float)oneGPSPos2.m_lon);
                a.writeFloat((float)oneGPSPos2.m_lat);
                a.writeFloat((float)oneGPSPos2.m_alt);
                a.writeFloat((float)oneGPSPos2.m_dir);
                a.writeFloat((float)oneGPSPos2.speed);
                a.writeLong(oneGPSPos2.stamp);
                System.out.println("one record added....Total:" + ++currRecord);
                b = oneGPSPos2.stamp;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (currRecord >= e && currRecord == e) {
            this.saveTrack();
        }
    }

    public void delete() {
        if (this.a != -1) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"GPSTrack", (boolean)true);
                recordStore.deleteRecord(this.a);
                this.a = -1;
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setName(String string) {
        if (this.a != -1) {
            this.loadTrack();
            this.m_name = string;
            this.saveTrack();
        }
        this.m_name = string;
    }

    public int getSizeTrack() {
        return this.c;
    }

    public int getNbWayPoints() {
        return this.b;
    }

    public long getTimeStamp() {
        return this.a;
    }

    public static void removeTrack(Track track) {
        tracks.removeElement(track);
        track.delete();
    }

    public void refreshTrack(MapCanvas mapCanvas) {
        this.setUrl(this.a, mapCanvas);
    }

    public void setTrackListener(TrackListener trackListener) {
        this.a = trackListener;
    }

    public void fireSelected(OneLoc oneLoc) {
        if (this.a != null) {
            this.a.onLocSelected(this, oneLoc);
        }
    }
}

