/*
 * Decompiled with CFR 0.152.
 */
package com.radiobee.player;

import com.radiobee.player.RBBuffer;
import com.radiobee.player.Settings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class RBStreamBufferV2
implements RBBuffer {
    Settings mProfile;
    ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    public RBStreamBufferV2(Settings profile) {
        this.mProfile = profile;
    }

    public synchronized int write(byte[] buff) throws Exception {
        return this.write(buff, buff.length);
    }

    public synchronized int write(byte[] buff, int len) throws Exception {
        while (this.bOut.size() + len > this.mProfile.getBufferSize()) {
            if (!this.mProfile.isRunning()) {
                return -1;
            }
            this.wait(this.mProfile.getTimeout2());
        }
        this.bOut.write(buff, 0, len);
        this.notifyAll();
        return len;
    }

    public synchronized ByteArrayInputStream read() throws Exception {
        while (this.bOut.size() < this.mProfile.getPlayChunck()) {
            if (!this.mProfile.isRunning()) {
                return null;
            }
            this.wait(this.mProfile.getTimeout2());
        }
        ByteArrayInputStream bRes = new ByteArrayInputStream(this.bOut.toByteArray());
        this.bOut.reset();
        this.notifyAll();
        return bRes;
    }
}

