/*
 * Decompiled with CFR 0.152.
 */
package com.radiobee.player;

import java.io.IOException;
import java.io.InputStream;

public class ICYMetaData {
    int brate;
    String name;
    String status;
    String genre;

    public void readICYTags(InputStream in) throws IOException {
        String line;
        do {
            line = this.readLine(in);
            this.getTagInfo(line);
        } while (line.length() > 2);
    }

    String readLine(InputStream in) throws IOException {
        char ch;
        String line = "";
        while ('\uffffffff' != (ch = (char)in.read()) && ch >= '\t' && (ch != '\r' || (ch = (char)in.read()) != '\n')) {
            line = line + ch;
        }
        return line;
    }

    void getTagInfo(String line) {
        if (line.startsWith("icy-name") || line.startsWith("x-audiocast-name")) {
            this.name = line.substring(line.indexOf(58) + 1);
        } else if (line.startsWith("icy-genre") || line.startsWith("x-audiocast-genre")) {
            this.genre = line.substring(line.indexOf(58) + 1);
        } else if (line.startsWith("icy-br") || line.startsWith("x-audiocast-bitrate")) {
            this.brate = Integer.parseInt(line.substring(line.indexOf(58) + 1));
        } else if (line.startsWith("ICY ")) {
            this.status = line.substring(line.indexOf(32) + 1);
        }
    }

    public String getStationName() {
        if (this.name == null) {
            return "n/a";
        }
        return this.name;
    }

    public String getStationGenre() {
        if (this.genre == null) {
            return "n/a";
        }
        return this.genre;
    }

    public String getStationStatus() {
        if (this.status == null) {
            return "unknown";
        }
        return this.status.substring(4);
    }

    public int getQuality() {
        return this.brate;
    }
}

