/*
 * Decompiled with CFR 0.152.
 */
package trezor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Entry {
    int id;
    String label;
    String body;

    public Entry(int n) {
        this.id = n;
    }

    public Entry(int n, byte[] byArray) {
        this(n);
        this.setBytes(byArray);
    }

    public Entry(String string, String string2) {
        this(0);
        this.label = string;
        this.body = string2;
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.label);
            dataOutputStream.writeUTF(this.body);
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void setBytes(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.label = dataInputStream.readUTF();
            this.body = dataInputStream.readUTF();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getId() {
        return this.id;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setId(int n) {
        this.id = n;
    }
}

