/*
 * Decompiled with CFR 0.152.
 */
package p;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import p.App;
import p.ColorForm;
import p.DrawField;
import p.Float;
import p.NewForm;
import p.OpenList;
import p.OptList;
import p.RGBColor;
import p.Rect;
import p.RedrawTimer;
import p.SaveForm;
import p.ShowTextForm;
import p.ToolForm;

public class MCanvas
extends Canvas
implements CommandListener {
    boolean AutoMode = false;
    public static final int MODE_ALL = 3;
    public static final int MODE_FULL = 1;
    public static final int MODE_SERVICE = 4;
    public static final int MODE_TOOL_BAR = 2;
    App app;
    boolean done = false;
    DrawField field;
    Graphics grBuffer;
    int height;
    Image imBuffer;
    Displayable parent;
    RedrawTimer rTimer;
    int repaintMode;
    private int repaintModeDefault = 3;
    int screenHeight;
    int screenWidth;
    public String serviceMsg;
    Timer timer;
    boolean undoAdded;
    Command undoCMD;
    int width;

    public MCanvas(App _app, Displayable _parent) {
        this.app = _app;
        this.parent = _parent;
        this.setCommandListener(this);
        this.addCommand(new Command(this.app.loc.getString("New"), 1, 1));
        this.addCommand(new Command(this.app.loc.getString("Open"), 1, 2));
        this.addCommand(new Command(this.app.loc.getString("Save"), 1, 3));
        this.addCommand(new Command(this.app.loc.getString("Options"), 1, 4));
        this.addCommand(new Command(this.app.loc.getString("About"), 1, 5));
        this.addCommand(new Command(this.app.loc.getString("Exit"), 7, 6));
        this.undoCMD = new Command(this.app.loc.getString("Undo"), 1, 0);
        this.undoAdded = false;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.CreateImgs();
        this.field = null;
        this.app.history.push(_parent);
        this.app.setScreen((Displayable)this);
        this.setDefaultRepaintMode(4);
        this.serviceMsg = "G-ed painte";
        this.repaint();
    }

    private void CreateImgs() {
        try {
            if (!this.isDoubleBuffered()) {
                this.imBuffer = Image.createImage((int)this.screenWidth, (int)this.screenHeight);
                this.grBuffer = this.imBuffer.getGraphics();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        Alert a;
        if (command.getCommandType() == 7) {
            this.app.quitApp();
        }
        if (command.getLabel() == this.app.loc.getString("Open")) {
            new OpenList(this.app, (Displayable)this);
        }
        if (command.getLabel() == this.app.loc.getString("Save")) {
            if (this.field == null) {
                a = new Alert(this.app.loc.getString("Error"), this.app.loc.getLongString(0), null, AlertType.ERROR);
                a.setTimeout(2000);
                Display.getDisplay((MIDlet)this.app).setCurrent(a, (Displayable)this);
            } else {
                new SaveForm(this.app, (Displayable)this);
            }
        }
        if (command.getLabel() == this.app.loc.getString("New")) {
            this.removeCommand(this.undoCMD);
            this.undoAdded = false;
            new NewForm(this.app, (Displayable)this);
        }
        if (command.getLabel() == this.app.loc.getString("Options")) {
            if (this.field == null) {
                a = new Alert(this.app.loc.getString("Error"), this.app.loc.getLongString(1), null, AlertType.ERROR);
                a.setTimeout(2000);
                Display.getDisplay((MIDlet)this.app).setCurrent(a, (Displayable)this);
            } else {
                new OptList(this.app, (Displayable)this);
            }
        }
        if (command.getLabel() == this.app.loc.getString("About")) {
            new ShowTextForm(this.app, (Displayable)this, this.app.loc.getLongString(2), this.app.loc.getString("About"));
        }
        if (command.getLabel() == this.app.loc.getString("Undo")) {
            this.field.undo();
            this.removeCommand(this.undoCMD);
            this.undoAdded = false;
        }
    }

    protected void keyPressed(int KeyCode) {
        if (this.AutoMode || this.field == null) {
            return;
        }
        if (KeyCode == 53) {
            this.field.switchTool();
            if (this.field.canUndo() && !this.undoAdded) {
                this.addCommand(this.undoCMD);
                this.undoAdded = true;
            }
            this.repaint();
        } else if (KeyCode == 42) {
            this.field.swapColors();
            this.repaintMode = 2;
            this.repaint();
        } else if (KeyCode == 35) {
            int p = this.field.getParam(0);
            int tt = this.field.toolType();
            switch (tt) {
                case 0: {
                    p = p < 6 ? ++p : 1;
                    this.field.setParam(p, 0);
                    break;
                }
                case 4: {
                    p = p == 1 ? 6 : 1;
                    this.field.setParam(p, 0);
                }
            }
            this.repaintMode = 2;
            this.repaint();
        } else if (KeyCode == 48) {
            this.field.nextTool();
            this.repaintMode = 2;
            this.repaint();
        } else if (KeyCode == 49 || KeyCode == 50 || KeyCode == 51 || KeyCode == 52 || KeyCode == 54 || KeyCode == 55 || KeyCode == 56 || KeyCode == 57) {
            int mov_x = 0;
            int mov_y = 0;
            switch (KeyCode) {
                case 49: {
                    --mov_x;
                    --mov_y;
                    break;
                }
                case 50: {
                    --mov_y;
                    break;
                }
                case 51: {
                    --mov_y;
                    ++mov_x;
                    break;
                }
                case 52: {
                    --mov_x;
                    break;
                }
                case 54: {
                    ++mov_x;
                    break;
                }
                case 55: {
                    --mov_x;
                    ++mov_y;
                    break;
                }
                case 56: {
                    ++mov_y;
                    break;
                }
                case 57: {
                    ++mov_x;
                    ++mov_y;
                }
            }
            this.field.moveCursor(mov_x, mov_y, false);
            this.repaintMode = 1;
            this.repaint();
        } else if (this.getGameAction(KeyCode) == 1 || this.getGameAction(KeyCode) == 2 || this.getGameAction(KeyCode) == 6 || this.getGameAction(KeyCode) == 5) {
            int mov_x = 0;
            int mov_y = 0;
            switch (this.getGameAction(KeyCode)) {
                case 1: {
                    mov_y -= this.app.jump;
                    break;
                }
                case 2: {
                    mov_x -= this.app.jump;
                    break;
                }
                case 6: {
                    mov_y += this.app.jump;
                    break;
                }
                case 5: {
                    mov_x += this.app.jump;
                }
            }
            this.field.moveCursor(mov_x, mov_y, true);
            this.repaintMode = 1;
            this.repaint();
        }
    }

    protected void keyRepeated(int KeyCode) {
        if (KeyCode == 49 || KeyCode == 50 || KeyCode == 51 || KeyCode == 52 || KeyCode == 54 || KeyCode == 55 || KeyCode == 56 || KeyCode == 57 || this.getGameAction(KeyCode) == 1 || this.getGameAction(KeyCode) == 6 || this.getGameAction(KeyCode) == 2 || this.getGameAction(KeyCode) == 5) {
            this.keyPressed(KeyCode);
        }
        if (KeyCode == 42) {
            this.field.swapColors();
            new ColorForm(this.app, (Displayable)this, this.field);
        }
        if (KeyCode == 48) {
            this.field.prevTool();
            new ToolForm(this.app, (Displayable)this, this.field);
        }
    }

    protected void paint(Graphics g) {
        Graphics g1 = g;
        if (!this.isDoubleBuffered()) {
            g = this.grBuffer;
        }
        if (this.repaintMode == 2 || this.repaintMode == 3) {
            this.field.drawToolBar(g, 0, 0);
            this.field.drawCoord(g);
        }
        if (this.repaintMode == 1 || this.repaintMode == 3) {
            g.setClip(0, 0, this.screenWidth, this.screenHeight);
            g.setColor(0);
            g.fillRect(0, 10, this.screenWidth, this.screenHeight - 10);
            this.field.drawCoord(g);
            this.field.drawAll(g, 0, 10);
            this.field.drawCursor(g);
        }
        if (this.repaintMode == 4) {
            g.setColor(0);
            g.fillRect(0, 0, this.screenWidth, this.screenHeight);
            g.setColor(0xFFFFFF);
            g.drawRect(2, 2, this.screenWidth - 4, this.screenHeight - 4);
            Font f = Font.getDefaultFont();
            g.setFont(f);
            g.drawString(this.serviceMsg, this.screenWidth / 2 - f.stringWidth(this.serviceMsg) / 2, this.screenHeight / 3, 20);
        }
        if (this.field != null && this.repaintMode != 4 && this.field.toolUsed() && !this.AutoMode) {
            int tt = this.field.toolType();
            switch (tt) {
                case 2: {
                    int cx = this.field.getToolParam(1);
                    int cy = this.field.getToolParam(2);
                    Rect cr = this.field.getCoord();
                    RGBColor r = this.field.getColor();
                    g.setColor(r.GetInt());
                    g.drawLine(cx, cy + 10, cr.x, cr.y + 10);
                    break;
                }
                case 3: {
                    int cx = this.field.getToolParam(1);
                    int cy = this.field.getToolParam(2);
                    Rect cr = this.field.getCoord();
                    RGBColor r = this.field.getColor();
                    g.setColor(r.GetInt());
                    g.drawLine(cx, cy + 10, cr.x, cr.y + 10);
                    int x1 = Math.min(cx, cr.x);
                    int x2 = Math.max(cx, cr.x);
                    int y1 = Math.min(cy, cr.y);
                    int y2 = Math.max(cy, cr.y);
                    int dx = Math.abs(x2 - x1);
                    int dy = Math.abs(y2 - y1);
                    int rad = (int)Float.sqrt(new Float(dx * dx).Add(new Float(dy * dy))).toLong();
                    g.drawRect(cx - rad, cy - rad + 10, rad * 2, rad * 2);
                    break;
                }
                case 4: {
                    int cx = this.field.getToolParam(1);
                    int cy = this.field.getToolParam(2);
                    Rect cr = this.field.getCoord();
                    RGBColor r = this.field.getColor();
                    g.setColor(r.GetInt());
                    int x1 = Math.min(cx, cr.x);
                    int x2 = Math.max(cx, cr.x);
                    int y1 = Math.min(cy, cr.y);
                    int y2 = Math.max(cy, cr.y);
                    int dx = Math.abs(x2 - x1);
                    int dy = Math.abs(y2 - y1);
                    g.drawRect(x1, y1 + 10, dx, dy);
                }
            }
        }
        if (!this.isDoubleBuffered()) {
            g1.drawImage(this.imBuffer, 0, 0, 20);
        }
        this.repaintMode = this.repaintModeDefault;
    }

    public void setDefaultRepaintMode(int m) {
        this.repaintModeDefault = m;
        this.repaintMode = m;
    }

    public void startAutoMode() {
        this.timer = new Timer();
        this.rTimer = new RedrawTimer(this);
        this.AutoMode = true;
        this.done = false;
        this.setDefaultRepaintMode(4);
        this.repaint();
        this.timer.schedule((TimerTask)this.rTimer, 1000L, 1000L);
    }

    public void stopAutoMode() {
        this.rTimer.cancel();
        this.rTimer = null;
        this.timer = null;
        this.AutoMode = false;
        this.setDefaultRepaintMode(3);
        this.repaint();
    }
}

