/*
 * Decompiled with CFR 0.152.
 */
package p;

public class Float {
    public static final Float E;
    private static final Float ERROR;
    private static final int ITNUM = 5;
    public static final Float LOG10;
    public static final Float ONE;
    public static final Float PI;
    public static final Float PIdiv12;
    public static final Float PIdiv2;
    public static final Float PIdiv4;
    public static final Float PIdiv6;
    public static final Float PImul2;
    public static final Float PImul4;
    public static final Float SQRT3;
    public static final Float ZERO;
    public long m_E;
    public long m_Val;
    private long maxLimit = 92233720368547758L;

    static {
        ERROR = new Float(Long.MAX_VALUE, Long.MAX_VALUE);
        SQRT3 = new Float(1732050807568877294L, -18L);
        PI = new Float(3141592653589793238L, -18L);
        ZERO = new Float();
        ONE = new Float(1L);
        E = new Float(271828182845904512L, -17L);
        LOG10 = new Float(2302585092994045684L, -18L);
        PIdiv2 = PI.Div(2L);
        PIdiv4 = PIdiv2.Div(2L);
        PIdiv6 = PIdiv2.Div(3L);
        PIdiv12 = PIdiv6.Div(2L);
        PImul2 = PI.Mul(2L);
        PImul4 = PI.Mul(4L);
    }

    public Float(long value, long e) {
        this.m_Val = value;
        this.m_E = this.m_Val == 0L ? 0L : e;
    }

    public Float(Float value) {
        this.m_Val = value.m_Val;
        this.m_E = this.m_Val == 0L ? 0L : value.m_E;
    }

    public Float(long value) {
        this.m_Val = value;
        this.m_E = 0L;
    }

    public Float() {
        this.m_E = 0L;
        this.m_Val = 0L;
    }

    public Float Add(Float value) {
        if (value.Equal(ZERO)) {
            return new Float(this);
        }
        long e1 = this.m_E;
        long e2 = value.m_E;
        long v1 = this.m_Val;
        long v2 = value.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        if (v1 > 0L && v2 > Long.MAX_VALUE - v1 || v1 < 0L && v2 < Long.MIN_VALUE - v1) {
            v1 /= 10L;
            ++e1;
            v2 /= 10L;
            ++e2;
        }
        if (v1 > 0L && v2 > Long.MAX_VALUE - v1) {
            return new Float(ERROR);
        }
        if (v1 < 0L && v2 < Long.MIN_VALUE - v1) {
            return new Float(ERROR);
        }
        return new Float(v1 + v2, e1);
    }

    public Float Div(Float value) {
        if (value.Equal(ONE)) {
            return new Float(this);
        }
        long e1 = this.m_E;
        long e2 = value.m_E;
        long v2 = value.m_Val;
        if (v2 == 0L) {
            return new Float(ERROR);
        }
        long v1 = this.m_Val;
        if (v1 == 0L) {
            return new Float(ZERO);
        }
        long val = 0L;
        while ((v1 %= v2) != 0L && Math.abs(val += v1 / v2) <= 0xCCCCCCCCCCCCCCCL) {
            if (Math.abs(v1) > 0xCCCCCCCCCCCCCCCL) {
                v2 /= 10L;
                ++e2;
            } else {
                v1 *= 10L;
                --e1;
            }
            val *= 10L;
        }
        Float f = new Float(val, e1 - e2);
        f.RemoveZero();
        return f;
    }

    public Float Div(long value) {
        return this.Div(new Float(value, 0L));
    }

    /*
     * Unable to fully structure code
     */
    public boolean Equal(Float x) {
        e1 = this.m_E;
        e2 = x.m_E;
        v1 = this.m_Val;
        v2 = x.m_Val;
        if (v1 == 0L && v2 == 0L || v1 == v2 && e1 == e2) {
            return true;
        }
        diff = e1 - e2;
        if (diff >= -20L && diff <= 20L) ** GOTO lbl32
        return false;
lbl-1000:
        // 1 sources

        {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
lbl32:
            // 6 sources

            ** while (e1 != e2)
        }
lbl33:
        // 1 sources

        return v1 == v2;
    }

    public boolean Great(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 > v2;
    }

    public boolean Less(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 < v2;
    }

    public boolean Less(long x) {
        return this.Less(new Float(x, 0L));
    }

    public Float Mul(Float value) {
        boolean negative2;
        boolean negative1;
        if (value.Equal(ZERO) || this.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (value.Equal(ONE)) {
            return new Float(this);
        }
        boolean bl = negative1 = this.m_Val < 0L;
        if (negative1) {
            this.m_Val = -this.m_Val;
        }
        boolean bl2 = negative2 = value.m_Val < 0L;
        if (negative2) {
            value.m_Val = -value.m_Val;
        }
        while (true) {
            if (value.m_Val > this.m_Val) {
                if (Long.MAX_VALUE / this.m_Val >= value.m_Val) break;
                value.m_Val /= 10L;
                ++value.m_E;
                continue;
            }
            if (Long.MAX_VALUE / value.m_Val >= this.m_Val) break;
            this.m_Val /= 10L;
            ++this.m_E;
        }
        if (negative1) {
            this.m_Val = -this.m_Val;
        }
        if (negative2) {
            value.m_Val = -value.m_Val;
        }
        long e = this.m_E + value.m_E;
        long v = this.m_Val * value.m_Val;
        return new Float(v, e);
    }

    public Float Mul(long value) {
        return this.Mul(new Float(value, 0L));
    }

    /*
     * Unable to fully structure code
     */
    public void RemoveZero() {
        if (this.m_Val != 0L) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this.m_Val /= 10L;
            ++this.m_E;
lbl6:
            // 2 sources

            ** while (this.m_Val % 10L == 0L)
        }
lbl7:
        // 1 sources

    }

    public static Float sqrt(Float x) {
        int sp = 0;
        boolean inv = false;
        if (x.Less(ZERO)) {
            return new Float(ERROR);
        }
        if (x.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (x.Equal(ONE)) {
            return new Float(ONE);
        }
        if (x.Less(ONE)) {
            x = ONE.Div(x);
            inv = true;
        }
        long e = x.m_E / 2L;
        Float tmp = new Float(x.m_Val, x.m_E - e * 2L);
        while (tmp.Great(new Float(16L))) {
            ++sp;
            tmp = tmp.Div(16L);
        }
        Float a = new Float(2L);
        int i = 5;
        while (i > 0) {
            Float b = tmp.Div(a);
            a = a.Add(b);
            a = a.Div(2L);
            --i;
        }
        while (sp > 0) {
            --sp;
            a = a.Mul(4L);
        }
        a.m_E += e;
        if (inv) {
            a = ONE.Div(a);
        }
        return a;
    }

    public long toLong() {
        long tmpE = this.m_E;
        long tmpVal = this.m_Val;
        while (tmpE != 0L) {
            if (tmpE < 0L) {
                tmpVal /= 10L;
                ++tmpE;
                continue;
            }
            tmpVal *= 10L;
            --tmpE;
        }
        return tmpVal;
    }
}

