/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.CategoryView;
import JabpLite.JabpLite;
import JabpLite.Sort;
import JabpLite.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TopExpenses
extends Canvas
implements CommandListener {
    Display display;
    Font font;
    JabpLite parent;
    int width;
    int height;
    int fontHeight;
    int fontWidth;
    int numberWidth;
    int nameWidth;
    int amountPosition;
    int currentX;
    int currentY;
    int totalAmount;

    public TopExpenses(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.addCommand(this.parent.okCommand);
        this.addCommand(this.parent.exitCommand);
        this.setCommandListener(this);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.numberWidth = this.font.stringWidth("999999.99");
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.fontHeight;
    }

    public void paint(Graphics graphics) {
        this.height = this.getHeight() - this.parent.heightAdjustment;
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        int n;
        this.currentY = this.fontHeight;
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        Vector<Category> vector = new Vector<Category>();
        CategoryStore categoryStore = new CategoryStore(this.parent);
        int n2 = categoryStore.getNumCategories();
        for (n = 0; n < n2; ++n) {
            Category category = categoryStore.getCategoryFromIndex(n);
            vector.addElement(category);
        }
        categoryStore.closeCategoryStore();
        categoryStore = null;
        Sort.sortCategory(vector, 0, n2 - 1, true);
        n = Math.min(n2, 10);
        for (int i = 0; i < n; ++i) {
            Category category = (Category)vector.elementAt(i);
            if (category.current < 0 || this.currentY + this.fontHeight > this.height - this.fontHeight) continue;
            this.buildLine(graphics, category.name, category.current);
        }
        vector = null;
    }

    void showHeader(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString("\u041e\u0441\u043d\u043e\u0432\u043d.\u0420\u0430\u0441\u0445\u043e\u0434\u044b", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        graphics.drawString("\u041a\u043e\u043b\u0438\u0447.", this.amountPosition + this.numberWidth - this.font.stringWidth("\u041a\u043e\u043b\u0438\u0447."), this.parent.fontAdjustment, 20);
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(0);
    }

    void buildLine(Graphics graphics, String string, int n) {
        graphics.drawString(string, this.parent.widthAdjustment, this.currentY + this.parent.fontAdjustment, 20);
        String string2 = Utilities.numberToString(n, false);
        graphics.drawString(string2, this.amountPosition + this.numberWidth - this.font.stringWidth(string2), this.currentY + this.parent.fontAdjustment, 20);
        this.currentY += this.fontHeight;
    }

    void setPositions() {
        this.nameWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.amountPosition = this.nameWidth + this.parent.widthAdjustment + 10;
    }

    protected void showNotify() {
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this && command == this.parent.okCommand) {
            if (this.parent.cv == null) {
                this.parent.cv = new CategoryView(this.parent, this.display);
            }
            this.display.setCurrent((Displayable)this.parent.cv);
        }
    }
}

