/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class SearchBox
extends TextBox
implements CommandListener {
    Econometer econometer;
    Displayable parent;
    Shop shop;

    SearchBox(Econometer econometer, Displayable displayable, Shop shop) {
        super(Locale.current.search, "", 32, 0);
        this.econometer = econometer;
        this.parent = displayable;
        this.shop = shop;
        this.setCommandListener(this);
        this.addCommand(Econometer.BACK_CMD);
        this.addCommand(Econometer.SEARCH_CMD);
        Display.getDisplay((MIDlet)econometer).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Econometer.SEARCH_CMD) {
            String string = this.getString().trim().toLowerCase();
            Vector<Purchase> vector = new Vector<Purchase>();
            int n = this.econometer.purchases.size();
            while (--n >= 0) {
                Purchase purchase = (Purchase)this.econometer.purchases.elementAt(n);
                if (this.shop != null && this.shop != purchase.shop || !purchase.search(string)) continue;
                vector.addElement(purchase);
            }
            if (vector.size() == 0) {
                this.econometer.showAlert(AlertType.WARNING, Locale.current.warning, Locale.current.notFound, (Displayable)this);
            } else {
                new SearchResult(this.econometer, (Displayable)this, vector);
            }
        } else if (command == Econometer.BACK_CMD) {
            Display.getDisplay((MIDlet)this.econometer).setCurrent(this.parent);
        }
    }
}

