/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class EditPurchaseForm
extends Form
implements CommandListener {
    Econometer econometer;
    UpdatableList parent;
    int parentListIndex;
    int purchaseIndex;
    TextField priceField;
    TextField descriptionField;
    Purchase purchase;

    EditPurchaseForm(String string, Econometer econometer, UpdatableList updatableList, int n, int n2) {
        super(string);
        this.econometer = econometer;
        this.parent = updatableList;
        this.parentListIndex = n;
        this.purchaseIndex = n2;
        this.purchase = (Purchase)econometer.purchases.elementAt(n2);
        this.priceField = new TextField(Locale.current.price, Purchase.printPrice(this.purchase.price), 12, Settings.instance.getPriceFieldFormat(this.purchase.price));
        this.descriptionField = new TextField(Locale.current.description, this.purchase.description, 64, 0);
        if (this.purchase.shop != null) {
            this.append((Item)new StringItem(Locale.current.location, this.purchase.shop.name));
        }
        this.append((Item)this.priceField);
        this.append((Item)this.descriptionField);
        this.setCommandListener(this);
        this.addCommand(Econometer.BACK_CMD);
        this.addCommand(Econometer.EDIT_CMD);
        this.addCommand(Econometer.DELETE_CMD);
        Display.getDisplay((MIDlet)econometer).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Econometer.DELETE_CMD) {
            this.parent.update(this.parentListIndex, 0L, this.purchase.price, true);
            this.econometer.removePurchase(this.purchase, this.purchaseIndex);
        } else if (command == Econometer.EDIT_CMD) {
            long l = 0L;
            try {
                l = Purchase.parsePrice(this.priceField.getString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (l <= 0L) {
                this.econometer.showAlert(AlertType.ERROR, Locale.current.error, Locale.current.priceNotValid, (Displayable)this);
                return;
            }
            if (l != this.purchase.price) {
                this.parent.update(this.parentListIndex, l, this.purchase.price, false);
                this.purchase.price = l;
            } else {
                if (this.purchase.description.equals(this.descriptionField.getString())) {
                    Display.getDisplay((MIDlet)this.econometer).setCurrent((Displayable)this.parent);
                    return;
                }
                this.purchase.description = this.descriptionField.getString();
            }
            this.econometer.updatePurchase(this.purchase);
        } else if (command != Econometer.BACK_CMD) {
            return;
        }
        Display.getDisplay((MIDlet)this.econometer).setCurrent((Displayable)this.parent);
    }
}

