/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class ShopMenu
extends List
implements CommandListener {
    Econometer econometer;
    Displayable parent;
    Shop shop;

    ShopMenu(Econometer econometer, Displayable displayable, Shop shop) {
        super(shop.name, 3, Locale.current.shopMenuItems, null);
        this.econometer = econometer;
        this.parent = displayable;
        this.shop = shop;
        this.setCommandListener(this);
        this.addCommand(Econometer.BACK_CMD);
        Display.getDisplay((MIDlet)econometer).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Econometer.BACK_CMD) {
            Display.getDisplay((MIDlet)this.econometer).setCurrent(this.parent);
        } else {
            switch (this.getSelectedIndex()) {
                case 0: {
                    new NewPurchaseForm(this.econometer, (Displayable)this, this.shop);
                    break;
                }
                case 1: {
                    new WeekList(this.econometer, (Displayable)this, this.shop);
                    break;
                }
                case 2: {
                    new MonthList(this.econometer, (Displayable)this, this.shop);
                    break;
                }
                case 3: {
                    if (this.econometer.purchases.size() == 0) {
                        this.econometer.showAlert(AlertType.WARNING, Locale.current.error, Locale.current.noData, (Displayable)this);
                        break;
                    }
                    this.econometer.showAlert(AlertType.INFO, Locale.current.analysis, this.econometer.analyze(this.shop), (Displayable)this);
                    break;
                }
                case 4: {
                    new SearchBox(this.econometer, (Displayable)this, this.shop);
                }
            }
        }
    }
}

